/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.ui.validation.ValidationUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrDebuggerPluginService;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageChannelFormat;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDataType;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDescriptor;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageShape;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewer;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.intellij.images.editor.actionSystem.ImageEditorActionUtil;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.ui.ImageComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u0086\u00012\u00020\u0001:\u0002\u0086\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZH\u0014\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u00020\u0015H\u0014J\b\u0010^\u001a\u00020\u0015H\u0016J\b\u0010_\u001a\u00020DH\u0002J\b\u0010`\u001a\u00020DH\u0002J\u0018\u0010a\u001a\u00020D2\u0006\u0010b\u001a\u00020\u001d2\u0006\u0010c\u001a\u00020dH\u0002J\u0010\u0010e\u001a\u00020D2\u0006\u0010\u0014\u001a\u00020fH\u0002J\u0016\u0010g\u001a\u0004\u0018\u00010h*\u00020i2\u0006\u0010c\u001a\u00020dH\u0002J\b\u0010j\u001a\u00020DH\u0002J\b\u0010k\u001a\u00020DH\u0002J\n\u0010l\u001a\u0004\u0018\u00010AH\u0002J\b\u0010m\u001a\u00020DH\u0002J\u0010\u0010n\u001a\u00020D2\u0006\u0010\u0014\u001a\u00020fH\u0002J\n\u0010o\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010p\u001a\u0004\u0018\u00010\u000bJ\u0014\u0010q\u001a\u00020D2\n\b\u0002\u0010r\u001a\u0004\u0018\u000105H\u0002J\u0010\u0010s\u001a\u00020D2\b\b\u0002\u0010t\u001a\u00020AJ)\u0010u\u001a\u00020D2\u001c\u0010v\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0x\u0012\u0006\u0012\u0004\u0018\u00010y0w\u00a2\u0006\u0002\u0010zJ\b\u0010\u007f\u001a\u00020DH\u0002J \u0010\u0080\u0001\u001a\u0003H\u0081\u0001\"\t\b\u0000\u0010\u0081\u0001*\u00020\u0015*\u0003H\u0081\u0001H\u0002\u00a2\u0006\u0003\u0010\u0082\u0001J\u001d\u0010\u0083\u0001\u001a\u00020P*\u00020P2\u000e\u0010\u0084\u0001\u001a\t\u0012\u0004\u0012\u00020D0\u0085\u0001H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001500X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020504X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010;\u001a\u0010\u0012\f\u0012\n <*\u0004\u0018\u00010\t0\t0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010=\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010E\u001a\u00020FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u000e\u0010K\u001a\u00020LX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020NX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020\"04X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020U04X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020WX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020WX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010{\u001a\u00020|8F\u00a2\u0006\u0006\u001a\u0004\b}\u0010~\u00a8\u0006\u0087\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewerDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "imageViewer", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewer;", "imageDescriptor", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDescriptor;", "initialImage", "Ljava/awt/image/BufferedImage;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewer;Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDescriptor;Ljava/awt/image/BufferedImage;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDebugProcess", "()Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "getImageViewer", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewer;", "imageUi", "Ljavax/swing/JComponent;", "getImageUi", "()Ljavax/swing/JComponent;", "imageComponent", "Lorg/intellij/images/ui/ImageComponent;", "getImageComponent", "()Lorg/intellij/images/ui/ImageComponent;", "coordX", "Ljavax/swing/JLabel;", "coordY", "address", "pixelData", "pixelX", "", "getPixelX", "()I", "setPixelX", "(I)V", "pixelY", "getPixelY", "setPixelY", "imageUpdateJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/Job;", "loadingLabel", "Lcom/intellij/ui/components/JBLabel;", "componentsDisabledDuringImageUpdate", "Ljava/util/concurrent/CopyOnWriteArrayList;", "centerTopPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "channelsCombo", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageChannelFormat;", "channelsComboUpdate", "Ljava/util/concurrent/atomic/AtomicBoolean;", "formatLabel", "errorLabel", "hasError", "imageDescriptorRef", "kotlin.jvm.PlatformType", "currentImageDescriptor", "getCurrentImageDescriptor", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDescriptor;", "initialShape", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "uiUpdateFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "autoReloadEnabled", "", "getAutoReloadEnabled", "()Z", "setAutoReloadEnabled", "(Z)V", "autoReloadCheckBox", "Ljavax/swing/JCheckBox;", "settingsPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "widthField", "Lcom/intellij/ui/components/JBTextField;", "heightField", "widthBytesField", "channelsCountCombo", "dataTypeCombo", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDataType;", "resetButton", "Ljavax/swing/JButton;", "applyButton", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "getPreferredFocusedComponent", "configureTopPanel", "configureCoordinatesSize", "setPreferredWidth", "label", "text", "", "addSettingsPanel", "Ljavax/swing/JPanel;", "validatePositiveInt", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "resetSettings", "applySettings", "validateAndGetShape", "updateSettings", "addBottomPanel", "findErrorLabel", "getCurrentImage", "updateTopPanel", "channelFormat", "reloadImage", "shape", "updateImage", "imageDescriptorSupplier", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function1;)V", "asExpirable", "Lcom/intellij/openapi/util/Expirable;", "getAsExpirable", "()Lcom/intellij/openapi/util/Expirable;", "updateUi", "disabledDuringImageUpdate", "T", "(Ljavax/swing/JComponent;)Ljavax/swing/JComponent;", "onEnter", "action", "Lkotlin/Function0;", "Companion", "intellij.cidr.debugger"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCidrImageViewerUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrImageViewerUi.kt\ncom/jetbrains/cidr/execution/debugger/actions/CidrImageViewerDialog\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,753:1\n4135#2,11:754\n4135#2,11:765\n1#3:776\n1863#4,2:777\n*S KotlinDebug\n*F\n+ 1 CidrImageViewerUi.kt\ncom/jetbrains/cidr/execution/debugger/actions/CidrImageViewerDialog\n*L\n197#1:754,11\n260#1:765,11\n506#1:777,2\n*E\n"})
public final class CidrImageViewerDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CidrDebugProcess debugProcess;
    @NotNull
    private final CidrImageViewer imageViewer;
    @NotNull
    private final JComponent imageUi;
    @NotNull
    private final ImageComponent imageComponent;
    @NotNull
    private final JLabel coordX;
    @NotNull
    private final JLabel coordY;
    @NotNull
    private final JLabel address;
    @NotNull
    private final JLabel pixelData;
    private int pixelX;
    private int pixelY;
    @NotNull
    private final AtomicReference<Job> imageUpdateJob;
    @NotNull
    private final JBLabel loadingLabel;
    @NotNull
    private final CopyOnWriteArrayList<JComponent> componentsDisabledDuringImageUpdate;
    @NotNull
    private final BorderLayoutPanel centerTopPanel;
    @NotNull
    private final ComboBox<CidrImageChannelFormat> channelsCombo;
    @NotNull
    private final AtomicBoolean channelsComboUpdate;
    @NotNull
    private final JBLabel formatLabel;
    @Nullable
    private final JLabel errorLabel;
    @NotNull
    private final AtomicBoolean hasError;
    @NotNull
    private final AtomicReference<CidrImageDescriptor> imageDescriptorRef;
    @NotNull
    private final CidrImageShape initialShape;
    @NotNull
    private final MutableSharedFlow<Unit> uiUpdateFlow;
    private volatile boolean autoReloadEnabled;
    private JCheckBox autoReloadCheckBox;
    private DialogPanel settingsPanel;
    private JBTextField widthField;
    private JBTextField heightField;
    private JBTextField widthBytesField;
    private ComboBox<Integer> channelsCountCombo;
    private ComboBox<CidrImageDataType> dataTypeCombo;
    private JButton resetButton;
    private JButton applyButton;
    @NotNull
    private static final Key<CidrImageViewerDialog> IMAGE_KEY;
    @NotNull
    private static final String AUTO_RELOAD = "cidr.debugger.imageViewer.autoReloadEnabled";
    private static final boolean AUTO_RELOAD_ENABLED_DEFAULT = true;

    /*
     * WARNING - void declaration
     */
    public CidrImageViewerDialog(@NotNull Project project, @NotNull CidrDebugProcess debugProcess, @NotNull CidrImageViewer imageViewer, @NotNull CidrImageDescriptor imageDescriptor, @NotNull BufferedImage initialImage) {
        Iterator $this$loadingLabel_u24lambda_u240;
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)imageViewer, (String)"imageViewer");
        Intrinsics.checkNotNullParameter((Object)imageDescriptor, (String)"imageDescriptor");
        Intrinsics.checkNotNullParameter((Object)initialImage, (String)"initialImage");
        super(project, true);
        this.project = project;
        this.debugProcess = debugProcess;
        this.imageViewer = imageViewer;
        this.coordX = new JLabel();
        this.coordY = new JLabel();
        this.address = new JLabel();
        this.pixelData = new JLabel();
        this.imageUpdateJob = new AtomicReference();
        JBLabel jBLabel2 = jBLabel = new JBLabel((Icon)AnimatedIcon.Default.INSTANCE);
        CidrImageViewerDialog cidrImageViewerDialog = this;
        boolean bl = false;
        $this$loadingLabel_u24lambda_u240.setVisible(false);
        cidrImageViewerDialog.loadingLabel = jBLabel;
        this.componentsDisabledDuringImageUpdate = new CopyOnWriteArrayList();
        this.centerTopPanel = new BorderLayoutPanel();
        this.channelsCombo = (ComboBox)this.disabledDuringImageUpdate((JComponent)new ComboBox());
        this.channelsComboUpdate = new AtomicBoolean(false);
        this.formatLabel = new JBLabel();
        this.hasError = new AtomicBoolean(false);
        this.imageDescriptorRef = new AtomicReference<CidrImageDescriptor>(imageDescriptor);
        this.initialShape = imageDescriptor.getShape();
        this.uiUpdateFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.autoReloadEnabled = CidrImageViewerDialog.Companion.getAutoReload();
        this.setModal(false);
        JComponent jComponent = this.imageUi = (JComponent)ImageEditorManagerImpl.createImageEditorUI((BufferedImage)initialImage);
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        Disposer.register((Disposable)this.myDisposable, (Disposable)((Disposable)jComponent));
        Disposer.register((Disposable)this.myDisposable, () -> CidrImageViewerDialog._init_$lambda$1(this));
        this.imageUi.putClientProperty(IMAGE_KEY, (Object)this);
        this.imageUi.setBackground(UIManager.getColor("Panel.background"));
        JComponent jComponent2 = UIUtil.findComponentOfType((JComponent)this.imageUi, ImageComponent.class);
        Intrinsics.checkNotNull((Object)jComponent2);
        this.imageComponent = (ImageComponent)jComponent2;
        this.errorLabel = this.findErrorLabel();
        this.configureCoordinatesSize();
        this.configureTopPanel();
        JComponent jComponent3 = this.imageUi;
        Intrinsics.checkNotNull((Object)jComponent3, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        this.addSettingsPanel((JPanel)jComponent3);
        JComponent jComponent4 = this.imageUi;
        Intrinsics.checkNotNull((Object)jComponent4, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        this.addBottomPanel((JPanel)jComponent4);
        this.imageComponent.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CidrImageDescriptor imageDescriptor = this.getCurrentImageDescriptor();
                BufferedImage bufferedImage = this.getCurrentImage();
                if (bufferedImage == null) {
                    return;
                }
                BufferedImage bufferedImage2 = bufferedImage;
                double scale = this.getImageComponent().getZoomFactor();
                if (scale > 0.0) {
                    int x = RangesKt.coerceIn((int)((int)((double)e.getX() / scale)), (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)bufferedImage2.getWidth())));
                    int y = RangesKt.coerceIn((int)((int)((double)e.getY() / scale)), (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)bufferedImage2.getHeight())));
                    Object[] objectArray = new Object[]{x};
                    coordX.setText(CidrDebuggerBundle.message("debug.imageViewer.coordX", objectArray));
                    objectArray = new Object[]{y};
                    coordY.setText(CidrDebuggerBundle.message("debug.imageViewer.coordY", objectArray));
                    address.setText(imageDescriptor.getPixelAddress(x, y).toString());
                    JLabel jLabel = pixelData;
                    String string = imageDescriptor.getPixelData(x, y);
                    if (string == null) {
                        string = "";
                    }
                    jLabel.setText(string);
                } else {
                    coordX.setText("");
                    coordY.setText("");
                    address.setText("");
                    pixelData.setText("");
                }
            }
        });
        List list = UIUtil.findComponentsOfType((JComponent)this.imageUi, JBLayeredPane.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findComponentsOfType(...)");
        List panes = list;
        for (JBLayeredPane pane : panes) {
            void $this$filterIsInstanceTo$iv$iv;
            MouseListener[] mouseListenerArray = pane.getMouseListeners();
            Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
            Object[] $this$filterIsInstance$iv = mouseListenerArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PopupHandler)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List popups = (List)destination$iv$iv;
            for (PopupHandler popup : popups) {
                pane.removeMouseListener((MouseListener)popup);
            }
        }
        this.imageComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BufferedImage bufferedImage = this.getCurrentImage();
                if (bufferedImage == null) {
                    return;
                }
                BufferedImage bufferedImage2 = bufferedImage;
                double scale = this.getImageComponent().getZoomFactor();
                if (scale > 0.0) {
                    this.setPixelX(RangesKt.coerceIn((int)((int)((double)e.getX() / scale)), (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)bufferedImage2.getWidth()))));
                    this.setPixelY(RangesKt.coerceIn((int)((int)((double)e.getY() / scale)), (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)bufferedImage2.getHeight()))));
                } else {
                    this.setPixelX(0);
                    this.setPixelY(0);
                }
            }
        });
        PopupHandler.installPopupMenu((JComponent)((JComponent)this.imageComponent), (String)"CIDR.Debugger.ImageViewerPopupActions", (String)"popup");
        JFrame jFrame = WindowManager.getInstance().getFrame(this.project);
        Intrinsics.checkNotNull((Object)jFrame);
        JFrame frame = jFrame;
        Dimension frameSize = frame.getSize();
        this.setSize(frameSize.width / 2, frameSize.height / 2);
        this.debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                if (this.getAutoReloadEnabled()) {
                    CidrImageViewerDialog.reloadImage$default(this, null, 1, null);
                }
            }

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> 4.sessionStopped$lambda$0(this));
            }

            private static final void sessionStopped$lambda$0(CidrImageViewerDialog this$0) {
                this$0.close(1);
            }
        }, this.myDisposable);
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CidrDebugProcess getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final CidrImageViewer getImageViewer() {
        return this.imageViewer;
    }

    @NotNull
    public final JComponent getImageUi() {
        return this.imageUi;
    }

    @NotNull
    public final ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    public final int getPixelX() {
        return this.pixelX;
    }

    public final void setPixelX(int n) {
        this.pixelX = n;
    }

    public final int getPixelY() {
        return this.pixelY;
    }

    public final void setPixelY(int n) {
        this.pixelY = n;
    }

    @NotNull
    public final CidrImageDescriptor getCurrentImageDescriptor() {
        CidrImageDescriptor cidrImageDescriptor = this.imageDescriptorRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)cidrImageDescriptor, (String)"get(...)");
        return cidrImageDescriptor;
    }

    public final boolean getAutoReloadEnabled() {
        return this.autoReloadEnabled;
    }

    public final void setAutoReloadEnabled(boolean bl) {
        this.autoReloadEnabled = bl;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[0];
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.imageUi;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.imageComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final void configureTopPanel() {
        void $this$filterIsInstanceTo$iv$iv;
        Component component = this.imageUi.getComponent(0);
        JPanel jPanel = component instanceof JPanel ? (JPanel)component : null;
        if (jPanel == null) {
            return;
        }
        JPanel topPanel = jPanel;
        Component[] componentArray = topPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$filterIsInstance$iv = componentArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JLabel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        JLabel originalInfoLabel = (JLabel)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (originalInfoLabel != null) {
            topPanel.remove(originalInfoLabel);
        }
        BorderLayoutPanel eastTopPanel = new BorderLayoutPanel();
        this.formatLabel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        eastTopPanel.add((Component)BuilderKt.panel(arg_0 -> CidrImageViewerDialog.configureTopPanel$lambda$4(this, arg_0)), (Object)"East");
        topPanel.add((Component)eastTopPanel, "East");
        this.channelsCombo.addItemListener(arg_0 -> CidrImageViewerDialog.configureTopPanel$lambda$5(this, arg_0));
        DialogPanel channelsPanel = BuilderKt.panel(arg_0 -> CidrImageViewerDialog.configureTopPanel$lambda$7(this, arg_0));
        channelsPanel.setBorder((Border)new JBEmptyBorder((Insets)JBInsets.create((int)0, (int)10)));
        this.centerTopPanel.add((Component)channelsPanel, (Object)"Center");
        topPanel.add((Component)this.centerTopPanel, "Center");
        CidrImageViewerDialog.updateTopPanel$default(this, null, 1, null);
    }

    private final void configureCoordinatesSize() {
        BufferedImage bufferedImage = this.getCurrentImage();
        if (bufferedImage == null) {
            return;
        }
        BufferedImage bufferedImage2 = bufferedImage;
        Object[] objectArray = new Object[]{bufferedImage2.getWidth()};
        String string = CidrDebuggerBundle.message("debug.imageViewer.coordX", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setPreferredWidth(this.coordX, string);
        objectArray = new Object[]{bufferedImage2.getHeight()};
        String string2 = CidrDebuggerBundle.message("debug.imageViewer.coordY", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.setPreferredWidth(this.coordY, string2);
        String maxAddress = StringsKt.replace((String)Address.MAX_VALUE.toString(), (char)'f', (char)'C', (boolean)true);
        this.setPreferredWidth(this.address, maxAddress);
    }

    private final void setPreferredWidth(JLabel label, String text) {
        FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
        int maxTextWidth = fontMetrics.stringWidth(text);
        label.setPreferredSize((Dimension)JBUI.size((int)(maxTextWidth + 10), (int)fontMetrics.getHeight()));
    }

    private final void addSettingsPanel(JPanel imageUi) {
        this.settingsPanel = BuilderKt.panel(arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27(this, arg_0));
        DialogPanel dialogPanel = this.settingsPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settingsPanel");
            dialogPanel = null;
        }
        dialogPanel.setBorder((Border)new JBEmptyBorder((Insets)UIUtil.getRegularPanelInsets()));
        DialogPanel dialogPanel2 = this.settingsPanel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settingsPanel");
            dialogPanel2 = null;
        }
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        dialogPanel2.registerValidators(disposable);
        DialogPanel dialogPanel3 = this.settingsPanel;
        if (dialogPanel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settingsPanel");
            dialogPanel3 = null;
        }
        imageUi.add((Component)dialogPanel3, "East");
        CoroutineScope coroutineScope = this.debugProcess.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        Job job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("ImageViewer")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CidrImageViewerDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)((Flow)CidrImageViewerDialog.access$getUiUpdateFlow$p(this.this$0)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ CidrImageViewerDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ CidrImageViewerDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        boolean imageUpdateIsRunning = CidrImageViewerDialog.access$getImageUpdateJob$p(this.this$0).get() != null;
                                                        Iterator<E> iterator = CidrImageViewerDialog.access$getComponentsDisabledDuringImageUpdate$p(this.this$0).iterator();
                                                        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                                                        Iterator<E> iterator2 = iterator;
                                                        while (iterator2.hasNext()) {
                                                            JComponent component = (JComponent)iterator2.next();
                                                            component.setEnabled(!imageUpdateIsRunning);
                                                        }
                                                        boolean failed = CidrImageViewerDialog.access$getHasError$p(this.this$0).get();
                                                        JButton jButton = CidrImageViewerDialog.access$getResetButton$p(this.this$0);
                                                        if (jButton == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException((String)"resetButton");
                                                            jButton = null;
                                                        }
                                                        jButton.setEnabled(!imageUpdateIsRunning && (!Intrinsics.areEqual((Object)this.this$0.getCurrentImageDescriptor().getShape(), (Object)CidrImageViewerDialog.access$getInitialShape$p(this.this$0)) || failed));
                                                        CidrImageShape newShape = CidrImageViewerDialog.access$validateAndGetShape(this.this$0);
                                                        JButton jButton2 = CidrImageViewerDialog.access$getApplyButton$p(this.this$0);
                                                        if (jButton2 == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException((String)"applyButton");
                                                            jButton2 = null;
                                                        }
                                                        jButton2.setEnabled(!imageUpdateIsRunning && newShape != null && (!Intrinsics.areEqual((Object)this.this$0.getCurrentImageDescriptor().getShape(), (Object)newShape) || failed));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Disposable disposable2 = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"myDisposable");
        CoroutineScopeKt.cancelOnDispose$default((Job)job2, (Disposable)disposable2, (boolean)false, (int)2, null);
        this.updateSettings();
    }

    private final ValidationInfo validatePositiveInt(ValidationInfoBuilder $this$validatePositiveInt, String text) {
        Integer value = StringsKt.toIntOrNull((String)text);
        if (value == null || value <= 0) {
            String string = CidrDebuggerBundle.message("debug.imageViewer.enterPositiveNumber", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validatePositiveInt.error(string);
        }
        return null;
    }

    private final void resetSettings() {
        this.reloadImage(this.initialShape);
    }

    private final void applySettings() {
        CidrImageShape cidrImageShape = this.validateAndGetShape();
        if (cidrImageShape == null) {
            return;
        }
        CidrImageShape newShape = cidrImageShape;
        this.reloadImage(newShape);
    }

    /*
     * WARNING - void declaration
     */
    private final CidrImageShape validateAndGetShape() {
        void it;
        String string;
        DialogPanel dialogPanel = this.settingsPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settingsPanel");
            dialogPanel = null;
        }
        if (!((Collection)dialogPanel.validateAll()).isEmpty()) {
            return null;
        }
        JBTextField jBTextField = this.widthField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"widthField");
            jBTextField = null;
        }
        String string2 = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        int n = Integer.parseInt(string2);
        JBTextField jBTextField2 = this.heightField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heightField");
            jBTextField2 = null;
        }
        String string3 = jBTextField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        int n2 = Integer.parseInt(string3);
        ComboBox<Integer> comboBox = this.channelsCountCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channelsCountCombo");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int n3 = (Integer)object;
        ComboBox<CidrImageDataType> comboBox2 = this.dataTypeCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataTypeCombo");
            comboBox2 = null;
        }
        Object object2 = comboBox2.getSelectedItem();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.actions.CidrImageDataType");
        CidrImageDataType cidrImageDataType = (CidrImageDataType)((Object)object2);
        JBTextField jBTextField3 = this.widthBytesField;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"widthBytesField");
            jBTextField3 = null;
        }
        String string4 = string = jBTextField3.getText();
        CidrImageDataType cidrImageDataType2 = cidrImageDataType;
        int n4 = n3;
        int n5 = n2;
        int n6 = n;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
        String string5 = bl2 ? string : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n7 = 32;
        Integer n8 = null;
        Integer n9 = string5 != null ? Integer.valueOf(Integer.parseInt(string5)) : null;
        CidrImageDataType cidrImageDataType3 = cidrImageDataType2;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        return new CidrImageShape(n12, n11, n10, cidrImageDataType3, n9, n8, n7, defaultConstructorMarker);
    }

    private final void updateSettings() {
        CidrImageShape shape = this.getCurrentImageDescriptor().getShape();
        JBTextField jBTextField = this.widthField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"widthField");
            jBTextField = null;
        }
        jBTextField.setText(String.valueOf(shape.getWidthPixels()));
        JBTextField jBTextField2 = this.heightField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heightField");
            jBTextField2 = null;
        }
        jBTextField2.setText(String.valueOf(shape.getHeightPixels()));
        JBTextField jBTextField3 = this.widthBytesField;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"widthBytesField");
            jBTextField3 = null;
        }
        jBTextField3.setText(shape.getWidthBytes() == shape.getWidthPixels() * shape.getChannelsCount() * shape.getDataType().getSize() ? "" : String.valueOf(shape.getWidthBytes()));
        ComboBox<Integer> comboBox = this.channelsCountCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channelsCountCombo");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)shape.getChannelsCount());
        ComboBox<CidrImageDataType> comboBox2 = this.dataTypeCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataTypeCombo");
            comboBox2 = null;
        }
        comboBox2.setSelectedItem((Object)shape.getDataType());
        this.configureCoordinatesSize();
        this.updateUi();
    }

    private final void addBottomPanel(JPanel imageUi) {
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel pixelInfoPanel = new JPanel(new GridBagLayout());
        pixelInfoPanel.add(this.coordX);
        pixelInfoPanel.add(this.coordY);
        pixelInfoPanel.add(this.address);
        pixelInfoPanel.add(this.pixelData);
        bottomPanel.add((Component)pixelInfoPanel, "West");
        bottomPanel.add((Component)this.loadingLabel, "East");
        imageUi.add((Component)bottomPanel, "South");
    }

    private final JLabel findErrorLabel() {
        JLabel errorLabel;
        Component[] componentArray = this.imageUi.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object object = ArraysKt.getOrNull((Object[])componentArray, (int)1);
        JPanel jPanel = object instanceof JPanel ? (JPanel)object : null;
        if (jPanel == null) {
            return null;
        }
        JPanel contentPanel = jPanel;
        Component[] componentArray2 = contentPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray2, (String)"getComponents(...)");
        Object object2 = ArraysKt.getOrNull((Object[])componentArray2, (int)1);
        JPanel jPanel2 = object2 instanceof JPanel ? (JPanel)object2 : null;
        if (jPanel2 == null) {
            return null;
        }
        JPanel errorPanel = jPanel2;
        Component[] componentArray3 = errorPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray3, (String)"getComponents(...)");
        object2 = ArraysKt.firstOrNull((Object[])componentArray3);
        JLabel jLabel = errorLabel = object2 instanceof JLabel ? (JLabel)object2 : null;
        if (Intrinsics.areEqual((Object)(jLabel != null ? jLabel.getIcon() : null), (Object)Messages.getErrorIcon())) {
            return errorLabel;
        }
        return null;
    }

    @Nullable
    public final BufferedImage getCurrentImage() {
        return this.imageComponent.getDocument().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateTopPanel(CidrImageChannelFormat channelFormat) {
        CidrImageDescriptor descriptor = this.getCurrentImageDescriptor();
        CidrImageShape $this$updateTopPanel_u24lambda_u2429 = descriptor.getShape();
        boolean bl = false;
        Object[] objectArray = new Object[]{$this$updateTopPanel_u24lambda_u2429.getWidthPixels(), $this$updateTopPanel_u24lambda_u2429.getHeightPixels(), $this$updateTopPanel_u24lambda_u2429.getChannelsCount(), $this$updateTopPanel_u24lambda_u2429.getDataType().getUiName()};
        this.formatLabel.setText(CidrDebuggerBundle.message("debug.imageViewer.shape", objectArray));
        List<CidrImageChannelFormat> formats = this.getCurrentImageDescriptor().getSupportedFormats();
        this.channelsComboUpdate.set(true);
        try {
            this.channelsCombo.removeAllItems();
            Iterable $this$forEach$iv = formats;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CidrImageChannelFormat it = (CidrImageChannelFormat)((Object)element$iv);
                boolean bl2 = false;
                this.channelsCombo.addItem((Object)it);
            }
            if (channelFormat != null) {
                this.channelsCombo.setSelectedItem((Object)channelFormat);
            }
        }
        finally {
            this.channelsComboUpdate.set(false);
        }
        this.centerTopPanel.setVisible(!((Collection)formats).isEmpty());
    }

    static /* synthetic */ void updateTopPanel$default(CidrImageViewerDialog cidrImageViewerDialog, CidrImageChannelFormat cidrImageChannelFormat, int n, Object object) {
        if ((n & 1) != 0) {
            cidrImageChannelFormat = null;
        }
        cidrImageViewerDialog.updateTopPanel(cidrImageChannelFormat);
    }

    public final void reloadImage(@NotNull CidrImageShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Expirable expirable = this.debugProcess.getStateExpirable();
        Intrinsics.checkNotNullExpressionValue((Object)expirable, (String)"getStateExpirable(...)");
        Expirable expirable2 = CidrDebuggerUtilKt.plus(expirable, this.getAsExpirable());
        if (!this.debugProcess.getSession().isSuspended()) {
            return;
        }
        this.updateImage((Function1<? super Continuation<? super CidrImageDescriptor>, ? extends Object>)((Function1)new Function1<Continuation<? super CidrImageDescriptor>, Object>(this, expirable2, shape, null){
            int label;
            final /* synthetic */ CidrImageViewerDialog this$0;
            final /* synthetic */ Expirable $expirable;
            final /* synthetic */ CidrImageShape $shape;
            {
                this.this$0 = $receiver;
                this.$expirable = $expirable;
                this.$shape = $shape;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getImageViewer().getImageDescriptor(this.this$0.getDebugProcess(), this.$expirable, this.$shape, (Continuation<? super CidrImageDescriptor>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super CidrImageDescriptor> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ void reloadImage$default(CidrImageViewerDialog cidrImageViewerDialog, CidrImageShape cidrImageShape, int n, Object object) {
        if ((n & 1) != 0) {
            cidrImageShape = cidrImageViewerDialog.getCurrentImageDescriptor().getShape();
        }
        cidrImageViewerDialog.reloadImage(cidrImageShape);
    }

    public final void updateImage(@NotNull Function1<? super Continuation<? super CidrImageDescriptor>, ? extends Object> imageDescriptorSupplier) {
        Intrinsics.checkNotNullParameter(imageDescriptorSupplier, (String)"imageDescriptorSupplier");
        BuildersKt.launch$default((CoroutineScope)((CidrDebuggerPluginService)this.project.getService(CidrDebuggerPluginService.class)).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, imageDescriptorSupplier, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CidrImageViewerDialog this$0;
            final /* synthetic */ Function1<Continuation<? super CidrImageDescriptor>, Object> $imageDescriptorSupplier;
            {
                this.this$0 = $receiver;
                this.$imageDescriptorSupplier = $imageDescriptorSupplier;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Expirable getAsExpirable() {
        return () -> CidrImageViewerDialog._get_asExpirable_$lambda$31(this);
    }

    private final void updateUi() {
        this.uiUpdateFlow.tryEmit((Object)Unit.INSTANCE);
    }

    private final <T extends JComponent> T disabledDuringImageUpdate(T $this$disabledDuringImageUpdate) {
        this.componentsDisabledDuringImageUpdate.add($this$disabledDuringImageUpdate);
        return $this$disabledDuringImageUpdate;
    }

    private final JBTextField onEnter(JBTextField $this$onEnter, Function0<Unit> action) {
        $this$onEnter.addKeyListener((KeyListener)new KeyAdapter(action){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
            }

            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    this.$action.invoke();
                }
            }
        });
        return $this$onEnter;
    }

    private static final void _init_$lambda$1(CidrImageViewerDialog this$0) {
        block0: {
            Job job2 = this$0.imageUpdateJob.get();
            if (job2 == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
    }

    private static final Unit configureTopPanel$lambda$4$lambda$3$lambda$2(CidrImageViewerDialog this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.autoReloadEnabled = it.isSelected();
        Companion.saveAutoReload(it.isSelected());
        return Unit.INSTANCE;
    }

    private static final Unit configureTopPanel$lambda$4$lambda$3(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.topGap(TopGap.SMALL);
        String string = CidrDebuggerBundle.message("debug.imageViewer.autoReload", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.autoReloadCheckBox = (JCheckBox)ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)CidrImageViewerDialog.Companion.getAutoReload()).onChanged(arg_0 -> CidrImageViewerDialog.configureTopPanel$lambda$4$lambda$3$lambda$2(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit configureTopPanel$lambda$4(CidrImageViewerDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CidrImageViewerDialog.configureTopPanel$lambda$4$lambda$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void configureTopPanel$lambda$5(CidrImageViewerDialog this$0, ItemEvent e) {
        if (!this$0.channelsComboUpdate.get() && e.getStateChange() == 1) {
            if (this$0.hasError.get()) {
                CidrImageViewerDialog.reloadImage$default(this$0, null, 1, null);
            } else {
                this$0.updateImage((Function1<? super Continuation<? super CidrImageDescriptor>, ? extends Object>)((Function1)new Function1<Continuation<? super CidrImageDescriptor>, Object>(this$0, null){
                    int label;
                    final /* synthetic */ CidrImageViewerDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return this.this$0.getCurrentImageDescriptor();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super CidrImageDescriptor> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        }
    }

    private static final Unit configureTopPanel$lambda$7$lambda$6(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.channelsCombo);
        return Unit.INSTANCE;
    }

    private static final Unit configureTopPanel$lambda$7(CidrImageViewerDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = CidrDebuggerBundle.message("debug.imageViewer.channelsFormat", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> CidrImageViewerDialog.configureTopPanel$lambda$7$lambda$6(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo addSettingsPanel$lambda$27$lambda$11$lambda$8(CidrImageViewerDialog this$0, ValidationInfoBuilder $this$validationInfo, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationInfo, (String)"$this$validationInfo");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return this$0.validatePositiveInt($this$validationInfo, string);
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$11$lambda$9(CidrImageViewerDialog this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUi();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$11$lambda$10(CidrImageViewerDialog this$0) {
        this$0.applySettings();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$11(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.widthField = this$0.onEnter((JBTextField)this$0.disabledDuringImageUpdate(Row.intTextField$default((Row)$this$row, null, null, (int)3, null).align((Align)AlignX.FILL.INSTANCE).validationInfo((arg_0, arg_1) -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$11$lambda$8(this$0, arg_0, arg_1)).onChanged(arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$11$lambda$9(this$0, arg_0)).getComponent()), (Function0<Unit>)((Function0)() -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$11$lambda$10(this$0)));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo addSettingsPanel$lambda$27$lambda$15$lambda$12(CidrImageViewerDialog this$0, ValidationInfoBuilder $this$validationInfo, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationInfo, (String)"$this$validationInfo");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return this$0.validatePositiveInt($this$validationInfo, string);
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$15$lambda$13(CidrImageViewerDialog this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUi();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$15$lambda$14(CidrImageViewerDialog this$0) {
        this$0.applySettings();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$15(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.heightField = this$0.onEnter((JBTextField)this$0.disabledDuringImageUpdate(Row.intTextField$default((Row)$this$row, null, null, (int)3, null).align((Align)AlignX.FILL.INSTANCE).validationInfo((arg_0, arg_1) -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$15$lambda$12(this$0, arg_0, arg_1)).onChanged(arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$15$lambda$13(this$0, arg_0)).getComponent()), (Function0<Unit>)((Function0)() -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$15$lambda$14(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$19$lambda$16(CidrImageViewerDialog this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUi();
        return Unit.INSTANCE;
    }

    private static final String addSettingsPanel$lambda$27$lambda$19$lambda$17(CidrImageViewerDialog this$0, String text) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return null;
        }
        Integer n = StringsKt.toIntOrNull((String)text);
        if (n == null) {
            return UIBundle.message((String)"please.enter.a.number", (Object[])new Object[0]);
        }
        int pitch = n;
        JBTextField jBTextField = this$0.widthField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"widthField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Integer n2 = StringsKt.toIntOrNull((String)string);
        if (n2 == null) {
            return null;
        }
        int width = n2;
        ComboBox<Integer> comboBox = this$0.channelsCountCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channelsCountCombo");
            comboBox = null;
        }
        Integer n3 = (object2 = comboBox.getSelectedItem()) instanceof Integer ? (Integer)object2 : null;
        if (n3 == null) {
            return null;
        }
        int channelsCount = n3;
        ComboBox<CidrImageDataType> comboBox2 = this$0.dataTypeCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataTypeCombo");
            comboBox2 = null;
        }
        CidrImageDataType cidrImageDataType = (object = comboBox2.getSelectedItem()) instanceof CidrImageDataType ? (CidrImageDataType)((Object)object) : null;
        if (cidrImageDataType == null) {
            return null;
        }
        CidrImageDataType dataType = cidrImageDataType;
        if (pitch < width * channelsCount * dataType.getSize()) {
            return "Pitch is too small";
        }
        return null;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$19$lambda$18(CidrImageViewerDialog this$0) {
        this$0.applySettings();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$19(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        DialogValidation.WithParameter[] withParameterArray = new DialogValidation.WithParameter[]{ValidationUtilKt.validationErrorFor(arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$19$lambda$17(this$0, arg_0))};
        this$0.widthBytesField = this$0.onEnter((JBTextField)this$0.disabledDuringImageUpdate(TextFieldKt.trimmedTextValidation((Cell)TextFieldKt.columns((Cell)$this$row.textField(), (int)6).align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$19$lambda$16(this$0, arg_0)), (DialogValidation.WithParameter[])withParameterArray).getComponent()), (Function0<Unit>)((Function0)() -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$19$lambda$18(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$21$lambda$20(CidrImageViewerDialog this$0, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUi();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$21(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Integer[]{1, 3, 4};
        this$0.channelsCountCombo = (ComboBox)this$0.disabledDuringImageUpdate(Row.comboBox$default((Row)$this$row, (Collection)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$21$lambda$20(this$0, arg_0)).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$23$lambda$22(CidrImageViewerDialog this$0, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUi();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$23(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.dataTypeCombo = (ComboBox)this$0.disabledDuringImageUpdate(Row.comboBox$default((Row)$this$row, (Collection)((Collection)CidrImageDataType.getEntries()), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$23$lambda$22(this$0, arg_0)).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$26$lambda$24(CidrImageViewerDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.resetSettings();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$26$lambda$25(CidrImageViewerDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.applySettings();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27$lambda$26(CidrImageViewerDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.imageViewer.reset", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.resetButton = (JButton)$this$row.button(string, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$26$lambda$24(this$0, arg_0)).align((Align)AlignX.LEFT.INSTANCE).enabled(false).getComponent();
        String string2 = CidrDebuggerBundle.message("debug.imageViewer.apply", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this$0.applyButton = (JButton)$this$row.button(string2, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$26$lambda$25(this$0, arg_0)).align((Align)AlignX.RIGHT.INSTANCE).enabled(false).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit addSettingsPanel$lambda$27(CidrImageViewerDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = CidrDebuggerBundle.message("debug.imageViewer.width", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$11(this$0, arg_0));
        String string2 = CidrDebuggerBundle.message("debug.imageViewer.height", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$15(this$0, arg_0));
        String string3 = CidrDebuggerBundle.message("debug.imageViewer.pitch", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$19(this$0, arg_0));
        String string4 = CidrDebuggerBundle.message("debug.imageViewer.channelsCount", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(string4, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$21(this$0, arg_0));
        String string5 = CidrDebuggerBundle.message("debug.imageViewer.dataType", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        $this$panel.row(string5, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$23(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CidrImageViewerDialog.addSettingsPanel$lambda$27$lambda$26(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean _get_asExpirable_$lambda$31(CidrImageViewerDialog this$0) {
        return this$0.isDisposed();
    }

    public static final /* synthetic */ MutableSharedFlow access$getUiUpdateFlow$p(CidrImageViewerDialog $this) {
        return $this.uiUpdateFlow;
    }

    public static final /* synthetic */ AtomicReference access$getImageUpdateJob$p(CidrImageViewerDialog $this) {
        return $this.imageUpdateJob;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getComponentsDisabledDuringImageUpdate$p(CidrImageViewerDialog $this) {
        return $this.componentsDisabledDuringImageUpdate;
    }

    public static final /* synthetic */ AtomicBoolean access$getHasError$p(CidrImageViewerDialog $this) {
        return $this.hasError;
    }

    public static final /* synthetic */ JButton access$getResetButton$p(CidrImageViewerDialog $this) {
        return $this.resetButton;
    }

    public static final /* synthetic */ CidrImageShape access$getInitialShape$p(CidrImageViewerDialog $this) {
        return $this.initialShape;
    }

    public static final /* synthetic */ CidrImageShape access$validateAndGetShape(CidrImageViewerDialog $this) {
        return $this.validateAndGetShape();
    }

    public static final /* synthetic */ JButton access$getApplyButton$p(CidrImageViewerDialog $this) {
        return $this.applyButton;
    }

    public static final /* synthetic */ JBLabel access$getLoadingLabel$p(CidrImageViewerDialog $this) {
        return $this.loadingLabel;
    }

    public static final /* synthetic */ void access$updateUi(CidrImageViewerDialog $this) {
        $this.updateUi();
    }

    public static final /* synthetic */ ComboBox access$getChannelsCombo$p(CidrImageViewerDialog $this) {
        return $this.channelsCombo;
    }

    public static final /* synthetic */ AtomicReference access$getImageDescriptorRef$p(CidrImageViewerDialog $this) {
        return $this.imageDescriptorRef;
    }

    public static final /* synthetic */ void access$updateTopPanel(CidrImageViewerDialog $this, CidrImageChannelFormat channelFormat) {
        $this.updateTopPanel(channelFormat);
    }

    public static final /* synthetic */ void access$updateSettings(CidrImageViewerDialog $this) {
        $this.updateSettings();
    }

    public static final /* synthetic */ JLabel access$getErrorLabel$p(CidrImageViewerDialog $this) {
        return $this.errorLabel;
    }

    static {
        Key key = Key.create((String)CidrImageViewerDialog.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IMAGE_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewerDialog$Companion;", "", "<init>", "()V", "IMAGE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewerDialog;", "getIMAGE_KEY", "()Lcom/intellij/openapi/util/Key;", "getDialog", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "AUTO_RELOAD", "", "AUTO_RELOAD_ENABLED_DEFAULT", "", "getAutoReload", "saveAutoReload", "", "autoReloadEnabled", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<CidrImageViewerDialog> getIMAGE_KEY() {
            return IMAGE_KEY;
        }

        @Nullable
        public final CidrImageViewerDialog getDialog(@NotNull AnActionEvent e) {
            JPanel imageUi;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = ImageEditorActionUtil.getImageComponentDecorator((AnActionEvent)e);
            JPanel jPanel = imageUi = object instanceof JPanel ? (JPanel)object : null;
            object = jPanel != null ? jPanel.getClientProperty(this.getIMAGE_KEY()) : null;
            return object instanceof CidrImageViewerDialog ? (CidrImageViewerDialog)((Object)object) : null;
        }

        private final boolean getAutoReload() {
            return PropertiesComponent.getInstance().getBoolean(CidrImageViewerDialog.AUTO_RELOAD, true);
        }

        public final void saveAutoReload(boolean autoReloadEnabled) {
            PropertiesComponent.getInstance().setValue(CidrImageViewerDialog.AUTO_RELOAD, autoReloadEnabled, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

