/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.jetbrains.cidr.execution.debugger.actions.CidrImageDataType;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0002&'BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u001bJ\b\u0010 \u001a\u00020!H\u0016J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010%\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "", "widthPixels", "", "heightPixels", "channelsCount", "dataType", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDataType;", "widthBytes", "pixelWidthBytes", "<init>", "(IIILcom/jetbrains/cidr/execution/debugger/actions/CidrImageDataType;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getWidthPixels", "()I", "getHeightPixels", "getChannelsCount", "getDataType", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDataType;", "getWidthBytes", "getPixelWidthBytes", "imageSizeBytes", "getImageSizeBytes", "pixelCount", "getPixelCount", "getPixelOffset", "x", "y", "(II)Ljava/lang/Integer;", "pixelOffsets", "Lkotlin/collections/IntIterator;", "getPixelOffsets", "()Lkotlin/collections/IntIterator;", "toString", "", "equals", "", "other", "hashCode", "Companion", "PixelOffsetIterator", "intellij.cidr.debugger"})
public final class CidrImageShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int widthPixels;
    private final int heightPixels;
    private final int channelsCount;
    @NotNull
    private final CidrImageDataType dataType;
    private final int widthBytes;
    private final int pixelWidthBytes;
    private final int imageSizeBytes;
    @NotNull
    private static final CidrImageShape DEFAULT = new CidrImageShape(0, 0, 0, CidrImageDataType.Uint8, null, null, 48, null);

    public CidrImageShape(int widthPixels, int heightPixels, int channelsCount, @NotNull CidrImageDataType dataType, @Nullable Integer widthBytes, @Nullable Integer pixelWidthBytes) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        this.widthPixels = widthPixels;
        this.heightPixels = heightPixels;
        this.channelsCount = channelsCount;
        this.dataType = dataType;
        int defaultPixelWidth = this.channelsCount * this.dataType.getSize();
        if (!(pixelWidthBytes == null || pixelWidthBytes >= defaultPixelWidth)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Integer n = pixelWidthBytes;
        this.pixelWidthBytes = n != null ? n : defaultPixelWidth;
        int defaultPitch = this.widthPixels * this.pixelWidthBytes;
        if (!(widthBytes == null || widthBytes >= defaultPitch)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Integer n2 = widthBytes;
        this.widthBytes = n2 != null ? n2 : defaultPitch;
        this.imageSizeBytes = this.widthBytes * this.heightPixels;
    }

    public /* synthetic */ CidrImageShape(int n, int n2, int n3, CidrImageDataType cidrImageDataType, Integer n4, Integer n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 4) != 0) {
            n3 = 1;
        }
        if ((n6 & 8) != 0) {
            cidrImageDataType = CidrImageDataType.Uint8;
        }
        if ((n6 & 0x10) != 0) {
            n4 = null;
        }
        if ((n6 & 0x20) != 0) {
            n5 = null;
        }
        this(n, n2, n3, cidrImageDataType, n4, n5);
    }

    public final int getWidthPixels() {
        return this.widthPixels;
    }

    public final int getHeightPixels() {
        return this.heightPixels;
    }

    public final int getChannelsCount() {
        return this.channelsCount;
    }

    @NotNull
    public final CidrImageDataType getDataType() {
        return this.dataType;
    }

    public final int getWidthBytes() {
        return this.widthBytes;
    }

    public final int getPixelWidthBytes() {
        return this.pixelWidthBytes;
    }

    public final int getImageSizeBytes() {
        return this.imageSizeBytes;
    }

    public final int getPixelCount() {
        return this.widthPixels * this.heightPixels;
    }

    @Nullable
    public final Integer getPixelOffset(int x, int y) {
        block4: {
            block3: {
                boolean bl = 0 <= x ? x < this.widthPixels : false;
                if (!bl) break block3;
                if (0 <= y ? y < this.heightPixels : false) break block4;
            }
            return null;
        }
        return y * this.widthBytes + x * this.pixelWidthBytes;
    }

    @NotNull
    public final IntIterator getPixelOffsets() {
        return new PixelOffsetIterator();
    }

    @NotNull
    public String toString() {
        return this.widthPixels + "x" + this.heightPixels + "x" + this.channelsCount + " " + this.dataType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CidrImageShape)) {
            return false;
        }
        if (this.widthPixels != ((CidrImageShape)other).widthPixels) {
            return false;
        }
        if (this.heightPixels != ((CidrImageShape)other).heightPixels) {
            return false;
        }
        if (this.channelsCount != ((CidrImageShape)other).channelsCount) {
            return false;
        }
        if (this.dataType != ((CidrImageShape)other).dataType) {
            return false;
        }
        if (this.widthBytes != ((CidrImageShape)other).widthBytes) {
            return false;
        }
        return this.pixelWidthBytes == ((CidrImageShape)other).pixelWidthBytes;
    }

    public int hashCode() {
        int result = this.widthPixels;
        result = 31 * result + this.heightPixels;
        result = 31 * result + this.channelsCount;
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.widthBytes;
        result = 31 * result + this.pixelWidthBytes;
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape$Companion;", "", "<init>", "()V", "DEFAULT", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "getDEFAULT", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CidrImageShape getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape$PixelOffsetIterator;", "Lkotlin/collections/IntIterator;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;)V", "y", "", "x", "rowOffset", "pixelOffset", "hasNext", "", "nextInt", "intellij.cidr.debugger"})
    private final class PixelOffsetIterator
    extends IntIterator {
        private int y;
        private int x;
        private int rowOffset;
        private int pixelOffset;

        public boolean hasNext() {
            return this.y < CidrImageShape.this.getHeightPixels();
        }

        public int nextInt() {
            int result = this.pixelOffset;
            int n = this.x;
            this.x = n + 1;
            this.pixelOffset += CidrImageShape.this.getPixelWidthBytes();
            if (this.x == CidrImageShape.this.getWidthPixels()) {
                this.x = 0;
                n = this.y;
                this.y = n + 1;
                this.rowOffset += CidrImageShape.this.getWidthBytes();
                this.pixelOffset = this.rowOffset;
            }
            return result;
        }
    }
}

