/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.LLRegisterSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"toggleRegisterSet", "", "settings", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;", "arch", "", "driverName", "registerSets", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLRegisterSet;", "updatedRegisterSet", "registerSetEnabled", "", "getEnabledRegisterSets", "allRegisterSets", "driver", "intellij.cidr.debugger"})
public final class CidrDebuggerRegisterSetsGroupKt {
    private static final void toggleRegisterSet(CidrDebuggerSettings settings, String arch, String driverName, List<LLRegisterSet> registerSets, String updatedRegisterSet, boolean registerSetEnabled) {
        HashMap updatedSettings = new HashMap();
        List<LLRegisterSet> currentEnabledSets = CidrDebuggerRegisterSetsGroupKt.getEnabledRegisterSets(registerSets, arch, driverName);
        for (LLRegisterSet regSet : registerSets) {
            String regSetName = regSet.getName();
            ((Map)updatedSettings).put(regSetName, Intrinsics.areEqual((Object)regSetName, (Object)updatedRegisterSet) ? registerSetEnabled : currentEnabledSets.contains(regSet));
        }
        settings.setRegisterSetSettings(arch, driverName, updatedSettings);
    }

    @NotNull
    public static final List<LLRegisterSet> getEnabledRegisterSets(@NotNull List<LLRegisterSet> allRegisterSets, @NotNull String arch, @NotNull String driver) {
        Intrinsics.checkNotNullParameter(allRegisterSets, (String)"allRegisterSets");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Map<String, Boolean> settings = CidrDebuggerSettings.getInstance().getRegisterSetSettings(arch, driver);
        if (allRegisterSets.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (settings == null) {
            return CollectionsKt.listOf((Object)allRegisterSets.get(0));
        }
        ArrayList<LLRegisterSet> result = new ArrayList<LLRegisterSet>();
        for (LLRegisterSet registerSet : allRegisterSets) {
            if (!Intrinsics.areEqual((Object)settings.get(registerSet.getName()), (Object)true)) continue;
            result.add(registerSet);
        }
        return result;
    }

    public static final /* synthetic */ void access$toggleRegisterSet(CidrDebuggerSettings settings, String arch, String driverName, List registerSets, String updatedRegisterSet, boolean registerSetEnabled) {
        CidrDebuggerRegisterSetsGroupKt.toggleRegisterSet(settings, arch, driverName, registerSets, updatedRegisterSet, registerSetEnabled);
    }
}

