/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.jetbrains.cidr.execution.debugger.actions.CidrImageChannelFormat;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDataType;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDescriptor;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageShape;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0012H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrByteArrayImageDescriptor;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDescriptor;", "shape", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "startAddress", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "bytesBGR", "", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;Lcom/jetbrains/cidr/execution/debugger/memory/Address;[B)V", "getShape", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "memory", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "Ljava/nio/ByteBuffer;", "getPixelAddress", "x", "", "y", "getPixelData", "", "getImage", "Ljava/awt/image/BufferedImage;", "format", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageChannelFormat;", "supportedFormats", "", "getSupportedFormats", "()Ljava/util/List;", "createBufferedImage", "bytes", "bufferedImageType", "intellij.cidr.debugger"})
public final class CidrByteArrayImageDescriptor
implements CidrImageDescriptor {
    @NotNull
    private final CidrImageShape shape;
    @NotNull
    private final Address startAddress;
    private final ByteBuffer memory;

    public CidrByteArrayImageDescriptor(@NotNull CidrImageShape shape, @NotNull Address startAddress, @NotNull byte[] bytesBGR) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)startAddress, (String)"startAddress");
        Intrinsics.checkNotNullParameter((Object)bytesBGR, (String)"bytesBGR");
        this.shape = shape;
        this.startAddress = startAddress;
        this.memory = ByteBuffer.wrap(bytesBGR).order(ByteOrder.nativeOrder());
    }

    @Override
    @NotNull
    public CidrImageShape getShape() {
        return this.shape;
    }

    @Override
    @NotNull
    public Address getPixelAddress(int x, int y) {
        Integer n = this.getShape().getPixelOffset(x, y);
        int offset = n != null ? n : 0;
        return this.startAddress.plus(offset);
    }

    @Override
    @Nullable
    public String getPixelData(int x, int y) {
        Integer pixelOffset = this.getShape().getPixelOffset(x, y);
        if (pixelOffset == null) {
            return null;
        }
        ArrayList<String> channelValues = new ArrayList<String>(this.getShape().getChannelsCount());
        int n = this.getShape().getChannelsCount();
        for (int chan = 0; chan < n; ++chan) {
            int offset = pixelOffset + chan * this.getShape().getDataType().getSize();
            String channelValue = switch (WhenMappings.$EnumSwitchMapping$0[this.getShape().getDataType().ordinal()]) {
                case 1 -> String.valueOf(this.memory.get(offset));
                case 2 -> UByte.toString-impl((byte)UByte.constructor-impl((byte)this.memory.get(offset)));
                case 3 -> String.valueOf(this.memory.getShort(offset));
                case 4 -> UShort.toString-impl((short)UShort.constructor-impl((short)this.memory.getShort(offset)));
                case 5 -> String.valueOf(this.memory.getInt(offset));
                case 6 -> String.valueOf(this.memory.getFloat(offset));
                case 7 -> String.valueOf(this.memory.getDouble(offset));
                default -> throw new NoWhenBranchMatchedException();
            };
            channelValues.add(channelValue);
        }
        return CollectionsKt.joinToString$default((Iterable)channelValues, null, null, null, (int)0, null, null, (int)63, null);
    }

    @Override
    @NotNull
    public BufferedImage getImage(@Nullable CidrImageChannelFormat format) {
        CidrImageChannelFormat cidrImageChannelFormat = format;
        int[] channelOffsets = switch (cidrImageChannelFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cidrImageChannelFormat.ordinal()]) {
            case 1 -> {
                int[] var5_2 = new int[]{0, 1, 2};
                yield var5_2;
            }
            case 2 -> {
                int[] var5_2 = new int[]{2, 1, 0};
                yield var5_2;
            }
            case 3 -> {
                int[] var5_2 = new int[]{0, 1, 2, 3};
                yield var5_2;
            }
            case 4 -> {
                int[] var5_2 = new int[]{2, 1, 0, 3};
                yield var5_2;
            }
            case 5 -> {
                int[] var5_2 = new int[]{0};
                yield var5_2;
            }
            case 6 -> {
                int[] var5_2 = new int[]{1};
                yield var5_2;
            }
            case 7 -> {
                int[] var5_2 = new int[]{2};
                yield var5_2;
            }
            case 8 -> {
                int[] var5_2 = new int[]{3};
                yield var5_2;
            }
            case -1 -> {
                int[] var5_2 = new int[]{0};
                yield var5_2;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        int i = 0;
        int n = channelOffsets.length;
        while (i < n) {
            int n2 = i++;
            channelOffsets[n2] = channelOffsets[n2] * this.getShape().getDataType().getSize();
        }
        byte[] bufferedImageBytes = new byte[this.getShape().getPixelCount() * channelOffsets.length];
        int dst = 0;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getShape().getDataType().ordinal()]) {
            case 2: {
                IntIterator intIterator = this.getShape().getPixelOffsets();
                while (((Iterator)intIterator).hasNext()) {
                    int pixel = intIterator.nextInt();
                    int n3 = channelOffsets.length;
                    for (int j = 0; j < n3; ++j) {
                        int chan = channelOffsets[j];
                        bufferedImageBytes[dst++] = this.memory.get(pixel + chan);
                    }
                }
                break;
            }
            case 1: {
                IntIterator intIterator = this.getShape().getPixelOffsets();
                while (((Iterator)intIterator).hasNext()) {
                    int pixel = intIterator.nextInt();
                    int n4 = channelOffsets.length;
                    for (int j = 0; j < n4; ++j) {
                        int chan = channelOffsets[j];
                        byte v = this.memory.get(pixel + chan);
                        bufferedImageBytes[dst++] = (byte)(v + 128);
                    }
                }
                break;
            }
            case 3: {
                IntIterator intIterator = this.getShape().getPixelOffsets();
                while (((Iterator)intIterator).hasNext()) {
                    int pixel = intIterator.nextInt();
                    int n5 = channelOffsets.length;
                    for (int j = 0; j < n5; ++j) {
                        int chan = channelOffsets[j];
                        short v = this.memory.getShort(pixel + chan);
                        bufferedImageBytes[dst++] = (byte)RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)v / 255.0f + (float)128)), (int)0, (int)255);
                    }
                }
                break;
            }
            case 4: {
                IntIterator intIterator = this.getShape().getPixelOffsets();
                while (((Iterator)intIterator).hasNext()) {
                    int pixel = intIterator.nextInt();
                    int n6 = channelOffsets.length;
                    for (int j = 0; j < n6; ++j) {
                        int chan = channelOffsets[j];
                        short v = UShort.constructor-impl((short)this.memory.getShort(pixel + chan));
                        bufferedImageBytes[dst++] = (byte)RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)UnsignedKt.uintToDouble((int)(v & 0xFFFF)) / 255.0f)), (int)0, (int)255);
                    }
                }
                break;
            }
            case 5: {
                IntIterator intIterator = this.getShape().getPixelOffsets();
                while (((Iterator)intIterator).hasNext()) {
                    int pixel = intIterator.nextInt();
                    int n7 = channelOffsets.length;
                    for (int j = 0; j < n7; ++j) {
                        int chan = channelOffsets[j];
                        int v = this.memory.getInt(pixel + chan);
                        int s = RangesKt.coerceIn((int)v, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
                        bufferedImageBytes[dst++] = (byte)RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)s / 255.0f + (float)128)), (int)0, (int)255);
                    }
                }
                break;
            }
            case 6: {
                IntIterator intIterator = this.getShape().getPixelOffsets();
                while (((Iterator)intIterator).hasNext()) {
                    int pixel = intIterator.nextInt();
                    int n8 = channelOffsets.length;
                    for (int j = 0; j < n8; ++j) {
                        int chan = channelOffsets[j];
                        float v = this.memory.getFloat(pixel + chan);
                        bufferedImageBytes[dst++] = (byte)RangesKt.coerceIn((int)MathKt.roundToInt((float)(v * (float)255)), (int)0, (int)255);
                    }
                }
                break;
            }
            case 7: {
                IntIterator intIterator = this.getShape().getPixelOffsets();
                while (((Iterator)intIterator).hasNext()) {
                    int pixel = intIterator.nextInt();
                    int n9 = channelOffsets.length;
                    for (int j = 0; j < n9; ++j) {
                        int chan = channelOffsets[j];
                        double v = this.memory.getDouble(pixel + chan);
                        bufferedImageBytes[dst++] = (byte)RangesKt.coerceIn((int)MathKt.roundToInt((double)(v * (double)255)), (int)0, (int)255);
                    }
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int bufferedImageType = switch (channelOffsets.length) {
            case 3 -> 5;
            case 4 -> 6;
            default -> 10;
        };
        return this.createBufferedImage(bufferedImageBytes, bufferedImageType);
    }

    @Override
    @NotNull
    public List<CidrImageChannelFormat> getSupportedFormats() {
        return switch (this.getShape().getChannelsCount()) {
            case 1 -> CollectionsKt.emptyList();
            case 3 -> {
                CidrImageChannelFormat[] var1_1 = new CidrImageChannelFormat[]{CidrImageChannelFormat.BGR, CidrImageChannelFormat.RGB, CidrImageChannelFormat.CHANNEL0, CidrImageChannelFormat.CHANNEL1, CidrImageChannelFormat.CHANNEL2};
                yield CollectionsKt.listOf((Object[])var1_1);
            }
            case 4 -> {
                CidrImageChannelFormat[] var1_2 = new CidrImageChannelFormat[]{CidrImageChannelFormat.BGRA, CidrImageChannelFormat.RGBA, CidrImageChannelFormat.CHANNEL0, CidrImageChannelFormat.CHANNEL1, CidrImageChannelFormat.CHANNEL2, CidrImageChannelFormat.CHANNEL3};
                yield CollectionsKt.listOf((Object[])var1_2);
            }
            default -> throw new IllegalStateException();
        };
    }

    private final BufferedImage createBufferedImage(byte[] bytes, int bufferedImageType) {
        BufferedImage result = new BufferedImage(this.getShape().getWidthPixels(), this.getShape().getHeightPixels(), bufferedImageType);
        result.getRaster().setDataElements(0, 0, this.getShape().getWidthPixels(), this.getShape().getHeightPixels(), bytes);
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CidrImageDataType.values().length];
            try {
                nArray[CidrImageDataType.Int8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Uint8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Int16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Uint16.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Int32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Float32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Float64.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CidrImageChannelFormat.values().length];
            try {
                nArray[CidrImageChannelFormat.RGB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.BGR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.RGBA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.BGRA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL0.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL1.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL2.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL3.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

