/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.system.OS;
import com.intellij.xdebugger.XAlternativeSourceHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.ThreadsActionsProvider;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XSourceKind;
import com.intellij.xdebugger.impl.XSourcePositionEx;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrDebuggerPluginService;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrAggregatedFrameStatistics;
import com.jetbrains.cidr.execution.debugger.CidrAggregatedSessionStatistics;
import com.jetbrains.cidr.execution.debugger.CidrAlternativeSourceHandler;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessChildProcessHandler;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessListener;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessRawViewSupport;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerCommandExecutor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrDisasmConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrSourceFileLocator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSteppingStatistic;
import com.jetbrains.cidr.execution.debugger.CidrSteppingStatisticKind;
import com.jetbrains.cidr.execution.debugger.CidrSuspendContext;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.CidrSwitchThreadOnSuspendUtil;
import com.jetbrains.cidr.execution.debugger.CidrThreadFreezer;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.actions.CidrFreezeInactiveThreadsAmongSelectedHandler;
import com.jetbrains.cidr.execution.debugger.actions.CidrFreezeOtherThreadsHandler;
import com.jetbrains.cidr.execution.debugger.actions.CidrFreezeSelectedThreadsHandler;
import com.jetbrains.cidr.execution.debugger.actions.CidrFreezeThreadHandler;
import com.jetbrains.cidr.execution.debugger.actions.CidrUnfreezeAllThreadsHandler;
import com.jetbrains.cidr.execution.debugger.actions.CidrUnfreezeSelectedThreadsHandler;
import com.jetbrains.cidr.execution.debugger.actions.CidrUnfreezeThreadHandler;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandExpiredException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.features.RichValueDescriptionSupport;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrAddressBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointHandler;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisContext;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.jetbrains.cidr.util.events.CidrEventTracerKt;
import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrDebugProcess
extends XDebugProcess
implements DebuggerDriver.Handler,
UserDataHolderEx,
NatvisContext,
ThreadsActionsProvider,
CidrDebugProcessChildProcessHandler {
    public static final long ABORT_COMMAND_TIMEOUT = 3000L;
    public static final String BACKEND_CONTENT_ID = "DEBUGGER_BACKEND_CONSOLE";
    public static final String MEMORY_VIEW_CONTENT_ID = "DEBUGGER_MEMORY_VIEW";
    public static final Key<CidrDebugProcess> DEBUG_PROCESS_KEY = Key.create((String)CidrDebugProcess.class.getSimpleName());
    public static final Key<Boolean> THROW_ON_THREAD_COLLECTION = Key.create((String)"THROW_ON_THREAD_COLLECTION");
    public static final Key<Boolean> THROW_ON_FRAME_COLLECTION = Key.create((String)"THROW_ON_FRAME_COLLECTION");
    private static final Topic<CidrDebugProcessListener> ourListenerTopic = new Topic("CidrDebugProcessListener events", CidrDebugProcessListener.class);
    private final UserDataHolderBase myUserDataHolder;
    private final Disposable myProcessDisposable;
    private final CidrDebuggerCommandExecutor myDebuggerCommandExecutor;
    private final Disposable myUiDisposable;
    private final MyProcessHandler myProcessHandler;
    private final DebuggerDriver myDriverDoNotUse;
    @NlsSafe
    private final String myDriverName;
    private final DebuggerDriverConfiguration myConfiguration;
    private final CidrAlternativeSourceHandler myAlternativeSourceHandler;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final CidrBreakpointHandler myBreakpointHandler;
    private final CidrWatchpointHandler myWatchpointHandler;
    private final CidrAddressBreakpointHandler myAddressBreakpointHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final CidrExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    private final CidrSymbolicBreakpointHandler mySymbolicBreakpointHandler;
    private final Semaphore myAttachedSemaphore;
    protected final ConsoleView myConsole;
    protected final boolean myEmulateTerminal;
    protected boolean showConsole;
    private final LanguageConsoleView myBackendConsole;
    @Nullable
    private final MemoryViewPanel myHexdumpViewPanel;
    @NotNull
    private final CidrDebuggerModuleMemory myMemory;
    protected final RunParameters myRunParameters;
    private final ConcurrentMap<String, CidrDebuggerTypesHelperBase> myTypesHelpers;
    private final List<Couple<File>> mySymbolFiles;
    final ExecutionResult<DebuggerDriver.Inferior> myInferiorResult;
    private volatile State myState;
    @Nls
    private volatile String myCurrentStateMessage;
    @Nullable
    private LLThread myResumptionThread;
    private final CidrSourceFileLocator mySourceFileLocator;
    @NotNull
    private HexChangedHandler myHexChangedHandler;
    private final long myCreationTime;
    private static final AtomicLong ourCounter = new AtomicLong();
    private final String myName;
    private final AtomicReference<CompletableFuture<XSuspendContext>> mySuspendContextCalculation;
    private final AtomicBoolean myTimeToFirstModuleReported;
    private final AtomicBoolean myTimeToProgramExecutionReported;
    private final AtomicReference<@NotNull CidrAggregatedFrameStatistics> myFrameStatistics;
    private final AtomicReference<@NotNull CidrAggregatedSessionStatistics> mySessionStatistics;
    private final AtomicReference<@Nullable CidrSteppingStatistic> mySteppingStatistic;
    private final AtomicLong myStateChangeCount;
    private final CoroutineScope myDebugProcessScope;
    @Nullable
    private volatile com.intellij.execution.ExecutionException myFatalException;
    @NotNull
    private final Object mySymbolsDownloadTaskLock;
    @Nullable
    private SymbolsDownloadTask mySymbolsDownloadTask;

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws com.intellij.execution.ExecutionException {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(0);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(1);
        }
        if (consoleBuilder == null) {
            CidrDebugProcess.$$$reportNull$$$0(2);
        }
        this(parameters, session, consoleBuilder, it -> Filter.EMPTY_ARRAY, false);
    }

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsoleFilterProvider backendConsoleFilterProvider) throws com.intellij.execution.ExecutionException {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(3);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(4);
        }
        if (consoleBuilder == null) {
            CidrDebugProcess.$$$reportNull$$$0(5);
        }
        if (backendConsoleFilterProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(6);
        }
        this(parameters, session, consoleBuilder, backendConsoleFilterProvider, false);
    }

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession _session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsoleFilterProvider backendConsoleFilterProvider, boolean emulateTerminal) throws com.intellij.execution.ExecutionException {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(7);
        }
        if (_session == null) {
            CidrDebugProcess.$$$reportNull$$$0(8);
        }
        if (consoleBuilder == null) {
            CidrDebugProcess.$$$reportNull$$$0(9);
        }
        if (backendConsoleFilterProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(10);
        }
        super(_session);
        this.myUserDataHolder = new UserDataHolderBase();
        this.myAttachedSemaphore = new Semaphore(0);
        this.showConsole = true;
        this.myTypesHelpers = new ConcurrentHashMap<String, CidrDebuggerTypesHelperBase>();
        this.mySymbolFiles = new ArrayList<Couple<File>>();
        this.myInferiorResult = new ExecutionResult();
        this.myState = State.INITIALIZED;
        this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
        this.mySourceFileLocator = new CidrSourceFileLocator(this);
        this.mySuspendContextCalculation = new AtomicReference();
        this.myTimeToFirstModuleReported = new AtomicBoolean(false);
        this.myTimeToProgramExecutionReported = new AtomicBoolean(false);
        this.myFrameStatistics = new AtomicReference<CidrAggregatedFrameStatistics>(new CidrAggregatedFrameStatistics());
        this.mySessionStatistics = new AtomicReference<CidrAggregatedSessionStatistics>(new CidrAggregatedSessionStatistics());
        this.mySteppingStatistic = new AtomicReference<Object>(null);
        this.myStateChangeCount = new AtomicLong(0L);
        this.mySymbolsDownloadTaskLock = new Object();
        this.myCreationTime = System.currentTimeMillis();
        this.myName = "CidrDebugProcess#" + ourCounter.incrementAndGet() + " '" + _session.getSessionName() + "'";
        final XDebugSessionImpl session = (XDebugSessionImpl)_session;
        session.setPauseActionSupported(true);
        ThreadingAssertions.assertEventDispatchThread();
        this.myRunParameters = parameters;
        this.myConfiguration = parameters.getDebuggerDriverConfiguration();
        this.myConfiguration.setDebugProcessName(this.myName);
        this.myDriverName = this.myConfiguration.getDriverName();
        CidrDebuggerPluginService debuggerPluginService = (CidrDebuggerPluginService)this.getProject().getService(CidrDebuggerPluginService.class);
        this.myProcessDisposable = Disposer.newDisposable((Disposable)debuggerPluginService, (String)"CidrDebugProcess");
        this.myDebugProcessScope = debuggerPluginService.createDebugProcessScope(this.myProcessDisposable, this.myName);
        this.myUiDisposable = Disposer.newDisposable();
        this.myBackendConsole = new LanguageConsoleImpl(this.getProject(), this.getBackendConsoleTabName(), this.myConfiguration.getConsoleLanguage());
        Disposer.register((Disposable)this.myUiDisposable, (Disposable)this.myBackendConsole);
        this.myBackendConsole.getConsoleEditor().getDocument().putUserData(DEBUG_PROCESS_KEY, (Object)this);
        this.myBackendConsole.setEditable(false);
        this.myProcessHandler = new MyProcessHandler();
        try {
            this.myDriverDoNotUse = (DebuggerDriver)CidrCoroutineHelper.runComputableWithModalProgressBlocking(this.getProject(), CidrDebuggerBundle.message("setting.up.debugger", new Object[0]), () -> this.myConfiguration.createDriver(this, ArchitectureType.forArchitecture(parameters.getArchitectureId())));
        }
        catch (com.intellij.execution.ExecutionException e) {
            try {
                Disposer.dispose((Disposable)this.myUiDisposable);
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
            throw e;
        }
        this.myDebuggerCommandExecutor = new CidrDebuggerCommandExecutor(this, this.myDriverDoNotUse, this.myProcessDisposable);
        final BaseProcessHandler driverProcessHandler = this.myDriverDoNotUse.getProcessHandler();
        driverProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) == 0) {
                    return;
                }
                boolean isRemote = CidrDebugProcess.this.myConfiguration.getHostMachine().isRemote();
                if (isRemote && (exitCode == -1 || exitCode == 137)) {
                    return;
                }
                OS os = CidrDebugProcess.this.myConfiguration.getHostMachine().getOS();
                String exitCodeStringified = ProcessTerminatedListener.stringifyExitCode((OS)os, (int)exitCode);
                String message = new HtmlBuilder().append(CidrDebuggerBundle.message("debug.popup.error.crashed", exitCodeStringified)).append(" ").appendLink("Restart", CidrDebugProcess.this.getRestartDebuggerMessage()).toString();
                session.reportMessage(message, MessageType.ERROR, new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        CidrDebugProcess.this.restartDebugger((XDebugSession)session);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$1", "processTerminated"));
            }
        });
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                driverProcessHandler.startNotify();
            }

            private boolean shouldDetach(boolean willBeDestroyed) {
                boolean detach;
                boolean bl = detach = !willBeDestroyed;
                if (detach && !(detach = CidrDebugProcess.this.isDetachDefault())) {
                    CidrDebuggerLog.LOG.error("Detaching the debug process is not supported");
                }
                return detach;
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                CidrDebugProcess.this.myAttachedSemaphore.release();
                Alarm forceTerminateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, CidrDebugProcess.this.myProcessDisposable);
                CidrDebugProcess.this.postCommand(driver -> {
                    try {
                        CidrDebugProcess.this.doDisconnectTarget(CidrDebugProcess.this.myInferiorResult.get(), !this.shouldDetach(willBeDestroyed));
                    }
                    finally {
                        if (forceTerminateAlarm.cancelAllRequests() > 0) {
                            CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                        }
                    }
                    driver.checkErrors();
                });
                forceTerminateAlarm.addRequest(() -> CidrDebugProcess.this.postCommand(driver -> {
                    CidrDebuggerLog.LOG.warn("Cannot detach/abort. Forcing driver termination");
                    CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                }, true), 3000L);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
                CidrDebugProcess.this.myState = State.FINISHED;
                Disposer.dispose((Disposable)CidrDebugProcess.this.myProcessDisposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myProcessDisposable);
        boolean memoryDocsEnabled = CidrDebuggerModuleMemory.memoryDocsEnabled((XDebugSession)session);
        this.myAlternativeSourceHandler = memoryDocsEnabled ? new CidrAlternativeSourceHandler((XDebugSession)session, this.myDebugProcessScope) : null;
        this.myEditorsProvider = this.createEditorsProvider(session.getRunProfile());
        this.myBreakpointHandler = this.createBreakpointHandler();
        this.myWatchpointHandler = new CidrWatchpointHandler(this);
        this.myAddressBreakpointHandler = new CidrAddressBreakpointHandler(this);
        this.myExceptionBreakpointHandler = this.createExceptionHandler();
        this.mySymbolicBreakpointHandler = this.createSymbolicHandler();
        List handlersList = ContainerUtil.packNullables((Object[])new XBreakpointHandler[]{this.myBreakpointHandler, this.myWatchpointHandler, this.myAddressBreakpointHandler, this.myExceptionBreakpointHandler, this.mySymbolicBreakpointHandler});
        this.myBreakpointHandlers = handlersList.toArray(XBreakpointHandler.EMPTY_ARRAY);
        this.myConsole = consoleBuilder.getConsole();
        this.myEmulateTerminal = emulateTerminal;
        Filter[] backendConsoleFilters = backendConsoleFilterProvider.getDefaultFilters(this.getProject());
        Arrays.stream(backendConsoleFilters).forEach(arg_0 -> ((LanguageConsoleView)this.myBackendConsole).addMessageFilter(arg_0));
        this.myMemory = new CidrDebuggerModuleMemory(this, this.myUiDisposable);
        this.myHexdumpViewPanel = MemoryViewPanel.create(this.getProject(), (VirtualFile)this.myMemory.getHexdumpDoc().getVirtualFile());
        if (this.myHexdumpViewPanel != null) {
            Disposer.register((Disposable)this.myUiDisposable, (Disposable)this.myHexdumpViewPanel);
        }
        session.addSessionListener(new XDebugSessionListener(){

            public void beforeSessionResume() {
                CidrDebugProcess.this.myStateChangeCount.incrementAndGet();
            }

            public void sessionPaused() {
                CidrDebugProcess.this.myStateChangeCount.incrementAndGet();
            }

            public void sessionStopped() {
                CidrDebugProcess.this.myStateChangeCount.incrementAndGet();
            }

            public void stackFrameChanged() {
                CidrDebugProcess.this.myStateChangeCount.incrementAndGet();
            }

            public void settingsChanged() {
                CidrDebugProcess.this.myStateChangeCount.incrementAndGet();
            }
        });
        session.addSessionListener(new XDebugSessionListener(){

            public void beforeSessionResume() {
                XStackFrame xStackFrame;
                if (!CidrDebugProcess.this.useLegacyStepping() && (xStackFrame = session.getCurrentStackFrame()) instanceof CidrStackFrame) {
                    CidrStackFrame stackFrame = (CidrStackFrame)xStackFrame;
                    CidrDebugProcess.this.myResumptionThread = stackFrame.getThread();
                } else {
                    xStackFrame = session.getSuspendContext();
                    if (xStackFrame instanceof CidrSuspendContext) {
                        CidrSuspendContext suspendContext = (CidrSuspendContext)xStackFrame;
                        CidrExecutionStack executionStack = suspendContext.getCurrentExecutionStack();
                        CidrDebugProcess.this.myResumptionThread = executionStack.getThread();
                    } else {
                        CidrDebugProcess.this.myResumptionThread = null;
                    }
                }
            }
        }, this.myProcessDisposable);
        session.addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                CidrDebugProcess.this.reportFrameStatistics();
            }

            public void sessionPaused() {
                CidrDebugProcess.this.reportFrameStatistics();
                CidrDebugProcess.this.reportSteppingStatistics();
            }

            public void sessionStopped() {
                CidrDebugProcess.this.reportFrameStatistics();
                CidrDebugProcess.this.reportAggregatedSessionStatistics();
                CidrDebugProcess.this.reportSteppingStatistics();
            }
        });
        MySuspensionGutterIconManager gutterIconManager = new MySuspensionGutterIconManager();
        Disposer.register((Disposable)this.myProcessDisposable, (Disposable)gutterIconManager);
        this.myHexChangedHandler = () -> session.rebuildViews();
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        settings.addHexFormattingSettingsListener(new CidrDebuggerSettings.SettingListener(){

            @Override
            public void settingChanged() {
                CidrDebugProcess.this.myHexChangedHandler.handleHexChanged();
            }
        }, this.myProcessDisposable);
        CidrDebuggerSettings.SettingListener rebuildViewsFunctor = () -> session.rebuildViews();
        settings.addMuteVariablesListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addValuesFilterEnabledListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addFrameDecorationSettingsListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addValuePresentationSettingsListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addShowFunctionReturnValueListener(rebuildViewsFunctor, this.myProcessDisposable);
        settings.addRegistersSettingsListener(rebuildViewsFunctor, this.myProcessDisposable);
        if (this.myDriverDoNotUse.supportsDebuggingForkedProcess()) {
            settings.addForkSettingsListener(() -> this.postCommand((DebuggerDriver driver) -> {
                driver.setFollowChildOnFork(settings.isFollowChildOnFork());
                return null;
            }), this.myProcessDisposable);
        }
        if (this.myDriverDoNotUse.supportsDebuggingMultipleProcesses()) {
            settings.addDetachSettingsListener(() -> this.postCommand((DebuggerDriver driver) -> {
                driver.setDetachOnFork(settings.isDetachOnFork());
                return null;
            }), this.myProcessDisposable);
        }
        ((CidrDebugProcessListener)this.getProject().getMessageBus().syncPublisher(ourListenerTopic)).processCreated(this, session.getExecutionEnvironment());
        Disposer.register((Disposable)this.myProcessDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = CidrDebugProcess.this.mySymbolsDownloadTaskLock;
                synchronized (object) {
                    if (CidrDebugProcess.this.mySymbolsDownloadTask != null) {
                        CidrDebugProcess.this.mySymbolsDownloadTask.setDone();
                        CidrDebugProcess.this.mySymbolsDownloadTask = null;
                    }
                }
            }
        });
    }

    public boolean IsParallelStackMinimizedByDefault() {
        return true;
    }

    protected void restartDebugger(@NotNull XDebugSession session) {
        XDebugSessionTab sessionTab;
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(11);
        }
        if ((sessionTab = ((XDebugSessionImpl)session).getSessionTab()) == null || Disposer.isDisposed((Disposable)sessionTab)) {
            return;
        }
        RunContentDescriptor runContentDescriptor = sessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            return;
        }
        JComponent component = runContentDescriptor.getComponent();
        if (component == null) {
            return;
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)component);
        ExecutionEnvironment environment = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(context);
        if (environment == null) {
            return;
        }
        ExecutionUtil.restart((ExecutionEnvironment)environment);
    }

    @NlsContexts.LinkLabel
    @NotNull
    protected String getRestartDebuggerMessage() {
        String string = CidrDebuggerBundle.message("debug.popup.rerun", this.getSession().getSessionName());
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public Disposable getProcessDisposable() {
        Disposable disposable = this.myProcessDisposable;
        if (disposable == null) {
            CidrDebugProcess.$$$reportNull$$$0(13);
        }
        return disposable;
    }

    @NotNull
    public Disposable getUiDisposable() {
        Disposable disposable = this.myUiDisposable;
        if (disposable == null) {
            CidrDebugProcess.$$$reportNull$$$0(14);
        }
        return disposable;
    }

    @NotNull
    public String getCurrentStateMessage() {
        String string = this.myCurrentStateMessage;
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            CidrDebugProcess.$$$reportNull$$$0(16);
        }
        return consoleView;
    }

    @NotNull
    private XDebuggerEditorsProvider createEditorsProvider(RunProfile profile) throws com.intellij.execution.ExecutionException {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = CidrDebuggerLanguageSupportManager.getInstance().createEditor(this.getProject(), profile);
        if (xDebuggerEditorsProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(17);
        }
        return xDebuggerEditorsProvider;
    }

    public boolean isDetachDefault() {
        return false;
    }

    public boolean supportsWatchpoints() {
        return this.myDriverDoNotUse.supportsWatchpoints();
    }

    public boolean supportsWatchpointLifetime() {
        return this.myDriverDoNotUse.supportsWatchpointLifetime();
    }

    public boolean supportsJumpToLine() {
        return !((XDebugSessionImpl)this.getSession()).isReadOnly() && this.myDriverDoNotUse.supportsJumpToLine();
    }

    @NotNull
    public CidrThreadFreezer getThreadFreezer() {
        return new CidrThreadFreezer(this, this.myDriverDoNotUse.supportsFreezeSingleThread(), this.myDriverDoNotUse.supportsFreezeOtherThreads());
    }

    public boolean isRichValueDescriptionEnabled() {
        return this.getUserData(CidrValue.THREAT_VALUE_AS_RICH_TEXT) == Boolean.TRUE;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getSession().getProject();
        if (project == null) {
            CidrDebugProcess.$$$reportNull$$$0(18);
        }
        return project;
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        if (driver == null) {
            CidrDebugProcess.$$$reportNull$$$0(19);
        }
        if (frame == null) {
            CidrDebugProcess.$$$reportNull$$$0(20);
        }
        EvaluationContext evaluationContext = this.myConfiguration.createEvaluationContext(driver, expirable, frame.getThread(), frame.getFrame(), frame);
        if (evaluationContext == null) {
            CidrDebugProcess.$$$reportNull$$$0(21);
        }
        return evaluationContext;
    }

    public boolean driverSupportsArrayEvaluation() {
        return this.myConfiguration.supportsArrayEvaluation();
    }

    public boolean driverSupportsCodeFragmentEvaluation() {
        return this.myConfiguration.isCodeFragmentEvaluationSupported();
    }

    @TestOnly
    public DebuggerDriver getDriverInTests() {
        return this.myDriverDoNotUse;
    }

    @TestOnly
    public DebuggerDriver.Inferior getInferiorInTests() {
        try {
            return this.myInferiorResult.get();
        }
        catch (com.intellij.execution.ExecutionException e) {
            return null;
        }
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logStack(@NotNull XSuspendContext suspendContext, @NotNull XDebugSession session) {
        if (suspendContext == null) {
            CidrDebugProcess.$$$reportNull$$$0(22);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(23);
        }
        XExecutionStack activeExecutionStack = suspendContext.getActiveExecutionStack();
        CidrExecutionStack cidrExecutionStack = (CidrExecutionStack)((Object)ObjectUtils.tryCast((Object)activeExecutionStack, CidrExecutionStack.class));
        try {
            if (cidrExecutionStack != null) {
                cidrExecutionStack.setRequestsBatching(false);
            }
            super.logStack(suspendContext, session);
        }
        finally {
            if (cidrExecutionStack != null) {
                cidrExecutionStack.setRequestsBatching(true);
            }
        }
    }

    public void setHexChangedHandler(@NotNull HexChangedHandler handler) {
        if (handler == null) {
            CidrDebugProcess.$$$reportNull$$$0(24);
        }
        this.myHexChangedHandler = handler;
    }

    protected boolean waitForTermination() {
        return this.myDriverDoNotUse.getProcessHandler().waitFor();
    }

    @TestOnly
    boolean waitForAttach(int timeout) throws InterruptedException {
        return this.myAttachedSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public final void start() {
        this.myState = State.STARTING;
        CidrDebugProcess.registerTabCompletion((Editor)this.myBackendConsole.getConsoleEditor());
        for (CidrDebugProcessConfigurator configurator : CidrDebugProcessConfigurator.EP_NAME.getExtensionList()) {
            configurator.configureBeforeTargetLoaded(this);
        }
        this.postCommand((DebuggerDriver driver) -> {
            DebuggerDriver.Inferior inferior;
            try {
                inferior = this.doLoadTarget(driver);
                List<Couple<File>> list = this.mySymbolFiles;
                synchronized (list) {
                    for (Couple<File> file : this.mySymbolFiles) {
                        driver.addSymbolsFile((File)file.first, (File)file.second);
                    }
                    this.mySymbolFiles.clear();
                }
                this.myState = State.STARTED;
            }
            catch (com.intellij.execution.ExecutionException e) {
                this.myInferiorResult.setException(e);
                throw e;
            }
            this.myInferiorResult.set(inferior);
        });
        for (CidrDebugProcessConfigurator configurator : CidrDebugProcessConfigurator.EP_NAME.getExtensionList()) {
            configurator.configure(this);
        }
    }

    protected static void registerTabCompletion(final Editor editor) {
        AnAction action = ActionManager.getInstance().getAction("CodeCompletion");
        if (action == null) {
            return;
        }
        AnActionWrapper wrappedAction = new AnActionWrapper(action){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                super.update(e);
                LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)editor);
                e.getPresentation().setEnabled(lookup == null || !lookup.isAvailableToUser());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$8", "update"));
            }
        };
        wrappedAction.registerCustomShortcutSet(9, 0, editor.getContentComponent());
    }

    @NotNull
    protected abstract DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException;

    @Nullable
    public MemoryViewPanel getHexdumpViewPanel() {
        return this.myHexdumpViewPanel;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                if (ui == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (console == null) {
                    9.$$$reportNull$$$0(1);
                }
                Content content = ui.createContent("ConsoleContent", console.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), null, console.getPreferredFocusableComponent());
                content.setCloseable(false);
                if (CidrDebugProcess.this.showConsole) {
                    ui.addContent(content, 1, PlaceInGrid.bottom, false);
                }
                Content content2 = content;
                if (content2 == null) {
                    9.$$$reportNull$$$0(2);
                }
                return content2;
            }

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    9.$$$reportNull$$$0(3);
                }
                Disposer.register((Disposable)ui.getContentManager(), (Disposable)CidrDebugProcess.this.myUiDisposable);
                Content backendConsoleContent = ui.createContent(CidrDebugProcess.BACKEND_CONTENT_ID, CidrDebugProcess.this.myBackendConsole.getComponent(), CidrDebugProcess.this.getBackendConsoleTabName(), AllIcons.Debugger.Console, CidrDebugProcess.this.myBackendConsole.getPreferredFocusableComponent());
                backendConsoleContent.setCloseable(false);
                9.addContent(ui, backendConsoleContent, false);
                for (BackendConsoleInjectionHelper helper : (BackendConsoleInjectionHelper[])BackendConsoleInjectionHelper.EP_NAME.getExtensions()) {
                    helper.subscribeToInjection(CidrDebugProcess.this.getSession());
                }
                LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)CidrDebugProcess.this.myBackendConsole, text -> CidrDebugProcess.this.executeConsoleCommand((String)text), (String)"AppCode.Debug.Console", null, null);
                if (CidrDebugProcess.this.myHexdumpViewPanel != null) {
                    Content memoryViewContent = ui.createContent(CidrDebugProcess.MEMORY_VIEW_CONTENT_ID, CidrDebugProcess.this.myHexdumpViewPanel.getComponent(), CidrDebuggerBundle.message("debug.memory.view.process", new Object[0]), null, CidrDebugProcess.this.myHexdumpViewPanel.getPreferredFocusableComponent());
                    memoryViewContent.setCloseable(false);
                    9.addContent(ui, memoryViewContent, false);
                }
                CidrDebugProcess.this.getSession().addSessionListener(new XDebugSessionListener(){
                    private CidrEventSpan myStateSpan;

                    public void sessionPaused() {
                        this.traceState(null);
                        CidrEventTracerKt.traceMarker("debug", "session paused", null);
                        this.enableConsole(true);
                    }

                    public void sessionResumed() {
                        CidrEventTracerKt.traceMarker("debug", "session resumed");
                        this.traceState(new CidrEventSpan("debug", "session running", null, "<DebugSession>"));
                        this.enableConsole(false);
                    }

                    public void sessionStopped() {
                        this.traceState(null);
                        CidrEventTracerKt.traceMarker("debug", "sessionStopped", null);
                        this.enableConsole(false);
                    }

                    private void enableConsole(boolean enabled) {
                        if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                            return;
                        }
                        CidrDebugProcess.this.myBackendConsole.setEditable(enabled);
                    }

                    private void traceState(@Nullable CidrEventSpan eventSpan) {
                        if (this.myStateSpan != null) {
                            this.myStateSpan.close();
                        }
                        this.myStateSpan = eventSpan;
                    }
                });
            }

            private static void addContent(@NotNull RunnerLayoutUi ui, Content content, boolean defaultIsMinimized) {
                boolean newDebugWindowView;
                if (ui == null) {
                    9.$$$reportNull$$$0(4);
                }
                if (newDebugWindowView = UIExperiment.isNewDebuggerUIEnabled()) {
                    ui.addContent(content, -1, PlaceInGrid.center, defaultIsMinimized);
                } else {
                    ui.addContent(content, 0, PlaceInGrid.center, defaultIsMinimized);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ui";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$9";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "registerConsoleContent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerConsoleContent";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "registerAdditionalContent";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "addContent";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    public boolean checkCanPerformCommands() {
        if (this.myDriverDoNotUse.isInPromptMode()) {
            this.getSession().reportMessage(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]), MessageType.WARNING);
            RunnerLayoutUi ui = this.getSession().getUI();
            Content gdbContent = ui.findContent(BACKEND_CONTENT_ID);
            ui.selectAndFocus(gdbContent, true, true);
            return false;
        }
        return true;
    }

    @Nls
    @NotNull
    protected String getBackendConsoleTabName() {
        String string = this.myDriverName;
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(26);
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    protected CidrBreakpointHandler createBreakpointHandler() {
        return new CidrBreakpointHandler(this);
    }

    @NotNull
    protected CidrExceptionBreakpointHandler createExceptionHandler() {
        return new CidrExceptionBreakpointHandler(this, (Class<? extends CidrExceptionBreakpointType>)CidrExceptionBreakpointType.class);
    }

    @Nullable
    private CidrSymbolicBreakpointHandler createSymbolicHandler() {
        CidrSymbolicBreakpointType symbolicBreakpointType = (CidrSymbolicBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class));
        return symbolicBreakpointType != null ? new CidrSymbolicBreakpointHandler(this, (Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>>)((Object)((Object)symbolicBreakpointType)).getClass()) : null;
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            CidrDebugProcess.$$$reportNull$$$0(27);
        }
        return this.myBreakpointHandlers;
    }

    @Nullable
    public XAlternativeSourceHandler getAlternativeSourceHandler() {
        return this.myAlternativeSourceHandler;
    }

    @NotNull
    public ConsoleView createConsole() {
        if (this.myEmulateTerminal) {
            ProcessHandlerTtyConnector ttyConnector = new ProcessHandlerTtyConnector(this.myProcessHandler, EncodingProjectManager.getInstance((Project)this.getProject()).getDefaultCharset()){

                public void resize(@NotNull TermSize termSize) {
                    if (termSize == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    CidrDebugProcess.this.resize(termSize.getColumns(), termSize.getRows());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termSize", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$10", "resize"));
                }
            };
            TerminalExecutionConsole terminalExecutionConsole = CidrDebugProcess.getTerminalExecutionConsole(this.myConsole);
            if (terminalExecutionConsole != null) {
                terminalExecutionConsole.attachToProcess((ProcessHandler)this.myProcessHandler, (TtyConnector)ttyConnector, true);
            }
        } else {
            this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        }
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            CidrDebugProcess.$$$reportNull$$$0(28);
        }
        return consoleView;
    }

    @Nullable
    private static TerminalExecutionConsole getTerminalExecutionConsole(@NotNull ConsoleView consoleView) {
        if (consoleView == null) {
            CidrDebugProcess.$$$reportNull$$$0(29);
        }
        if (consoleView instanceof TerminalExecutionConsole) {
            TerminalExecutionConsole terminalExecutionConsole = (TerminalExecutionConsole)consoleView;
            return terminalExecutionConsole;
        }
        if (consoleView instanceof ConsoleViewWrapperBase) {
            ConsoleViewWrapperBase consoleViewWrapper = (ConsoleViewWrapperBase)consoleView;
            return CidrDebugProcess.getTerminalExecutionConsole(consoleViewWrapper.getDelegate());
        }
        CidrDebuggerLog.LOG.error("Cannot retrieve TerminalExecutionConsole from ConsoleView");
        return null;
    }

    public LanguageConsoleView getDebuggerConsole() {
        return this.myBackendConsole;
    }

    public void sessionInitialized() {
        this.setupWatchesEvaluatedListener();
        this.postCommand((DebuggerDriver driver) -> {
            if (this.myState != State.STARTED) {
                return;
            }
            this.doStartTarget(this.myInferiorResult.get());
            this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
            this.getSession().rebuildViews();
            CidrDebuggerUsagesCollector.logDebugSessionInitialized(this.getDriverName(), System.currentTimeMillis() - this.myCreationTime);
        });
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws com.intellij.execution.ExecutionException {
        if (inferior == null) {
            CidrDebugProcess.$$$reportNull$$$0(30);
        }
        return inferior.start();
    }

    protected void doDisconnectTarget(@NotNull DebuggerDriver.Inferior inferior, boolean shouldDestroy) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (inferior == null) {
            CidrDebugProcess.$$$reportNull$$$0(31);
        }
        if (shouldDestroy) {
            inferior.destroy();
        } else {
            inferior.detach();
        }
    }

    public void stop() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            this.myWatchpointHandler.cleanup();
            this.myAddressBreakpointHandler.cleanup();
        });
        this.getProcessHandler().destroyProcess();
    }

    public void startPausing() {
        this.postCommand(DebuggerDriver::interrupt);
    }

    public void resume(@Nullable XSuspendContext context) {
        LLThread resumptionThread = this.getResumptionThread();
        this.postCommand((DebuggerDriver driver) -> driver.resume(resumptionThread));
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(32);
        }
        Address address = this.positionToAddress(position);
        this.postCommand((DebuggerDriver driver) -> {
            if (address != null) {
                driver.runTo(address);
            } else {
                driver.runTo(position.getFile().getPath(), position.getLine());
            }
        });
    }

    public boolean jumpToLine(@NotNull LLThread thread, @NotNull VirtualFile file, int line) {
        XSuspendContext context;
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(33);
        }
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(34);
        }
        if ((context = this.getSession().getSuspendContext()) == null) {
            return false;
        }
        this.jumpToLineImpl(thread, file, line, false, context).thenAccept(askToRetry -> {
            if (!askToRetry.booleanValue()) {
                return;
            }
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"", (String)CidrDebuggerBundle.message("debug.jumpToLine.warning", new Object[0])).icon(Messages.getWarningIcon());
                if (yesNo.ask(this.getProject())) {
                    XSuspendContext newContext = this.getSession().getSuspendContext();
                    if (newContext == null) {
                        return;
                    }
                    this.jumpToLineImpl(thread, file, line, true, newContext);
                }
            });
        });
        return true;
    }

    @NotNull
    private CompletableFuture<Boolean> jumpToLineImpl(@NotNull LLThread thread, @NotNull VirtualFile file, int line, boolean canLeaveFunction, @NotNull XSuspendContext context) {
        Address address;
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(35);
        }
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(36);
        }
        if (context == null) {
            CidrDebugProcess.$$$reportNull$$$0(37);
        }
        String path = file.getPath();
        XSourcePosition position = XDebuggerUtil.getInstance().createPosition(file, line);
        Address address2 = address = position != null ? this.positionToAddress(position) : null;
        if (this.fileToMemoryDoc(file) != null && address == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                CidrDebugProcess.$$$reportNull$$$0(38);
            }
            return completableFuture;
        }
        this.handleRunning();
        CompletableFuture<Boolean> completableFuture = this.postCommand((DebuggerDriver driver) -> {
            DebuggerDriver.StopPlace stopPlace;
            try {
                stopPlace = address != null ? driver.jumpToAddress(thread, address, canLeaveFunction) : driver.jumpToLine(thread, path, line, canLeaveFunction);
            }
            catch (DebuggerDriver.JumpToLineOutsideCurrentFunctionException ignored) {
                this.notifyPositionReached(context, false);
                return true;
            }
            catch (DebuggerCommandException ex) {
                @NlsSafe String message = CidrDebugProcess.formatJumpToLineErrorMessageToHTML(StringUtil.notNullize((String)ex.getMessage()));
                this.getSession().reportMessage(message, MessageType.ERROR);
                this.notifyPositionReached(context, false);
                return false;
            }
            this.handleInterrupted(stopPlace);
            return false;
        });
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    @NotNull
    @NlsSafe
    private static String formatJumpToLineErrorMessageToHTML(@NotNull String message) {
        if (message == null) {
            CidrDebugProcess.$$$reportNull$$$0(40);
        }
        @NlsSafe String shortMessage = CidrDebugProcess.stripJumpToLineErrorMessage(message);
        String string = HtmlChunk.text((String)shortMessage).toString();
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    private static String stripJumpToLineErrorMessage(@NotNull String message) {
        int offset;
        if (message == null) {
            CidrDebugProcess.$$$reportNull$$$0(42);
        }
        if ((offset = (message = message.trim()).indexOf(10)) == -1) {
            String string = message;
            if (string == null) {
                CidrDebugProcess.$$$reportNull$$$0(43);
            }
            return string;
        }
        for (int i = 0; i < 5 && offset != -1; ++i) {
            offset = message.indexOf(10, offset + 1);
        }
        if (offset == -1) {
            String string = message;
            if (string == null) {
                CidrDebugProcess.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = message.substring(0, offset + 1) + "\t...";
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(45);
        }
        return string;
    }

    @Nullable
    private Address positionToAddress(@NotNull XSourcePosition position) {
        CidrMemoryDoc<?> memoryDoc;
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(46);
        }
        return (memoryDoc = this.fileToMemoryDoc(position.getFile())) == null ? null : memoryDoc.getAddress(position);
    }

    @Nullable
    public CidrMemoryDoc<?> fileToMemoryDoc(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CidrDebugProcess.$$$reportNull$$$0(47);
        }
        if (!(virtualFile instanceof MemoryViewFile)) {
            return null;
        }
        MemoryViewFile memoryViewFile = (MemoryViewFile)virtualFile;
        CidrMemoryDoc<?> memoryDoc = memoryViewFile.getMemoryDoc();
        if (memoryDoc != null && !this.myMemory.contains(memoryDoc)) {
            return null;
        }
        return memoryDoc;
    }

    private boolean isDisassemblyContext(@Nullable XSuspendContext context) {
        if (context == null) {
            return false;
        }
        XExecutionStack stack = context.getActiveExecutionStack();
        if (stack == null) {
            return false;
        }
        XStackFrame frame = stack.getTopFrame();
        if (!(frame instanceof CidrStackFrame)) {
            return false;
        }
        return !((CidrStackFrame)frame).hasSourceFile() || ((XDebugSessionImpl)this.getSession()).getCurrentSourceKind() == XSourceKind.ALTERNATIVE;
    }

    protected boolean useLegacyStepping() {
        return Registry.is((String)"cidr.debugger.stepping.legacyStepping", (boolean)false);
    }

    @NotNull
    private LLThread getResumptionThread() {
        if (this.myResumptionThread == null) {
            throw new IllegalStateException("No current thread for stepping");
        }
        LLThread lLThread = this.myResumptionThread;
        if (lLThread == null) {
            CidrDebugProcess.$$$reportNull$$$0(48);
        }
        return lLThread;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        boolean stepByInstruction = this.isDisassemblyContext(context);
        LLThread resumptionThread = this.getResumptionThread();
        this.postCommand((DebuggerDriver driver) -> {
            this.startSteppingActivity(CidrSteppingStatisticKind.StepOver);
            driver.stepOver(resumptionThread, stepByInstruction);
        });
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = this.isDisassemblyContext(context);
        LLThread resumptionThread = this.getResumptionThread();
        this.postCommand((DebuggerDriver driver) -> {
            this.startSteppingActivity(CidrSteppingStatisticKind.StepInto);
            driver.stepInto(resumptionThread, false, stepByInstruction);
        });
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = this.isDisassemblyContext(context);
        LLThread resumptionThread = this.getResumptionThread();
        this.postCommand((DebuggerDriver driver) -> {
            this.startSteppingActivity(CidrSteppingStatisticKind.ForceStepInto);
            driver.stepInto(resumptionThread, true, stepByInstruction);
        });
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        boolean stopInFramesWithoutDebugInfo = this.isDisassemblyContext(context);
        LLThread resumptionThread = this.getResumptionThread();
        this.postCommand((DebuggerDriver driver) -> {
            this.startSteppingActivity(CidrSteppingStatisticKind.StepOut);
            driver.stepOut(resumptionThread, stopInFramesWithoutDebugInfo);
        });
    }

    @Nullable
    public XSourcePosition createSourcePosition(@NotNull String file, @Nullable DebuggerSourceFileHash hash, int line) {
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(49);
        }
        try {
            VirtualFile resolvedFile = this.resolveFile(file, hash);
            return resolvedFile != null ? XDebuggerUtil.getInstance().createPosition(resolvedFile, line) : null;
        }
        catch (ProcessCanceledException ignore) {
            return null;
        }
    }

    @Nullable
    public VirtualFile resolveFile(@NotNull String file, @Nullable DebuggerSourceFileHash hash) {
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(50);
        }
        return (VirtualFile)ReadAction.compute(() -> {
            VirtualFile vFile = this.getSourceFileLocator().locate(file, hash);
            if (vFile == null) {
                return null;
            }
            VirtualFile resolvedFile = ProjectRootUtil.findSymlinkedFileInContent((Project)this.getProject(), (VirtualFile)vFile);
            if (CidrDebuggerLog.LOG.isTraceEnabled() && !vFile.equals(resolvedFile)) {
                CidrDebuggerLog.LOG.trace("Debugger path resolved: " + vFile + " -> " + resolvedFile);
            }
            return resolvedFile;
        });
    }

    @NotNull
    public XSourcePosition createDisasmPosition(@NotNull Address address) {
        if (address == null) {
            CidrDebugProcess.$$$reportNull$$$0(51);
        }
        XSourcePositionEx xSourcePositionEx = this.myMemory.getDisasmDoc().getAddressPosition(address);
        if (xSourcePositionEx == null) {
            CidrDebugProcess.$$$reportNull$$$0(52);
        }
        return xSourcePositionEx;
    }

    protected void executeConsoleCommand(@NotNull String text) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(53);
        }
        long threadId = this.getCurrentThreadId();
        int frameIndex = this.getCurrentFrameIndex();
        this.postCommand((DebuggerDriver driver) -> {
            RichValueDescriptionSupport richValueDescriptionSupport = this.isRichValueDescriptionEnabled() ? (RichValueDescriptionSupport)ObjectUtils.tryCast((Object)driver, RichValueDescriptionSupport.class) : null;
            try {
                if (richValueDescriptionSupport != null) {
                    richValueDescriptionSupport.setRichValueDescriptionEnabled(false);
                }
                driver.executeInterpreterCommand(threadId, frameIndex, text);
            }
            catch (DebuggerCommandException e) {
                this.printlnToConsole(e.getMessage());
            }
            finally {
                if (richValueDescriptionSupport != null) {
                    richValueDescriptionSupport.setRichValueDescriptionEnabled(true);
                }
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> postCommand(@NotNull VoidDebuggerCommand command) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(54);
        }
        CompletableFuture<Void> completableFuture = this.postCommand((DebuggerCommand)command);
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(55);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> postCommand(@Nullable Expirable expirable, @NotNull VoidDebuggerCommand command) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(56);
        }
        CompletableFuture<Void> completableFuture = this.postCommand(expirable, (DebuggerCommand)command);
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(57);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> postCommand(@NotNull VoidDebuggerCommand command, boolean useAlternativeDispatcher) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(58);
        }
        CompletableFuture<Void> completableFuture = this.postCommand((DebuggerCommand)command, useAlternativeDispatcher);
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(59);
        }
        return completableFuture;
    }

    @NotNull
    public <T> CompletableFuture<T> postCommand(@NotNull DebuggerCommand<T> command) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(60);
        }
        CompletableFuture<T> completableFuture = this.myDebuggerCommandExecutor.executeCommandAsync(command, command.canExecuteWhileRunning(), false);
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(61);
        }
        return completableFuture;
    }

    @NotNull
    public <T> CompletableFuture<T> postCommand(@Nullable Expirable expirable, @NotNull DebuggerCommand<T> command) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(62);
        }
        CompletableFuture<T> completableFuture = this.myDebuggerCommandExecutor.executeCommandAsync(command, command.canExecuteWhileRunning(), false, expirable);
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(63);
        }
        return completableFuture;
    }

    @NotNull
    public <T> CompletableFuture<T> postCommand(@NotNull DebuggerCommand<T> command, boolean useAlternativeDispatcher) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(64);
        }
        CompletableFuture<T> completableFuture = this.myDebuggerCommandExecutor.executeCommandAsync(command, command.canExecuteWhileRunning(), useAlternativeDispatcher);
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(65);
        }
        return completableFuture;
    }

    @NotNull
    public CidrDebuggerCommandExecutor getDebuggerCommandExecutor() {
        CidrDebuggerCommandExecutor cidrDebuggerCommandExecutor = this.myDebuggerCommandExecutor;
        if (cidrDebuggerCommandExecutor == null) {
            CidrDebugProcess.$$$reportNull$$$0(66);
        }
        return cidrDebuggerCommandExecutor;
    }

    public void completeConsoleCommand(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(67);
        }
        if (result == null) {
            CidrDebugProcess.$$$reportNull$$$0(68);
        }
        String command = parameters.getOriginalFile().getText();
        int offset = parameters.getOffset();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        DebuggerDriver.ResultList<String> completions = this.completeConsoleCommand(command, offset, progressIndicator);
        if (!completions.list.isEmpty()) {
            if (completions.hasMore && completions.list.size() > 1) {
                result.addLookupAdvertisement(CidrDebuggerBundle.message("debug.console.completions.tooManyCompletions", completions.list.size()));
            }
            result.addAllElements((Iterable)ContainerUtil.map(completions.list, lookupString -> LookupElementBuilder.create((String)(lookupString + " "))));
        }
    }

    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int offset, @NotNull ProgressIndicator progressIndicator) {
        DebuggerDriver.ResultList resultList;
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(69);
        }
        if (progressIndicator == null) {
            CidrDebugProcess.$$$reportNull$$$0(70);
        }
        CompletableFuture completionFuture = this.postCommand((DebuggerDriver driver) -> {
            if (driver.isInPromptMode()) {
                return DebuggerDriver.ResultList.empty();
            }
            return driver.completeConsoleCommand(command, offset);
        });
        try {
            resultList = (DebuggerDriver.ResultList)ApplicationUtil.runWithCheckCanceled(completionFuture, (ProgressIndicator)progressIndicator);
        }
        catch (ExecutionException e) {
            DebuggerDriver.ResultList<String> resultList2 = DebuggerDriver.ResultList.empty();
            if (resultList2 == null) {
                CidrDebugProcess.$$$reportNull$$$0(72);
            }
            return resultList2;
        }
        if (resultList == null) {
            CidrDebugProcess.$$$reportNull$$$0(71);
        }
        return resultList;
    }

    @Nullable
    public PsiElement getDebuggerContext() {
        return this.getDebuggerContext(this.getCurrentPosition());
    }

    @Nullable
    public PsiElement getDebuggerContext(@Nullable XSourcePosition position) {
        if (position == null) {
            return null;
        }
        return (PsiElement)ReadAction.compute(() -> {
            CidrDebuggerTypesHelperBase typesHelper = this.getTypesHelper(position);
            if (!(typesHelper instanceof CidrDebuggerTypesHelper)) {
                return null;
            }
            return ((CidrDebuggerTypesHelper)typesHelper).getContextElement(position);
        });
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(73);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(74);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(75);
        }
        if (value == null) {
            CidrDebugProcess.$$$reportNull$$$0(76);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrDebugProcess.$$$reportNull$$$0(77);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(78);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrDebugProcess.$$$reportNull$$$0(79);
        }
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getInstance().getLanguage(frame));
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper(@NotNull XSourcePosition position) {
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(80);
        }
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getInstance().getLanguage(position));
    }

    @NotNull
    private CidrDebuggerTypesHelperBase getTypesHelper(@Nullable Language language) {
        Language key = language == null ? Language.ANY : language;
        CidrDebuggerTypesHelperBase cidrDebuggerTypesHelperBase = this.myTypesHelpers.computeIfAbsent(key.getID(), langId -> CidrDebuggerLanguageSupportManager.getInstance().createTypesHelper(language, this));
        if (cidrDebuggerTypesHelperBase == null) {
            CidrDebugProcess.$$$reportNull$$$0(81);
        }
        return cidrDebuggerTypesHelperBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbolsFile(File dSYM, File module) {
        CidrDebuggerLog.LOG.assertTrue(this.myState == State.INITIALIZED, (Object)("Session is already started: " + this.myState));
        List<Couple<File>> list = this.mySymbolFiles;
        synchronized (list) {
            this.mySymbolFiles.add((Couple<File>)Couple.of((Object)dSYM, (Object)module));
        }
    }

    @NotNull
    public RunParameters getRunParameters() {
        RunParameters runParameters = this.myRunParameters;
        if (runParameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(82);
        }
        return runParameters;
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull DebuggerCommand<?> command, @NotNull com.intellij.execution.ExecutionException exception) {
        if (driver == null) {
            CidrDebugProcess.$$$reportNull$$$0(83);
        }
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(84);
        }
        if (exception == null) {
            CidrDebugProcess.$$$reportNull$$$0(85);
        }
        if (exception instanceof DebuggerCommandExpiredException) {
            DebuggerCommandExpiredException expiredException = (DebuggerCommandExpiredException)exception;
            String commandText = expiredException.getCommand();
            if (!StringUtil.isEmpty((String)commandText)) {
                CidrDebuggerLog.LOG.debug("Command expired: '" + commandText + "'");
            } else {
                CidrDebuggerLog.LOG.debug("Command expired");
            }
            return;
        }
        DebuggerIllegalStateException illegalState = (DebuggerIllegalStateException)((Object)ExceptionUtil.findCause((Throwable)exception, DebuggerIllegalStateException.class));
        if (illegalState != null) {
            CidrDebuggerLog.LOG.info((Throwable)exception);
            String message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)illegalState));
            if (!(command instanceof DebuggerUIUpdateCommand)) {
                this.getSession().reportMessage(message, MessageType.WARNING);
            }
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                CidrDebuggerLog.LOG.debug((Throwable)exception);
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if (command instanceof DebuggerStartupCommand || isFatalError) {
            String message = exception.getMessage();
            if (this.myConfiguration.getHostMachine().getOS() == OS.Linux && message != null && message.contains("ptrace: Operation not permitted")) {
                this.printlnToConsole(CidrDebuggerBundle.message("debug.command.error.checkPermissionsMessage", new Object[0]));
            }
            this.myFatalException = exception;
            CidrDebuggerLog.LOG.debug((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            if (!this.reportEvaluationTimeOutError(exception)) {
                this.reportErrorInRedBalloon(exception);
            }
            if (isFatalError) {
                driver.getProcessHandler().destroyProcess();
            } else {
                this.getSession().stop();
            }
            return;
        }
        if (!(exception instanceof ThrowInTest.TestException)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CidrDebuggerLog.LOG.warn((Throwable)exception);
            } else {
                CidrDebuggerLog.LOG.error((Throwable)exception);
            }
        }
    }

    private void reportErrorInRedBalloon(com.intellij.execution.ExecutionException e) {
        DebuggerCommandException dce = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
        String message = (dce != null ? dce : e).getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            CidrDebuggerLog.LOG.error("Execution errors must have error description", (Throwable)e);
            message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e));
        }
        this.getSession().reportMessage(message, MessageType.ERROR, (HyperlinkListener)ExceptionUtil.findCause((Throwable)e, HyperlinkListener.class));
    }

    private boolean reportEvaluationTimeOutError(@NotNull com.intellij.execution.ExecutionException e) {
        DebuggerEvaluationTimedOutException evaluationTimedOutException;
        if (e == null) {
            CidrDebugProcess.$$$reportNull$$$0(86);
        }
        if ((evaluationTimedOutException = (DebuggerEvaluationTimedOutException)((Object)ExceptionUtil.findCause((Throwable)e, DebuggerEvaluationTimedOutException.class))) == null) {
            return false;
        }
        String message = CidrDebuggerBundle.message("debug.command.error.evaluationTimedOut", evaluationTimedOutException.getExpression(), CidrDebuggerBundle.message("action.CIDR.Debugger.DisableValueRenderers.text", new Object[0]));
        this.getSession().reportMessage(message, MessageType.ERROR, eventType -> {
            if (eventType.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                CidrDebuggerSettings.getInstance().setRenderersEnabled(false);
            }
        });
        return true;
    }

    public void printlnToConsole(@Nullable String message) {
        if (message != null && !this.getProject().isDisposed()) {
            if (!StringUtil.endsWithLineBreak((CharSequence)(message = StringUtil.stripHtml((String)message, (boolean)true)))) {
                message = (String)message + "\n";
            }
            this.getProcessHandler().notifyTextAvailable((String)message, ProcessOutputTypes.SYSTEM);
        }
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame != null ? frame.getSourcePosition() : null;
    }

    public long getCurrentThreadId() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getThreadId() : -1L;
    }

    public int getCurrentFrameIndex() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getFrameIndex() : -1;
    }

    @Override
    public void handleModulesLoaded(@NotNull List<LLModule> modules) {
        if (modules == null) {
            CidrDebugProcess.$$$reportNull$$$0(87);
        }
        if (this.reportProgramStartStatistics()) {
            long deltaTimeMs = System.currentTimeMillis() - this.myCreationTime;
            if (this.myTimeToFirstModuleReported.compareAndSet(false, true)) {
                CidrDebuggerUsagesCollector.logProgramFirstModuleLoaded(this.getDriverName(), deltaTimeMs);
            }
            this.mySessionStatistics.get().handleModulesLoaded(deltaTimeMs, modules.size());
        }
    }

    @Override
    public void handleRunning() {
        if (this.reportProgramStartStatistics() && this.myTimeToProgramExecutionReported.compareAndSet(false, true)) {
            CidrDebuggerUsagesCollector.logProgramExecutionStarted(this.getDriverName(), System.currentTimeMillis() - this.myCreationTime);
        }
        this.getSession().sessionResumed();
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(88);
        }
        this.notifyPositionReached(new CidrSuspendContext(this, stopPlace, null), false);
    }

    @Override
    public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(89);
        }
        if (signal == null) {
            CidrDebugProcess.$$$reportNull$$$0(90);
        }
        if (meaning == null) {
            CidrDebugProcess.$$$reportNull$$$0(91);
        }
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause(CidrSuspensionCause.Type.SIGNAL, signal + " (" + meaning + ")", stopPlace.frame.getFile(), stopPlace.frame.getHash(), stopPlace.frame.getLine(), stopPlace.frame.getProgramCounter()));
    }

    @Override
    public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(92);
        }
        if (exceptionAddress == null) {
            CidrDebugProcess.$$$reportNull$$$0(93);
        }
        if (description == null) {
            CidrDebugProcess.$$$reportNull$$$0(94);
        }
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause(CidrSuspensionCause.Type.EXCEPTION, description, exceptionFile, exceptionHash, exceptionLine, exceptionAddress));
    }

    private void doHandleSignalled(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(95);
        }
        if (cause == null) {
            CidrDebugProcess.$$$reportNull$$$0(96);
        }
        this.printlnToConsole(cause.getDisplayString());
        this.notifyPositionReached(CidrSwitchThreadOnSuspendUtil.createSuspendContext(this, stopPlace, cause), true);
    }

    @Override
    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
        Object b;
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(97);
        }
        if ((b = this.myBreakpointHandler.getXBreakpoint(breakpointNumber)) == null) {
            b = this.myAddressBreakpointHandler.getXBreakpoint(breakpointNumber);
        }
        if (b == null) {
            b = this.myExceptionBreakpointHandler.getXBreakpoint(breakpointNumber);
        }
        if (b == null && this.mySymbolicBreakpointHandler != null) {
            b = this.mySymbolicBreakpointHandler.getXBreakpoint(breakpointNumber);
        }
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(98);
        }
        Object b = this.myWatchpointHandler.getXBreakpoint(watchpointNumber);
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleAttached(int pid) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.attachedTo", pid));
        this.myAttachedSemaphore.release();
    }

    @Override
    public void handleConnected(@NotNull String connection) {
        if (connection == null) {
            CidrDebugProcess.$$$reportNull$$$0(99);
        }
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.connectedTo", connection));
    }

    @Override
    public void handleDetached() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.detached", new Object[0]));
        this.getSession().stop();
    }

    @Override
    public void handleDisconnected() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.disconnected", new Object[0]));
        this.getSession().stop();
    }

    protected void handleCodepoint(@NotNull DebuggerDriver.StopPlace stopPlace, @Nullable XBreakpoint<?> b) {
        XBreakpointProperties props;
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(100);
        }
        CidrSuspensionCause cause = null;
        XBreakpointProperties xBreakpointProperties = props = b != null ? b.getProperties() : null;
        if (props instanceof CidrExceptionBreakpointType.Properties) {
            cause = new CidrSuspensionCause(CidrSuspensionCause.Type.EXCEPTION_BREAKPOINT, "Exception breakpoint", stopPlace.frame.getFile(), stopPlace.frame.getHash(), stopPlace.frame.getLine(), stopPlace.frame.getProgramCounter());
        }
        CidrSuspendContext suspendContext = new CidrSuspendContext(this, stopPlace, cause);
        if (b == null) {
            this.notifyPositionReached(suspendContext, true);
            return;
        }
        XExpression expressionObject = b.getLogExpressionObject();
        if (expressionObject == null) {
            boolean shouldSuspend = this.getSession().breakpointReached(b, null, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
            return;
        }
        String expression = expressionObject.getExpression();
        this.postCommand((DebuggerDriver driver) -> {
            String evaluatedLogExpression;
            CidrExecutionStack executionStack = suspendContext.getActiveExecutionStack();
            XStackFrame frame = executionStack.getTopFrame();
            XSourcePosition sourcePosition = frame != null ? frame.getSourcePosition() : null;
            CidrEvaluator evaluator = (CidrEvaluator)(frame != null ? frame.getEvaluator() : null);
            if (evaluator != null) {
                try {
                    CidrEvaluatedValue evaluatedValue = evaluator.doEvaluate(driver, sourcePosition, (XExpression)XExpressionImpl.fromText((String)expression));
                    evaluatedLogExpression = expression + " = " + evaluatedValue.getConsoleDescription(evaluatedValue.createEvaluationContext(driver, null));
                }
                catch (DebuggerCommandException e) {
                    evaluatedLogExpression = "error evaluating " + expression + ": " + e.getMessage();
                }
            } else {
                evaluatedLogExpression = "error evaluating " + expression;
            }
            return evaluatedLogExpression;
        }).whenComplete((evaluatedLogExpression, e) -> {
            Object expressionString = null;
            if (evaluatedLogExpression != null) {
                expressionString = evaluatedLogExpression;
            } else if (e != null) {
                expressionString = "error evaluating " + expression + ": " + e.getMessage();
            }
            boolean shouldSuspend = this.getSession().breakpointReached(b, (String)expressionString, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
        });
    }

    @Override
    public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(101);
        }
        if (type == null) {
            CidrDebugProcess.$$$reportNull$$$0(102);
        }
        this.myProcessHandler.notifyTextAvailable(text, type);
    }

    @Override
    public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(103);
        }
        if (type == null) {
            CidrDebugProcess.$$$reportNull$$$0(104);
        }
        ConsoleViewContentType contentType = ProcessOutputType.isStdout((Key)type) ? ConsoleViewContentType.NORMAL_OUTPUT : (ProcessOutputType.isStderr((Key)type) ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> this.myBackendConsole.print(text, contentType));
    }

    @Override
    public void handlePrompt(@NotNull String prompt) {
        if (prompt == null) {
            CidrDebugProcess.$$$reportNull$$$0(105);
        }
        LanguageConsoleView backendConsole = this.getDebuggerConsole();
        if (this.getProject().isDisposed() || backendConsole == null || Disposer.isDisposed((Disposable)backendConsole)) {
            return;
        }
        backendConsole.setPrompt(prompt);
    }

    @Override
    public void handleTargetTerminated(@NotNull DebuggerDriver.ExitStatus exitStatus) {
        if (exitStatus == null) {
            CidrDebugProcess.$$$reportNull$$$0(106);
        }
        if (exitStatus != DebuggerDriver.ExitStatus.UNKNOWN) {
            this.myProcessHandler.setExitCode(exitStatus.code);
            if (exitStatus.description != null) {
                this.myProcessHandler.notifyTextAvailable(exitStatus.description + "\n", ProcessOutputTypes.SYSTEM);
            }
        } else {
            this.myProcessHandler.setExitCode(-1);
        }
        this.getSession().stop();
    }

    @Override
    public void handleExited(int code) {
        this.getSession().stop();
    }

    @Override
    public void handleWatchpointScope(int watchpointNumber) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> this.myWatchpointHandler.handleWatchpointScope(watchpointNumber));
        this.postCommand(DebuggerDriver::resume);
    }

    @Override
    public void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        if (breakpoint == null) {
            CidrDebugProcess.$$$reportNull$$$0(107);
        }
        this.myBreakpointHandler.handleBreakpointAdded(breakpoint);
        this.myAddressBreakpointHandler.handleBreakpointAdded(breakpoint);
    }

    @Override
    public void handleBreakpointRemoved(int breakpointId) {
        this.myBreakpointHandler.handleBreakpointRemoved(breakpointId);
        this.myAddressBreakpointHandler.handleBreakpointRemoved(breakpointId);
    }

    @Override
    public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        if (breakpoint == null) {
            CidrDebugProcess.$$$reportNull$$$0(108);
        }
        this.myBreakpointHandler.handleBreakpointUpdated(breakpoint.getId(), breakpoint);
        this.myAddressBreakpointHandler.handleBreakpointUpdated(breakpoint.getId(), breakpoint);
    }

    @Override
    public void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        if (locations == null) {
            CidrDebugProcess.$$$reportNull$$$0(109);
        }
        this.myBreakpointHandler.handleBreakpointLocationsReplaced(breakpointId, locations);
        this.myAddressBreakpointHandler.handleBreakpointLocationsReplaced(breakpointId, locations);
    }

    @Override
    public void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        if (locations == null) {
            CidrDebugProcess.$$$reportNull$$$0(110);
        }
        this.myBreakpointHandler.handleBreakpointLocationsUpdated(breakpointId, locations);
        this.myAddressBreakpointHandler.handleBreakpointLocationsUpdated(breakpointId, locations);
    }

    @Override
    public void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
        if (locationIds == null) {
            CidrDebugProcess.$$$reportNull$$$0(111);
        }
        this.myBreakpointHandler.handleBreakpointLocationsRemoved(breakpointId, locationIds);
        this.myAddressBreakpointHandler.handleBreakpointLocationsRemoved(breakpointId, locationIds);
    }

    @Override
    public void handleSelectedFrameChanged(@NotNull LLThread thread, @NotNull LLFrame frame) {
        CidrSuspendContext suspendContext;
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(112);
        }
        if (frame == null) {
            CidrDebugProcess.$$$reportNull$$$0(113);
        }
        if ((suspendContext = (CidrSuspendContext)((Object)ObjectUtils.tryCast((Object)this.getSession().getSuspendContext(), CidrSuspendContext.class))) == null) {
            return;
        }
        CidrExecutionStack newStack = suspendContext.getOrCreateExecutionStack(thread);
        CidrStackFrame newFrame = newStack.newFrame(frame);
        boolean isTopFrame = frame.getIndex() == 0;
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> this.getSession().setCurrentStackFrame((XExecutionStack)newStack, (XStackFrame)newFrame, isTopFrame));
    }

    private void notifyPositionReached(@NotNull XSuspendContext suspendContext, boolean attract) {
        if (suspendContext == null) {
            CidrDebugProcess.$$$reportNull$$$0(114);
        }
        this.notifyPositionReached(CompletableFuture.completedFuture(suspendContext), attract);
    }

    private void notifyPositionReached(@NotNull CompletableFuture<XSuspendContext> suspendContext, boolean attract) {
        CompletableFuture<XSuspendContext> currentTask;
        if (suspendContext == null) {
            CidrDebugProcess.$$$reportNull$$$0(115);
        }
        if ((currentTask = this.mySuspendContextCalculation.compareAndExchange(null, suspendContext)) != null) {
            CidrDebuggerLog.LOG.error("notifyPositionReached happened while previous one is still being processed");
            return;
        }
        suspendContext.whenComplete((context, error) -> {
            this.mySuspendContextCalculation.set(null);
            if (context == null) {
                CidrDebuggerLog.LOG.error("CompletableFuture<XSuspendContext> should always return context and never throw exception!", error);
            } else {
                ((XDebugSessionImpl)this.getSession()).positionReached(context, attract);
            }
        });
    }

    @Override
    public void handleChildProcessCreated(long childPid) {
        this.onChildProcessCreated(childPid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSymbolsDownloadStarted(@NotNull @NlsContexts.ProgressText String caption, @NotNull String details) {
        if (caption == null) {
            CidrDebugProcess.$$$reportNull$$$0(116);
        }
        if (details == null) {
            CidrDebugProcess.$$$reportNull$$$0(117);
        }
        Object object = this.mySymbolsDownloadTaskLock;
        synchronized (object) {
            if (this.mySymbolsDownloadTask != null) {
                this.mySymbolsDownloadTask.setDone();
            }
            this.mySymbolsDownloadTask = new SymbolsDownloadTask(caption, details);
            this.mySymbolsDownloadTask.queue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSymbolsDownloadProgress(int percent) {
        Object object = this.mySymbolsDownloadTaskLock;
        synchronized (object) {
            if (this.mySymbolsDownloadTask == null) {
                return;
            }
            this.mySymbolsDownloadTask.setPercent(percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSymbolsDownloadFinished() {
        Object object = this.mySymbolsDownloadTaskLock;
        synchronized (object) {
            if (this.mySymbolsDownloadTask == null) {
                return;
            }
            this.mySymbolsDownloadTask.setDone();
            this.mySymbolsDownloadTask = null;
        }
    }

    @NotNull
    public CidrSourceFileLocator getSourceFileLocator() {
        CidrSourceFileLocator cidrSourceFileLocator = this.mySourceFileLocator;
        if (cidrSourceFileLocator == null) {
            CidrDebugProcess.$$$reportNull$$$0(118);
        }
        return cidrSourceFileLocator;
    }

    @NotNull
    public CidrExecutionStack newExecutionStack(@NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause cause, @Nullable LLValue returnValue) {
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(119);
        }
        return new CidrExecutionStack(this, thread, frame, current, cause, returnValue);
    }

    public static boolean viewsUpdatesDisabledInTests(@NotNull Object container) {
        if (container == null) {
            CidrDebugProcess.$$$reportNull$$$0(120);
        }
        return ApplicationManager.getApplication().isUnitTestMode() && !container.getClass().getSimpleName().contains("XTest");
    }

    @Override
    public void handleNotification(@NotNull String message, @NotNull DebuggerDriver.NotificationType type) {
        if (message == null) {
            CidrDebugProcess.$$$reportNull$$$0(121);
        }
        if (type == null) {
            CidrDebugProcess.$$$reportNull$$$0(122);
        }
        MessageType messageType = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DebuggerDriver.NotificationType.INFO -> MessageType.INFO;
            case DebuggerDriver.NotificationType.WARNING -> MessageType.WARNING;
            case DebuggerDriver.NotificationType.ERROR -> MessageType.ERROR;
        };
        this.getSession().reportMessage(message, messageType);
    }

    public boolean supportsMemoryWrite() {
        return this.myDriverDoNotUse.supportsMemoryWrite();
    }

    public boolean supportsRegisters() {
        return this.myDriverDoNotUse.supportsRegisters();
    }

    public boolean supportsDebuggingForkedProcess() {
        return this.myDriverDoNotUse.supportsDebuggingForkedProcess();
    }

    public boolean supportsDebuggingMultipleProcesses() {
        return this.myDriverDoNotUse.supportsDebuggingMultipleProcesses();
    }

    public void resize(int columns, int rows) {
        this.postCommand((DebuggerDriver driver) -> driver.resize(columns, rows));
    }

    private void setupWatchesEvaluatedListener() {
        final XDebugSessionTab tab = Objects.requireNonNull(((XDebugSessionImpl)this.getSession()).getSessionTab());
        this.addWatchesEvaluatedListener(tab);
        tab.getUi().getContentManager().addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                String viewId;
                if (event == null) {
                    11.$$$reportNull$$$0(0);
                }
                if ("VariablesContent".equals(viewId = (String)event.getContent().getUserData(ViewImpl.ID))) {
                    if (tab.isWatchesInVariables()) {
                        CidrDebugProcess.this.addWatchesEvaluatedListener(tab);
                    }
                } else if ("WatchesContent".equals(viewId)) {
                    CidrDebugProcess.this.addWatchesEvaluatedListener(tab);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$11", "contentAdded"));
            }
        });
    }

    private void addWatchesEvaluatedListener(@NotNull XDebugSessionTab tab) {
        if (tab == null) {
            CidrDebugProcess.$$$reportNull$$$0(123);
        }
        XVariablesView view = Objects.requireNonNull((XVariablesView)tab.getWatchesView());
        view.getTree().addTreeListener((XDebuggerTreeListener)new WatchesEvaluatedListener(view), this.myMemory.getHexdumpDoc().getDisposable());
    }

    private void watchExpressionsEvaluated() {
        this.myMemory.getHexdumpDoc().refresh(AddressRange.WHOLE);
    }

    @NotNull
    public String getDriverName() {
        String string = this.myDriverName;
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(124);
        }
        return string;
    }

    @NotNull
    public CidrDebuggerModuleMemory getMemory() {
        CidrDebuggerModuleMemory cidrDebuggerModuleMemory = this.myMemory;
        if (cidrDebuggerModuleMemory == null) {
            CidrDebugProcess.$$$reportNull$$$0(125);
        }
        return cidrDebuggerModuleMemory;
    }

    @NotNull
    public CidrDisasmConfigurator getDisasmConfigurator() {
        return new CidrDisasmConfigurator(this, this.myDriverDoNotUse.getDisasmFlavor());
    }

    @ApiStatus.Internal
    public void addValuePresentationTime(long durationMillis) {
        this.myFrameStatistics.get().addValuePresentationTime(durationMillis);
    }

    @ApiStatus.Internal
    public void addChildrenLoadingTime(long durationMillis) {
        this.myFrameStatistics.get().addChildrenLoadingTime(durationMillis);
    }

    private void reportFrameStatistics() {
        CidrAggregatedFrameStatistics statistics = this.myFrameStatistics.getAndSet(new CidrAggregatedFrameStatistics());
        statistics.report(this.getDriverName());
    }

    private void reportAggregatedSessionStatistics() {
        if (this.reportProgramStartStatistics()) {
            CidrAggregatedSessionStatistics statistics = this.mySessionStatistics.getAndSet(new CidrAggregatedSessionStatistics());
            statistics.report(this.getDriverName());
        }
    }

    private void startSteppingActivity(@NotNull CidrSteppingStatisticKind kind) {
        if (kind == null) {
            CidrDebugProcess.$$$reportNull$$$0(126);
        }
        this.reportSteppingStatistics();
        StructuredIdeActivity activity = CidrDebuggerUsagesCollector.startSteppingActivity(this.getProject());
        if (activity == null) {
            return;
        }
        this.mySteppingStatistic.set(new CidrSteppingStatistic(kind, activity));
    }

    private void reportSteppingStatistics() {
        CidrSteppingStatistic value = this.mySteppingStatistic.getAndSet(null);
        if (value == null) {
            return;
        }
        CidrDebuggerUsagesCollector.finishSteppingActivity(value.getActivity(), this.getDriverName(), value.getKind());
    }

    @ApiStatus.Internal
    public void notifyChildrenLoadingCancelled(@NotNull CidrValue value) {
        if (value == null) {
            CidrDebugProcess.$$$reportNull$$$0(127);
        }
        ((CidrDebugProcessListener)this.getProject().getMessageBus().syncPublisher(ourListenerTopic)).childrenLoadingCancelled(this, value);
    }

    @ApiStatus.Internal
    public void notifyValueLoadingCancelled(@NotNull CidrValue value) {
        if (value == null) {
            CidrDebugProcess.$$$reportNull$$$0(128);
        }
        ((CidrDebugProcessListener)this.getProject().getMessageBus().syncPublisher(ourListenerTopic)).valueLoadingCancelled(this, value);
    }

    @ApiStatus.Experimental
    @NotNull
    public CidrDebugProcessRawViewSupport getRawViewSupport() {
        return new CidrDebugProcessRawViewSupport(this, this.myDriverDoNotUse.getRawViewSupport());
    }

    @ApiStatus.Internal
    public boolean reportProgramStartStatistics() {
        return false;
    }

    public void afterDebugSessionStarted() {
        for (CidrDebugProcessConfigurator configurator : CidrDebugProcessConfigurator.EP_NAME.getExtensionList()) {
            configurator.configureAfterSessionCreated(this);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(129);
        }
        return string;
    }

    public String toString() {
        return this.myName;
    }

    @ApiStatus.Internal
    @NotNull
    public Expirable getStateExpirable() {
        final long currentState = this.myStateChangeCount.get();
        return new Expirable(){

            public boolean isExpired() {
                return CidrDebugProcess.this.myStateChangeCount.get() != currentState;
            }
        };
    }

    @ApiStatus.Experimental
    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myDebugProcessScope;
        if (coroutineScope == null) {
            CidrDebugProcess.$$$reportNull$$$0(130);
        }
        return coroutineScope;
    }

    @ApiStatus.Experimental
    @Nullable
    public com.intellij.execution.ExecutionException getFatalException() {
        return this.myFatalException;
    }

    @Nullable
    public DebuggerActionHandler getFreezeActiveThreadHandler() {
        return CidrFreezeThreadHandler.INSTANCE;
    }

    @Nullable
    public DebuggerActionHandler getThawActiveThreadHandler() {
        return CidrUnfreezeThreadHandler.INSTANCE;
    }

    @Nullable
    public DebuggerActionHandler getFreezeInactiveThreadsHandler() {
        return CidrFreezeOtherThreadsHandler.INSTANCE;
    }

    @Nullable
    public DebuggerActionHandler getThawAllThreadsHandler() {
        return CidrUnfreezeAllThreadsHandler.INSTANCE;
    }

    @Nullable
    public DebuggerActionHandler getFreezeSelectedThreads() {
        return CidrFreezeSelectedThreadsHandler.INSTANCE;
    }

    @Nullable
    public DebuggerActionHandler getThawSelectedThreads() {
        return CidrUnfreezeSelectedThreadsHandler.INSTANCE;
    }

    @Nullable
    public DebuggerActionHandler getFreezeInactiveThreadsAmongSelectedHandler() {
        return CidrFreezeInactiveThreadsAmongSelectedHandler.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 15, 16, 17, 18, 21, 25, 26, 27, 28, 38, 39, 41, 43, 44, 45, 48, 52, 55, 57, 59, 61, 63, 65, 66, 71, 72, 77, 81, 82, 118, 124, 125, 129, 130 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendConsoleFilterProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_session";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 77: 
            case 81: 
            case 82: 
            case 118: 
            case 124: 
            case 125: 
            case 129: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess";
                break;
            }
            case 19: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 20: 
            case 79: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 22: 
            case 114: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferior";
                break;
            }
            case 32: 
            case 46: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 33: 
            case 35: 
            case 112: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 34: 
            case 36: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 40: 
            case 42: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 53: 
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 69: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 76: 
            case 127: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 88: 
            case 89: 
            case 92: 
            case 95: 
            case 97: 
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signal";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meaning";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionAddress";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 102: 
            case 104: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitStatus";
                break;
            }
            case 107: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationIds";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartDebuggerMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessDisposable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiDisposable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStateMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorsProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluationContext";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackendConsoleTabName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToLineImpl";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "formatJumpToLineErrorMessageToHTML";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "stripJumpToLineErrorMessage";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getResumptionThread";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisasmPosition";
                break;
            }
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "postCommand";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerCommandExecutor";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "completeConsoleCommand";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesHelper";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunParameters";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileLocator";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverName";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemory";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "restartDebugger";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 77: 
            case 81: 
            case 82: 
            case 118: 
            case 124: 
            case 125: 
            case 129: 
            case 130: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "logStack";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setHexChangedHandler";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTerminalExecutionConsole";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doStartTarget";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doDisconnectTarget";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLine";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLineImpl";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "formatJumpToLineErrorMessageToHTML";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "stripJumpToLineErrorMessage";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "positionToAddress";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "fileToMemoryDoc";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createSourcePosition";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resolveFile";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createDisasmPosition";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "executeConsoleCommand";
                break;
            }
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "postCommand";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "completeConsoleCommand";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getTypesHelper";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "handleCommandException";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "reportEvaluationTimeOutError";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "handleModulesLoaded";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "handleInterrupted";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "doHandleSignalled";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpoint";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "handleWatchpoint";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "handleConnected";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "handleCodepoint";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetOutput";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "handleDebuggerOutput";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "handlePrompt";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetTerminated";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointAdded";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointUpdated";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointLocationsReplaced";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointLocationsUpdated";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointLocationsRemoved";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "handleSelectedFrameChanged";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "notifyPositionReached";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "handleSymbolsDownloadStarted";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "newExecutionStack";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "viewsUpdatesDisabledInTests";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "handleNotification";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "addWatchesEvaluatedListener";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "startSteppingActivity";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "notifyChildrenLoadingCancelled";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "notifyValueLoadingCancelled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 15, 16, 17, 18, 21, 25, 26, 27, 28, 38, 39, 41, 43, 44, 45, 48, 52, 55, 57, 59, 61, 63, 65, 66, 71, 72, 77, 81, 82, 118, 124, 125, 129, 130 -> new IllegalStateException(string);
        };
    }

    static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        FINISHED;

    }

    private class MyProcessHandler
    extends ProcessHandler {
        private final AtomicReference<Integer> myExitCode = new AtomicReference();
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        private MyProcessHandler() {
        }

        public void setExitCode(int exitCode) {
            this.myExitCode.set(exitCode);
        }

        @NotNull
        public Integer getExitCode() {
            Integer exitCode = this.myExitCode.get();
            Integer n = exitCode == null ? 0 : exitCode;
            if (n == null) {
                MyProcessHandler.$$$reportNull$$$0(0);
            }
            return n;
        }

        protected void destroyProcessImpl() {
            this.doDestroyOrDetach(false);
        }

        protected void detachProcessImpl() {
            this.doDestroyOrDetach(true);
        }

        private void doDestroyOrDetach(boolean detach) {
            ProcessIOExecutorService.INSTANCE.execute(() -> {
                if (CidrDebugProcess.this.waitForTermination()) {
                    if (detach) {
                        this.notifyProcessDetached();
                    } else {
                        this.notifyProcessTerminated(this.getExitCode());
                    }
                }
            });
        }

        public boolean detachIsDefault() {
            return CidrDebugProcess.this.isDetachDefault();
        }

        public OutputStream getProcessInput() {
            return CidrDebugProcess.this.myDriverDoNotUse.getProcessInput();
        }

        public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MyProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyProcessHandler.$$$reportNull$$$0(2);
            }
            if (CidrDebugProcess.this.myEmulateTerminal) {
                super.notifyTextAvailable(text, outputType);
            } else {
                this.myAnsiEscapeDecoder.escapeText(text, outputType, (x$0, x$1) -> super.notifyTextAvailable(x$0, x$1));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MyProcessHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExitCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MySuspensionGutterIconManager
    implements XDebugSessionListener,
    XDebuggerManagerListener,
    Disposable {
        @NotNull
        private final XDebugSession mySession;
        @NotNull
        private final ExecutionPointHighlighter myExecutionPointHighlighter;

        MySuspensionGutterIconManager() {
            Project project = CidrDebugProcess.this.getProject();
            this.mySession = CidrDebugProcess.this.getSession();
            this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project, CidrDebugProcess.this.myUiDisposable);
            this.mySession.addSessionListener((XDebugSessionListener)this, (Disposable)this);
            project.getMessageBus().connect((Disposable)this).subscribe(XDebuggerManager.TOPIC, (Object)this);
        }

        public void dispose() {
            this.hide();
        }

        public void sessionPaused() {
            this.update();
        }

        public void sessionResumed() {
            this.update();
        }

        public void sessionStopped() {
            this.update();
        }

        public void stackFrameChanged() {
            this.update();
        }

        public void settingsChanged() {
            this.update();
        }

        public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
            this.update();
        }

        private void hide() {
            this.myExecutionPointHighlighter.hide();
        }

        private void update() {
            this.hide();
            if (XDebuggerManager.getInstance((Project)this.mySession.getProject()).getCurrentSession() != this.mySession) {
                return;
            }
            XSuspendContext suspendContext = this.mySession.getSuspendContext();
            if (suspendContext == null) {
                return;
            }
            XExecutionStack suspendExecutionStack = suspendContext.getActiveExecutionStack();
            if (!(suspendExecutionStack instanceof CidrExecutionStack)) {
                return;
            }
            CidrSuspensionCause suspensionCause = ((CidrExecutionStack)suspendExecutionStack).getSuspensionCause();
            if (suspensionCause == null) {
                return;
            }
            XStackFrame suspendFrame = suspendExecutionStack.getTopFrame();
            if (suspendFrame == null || this.mySession.getCurrentStackFrame() != suspendFrame) {
                return;
            }
            XSourcePosition position = null;
            if (suspensionCause.file != null) {
                position = CidrDebugProcess.this.createSourcePosition(suspensionCause.file, suspensionCause.hash, suspensionCause.line);
            }
            if (position == null) {
                position = CidrDebugProcess.this.createDisasmPosition(suspensionCause.address);
            }
            this.myExecutionPointHighlighter.show(position, true, (GutterIconRenderer)new MySuspensionGutterIconRenderer(suspensionCause), false);
        }
    }

    @FunctionalInterface
    public static interface HexChangedHandler {
        public void handleHexChanged();
    }

    public static interface DebuggerStartupCommand
    extends VoidDebuggerCommand {
    }

    @FunctionalInterface
    public static interface VoidDebuggerCommand
    extends DebuggerCommand<Void> {
        public void run(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @Override
        default public Void call(@NotNull DebuggerDriver driver) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (driver == null) {
                VoidDebuggerCommand.$$$reportNull$$$0(0);
            }
            this.run(driver);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$VoidDebuggerCommand", "call"));
        }
    }

    @FunctionalInterface
    public static interface DebuggerCommand<R> {
        public R call(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        default public boolean canExecuteWhileRunning() {
            return true;
        }
    }

    @FunctionalInterface
    public static interface SuspendedDebuggerCommand<R>
    extends DebuggerCommand<R> {
        @Override
        default public boolean canExecuteWhileRunning() {
            return false;
        }
    }

    public static interface DebuggerUIUpdateCommand
    extends VoidDebuggerCommand,
    SuspendedDebuggerCommand<Void> {
    }

    private class SymbolsDownloadTask
    extends Task.Backgroundable {
        private static final long TIMEOUT_MS = 100L;
        @NotNull
        private final @NlsContexts.ProgressText String myCaption;
        @NotNull
        private final String myDetails;
        private int myPercent;
        private boolean myDone;

        SymbolsDownloadTask(@NotNull String caption, String details) {
            if (caption == null) {
                SymbolsDownloadTask.$$$reportNull$$$0(0);
            }
            if (details == null) {
                SymbolsDownloadTask.$$$reportNull$$$0(1);
            }
            super(CidrDebugProcess.this.getProject(), CidrDebuggerBundle.message("progress.title.downloading.symbols", new Object[0]), true);
            this.myPercent = 0;
            this.myDone = false;
            this.myCaption = caption;
            this.myDetails = details;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                SymbolsDownloadTask.$$$reportNull$$$0(2);
            }
            indicator.setText(this.myCaption);
            indicator.setIndeterminate(false);
            try {
                SymbolsDownloadTask symbolsDownloadTask = this;
                synchronized (symbolsDownloadTask) {
                    while (!this.myDone) {
                        if (indicator.isCanceled()) {
                            CidrDebugProcess.this.postCommand(driver -> driver.cancelSymbolsDownload(this.myDetails), true);
                            break;
                        }
                        indicator.setFraction((double)this.myPercent / 100.0);
                        ((Object)((Object)this)).wait(100L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void setPercent(int percent) {
            this.myPercent = percent;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void setDone() {
            this.myDone = true;
            ((Object)((Object)this)).notifyAll();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "details";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$SymbolsDownloadTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class WatchesEvaluatedListener
    implements XDebuggerTreeListener {
        private final XVariablesView myView;

        WatchesEvaluatedListener(XVariablesView view) {
            if (view == null) {
                WatchesEvaluatedListener.$$$reportNull$$$0(0);
            }
            this.myView = view;
        }

        public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<? extends XValueContainerNode<?>> children, boolean last) {
            if (node == null) {
                WatchesEvaluatedListener.$$$reportNull$$$0(1);
            }
            if (children == null) {
                WatchesEvaluatedListener.$$$reportNull$$$0(2);
            }
            if (last && node == this.myView.getTree().getRoot()) {
                CidrDebugProcess.this.watchExpressionsEvaluated();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$WatchesEvaluatedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenLoaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MySuspensionGutterIconRenderer
    extends GutterIconRenderer {
        @NotNull
        private final CidrSuspensionCause mySuspensionCause;

        private MySuspensionGutterIconRenderer(@NotNull CidrSuspensionCause suspensionCause) {
            if (suspensionCause == null) {
                MySuspensionGutterIconRenderer.$$$reportNull$$$0(0);
            }
            this.mySuspensionCause = suspensionCause;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.mySuspensionCause.icon;
            if (icon == null) {
                MySuspensionGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @NotNull
        public String getTooltipText() {
            String string = this.mySuspensionCause.getDisplayString();
            if (string == null) {
                MySuspensionGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MySuspensionGutterIconRenderer renderer = (MySuspensionGutterIconRenderer)((Object)o);
            return this.mySuspensionCause.equals(renderer.mySuspensionCause);
        }

        public int hashCode() {
            return Objects.hash(this.mySuspensionCause);
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspensionCause";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MySuspensionGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MySuspensionGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

