/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.starter;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.CliktCommandKt;
import com.github.ajalt.clikt.core.NoOpCliktCommand;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.arguments.ArgumentTransformContext;
import com.github.ajalt.clikt.parameters.arguments.ProcessedArgument;
import com.github.ajalt.clikt.parameters.options.OptionTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.supporters.FormatterType;
import org.jetbrains.completion.full.line.starter.ConvertersKt;
import org.jetbrains.completion.full.line.starter.ErrorsKt;
import org.jetbrains.completion.full.line.starter.FullLineFormatter;
import org.jetbrains.completion.full.line.starter.FullLineInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand;", "Lcom/github/ajalt/clikt/core/NoOpCliktCommand;", "<init>", "()V", "Format", "Info", "Help", "intellij.fullLine"})
public final class FullLineCommand
extends NoOpCliktCommand {
    @NotNull
    public static final FullLineCommand INSTANCE = new FullLineCommand();

    private FullLineCommand() {
        super(null, null, null, false, false, null, null, false, false, 511, null);
    }

    static {
        CliktCommand[] cliktCommandArray = new CliktCommand[]{Format.INSTANCE, Info.INSTANCE, Help.INSTANCE};
        CliktCommandKt.subcommands((CliktCommand)((CliktCommand)INSTANCE), (CliktCommand[])cliktCommandArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0010\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0011\u0010\nR\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\f\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\f\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\f\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\f\u001a\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand$Format;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "supportedExtensions", "", "", "parse", "Ljava/io/File;", "getParse", "()Ljava/io/File;", "parse$delegate", "Lkotlin/properties/ReadOnlyProperty;", "output", "getOutput", "output$delegate", "failed", "getFailed", "failed$delegate", "threads", "", "getThreads", "()I", "threads$delegate", "languagesToFilter", "getLanguagesToFilter", "()Ljava/util/List;", "languagesToFilter$delegate", "preserveOrder", "", "getPreserveOrder", "()Z", "preserveOrder$delegate", "formatterType", "getFormatterType", "()Ljava/lang/String;", "formatterType$delegate", "run", "", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineStarter.kt\norg/jetbrains/completion/full/line/starter/FullLineCommand$Format\n+ 2 TransformAll.kt\ncom/github/ajalt/clikt/parameters/options/OptionWithValuesKt__TransformAllKt\n*L\n1#1,125:1\n87#2,5:126\n*S KotlinDebug\n*F\n+ 1 FullLineStarter.kt\norg/jetbrains/completion/full/line/starter/FullLineCommand$Format\n*L\n85#1:126,5\n*E\n"})
    public static final class Format
    extends CliktCommand {
        @NotNull
        public static final Format INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final List<String> supportedExtensions;
        @NotNull
        private static final ReadOnlyProperty parse$delegate;
        @NotNull
        private static final ReadOnlyProperty output$delegate;
        @NotNull
        private static final ReadOnlyProperty failed$delegate;
        @NotNull
        private static final ReadOnlyProperty threads$delegate;
        @NotNull
        private static final ReadOnlyProperty languagesToFilter$delegate;
        @NotNull
        private static final ReadOnlyProperty preserveOrder$delegate;
        @NotNull
        private static final ReadOnlyProperty formatterType$delegate;

        private Format() {
            super("Format passed files with jsonl format data", null, null, false, false, null, null, false, false, false, 1022, null);
        }

        private final File getParse() {
            return (File)parse$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final File getOutput() {
            return (File)output$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final File getFailed() {
            return (File)failed$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        private final int getThreads() {
            return ((Number)threads$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
        }

        private final List<String> getLanguagesToFilter() {
            return (List)languagesToFilter$delegate.getValue((Object)this, $$delegatedProperties[4]);
        }

        private final boolean getPreserveOrder() {
            return (Boolean)preserveOrder$delegate.getValue((Object)this, $$delegatedProperties[5]);
        }

        private final String getFormatterType() {
            return (String)formatterType$delegate.getValue((Object)this, $$delegatedProperties[6]);
        }

        public void run() {
            Runtime runtime = Runtime.getRuntime();
            if ((runtime != null ? runtime.maxMemory() : 0L) < 0x780000000L) {
                String string = "Please set big enough -Xmx or we will drop big files (which maybe is ok for your).\nWe need around 1gb of ram for every 1k line of code.\nSo if you want to process even huge files in dataset set -Xmx30g.";
                System.out.println((Object)string);
            }
            FullLineFormatter formatter = new FullLineFormatter(new FullLineFormatter.Args(this.getParse(), this.getOutput(), this.getFailed(), this.getThreads(), this.getLanguagesToFilter(), this.getPreserveOrder(), FormatterType.valueOf(this.getFormatterType())));
            formatter.run();
        }

        private static final Unit parse_delegate$lambda$0(ArgumentTransformContext $this$validate, File it) {
            Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"$this$validate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.isFile() && !supportedExtensions.contains(FilesKt.getExtension((File)it))) {
                ErrorsKt.noFormattersForLanguage(FilesKt.getExtension((File)it), (Collection<String>)supportedExtensions);
                throw new KotlinNothingValueException();
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$defaultLazy$iv$iv;
            Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "parse", "getParse()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "output", "getOutput()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "failed", "getFailed()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "threads", "getThreads()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "languagesToFilter", "getLanguagesToFilter()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "preserveOrder", "getPreserveOrder()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Format.class, "formatterType", "getFormatterType()Ljava/lang/String;", 0)))};
            $$delegatedProperties = objectArray;
            INSTANCE = new Format();
            objectArray = new String[]{"gz", "jsonl"};
            supportedExtensions = CollectionsKt.listOf((Object[])objectArray);
            parse$delegate = ArgumentKt.validate((ProcessedArgument)FileKt.file$default((ProcessedArgument)ArgumentKt.argument$default((CliktCommand)INSTANCE, (String)"FILE-TO-PARSE", (String)"Path jsonl file/folder/gzip file with formatting data", null, null, (int)12, null), (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (int)38, null), Format::parse_delegate$lambda$0).provideDelegate((CliktCommand)INSTANCE, $$delegatedProperties[0]);
            output$delegate = ArgumentKt.default$default((ProcessedArgument)FileKt.file$default((ProcessedArgument)ArgumentKt.argument$default((CliktCommand)INSTANCE, (String)"FILE-TO-OUTPUT", (String)"Path to output formatting result, might be jsonl/gzip file", null, null, (int)12, null), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)38, null), (Object)new File("output.jsonl.gz"), null, (int)2, null).provideDelegate((CliktCommand)INSTANCE, $$delegatedProperties[1]);
            objectArray = new String[]{"--failed-output", "-f"};
            OptionWithValues $this$defaultLazy_u24default$iv = FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)INSTANCE), (String[])objectArray, (String)"Path for file data with failed cases and short explanation", null, (boolean)false, null, null, null, null, (int)252, null), (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (int)38, null);
            String defaultForHelp$iv = "";
            OptionWithValues optionWithValues = $this$defaultLazy_u24default$iv;
            String defaultForHelp$iv$iv = defaultForHelp$iv;
            boolean $i$f$defaultLazy = false;
            failed$delegate = OptionWithValuesKt.transformAll$default((OptionWithValues)$this$defaultLazy$iv$iv, (String)defaultForHelp$iv$iv, (boolean)false, (Function2)((Function2)new Function2<OptionTransformContext, List<? extends File>, File>(){

                @NotNull
                public final File invoke(@NotNull OptionTransformContext $this$transformAll, @NotNull List<? extends File> it) {
                    Intrinsics.checkNotNullParameter((Object)$this$transformAll, (String)"$this$transformAll");
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Object object = CollectionsKt.lastOrNull(it);
                    if (object == null) {
                        boolean bl = false;
                        object = new File("failed.jsonl.gz");
                    }
                    return object;
                }
            }), (int)2, null).provideDelegate((ParameterHolder)INSTANCE, $$delegatedProperties[2]);
            objectArray = new String[]{"--threads", "-t"};
            threads$delegate = OptionWithValuesKt.default$default((OptionWithValues)IntKt.int((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)INSTANCE), (String[])objectArray, (String)"Add option to run formatting in parallel, just pass value more than 1 or 1 if you want to do it synchronously", null, (boolean)false, null, null, null, null, (int)252, null)), (Object)Runtime.getRuntime().availableProcessors(), null, (int)2, null).provideDelegate((ParameterHolder)INSTANCE, $$delegatedProperties[3]);
            objectArray = new String[]{"--filter-tags", "-tags"};
            languagesToFilter$delegate = OptionWithValuesKt.multiple$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)INSTANCE), (String[])objectArray, (String)"List of languages and dialects to filter-out while formatting, such files will be marked in failed file. See `info` command for list of supported languages.", null, (boolean)false, null, null, null, null, (int)252, null), null, (boolean)false, (int)3, null).provideDelegate((ParameterHolder)INSTANCE, $$delegatedProperties[4]);
            objectArray = new String[]{"--preserve-order", "-o"};
            preserveOrder$delegate = OptionWithValuesKt.default$default(ConvertersKt.boolean((OptionWithValues<String, String, String>)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)INSTANCE), (String[])objectArray, (String)"If `--threads > 1` - keep an order of result formatted files, passing false might win extra ~100ms", null, (boolean)false, null, null, null, null, (int)252, null)), (Object)true, null, (int)2, null).provideDelegate((ParameterHolder)INSTANCE, $$delegatedProperties[5]);
            objectArray = new String[]{"--formatter-type", "-f"};
            formatterType$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)INSTANCE), (String[])objectArray, (String)"Type of the formatter", null, (boolean)false, null, null, null, null, (int)252, null), (Object)"Trim", null, (int)2, null).provideDelegate((ParameterHolder)INSTANCE, $$delegatedProperties[6]);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand$Help;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "run", "", "intellij.fullLine"})
    public static final class Help
    extends CliktCommand {
        @NotNull
        public static final Help INSTANCE = new Help();

        private Help() {
            super("Prints help info (passing --help won't work)", null, null, false, false, null, null, false, false, false, 1022, null);
        }

        public void run() {
            String help = INSTANCE.getFormattedHelp();
            System.out.println((Object)help);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineCommand$Info;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "run", "", "intellij.fullLine"})
    public static final class Info
    extends CliktCommand {
        @NotNull
        public static final Info INSTANCE = new Info();

        private Info() {
            super("Get info about current environment (system, plugin, list of supported languages)", null, null, false, false, null, null, false, false, false, 1022, null);
        }

        public void run() {
            String info = FullLineInfo.INSTANCE.collect();
            System.out.println((Object)info);
        }
    }
}

