/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.services.helpers;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.ModelSchema;
import org.jetbrains.completion.full.line.local.NativeServerException;
import org.jetbrains.completion.full.line.local.NativeServerSchema;
import org.jetbrains.completion.full.line.local.generation.model.remote.NativeServerDiagnosticCallback;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/local/services/helpers/NativeServerExceptionFactory;", "", "serverPath", "Ljava/io/File;", "diagnosticsCallback", "Lorg/jetbrains/completion/full/line/local/generation/model/remote/NativeServerDiagnosticCallback;", "schema", "Lorg/jetbrains/completion/full/line/local/ModelSchema;", "<init>", "(Ljava/io/File;Lorg/jetbrains/completion/full/line/local/generation/model/remote/NativeServerDiagnosticCallback;Lorg/jetbrains/completion/full/line/local/ModelSchema;)V", "throwException", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getLogsAttachments", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "()[Lcom/intellij/openapi/diagnostic/Attachment;", "getVersionAttachment", "getMachineSpecificationAttachment", "getServerFileAttachment", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nNativeServerExceptionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeServerExceptionFactory.kt\norg/jetbrains/completion/full/line/local/services/helpers/NativeServerExceptionFactory\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,71:1\n24#2:72\n37#3,2:73\n*S KotlinDebug\n*F\n+ 1 NativeServerExceptionFactory.kt\norg/jetbrains/completion/full/line/local/services/helpers/NativeServerExceptionFactory\n*L\n20#1:72\n30#1:73,2\n*E\n"})
public final class NativeServerExceptionFactory {
    @NotNull
    private final File serverPath;
    @NotNull
    private final NativeServerDiagnosticCallback diagnosticsCallback;
    @NotNull
    private final ModelSchema schema;

    public NativeServerExceptionFactory(@NotNull File serverPath, @NotNull NativeServerDiagnosticCallback diagnosticsCallback, @NotNull ModelSchema schema) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)diagnosticsCallback, (String)"diagnosticsCallback");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.serverPath = serverPath;
        this.diagnosticsCallback = diagnosticsCallback;
        this.schema = schema;
    }

    @NotNull
    public final Void throwException(@NotNull Exception cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Object[] attachments = this.getLogsAttachments();
        NativeServerExceptionFactory $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(NativeServerExceptionFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Collected native server attachments:\n" + ArraysKt.joinToString$default((Object[])attachments, (CharSequence)"\n", null, null, (int)0, null, NativeServerExceptionFactory::throwException$lambda$0, (int)30, null));
        throw new NativeServerException(cause, (Attachment[])attachments);
    }

    private final Attachment[] getLogsAttachments() {
        List list;
        List $this$getLogsAttachments_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getLogsAttachments_u24lambda_u241.add(this.getVersionAttachment());
        $this$getLogsAttachments_u24lambda_u241.add(this.getMachineSpecificationAttachment());
        $this$getLogsAttachments_u24lambda_u241.add(this.getServerFileAttachment(this.serverPath));
        $this$getLogsAttachments_u24lambda_u241.add(this.diagnosticsCallback.getLogsAttachment());
        Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Attachment[0]);
    }

    private final Attachment getVersionAttachment() {
        NativeServerSchema nativeServerSchema = this.schema.getNative();
        return new Attachment("version.txt", StringsKt.trimIndent((String)("\n      modelVersion=" + this.schema.getVersion() + "\n      nativeVersion=" + (nativeServerSchema != null ? nativeServerSchema.getVersion() : null) + "\n      language=" + CollectionsKt.joinToString$default((Iterable)this.schema.languages(), null, null, null, (int)0, null, NativeServerExceptionFactory::getVersionAttachment$lambda$2, (int)31, null) + "\n    ")));
    }

    private final Attachment getMachineSpecificationAttachment() {
        return new Attachment("specification.txt", StringsKt.trimIndent((String)("\n      CpuArch=" + CpuArch.CURRENT + "\n      OS_NAME=" + SystemInfoRt.OS_NAME + "\n      OS_VERSION=" + SystemInfoRt.OS_VERSION + "\n    ")));
    }

    private final Attachment getServerFileAttachment(File serverPath) {
        String sha256 = serverPath.isFile() && serverPath.exists() ? Base64.getEncoder().encodeToString(DigestUtil.sha256().digest(FilesKt.readBytes((File)serverPath))) : null;
        File file = serverPath.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
        String pathFromRoot = FilesKt.relativeTo((File)file, (File)new File(PathManager.getSystemPath())).getPath();
        return new Attachment("inference_server.info", StringsKt.trimIndent((String)("\n        path=" + pathFromRoot + "\n        isFile=" + serverPath.isFile() + "\n        isDirectory=" + serverPath.isDirectory() + "\n        exists=" + serverPath.exists() + "\n        name=" + serverPath.getName() + "\n        length=" + serverPath.length() + "\n        sha256=" + sha256 + "\n      ")));
    }

    private static final CharSequence throwException$lambda$0(Attachment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDisplayText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayText(...)");
        return string;
    }

    private static final CharSequence getVersionAttachment$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

