/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.llmInstaller.AIAssistantContentExtension;
import com.intellij.llmInstaller.AILicenseManager;
import com.intellij.llmInstaller.AILicenseState;
import com.intellij.llmInstaller.AiPluginInstallationListener;
import com.intellij.llmInstaller.InstallationState;
import com.intellij.llmInstaller.LLMInstallerServiceProjectScope;
import com.intellij.llmInstaller.LlmInstallerStatistics;
import com.intellij.llmInstaller.api.AiPluginCoreConstants;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\r\u0010\u0002\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\b\u0010\b\u001a\u00020\tH\u0000\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\u001a\b\u0010\f\u001a\u00020\tH\u0000\u001a\b\u0010\r\u001a\u00020\tH\u0000\u001a\b\u0010\u000e\u001a\u00020\tH\u0000\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015\u001a\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00152\u0006\u0010\u0018\u001a\u00020\u0005\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"EVAL_PREFIX", "", "getJBADisplayName", "Lcom/intellij/openapi/util/NlsSafe;", "getScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "isLLMPluginDisabled", "", "getLLMPluginInstallationState", "Lcom/intellij/llmInstaller/InstallationState;", "enableLLMPlugin", "canLoadUnloadWithoutRestart", "isFreeTrialAvailable", "getProductLicense", "facade", "Lcom/intellij/ui/LicensingFacade;", "isEvalLicense", "stamp", "getAILicenseState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/llmInstaller/AILicenseState;", "licensingFacadeStateIn", "cs", "installAiPlugin", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "listener", "Lcom/intellij/llmInstaller/AiPluginInstallationListener;", "intellij.llmInstaller"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/llmInstaller/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1#2:285\n31#3,2:286\n1557#4:288\n1628#4,3:289\n1755#4,3:292\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/intellij/llmInstaller/UtilsKt\n*L\n76#1:286,2\n260#1:288\n260#1:289,3\n263#1:292,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final String EVAL_PREFIX = "eval:";

    @NotNull
    public static final String getJBADisplayName() {
        String string;
        JBAccountInfoService jBAccountInfoService = JBAccountInfoService.getInstance();
        if (jBAccountInfoService == null || (jBAccountInfoService = jBAccountInfoService.getUserData()) == null) {
            return "";
        }
        JBAccountInfoService userData = jBAccountInfoService;
        String it = string = userData.presentableName;
        boolean bl = false;
        String string2 = !Intrinsics.areEqual((Object)it, (Object)userData.loginName) ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public static final CoroutineScope getScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<LLMInstallerServiceProjectScope> serviceClass$iv = LLMInstallerServiceProjectScope.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((LLMInstallerServiceProjectScope)object).getScope();
    }

    public static final boolean isLLMPluginDisabled() {
        return UtilsKt.getLLMPluginInstallationState() == InstallationState.DISABLED;
    }

    @NotNull
    public static final InstallationState getLLMPluginInstallationState() {
        return !PluginManager.isPluginInstalled((PluginId)AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID()) ? InstallationState.NOT_INSTALLED : (PluginEnabler.getInstance().isDisabled(AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID()) ? InstallationState.DISABLED : (AIAssistantContentExtension.Companion.getEP_NAME().getExtensionList().isEmpty() ? InstallationState.INCOMPATIBLE : InstallationState.ENABLED));
    }

    public static final boolean enableLLMPlugin() {
        return PluginEnabler.getInstance().enableById(SetsKt.setOf((Object)AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID()));
    }

    public static final boolean canLoadUnloadWithoutRestart() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID());
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)ideaPluginDescriptor : null;
        if (ideaPluginDescriptorImpl == null) {
            return false;
        }
        IdeaPluginDescriptorImpl ideaPluginDescriptor2 = ideaPluginDescriptorImpl;
        return DynamicPlugins.INSTANCE.checkCanUnloadWithoutRestart(ideaPluginDescriptor2) == null;
    }

    public static final boolean isFreeTrialAvailable() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return true;
        }
        LicensingFacade licensingFacade2 = licensingFacade;
        if (licensingFacade2.isEvaluationLicense()) {
            return false;
        }
        String string = licensingFacade2.metadata;
        if (string == null) {
            return true;
        }
        String metadata = string;
        if (metadata.length() < 20) {
            return true;
        }
        char type = metadata.charAt(10);
        switch (type) {
            case 'E': 
            case 'L': 
            case 'O': {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static final String getProductLicense(@NotNull LicensingFacade facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        return facade.getConfirmationStamp(facade.platformProductCode);
    }

    public static final boolean isEvalLicense(@NotNull String stamp) {
        Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
        return StringsKt.startsWith$default((String)stamp, (String)EVAL_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final StateFlow<AILicenseState> getAILicenseState() {
        return AILicenseManager.Companion.getInstance().getLicenseState();
    }

    @NotNull
    public static final StateFlow<LicensingFacade> licensingFacadeStateIn(@NotNull CoroutineScope cs) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        MutableStateFlow mutableState = mutableStateFlow = StateFlowKt.MutableStateFlow((Object)LicensingFacade.getInstance());
        boolean bl = false;
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationKt.getApplication().getMessageBus().connect(cs);
        Topic topic = LicensingFacade.LicenseStateListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, arg_0 -> UtilsKt.licensingFacadeStateIn$lambda$2$lambda$1(mutableState, arg_0));
        mutableState.setValue((Object)LicensingFacade.getInstance());
        return FlowKt.asStateFlow((MutableStateFlow)mutableStateFlow);
    }

    public static final void installAiPlugin(@NotNull ProgressIndicator indicator, @NotNull AiPluginInstallationListener listener2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        PluginId llmPluginId = AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID();
        List marketplacePlugins = null;
        List customPlugins = null;
        PluginNode llmDescriptor = null;
        try {
            Object v1;
            block8: {
                marketplacePlugins = MarketplaceRequests.Companion.loadLastCompatiblePluginDescriptors$default((MarketplaceRequests.Companion)MarketplaceRequests.Companion, (Set)SetsKt.setOf((Object)llmPluginId), null, (boolean)true, (int)2, null);
                customPlugins = RepositoryHelper.loadPluginsFromCustomRepositories((ProgressIndicator)indicator);
                Collection collection = RepositoryHelper.mergePluginsFromRepositories((List)marketplacePlugins, (List)customPlugins, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"mergePluginsFromRepositories(...)");
                Collection descriptors = collection;
                Iterable iterable = descriptors;
                for (Object t : iterable) {
                    PluginNode it = (PluginNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)llmPluginId)) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            llmDescriptor = v1;
        }
        catch (Exception e) {
            LlmInstallerStatistics.INSTANCE.logError(true, false, e.getClass());
            listener2.onInstallError(true, false, e);
            return;
        }
        if (llmDescriptor == null) {
            LlmInstallerStatistics.INSTANCE.logPluginNotFound();
            listener2.onPluginNotFound();
            return;
        }
        listener2.onInstallStarted();
        PluginInstallOperation operation = new PluginInstallOperation(CollectionsKt.listOf((Object)llmDescriptor), (Collection)customPlugins, (PluginEnabler)PluginEnabler.HEADLESS, indicator);
        operation.setAllowInstallWithoutRestart(true);
        try {
            operation.run();
        }
        catch (Exception e) {
            LlmInstallerStatistics.INSTANCE.logError(false, !operation.isShownErrors(), e.getClass());
            listener2.onInstallError(false, !operation.isShownErrors(), e);
            return;
        }
        if (operation.isSuccess()) {
            Ref.BooleanRef restartNeeded = new Ref.BooleanRef();
            ApplicationManager.getApplication().invokeAndWait(() -> UtilsKt.installAiPlugin$lambda$6(restartNeeded, operation, indicator));
            LlmInstallerStatistics.INSTANCE.logSuccessResult();
            listener2.onInstallSuccess(restartNeeded.element);
        } else {
            LlmInstallerStatistics.INSTANCE.logError(false, !operation.isShownErrors(), null);
            listener2.onInstallError(false, !operation.isShownErrors(), null);
        }
    }

    private static final void licensingFacadeStateIn$lambda$2$lambda$1(MutableStateFlow $mutableState, LicensingFacade facade) {
        $mutableState.setValue((Object)facade);
    }

    /*
     * WARNING - void declaration
     */
    private static final void installAiPlugin$lambda$6(Ref.BooleanRef $restartNeeded, PluginInstallOperation $operation, ProgressIndicator $indicator) {
        boolean bl;
        boolean bl2;
        block4: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List list = $operation.getPendingDynamicPluginInstalls();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPendingDynamicPluginInstalls(...)");
            Iterable iterable = list;
            Ref.BooleanRef booleanRef = $restartNeeded;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PendingDynamicPluginInstall pendingDynamicPluginInstall = (PendingDynamicPluginInstall)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Path file = pendingDynamicPluginInstall.component1();
                IdeaPluginDescriptorImpl pluginDescriptor = pendingDynamicPluginInstall.component2();
                $indicator.checkCanceled();
                collection.add(!PluginInstaller.installAndLoadDynamicPlugin((Path)file, (IdeaPluginDescriptorImpl)pluginDescriptor));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl4 = false;
                    if (!it) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
        }
        booleanRef.element = bl = bl2;
    }
}

