/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.communicator;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.settingsSync.core.SettingsSyncBundle;
import com.intellij.settingsSync.core.SettingsSyncEventListener;
import com.intellij.settingsSync.core.SettingsSyncLocalSettings;
import com.intellij.settingsSync.core.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.core.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.core.communicator.SettingsSyncCommunicatorProvider;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import com.intellij.util.ResettableLazy;
import com.intellij.util.ResettableLazyKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\"#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bJ\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\u0007J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001bJ\n\u0010!\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder;", "Lcom/intellij/settingsSync/core/SettingsSyncEventListener;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DEFAULT_PROVIDER_CODE", "", "DEFAULT_USER_ID", "communicatorLazy", "Lcom/intellij/util/ResettableLazy;", "Lcom/intellij/settingsSync/core/SettingsSyncRemoteCommunicator;", "getRemoteCommunicator", "getAuthService", "Lcom/intellij/settingsSync/core/auth/SettingsSyncAuthService;", "isAvailable", "", "invalidateCommunicator", "", "getCurrentUserData", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "loginStateChanged", "createRemoteCommunicator", "provider", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncCommunicatorProvider;", "userId", "getAvailableProviders", "", "getExternalProviders", "getDefaultProvider", "getProvider", "providerCode", "getAvailableUserAccounts", "getCurrentProvider", "DummyAuthService", "DummyDefaultCommunicatorProvider", "intellij.settingsSync.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRemoteCommunicatorHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCommunicatorHolder.kt\ncom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n1#2:142\n774#3:143\n865#3,2:144\n1368#3:146\n1454#3,5:147\n14#4:152\n*S KotlinDebug\n*F\n+ 1 RemoteCommunicatorHolder.kt\ncom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder\n*L\n89#1:143\n89#1:144,2\n101#1:146\n101#1:147,5\n20#1:152\n*E\n"})
public final class RemoteCommunicatorHolder
implements SettingsSyncEventListener {
    @NotNull
    public static final RemoteCommunicatorHolder INSTANCE = new RemoteCommunicatorHolder();
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String DEFAULT_PROVIDER_CODE = "jba";
    @NotNull
    public static final String DEFAULT_USER_ID = "jba";
    @NotNull
    private static final ResettableLazy<SettingsSyncRemoteCommunicator> communicatorLazy;

    private RemoteCommunicatorHolder() {
    }

    @Nullable
    public final SettingsSyncRemoteCommunicator getRemoteCommunicator() {
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = (SettingsSyncRemoteCommunicator)communicatorLazy.getValue();
        if (settingsSyncRemoteCommunicator == null) {
            settingsSyncRemoteCommunicator = this.createRemoteCommunicator();
        }
        return settingsSyncRemoteCommunicator;
    }

    @Nullable
    public final SettingsSyncAuthService getAuthService() {
        SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider = this.getCurrentProvider();
        return settingsSyncCommunicatorProvider != null ? settingsSyncCommunicatorProvider.getAuthService() : null;
    }

    public final boolean isAvailable() {
        return communicatorLazy.getValue() != null;
    }

    public final void invalidateCommunicator() {
        Unit unit;
        communicatorLazy.reset();
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        logger.warn("Invalidating remote communicator");
    }

    @Nullable
    public final SettingsSyncUserData getCurrentUserData() {
        String string = SettingsSyncLocalSettings.Companion.getInstance().getUserId();
        if (string == null) {
            RemoteCommunicatorHolder $this$getCurrentUserData_u24lambda_u242 = this;
            boolean bl = false;
            logger.warn("No current userId. Returning null user data");
            return null;
        }
        String userId = string;
        SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider = this.getCurrentProvider();
        if (settingsSyncCommunicatorProvider == null) {
            RemoteCommunicatorHolder $this$getCurrentUserData_u24lambda_u243 = this;
            boolean bl = false;
            logger.warn("No active provider. Returning null user data");
            return null;
        }
        SettingsSyncCommunicatorProvider provider = settingsSyncCommunicatorProvider;
        return provider.getAuthService().getUserData(userId);
    }

    @Override
    public void loginStateChanged() {
    }

    @Nullable
    public final SettingsSyncRemoteCommunicator createRemoteCommunicator(@NotNull SettingsSyncCommunicatorProvider provider, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return provider.createCommunicator(userId);
    }

    private final SettingsSyncRemoteCommunicator createRemoteCommunicator() {
        SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider = this.getCurrentProvider();
        if (settingsSyncCommunicatorProvider == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u244 = this;
            boolean bl = false;
            logger.warn("Attempting to create remote communicator without active provider");
            return null;
        }
        SettingsSyncCommunicatorProvider provider = settingsSyncCommunicatorProvider;
        String string = SettingsSyncLocalSettings.Companion.getInstance().getUserId();
        if (string == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u245 = this;
            boolean bl = false;
            logger.warn("Empty current userId. Communicator will not be created.");
            return null;
        }
        String userId = string;
        SettingsSyncUserData settingsSyncUserData = provider.getAuthService().getUserData(userId);
        if (settingsSyncUserData == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u246 = this;
            boolean bl = false;
            logger.warn("Empty current user data. Communicator will not be created.");
            return null;
        }
        SettingsSyncUserData currentUserData = settingsSyncUserData;
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = provider.createCommunicator(currentUserData.getId());
        if (settingsSyncRemoteCommunicator == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u247 = this;
            boolean bl = false;
            logger.warn("Provider '" + provider.getProviderCode() + "' returned empty communicator");
            return null;
        }
        SettingsSyncRemoteCommunicator communicator = settingsSyncRemoteCommunicator;
        return communicator;
    }

    @NotNull
    public final List<SettingsSyncCommunicatorProvider> getAvailableProviders() {
        Object v0;
        ArrayList<DummyDefaultCommunicatorProvider> extensionList;
        block2: {
            extensionList = new ArrayList<DummyDefaultCommunicatorProvider>();
            extensionList.addAll(SettingsSyncCommunicatorProvider.PROVIDER_EP.getExtensionList());
            Iterable iterable = extensionList;
            for (Object t : iterable) {
                SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProviderCode(), (Object)"jba")) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if (v0 == null) {
            extensionList.add(DummyDefaultCommunicatorProvider.INSTANCE);
        }
        return extensionList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsSyncCommunicatorProvider> getExternalProviders() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAvailableProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getProviderCode(), (Object)"jba"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final SettingsSyncCommunicatorProvider getDefaultProvider() {
        return this.getProvider("jba");
    }

    @Nullable
    public final SettingsSyncCommunicatorProvider getProvider(@NotNull String providerCode) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)providerCode, (String)"providerCode");
            Iterable iterable = this.getAvailableProviders();
            for (Object t : iterable) {
                SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProviderCode(), (Object)providerCode)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsSyncUserData> getAvailableUserAccounts() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getAvailableProviders();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getAuthService().getAvailableUserAccounts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SettingsSyncCommunicatorProvider getCurrentProvider() {
        String string = SettingsSyncLocalSettings.Companion.getInstance().getProviderCode();
        if (string == null) {
            return null;
        }
        String providerCode = string;
        return this.getProvider(providerCode);
    }

    private static final SettingsSyncRemoteCommunicator communicatorLazy$lambda$0() {
        return INSTANCE.createRemoteCommunicator();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteCommunicatorHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteCommunicatorHolder.logger = logger;
        communicatorLazy = ResettableLazyKt.resettableLazy(RemoteCommunicatorHolder::communicatorLazy$lambda$0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService;", "Lcom/intellij/settingsSync/core/auth/SettingsSyncAuthService;", "<init>", "()V", "providerCode", "", "getProviderCode", "()Ljava/lang/String;", "providerName", "getProviderName", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "login", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "parentComponent", "Ljava/awt/Component;", "(Ljava/awt/Component;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUserData", "userId", "getAvailableUserAccounts", "", "intellij.settingsSync.core"})
    private static final class DummyAuthService
    implements SettingsSyncAuthService {
        @NotNull
        public static final DummyAuthService INSTANCE = new DummyAuthService();
        @NotNull
        private static final String providerCode = "jba";
        @NotNull
        private static final String providerName = "JetBrains";
        @NotNull
        private static final Icon icon;

        private DummyAuthService() {
        }

        @Override
        @NotNull
        public String getProviderCode() {
            return providerCode;
        }

        @Override
        @NotNull
        public String getProviderName() {
            return providerName;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return icon;
        }

        @Override
        @Nullable
        public Object login(@Nullable Component parentComponent, @NotNull Continuation<? super SettingsSyncUserData> $completion) {
            return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SettingsSyncUserData>, Object>(parentComponent, null){
                int label;
                final /* synthetic */ Component $parentComponent;
                {
                    this.$parentComponent = $parentComponent;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (this.$parentComponent != null) {
                                Messages.showInfoMessage((Component)this.$parentComponent, (String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.text", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.title", new Object[0]));
                            } else {
                                Messages.showInfoMessage((String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.text", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.title", new Object[0]));
                            }
                            return null;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super SettingsSyncUserData> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Override
        @Nullable
        public SettingsSyncUserData getUserData(@NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return null;
        }

        @Override
        @NotNull
        public List<SettingsSyncUserData> getAvailableUserAccounts() {
            return CollectionsKt.emptyList();
        }

        static {
            Icon icon = AllIcons.Ultimate.IdeaUltimatePromo;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IdeaUltimatePromo");
            DummyAuthService.icon = icon;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyDefaultCommunicatorProvider;", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncCommunicatorProvider;", "<init>", "()V", "providerCode", "", "getProviderCode", "()Ljava/lang/String;", "authService", "Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService;", "getAuthService", "()Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService;", "createCommunicator", "Lcom/intellij/settingsSync/core/SettingsSyncRemoteCommunicator;", "userId", "intellij.settingsSync.core"})
    private static final class DummyDefaultCommunicatorProvider
    implements SettingsSyncCommunicatorProvider {
        @NotNull
        public static final DummyDefaultCommunicatorProvider INSTANCE = new DummyDefaultCommunicatorProvider();
        @NotNull
        private static final DummyAuthService authService = DummyAuthService.INSTANCE;

        private DummyDefaultCommunicatorProvider() {
        }

        @Override
        @NotNull
        public String getProviderCode() {
            return "jba";
        }

        @Override
        @NotNull
        public DummyAuthService getAuthService() {
            return authService;
        }

        @Override
        @Nullable
        public SettingsSyncRemoteCommunicator createCommunicator(@NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return null;
        }
    }
}

