/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.project.CompDBProjectResolver;
import com.jetbrains.cidr.cpp.compdb.project.CompDBStateData;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBLocalSettings;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBProjectSettings;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="CompDBWorkspace")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J8\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0016\u001a\u0004\u0018\u00010\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace;", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "Lcom/jetbrains/cidr/project/workspace/WorkspaceWithEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getClientKey", "", "Lorg/jetbrains/annotations/NotNull;", "createEnvironment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "toolchainNameOrNullForDefault", "problems", "Lcom/jetbrains/cidr/toolchains/EnvironmentProblems;", "checkIfFunctional", "", "onMissingToolchain", "Ljava/lang/Runnable;", "environment", "getEnvironment", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "checkInitialState", "", "externalModuleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "Companion", "intellij.clion.compdb"})
@SourceDebugExtension(value={"SMAP\nCompDBWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompDBWorkspace.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBWorkspace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1863#2,2:133\n1863#2,2:135\n*S KotlinDebug\n*F\n+ 1 CompDBWorkspace.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBWorkspace\n*L\n73#1:133,2\n84#1:135,2\n*E\n"})
public final class CompDBWorkspace
extends ExternalWorkspace
implements WorkspaceWithEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CompDBWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public String getClientKey() {
        String string = CompDBUtilKt.getID().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @Nullable
    public CPPEnvironment createEnvironment(@Nullable Project project, @Nullable String toolchainNameOrNullForDefault, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        return CPPToolchains.createCPPEnvironment((Project)project, (File)this.getProjectPath().toFile(), (String)toolchainNameOrNullForDefault, (EnvironmentProblems)problems, (boolean)checkIfFunctional, (Runnable)onMissingToolchain);
    }

    @NotNull
    public final CPPEnvironment getEnvironment() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        CompDBLocalSettings localSettings = CompDBLocalSettings.Companion.getInstance(project);
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = this.createEnvironment(this.myProject, localSettings.getToolchainName(), environmentProblems, false, null);
        environmentProblems.throwAsExecutionException();
        if (environment == null) {
            throw new ExecutionException(CompDBBundle.message("error.no.environment", new Object[0]));
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkInitialState() {
        ExternalSystemProgressNotificationManager notificationManager;
        var listener2 = new ExternalSystemTaskNotificationListener(){
            private final Set<String> alreadyRefreshed;
            {
                Set set = ConcurrentCollectionFactory.createConcurrentSet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
                this.alreadyRefreshed = set;
            }

            public final Set<String> getAlreadyRefreshed() {
                return this.alreadyRefreshed;
            }

            public void onStart(ExternalSystemTaskId taskId, String workingDir) {
                Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
                if (Intrinsics.areEqual((Object)CompDBUtilKt.getID(), (Object)taskId.getProjectSystemId()) && taskId.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
                    String string = workingDir;
                    Intrinsics.checkNotNull((Object)string);
                    this.alreadyRefreshed.add(string);
                }
            }
        };
        ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager = notificationManager = ExternalSystemProgressNotificationManager.getInstance();
        if (externalSystemProgressNotificationManager != null) {
            externalSystemProgressNotificationManager.addNotificationListener(listener2);
        }
        try {
            CPPEnvironment environment = this.getEnvironment();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Collection modules = ExternalWorkspace.Companion.findExternalModuleNodes(project);
            Iterable $this$forEach$iv = modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataNode it = (DataNode)element$iv;
                boolean bl = false;
                String pathToRefresh = this.checkInitialState((DataNode<ExternalModule>)it, environment);
                if (pathToRefresh == null || listener2.getAlreadyRefreshed().contains(pathToRefresh)) continue;
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                CompDBUtil.INSTANCE.markProjectDirty(project2, pathToRefresh);
            }
        }
        catch (ExecutionException ex) {
            CompDBLog.INSTANCE.getLOG().debug("Initial state check: can't create environment");
            CompDBLog.INSTANCE.getLOG().debug((Throwable)ex);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable $this$forEach$iv = CompDBUtil.INSTANCE.linkedProjectSettings(project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompDBProjectSettings it = (CompDBProjectSettings)((Object)element$iv);
                boolean bl = false;
                if (listener2.getAlreadyRefreshed().contains(it.getExternalProjectPath())) continue;
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                String string = it.getExternalProjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
                CompDBUtil.INSTANCE.markProjectDirty(project3, string);
            }
        }
        finally {
            ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager2 = notificationManager;
            if (externalSystemProgressNotificationManager2 != null) {
                externalSystemProgressNotificationManager2.removeNotificationListener(listener2);
            }
        }
    }

    private final String checkInitialState(DataNode<ExternalModule> externalModuleNode, CPPEnvironment environment) {
        DataNode ideaModule = ExternalSystemApiUtil.findParent(externalModuleNode, (Key)ProjectKeys.MODULE);
        CompDBLog.INSTANCE.getLOG().assertTrue(ideaModule != null);
        DataNode compDBStateNode = ExternalSystemApiUtil.find(externalModuleNode, CompDBStateData.Companion.getCOMPDB_STATE_DATA_KEY());
        if (compDBStateNode == null) {
            CompDBLog.INSTANCE.getLOG().debug("Initial state check: no previously created state");
            DataNode dataNode = ideaModule;
            Intrinsics.checkNotNull((Object)dataNode);
            return ((ModuleData)dataNode.getData()).getLinkedExternalProjectPath();
        }
        DataNode<CompDBStateData> newCompDBStateNode = CompDBProjectResolver.Companion.createStateData(environment);
        if (!Intrinsics.areEqual(newCompDBStateNode, (Object)compDBStateNode)) {
            if (CompDBLog.INSTANCE.getLOG().isDebugEnabled()) {
                CompDBLog.INSTANCE.getLOG().debug(StringsKt.trimMargin$default((String)("\n          |Initial state check: state changed\n          |Old: " + compDBStateNode.getData() + "\n          |New: " + newCompDBStateNode.getData()), null, (int)1, null));
            }
            DataNode dataNode = ideaModule;
            Intrinsics.checkNotNull((Object)dataNode);
            return ((ModuleData)dataNode.getData()).getLinkedExternalProjectPath();
        }
        return null;
    }

    @NotNull
    public List<CidrToolEnvironment> getEnvironment() {
        List list;
        try {
            list = CollectionsKt.listOf((Object)this.getEnvironment());
        }
        catch (ExecutionException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final CompDBWorkspace getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.compdb"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CompDBWorkspace getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(CompDBWorkspace.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (CompDBWorkspace)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

