/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.cpp.diagnostics.CdIndenter;
import com.jetbrains.cidr.cpp.diagnostics.CdToolchainsKt;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.CidrProjectAction;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/ShowRemoteHostsInfoAction;", "Lcom/jetbrains/cidr/project/CidrProjectAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getRemoteEnvironments", "", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "workspaces", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.diagnostics"})
@SourceDebugExtension(value={"SMAP\nShowRemoteHostsInfoAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowRemoteHostsInfoAction.kt\ncom/jetbrains/cidr/cpp/diagnostics/ShowRemoteHostsInfoAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1611#2,9:89\n1863#2:98\n1864#2:100\n1620#2:101\n1368#2:102\n1454#2,5:103\n774#2:108\n865#2,2:109\n1611#2,9:111\n1863#2:120\n1864#2:122\n1620#2:123\n774#2:124\n865#2,2:125\n1863#2,2:127\n1#3:99\n1#3:121\n*S KotlinDebug\n*F\n+ 1 ShowRemoteHostsInfoAction.kt\ncom/jetbrains/cidr/cpp/diagnostics/ShowRemoteHostsInfoAction\n*L\n72#1:89,9\n72#1:98\n72#1:100\n72#1:101\n73#1:102\n73#1:103,5\n74#1:108\n74#1:109,2\n77#1:111,9\n77#1:120\n77#1:122\n77#1:123\n84#1:124\n84#1:125,2\n44#1:127,2\n72#1:99\n77#1:121\n*E\n"})
public final class ShowRemoteHostsInfoAction
extends CidrProjectAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List workspaces = CidrProjectAction.Companion.getActionWorkspaces(e);
        if (workspaces.isEmpty()) {
            return;
        }
        CdIndenter log = new CdIndenter(4);
        CdToolchainsKt.processSystemInfo(log);
        log.put(new Object[0]);
        HashSet hosts = new HashSet();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ShowRemoteHostsInfoAction.actionPerformed$lambda$2(this, workspaces, project2, hosts, log), CppDiagnosticsBundle.message("cpp.diagnostics.progress.hosts.info", new Object[0]), true, project2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CidrToolEnvironment> getRemoteEnvironments(List<? extends CidrWorkspace> workspaces, Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        Iterable $this$mapNotNull$iv2;
        Function1 isRemote = ShowRemoteHostsInfoAction::getRemoteEnvironments$lambda$3;
        Iterable iterable = workspaces;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WorkspaceWithEnvironment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CidrWorkspace it = (CidrWorkspace)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof WorkspaceWithEnvironment ? (WorkspaceWithEnvironment)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv2 = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv2 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            WorkspaceWithEnvironment it = (WorkspaceWithEnvironment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getEnvironment();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            if (!((Boolean)isRemote.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activeRemoteEnvironments = (List)destination$iv$iv;
        Object object = ActionsKt.runReadAction(ShowRemoteHostsInfoAction::getRemoteEnvironments$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Iterable $i$f$filter22 = (Iterable)object;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            CPPEnvironment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CPPToolchains.Toolchain it = (CPPToolchains.Toolchain)element$iv$iv;
            boolean bl4 = false;
            if (CPPToolchains.createCPPEnvironment((Project)project, null, (String)it.getName(), (EnvironmentProblems)new EnvironmentProblems(), (boolean)false, null) == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)isRemote.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List allRemoteEnvironments = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)activeRemoteEnvironments, (Iterable)allRemoteEnvironments);
    }

    private static final void actionPerformed$lambda$2$lambda$1(CdIndenter $log, Project $project) {
        LightVirtualFile infoFile = new LightVirtualFile("Remote Hosts Info", (FileType)PlainTextFileType.INSTANCE, (CharSequence)$log.getResult());
        FileEditorManager.getInstance((Project)$project).openFile((VirtualFile)infoFile, false);
    }

    private static final void actionPerformed$lambda$2(ShowRemoteHostsInfoAction this$0, List $workspaces, Project $project, HashSet $hosts, CdIndenter $log) {
        Iterable $this$forEach$iv = this$0.getRemoteEnvironments($workspaces, $project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String hostId;
            CidrToolEnvironment environment = (CidrToolEnvironment)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)environment.getHostMachine().getHostId(), (String)"getHostId(...)");
            if (!$hosts.add(hostId)) continue;
            try {
                CdToolchainsKt.processRemoteHost($log, environment);
                $log.put(new Object[0]);
            }
            catch (Throwable t) {
                Object[] objectArray = new Object[]{hostId, "  ==>  ", CdToolchainsKt.stackTraceToString(t)};
                $log.put(objectArray);
                $log.put(new Object[0]);
            }
        }
        if (!ProgressManager.getInstance().getProgressIndicator().isCanceled()) {
            ApplicationManager.getApplication().invokeLater(() -> ShowRemoteHostsInfoAction.actionPerformed$lambda$2$lambda$1($log, $project));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getRemoteEnvironments$lambda$3(CidrToolEnvironment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.getHostMachine().isRemote()) return false;
        String string = it.getHostMachine().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"Remote", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final List getRemoteEnvironments$lambda$6() {
        return CPPToolchains.getInstance().getToolchains();
    }
}

