/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.intellij.util.io.Compressor;
import com.jetbrains.cidr.cpp.diagnostics.CdCidrWorkspaceKt;
import com.jetbrains.cidr.cpp.diagnostics.CdDateUtilKt;
import com.jetbrains.cidr.cpp.diagnostics.CdOCWorkspaceKt;
import com.jetbrains.cidr.cpp.diagnostics.CdToolchainsKt;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsBundle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/troubleshooting/TroubleInfoCollector;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "collectInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformed", "collectData", "", "Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction$Companion$FilenameAndContent;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "Companion", "intellij.clion.diagnostics"})
@SourceDebugExtension(value={"SMAP\nCppDiagnosticsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppDiagnosticsAction.kt\ncom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1797#2,3:164\n*S KotlinDebug\n*F\n+ 1 CppDiagnosticsAction.kt\ncom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction\n*L\n44#1:164,3\n*E\n"})
public final class CppDiagnosticsAction
extends DumbAwareAction
implements TroubleInfoCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("C/C++ Diagnostics", NotificationDisplayType.BALLOON, true, null, null, 24, null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(DumbAwareAction.getEventProject((AnActionEvent)e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String collectInfo(@NotNull Project project) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = this.collectData(ProgressManager.getGlobalProgressIndicator(), project);
        StringBuilder stringBuilder = new StringBuilder("=====CLION SUMMARY=====").append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        StringBuilder initial$iv = stringBuilder;
        boolean $i$f$fold = false;
        StringBuilder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void fileWithContents;
            Companion.FilenameAndContent filenameAndContent = (Companion.FilenameAndContent)element$iv;
            StringBuilder acc = accumulator$iv;
            boolean bl = false;
            StringBuilder stringBuilder2 = acc.append(fileWithContents.getFilename());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            StringBuilder stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3.append(fileWithContents.getContents());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }
        String string = accumulator$iv.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = CppDiagnosticsBundle.message("cpp.diagnostics.progress.title", new Object[0]);
        Task.Modal task2 = new Task.Modal(project2, this, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ CppDiagnosticsAction this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                List files = CppDiagnosticsAction.access$collectData(this.this$0, indicator, this.$project);
                com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsAction$Companion.access$zipAndReveal(CppDiagnosticsAction.Companion, files);
                if (Registry.Companion.is("cpp.diagnostics.also.open.in.editor")) {
                    ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.$project)).submit(() -> actionPerformed.task.1.run$lambda$0(files, this.$project));
                }
            }

            private static final void run$lambda$0(List $files, Project $project) {
                for (Companion.FilenameAndContent file : $files) {
                    LightVirtualFile virtualFile = new LightVirtualFile(file.getFilename(), (CharSequence)file.getContents());
                    FileEditorManager.getInstance((Project)$project).openFile((VirtualFile)virtualFile, true);
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private final List<Companion.FilenameAndContent> collectData(ProgressIndicator indicator, Project project) {
        String toolchains = (String)CppDiagnosticsAction.Companion.readActionWithText(indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.toolchains", new Object[0]), () -> CppDiagnosticsAction.collectData$lambda$1(project));
        String cidrWorkspaces = (String)CppDiagnosticsAction.Companion.readActionWithText(indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.workspace", new Object[0]), () -> CppDiagnosticsAction.collectData$lambda$2(project));
        String ocWorkspace = (String)CppDiagnosticsAction.Companion.readActionWithText(indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.ocWorkspace", new Object[0]), () -> CppDiagnosticsAction.collectData$lambda$3(project));
        String ocWorkspaceEvents = (String)CppDiagnosticsAction.Companion.readActionWithText(indicator, CppDiagnosticsBundle.message("cpp.diagnostics.progress.ocWorkspaceEvents", new Object[0]), () -> CppDiagnosticsAction.collectData$lambda$4(project));
        Object[] objectArray = new Companion.FilenameAndContent[]{new Companion.FilenameAndContent("Toolchains.txt", toolchains), new Companion.FilenameAndContent("CidrWorkspaces.txt", cidrWorkspaces), new Companion.FilenameAndContent("OCWorkspaceEvents.txt", ocWorkspaceEvents), new Companion.FilenameAndContent("OCWorkspace.txt", ocWorkspace)};
        List files = CollectionsKt.listOf((Object[])objectArray);
        return files;
    }

    @NotNull
    public String toString() {
        return CppDiagnosticsBundle.message("cpp.diagnostic.issue.title", new Object[0]);
    }

    private static final String collectData$lambda$1(Project $project) {
        return CdToolchainsKt.collectToolchains($project);
    }

    private static final String collectData$lambda$2(Project $project) {
        return CdCidrWorkspaceKt.collectCidrWorkspaces($project);
    }

    private static final String collectData$lambda$3(Project $project) {
        return CdOCWorkspaceKt.collectOCWorkspace($project);
    }

    private static final String collectData$lambda$4(Project $project) {
        return CdCidrWorkspaceKt.collectOCWorkspaceEvents($project);
    }

    public static final /* synthetic */ List access$collectData(CppDiagnosticsAction $this, ProgressIndicator indicator, Project project) {
        return $this.collectData(indicator, project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\f0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction$Companion;", "", "<init>", "()V", "createZip", "Ljava/io/File;", "files", "", "Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction$Companion$FilenameAndContent;", "zipAndReveal", "", "readActionWithText", "R", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "text", "", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "FilenameAndContent", "intellij.clion.diagnostics"})
    public static final class Companion {
        private Companion() {
        }

        private final File createZip(Iterable<FilenameAndContent> files) throws IOException {
            String productName = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getLowercaseProductName());
            File file = FileUtil.createTempFile((String)(productName + "-cpp-diag-" + CdDateUtilKt.formatCurrentTime()), (String)".zip");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File zippedLogsFile = file;
            try {
                Compressor.Zip zip = new Compressor.Zip(zippedLogsFile);
                for (FilenameAndContent file2 : files) {
                    String string = file2.getFilename();
                    String string2 = file2.getContents();
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    zip.addFile(string, (InputStream)new ByteArrayInputStream(byArray));
                }
                zip.close();
            }
            catch (IOException exception) {
                FileUtil.delete((File)zippedLogsFile);
                throw exception;
            }
            return zippedLogsFile;
        }

        private final void zipAndReveal(Iterable<FilenameAndContent> files) {
            try {
                File zippedDiagnostics = this.createZip(files);
                if (RevealFileAction.isSupported()) {
                    RevealFileAction.openFile((File)zippedDiagnostics);
                } else {
                    Object[] objectArray = new Object[]{zippedDiagnostics.getAbsolutePath()};
                    Notification logNotification = new Notification(NOTIFICATION_GROUP.getDisplayId(), "", CppDiagnosticsBundle.message("cpp.diagnostics.are.collected.0", objectArray), NotificationType.INFORMATION);
                    Notifications.Bus.notify((Notification)logNotification);
                }
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{e.getLocalizedMessage()};
                Notification errorNotification = new Notification(NOTIFICATION_GROUP.getDisplayId(), "", CppDiagnosticsBundle.message("cpp.diagnostics.cant.write.0", objectArray), NotificationType.ERROR);
                Notifications.Bus.notify((Notification)errorNotification);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <R> R readActionWithText(ProgressIndicator indicator, @NlsContexts.ProgressText String text, Function0<? extends R> block) {
            ProgressIndicator progressIndicator = indicator;
            String oldText = progressIndicator != null ? progressIndicator.getText() : null;
            ProgressIndicator progressIndicator2 = indicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(text);
            }
            try {
                Object object = ActionsKt.runReadAction(block);
                return (R)object;
            }
            finally {
                block4: {
                    ProgressIndicator progressIndicator3 = indicator;
                    if (progressIndicator3 == null) break block4;
                    progressIndicator3.setText(oldText);
                }
            }
        }

        public static final /* synthetic */ void access$zipAndReveal(Companion $this, Iterable files) {
            $this.zipAndReveal(files);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CppDiagnosticsAction$Companion$FilenameAndContent;", "", "filename", "", "contents", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFilename", "()Ljava/lang/String;", "getContents", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.diagnostics"})
        private static final class FilenameAndContent {
            @NotNull
            private final String filename;
            @NotNull
            private final String contents;

            public FilenameAndContent(@NotNull String filename, @NotNull String contents) {
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                this.filename = filename;
                this.contents = contents;
            }

            @NotNull
            public final String getFilename() {
                return this.filename;
            }

            @NotNull
            public final String getContents() {
                return this.contents;
            }

            @NotNull
            public final String component1() {
                return this.filename;
            }

            @NotNull
            public final String component2() {
                return this.contents;
            }

            @NotNull
            public final FilenameAndContent copy(@NotNull String filename, @NotNull String contents) {
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                return new FilenameAndContent(filename, contents);
            }

            public static /* synthetic */ FilenameAndContent copy$default(FilenameAndContent filenameAndContent, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = filenameAndContent.filename;
                }
                if ((n & 2) != 0) {
                    string2 = filenameAndContent.contents;
                }
                return filenameAndContent.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "FilenameAndContent(filename=" + this.filename + ", contents=" + this.contents + ")";
            }

            public int hashCode() {
                int result = this.filename.hashCode();
                result = result * 31 + this.contents.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FilenameAndContent)) {
                    return false;
                }
                FilenameAndContent filenameAndContent = (FilenameAndContent)other;
                if (!Intrinsics.areEqual((Object)this.filename, (Object)filenameAndContent.filename)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.contents, (Object)filenameAndContent.contents);
            }
        }
    }
}

