/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.rsync.RSyncOptions;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.cpp.diagnostics.CdIndenter;
import com.jetbrains.cidr.cpp.diagnostics.CdToolchainsKt;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.cpp.toolchains.Make;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.system.CidrRSyncUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWrapper;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001aO\u0010 \u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00172\b\b\u0001\u0010\"\u001a\u00020\u00012!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00190$2\b\b\u0002\u0010'\u001a\u00020\u0001H\u0002\u001a\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u000e\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020,\u001a\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110.2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110.2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u00060"}, d2={"collectToolchains", "", "project", "Lcom/intellij/openapi/project/Project;", "processSystemInfo", "", "log", "Lcom/jetbrains/cidr/cpp/diagnostics/CdIndenter;", "processDevOptions", "processRemoteHost", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "logTool", "tool", "Lcom/jetbrains/cidr/toolchains/CidrExecutableTool;", "toolName", "processCPPEnvironment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "processGeneralToolchainInfo", "toolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "testRemoteHost", "remoteHost", "Lcom/jetbrains/cidr/system/HostMachine;", "checkConnection", "", "processCheck", "checkRemoteFS", "checkRemoteTar", "checkRemoteRsync", "checkRemotePigz", "checkRsyncDownload", "test", "host", "testName", "check", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "failStatusMsg", "getCredentials", "Lcom/intellij/remote/RemoteCredentials;", "stackTraceToString", "t", "", "getAllEnvironments", "", "getAllProjectEnvironments", "intellij.clion.diagnostics"})
@SourceDebugExtension(value={"SMAP\nCdToolchains.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdToolchains.kt\ncom/jetbrains/cidr/cpp/diagnostics/CdToolchainsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CdIndenter.kt\ncom/jetbrains/cidr/cpp/diagnostics/CdIndenter\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,296:1\n1863#2,2:297\n1863#2,2:322\n1863#2,2:334\n1557#2:339\n1628#2,3:340\n1557#2:343\n1628#2,3:344\n774#2:347\n865#2,2:348\n1611#2,9:350\n1863#2:359\n1864#2:361\n1620#2:362\n1663#2,8:363\n1611#2,9:371\n1863#2:380\n1864#2:382\n1620#2:383\n1368#2:384\n1454#2,5:385\n1611#2,9:390\n1863#2:399\n1864#2:401\n1620#2:402\n1663#2,8:403\n30#3,8:299\n30#3,8:307\n30#3,3:315\n30#3,3:319\n35#3,3:324\n35#3,3:328\n30#3,3:331\n35#3,3:336\n1#4:318\n1#4:360\n1#4:381\n1#4:400\n48#5:327\n*S KotlinDebug\n*F\n+ 1 CdToolchains.kt\ncom/jetbrains/cidr/cpp/diagnostics/CdToolchainsKt\n*L\n42#1:297,2\n126#1:322,2\n154#1:334,2\n273#1:339\n273#1:340,3\n275#1:343\n275#1:344,3\n276#1:347\n276#1:348,2\n277#1:350,9\n277#1:359\n277#1:361\n277#1:362\n285#1:363,8\n291#1:371,9\n291#1:380\n291#1:382\n291#1:383\n292#1:384\n292#1:385,5\n293#1:390,9\n293#1:399\n293#1:401\n293#1:402\n294#1:403,8\n69#1:299,8\n86#1:307,8\n111#1:315,3\n124#1:319,3\n124#1:324,3\n111#1:328,3\n153#1:331,3\n153#1:336,3\n277#1:360\n291#1:381\n293#1:400\n131#1:327\n*E\n"})
public final class CdToolchainsKt {
    @NotNull
    public static final String collectToolchains(@Nullable Project project) {
        CdIndenter log = new CdIndenter(4);
        CdToolchainsKt.processSystemInfo(log);
        log.put(new Object[0]);
        Iterable $this$forEach$iv = CdToolchainsKt.getAllEnvironments(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CPPEnvironment it = (CPPEnvironment)element$iv;
            boolean bl = false;
            CdToolchainsKt.processCPPEnvironment(log, it);
            log.put(new Object[0]);
        }
        return log.getResult();
    }

    public static final void processSystemInfo(@NotNull CdIndenter log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
        ApplicationNamesInfo namesInfo = applicationNamesInfo;
        Object[] objectArray = new Object[]{"IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asString() + ")"};
        log.put(objectArray);
        objectArray = new Object[]{"OS: " + SystemInfo.OS_NAME + " (" + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")"};
        log.put(objectArray);
        CPPToolchains cPPToolchains = CPPToolchains.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"getInstance(...)");
        CPPToolchains cppToolchains = cPPToolchains;
        Object[] objectArray2 = new Object[1];
        Object object = cppToolchains.getDefaultToolchain();
        if (object == null || (object = object.getName()) == null) {
            object = "UNKNOWN";
        }
        objectArray2[0] = "Default toolchain: " + (String)object;
        log.put(objectArray2);
        CdToolchainsKt.processDevOptions(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processDevOptions(CdIndenter log) {
        Object[] objectArray = new Object[]{"Options:"};
        log.put(objectArray);
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            boolean bl = false;
            CdToolchainsKt.processDevOptions$logOption(log, "clion.remote.compress.tar", true);
            CdToolchainsKt.processDevOptions$logIntOption(log, "clion.remote.tar.timeout", 240000);
            CdToolchainsKt.processDevOptions$logOption(log, "clion.remote.resync.system.cache", false);
            CdToolchainsKt.processDevOptions$logOption(log, "clion.remote.upload.external.changes", true);
        }
        finally {
            this_$iv.unIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void processRemoteHost(@NotNull CdIndenter log, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!environment.getHostMachine().isRemote()) {
            return;
        }
        HostMachine remoteHost = environment.getHostMachine();
        String string = remoteHost.getHostId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostId(...)");
        String hostId = string;
        boolean isWsl = environment instanceof CPPEnvironment && ((CPPEnvironment)environment).getToolSet().isWSL();
        Object[] objectArray = new Object[]{"Remote Host: " + remoteHost.getName() + " (" + hostId + ")", isWsl ? " is WSL" : ""};
        log.put(objectArray);
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)remoteHost);
            CdToolchainsKt.testRemoteHost(log, remoteHost);
            if (environment instanceof CPPEnvironment) {
                CdToolchainsKt.processCPPEnvironment(log, (CPPEnvironment)environment);
            }
        }
        finally {
            this_$iv.unIndent();
        }
    }

    private static final void logTool(CidrExecutableTool tool, String toolName, CdIndenter log) {
        Object[] objectArray;
        try {
            objectArray = tool.readVersion();
        }
        catch (ExecutionException e) {
            objectArray = null;
        }
        Object[] version = objectArray;
        objectArray = new Object[]{toolName + " (" + (String)version + "): " + tool.getExecutablePath()};
        log.put(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processCPPEnvironment(CdIndenter log, CPPEnvironment environment) {
        ProgressManager.checkCanceled();
        CPPToolchains.Toolchain toolchain = environment.getToolchain();
        Intrinsics.checkNotNullExpressionValue((Object)toolchain, (String)"getToolchain(...)");
        CPPToolchains.Toolchain toolchain2 = toolchain;
        HostMachine hostMachine = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        HostMachine hostMachine2 = hostMachine;
        Object[] objectArray = new Object[]{"Toolchain: " + toolchain2.getName()};
        log.put(objectArray);
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            CMakeExecutableTool it;
            boolean bl = false;
            CdToolchainsKt.processGeneralToolchainInfo(log, toolchain2);
            CMakeExecutableTool cMakeExecutableTool = environment.getCMake();
            if (cMakeExecutableTool != null) {
                it = cMakeExecutableTool;
                boolean bl2 = false;
                CdToolchainsKt.logTool((CidrExecutableTool)it, "cmake", log);
            }
            Make make = environment.getMake();
            if (make != null) {
                it = make;
                boolean bl3 = false;
                CdToolchainsKt.logTool((CidrExecutableTool)it, "make", log);
            }
            GDB gDB = environment.getGDB();
            if (gDB != null) {
                it = gDB;
                boolean bl4 = false;
                CdToolchainsKt.logTool((CidrExecutableTool)it, "cmake", log);
            }
            if (hostMachine2 instanceof MappedHost) {
                Object[] objectArray2 = new Object[]{"Path Mappings:"};
                log.put(objectArray2);
                PathMapper pathMapper = null;
                PathMapper pathMapper2 = ((MappedHost)hostMachine2).getPathMapper();
                Intrinsics.checkNotNullExpressionValue((Object)pathMapper2, (String)"getPathMapper(...)");
                pathMapper = pathMapper2;
                if (pathMapper instanceof PathMapperWrapper) {
                    pathMapper = ((PathMapperWrapper)pathMapper).getOriginal();
                }
                CdIndenter this_$iv2 = log;
                boolean $i$f$scope2 = false;
                this_$iv2.indent();
                try {
                    boolean bl5 = false;
                    if (pathMapper instanceof PathMappingSettings) {
                        List list = ((PathMappingSettings)pathMapper).getPathMappings();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathMappings(...)");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            PathMappingSettings.PathMapping it2 = (PathMappingSettings.PathMapping)element$iv;
                            boolean bl6 = false;
                            Object[] objectArray3 = new Object[]{it2.getLocalRoot() + " -> " + it2.getRemoteRoot()};
                            log.put(objectArray3);
                        }
                    }
                }
                finally {
                    this_$iv2.unIndent();
                }
            }
            boolean $i$f$serviceOrNull = false;
            Application application = ApplicationManager.getApplication();
            if ((application != null ? application.getService(RemoteDeployment.class) : null) != null) {
                String string = RemoteDeploymentHelper.getRootPath((String)hostMachine2.getHostId());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootPath(...)");
                String rootPath = string;
                if (((CharSequence)rootPath).length() == 0) {
                    rootPath = "not specified";
                }
                Object[] objectArray4 = new Object[]{"Root Path: " + rootPath};
                log.put(objectArray4);
                if (hostMachine2 instanceof RemoteHost) {
                    objectArray4 = new Object[]{"Header-roots cache: " + ((RemoteHost)hostMachine2).getCacheDirectory().getAbsolutePath()};
                    log.put(objectArray4);
                }
            }
        }
        finally {
            this_$iv.unIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processGeneralToolchainInfo(CdIndenter log, CPPToolchains.Toolchain toolchain) {
        block7: {
            Object[] objectArray = new Object[]{"OS: " + toolchain.getOSType()};
            log.put(objectArray);
            objectArray = new Object[]{"Kind: " + toolchain.getToolSetKind()};
            log.put(objectArray);
            objectArray = new Object[]{"Path: " + toolchain.getToolSetPath()};
            log.put(objectArray);
            List list = toolchain.getToolSetOptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getToolSetOptions(...)");
            List options = list;
            if (!((Collection)options).isEmpty()) {
                Object[] objectArray2 = new Object[]{"Options:"};
                log.put(objectArray2);
                CdIndenter this_$iv = log;
                boolean $i$f$scope = false;
                this_$iv.indent();
                try {
                    boolean bl = false;
                    Iterable $this$forEach$iv = options;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CPPToolSet.Option it = (CPPToolSet.Option)element$iv;
                        boolean bl2 = false;
                        Object[] objectArray3 = new Object[]{it.getUniqueID()};
                        log.put(objectArray3);
                    }
                }
                finally {
                    this_$iv.unIndent();
                }
            }
            String string = toolchain.getCustomCCompilerPath();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Object[] objectArray4 = new Object[]{"c: " + it};
                log.put(objectArray4);
            }
            String string2 = toolchain.getCustomCXXCompilerPath();
            if (string2 == null) break block7;
            String it = string2;
            boolean bl = false;
            Object[] objectArray5 = new Object[]{"cxx: " + it};
            log.put(objectArray5);
        }
    }

    private static final void testRemoteHost(CdIndenter log, HostMachine remoteHost) {
        boolean isConnected2 = CdToolchainsKt.test$default(log, remoteHost, "test connection", testRemoteHost.isConnected.1.INSTANCE, null, 16, null);
        if (isConnected2) {
            CdToolchainsKt.test$default(log, remoteHost, "run remote process", testRemoteHost.1.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "remote FS", testRemoteHost.2.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "tar", testRemoteHost.3.INSTANCE, null, 16, null);
            CdToolchainsKt.test(log, remoteHost, "rsync local", (Function1<? super HostMachine, Boolean>)((Function1)arg_0 -> CdToolchainsKt.testRemoteHost$lambda$13(remoteHost, arg_0)), "[NOT CONFIGURED]");
            CdToolchainsKt.test$default(log, remoteHost, "rsync remote", testRemoteHost.5.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "rsync download", testRemoteHost.6.INSTANCE, null, 16, null);
            CdToolchainsKt.test$default(log, remoteHost, "pigz remote", testRemoteHost.7.INSTANCE, null, 16, null);
        }
    }

    private static final boolean checkConnection(HostMachine remoteHost) {
        return RemoteUtil.checkConnection((RemoteCredentials)CdToolchainsKt.getCredentials(remoteHost));
    }

    private static final boolean processCheck(HostMachine remoteHost) {
        String[] stringArray = new String[]{"pwd"};
        ProcessOutput processOutput = remoteHost.runProcess(new GeneralCommandLine(stringArray), ProgressManager.getInstance().getProgressIndicator(), 5000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output = processOutput;
        return output.getExitCode() == 0 && StringUtil.isNotEmpty((String)output.getStdout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkRemoteFS(HostMachine remoteHost) {
        Path path = remoteHost.createTempDirectory("host_info", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path tmp = path;
        try {
            Path file = Files.createFile(tmp.resolve("file.txt"), new FileAttribute[0]);
            String testString = "Hello, CLion!";
            Intrinsics.checkNotNull((Object)file);
            PathKt.write$default((Path)file, (CharSequence)testString, null, (boolean)false, (int)2, null);
            Path path2 = remoteHost.getPath(((Object)file.toAbsolutePath()).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
            Path filePath = path2;
            boolean bl = Intrinsics.areEqual((Object)testString, (Object)PathsKt.readText$default((Path)filePath, null, (int)1, null));
            return bl;
        }
        finally {
            PathKt.delete$default((Path)tmp, (boolean)false, (int)1, null);
        }
    }

    private static final boolean checkRemoteTar(HostMachine remoteHost) {
        return RemoteUtil.isTarInstalled(arg_0 -> CdToolchainsKt.checkRemoteTar$lambda$14(remoteHost, arg_0));
    }

    private static final boolean checkRemoteRsync(HostMachine remoteHost) {
        return RemoteUtil.isRsyncInstalled(arg_0 -> CdToolchainsKt.checkRemoteRsync$lambda$15(remoteHost, arg_0));
    }

    private static final boolean checkRemotePigz(HostMachine remoteHost) {
        return RemoteUtil.isPigzInstalled(arg_0 -> CdToolchainsKt.checkRemotePigz$lambda$16(remoteHost, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkRsyncDownload(HostMachine remoteHost) throws IOException {
        RemoteCredentials credentials = CdToolchainsKt.getCredentials(remoteHost);
        Path path = remoteHost.createTempDirectory("remote", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path remote = path;
        File file = FileUtil.createTempDirectory((String)"local", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        File local = file;
        File file2 = FileUtil.createTempFile((String)"log", null);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File logFile = file2;
        try {
            Path file3 = Files.createFile(remote.resolve("file.txt"), new FileAttribute[0]);
            String testString = "Hello, CLion!";
            Intrinsics.checkNotNull((Object)file3);
            PathKt.write$default((Path)file3, (CharSequence)testString, null, (boolean)false, (int)2, null);
            RSyncUtil.downloadFolderWithRSync((String)local.getPath(), (String)((Object)remote).toString(), (RemoteCredentials)credentials, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (RSyncOptions)new RSyncOptions(null, false, logFile.getPath(), false, null, false, 59, null));
            String string = FileUtil.loadFile((File)new File(local, "file.txt"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
            String text = string;
            boolean bl = Intrinsics.areEqual((Object)testString, (Object)text);
            return bl;
        }
        finally {
            PathKt.delete$default((Path)remote, (boolean)false, (int)1, null);
            local.delete();
            logFile.delete();
        }
    }

    private static final boolean test(CdIndenter log, HostMachine host, @NonNls String testName, Function1<? super HostMachine, Boolean> check, String failStatusMsg) {
        ProgressManager.checkCanceled();
        boolean status = false;
        try {
            status = (Boolean)check.invoke((Object)host);
            String statusStr = status ? "[OK]" : failStatusMsg;
            Object[] objectArray = new Object[]{statusStr + " " + testName};
            log.put(objectArray);
        }
        catch (Throwable t) {
            Object[] objectArray = new Object[]{"[ERROR] " + testName + "  ==>  ", CdToolchainsKt.stackTraceToString(t)};
            log.put(objectArray);
        }
        return status;
    }

    static /* synthetic */ boolean test$default(CdIndenter cdIndenter, HostMachine hostMachine, String string, Function1 function1, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = "[FAILED]";
        }
        return CdToolchainsKt.test(cdIndenter, hostMachine, string, (Function1<? super HostMachine, Boolean>)function1, string2);
    }

    private static final RemoteCredentials getCredentials(HostMachine remoteHost) {
        RemoteCredentials remoteCredentials = RemoteUtil.getCredentials((HostMachine)remoteHost);
        if (remoteCredentials == null) {
            throw new IllegalStateException("Cannot find credentials by hostId");
        }
        return remoteCredentials;
    }

    @NotNull
    public static final String stackTraceToString(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<CPPEnvironment> getAllEnvironments(Project project) {
        void $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<CPPEnvironment> projectEnvironments = project == null ? CollectionsKt.emptyList() : CdToolchainsKt.getAllProjectEnvironments(project);
        Iterable $this$map$iv2 = projectEnvironments;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CPPEnvironment cPPEnvironment = (CPPEnvironment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getToolchain().getName());
        }
        HashSet toolchainsSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        List list = CPPToolchains.getInstance().getToolchains();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getToolchains(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CPPToolchains.Toolchain bl = (CPPToolchains.Toolchain)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!toolchainsSet.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            CPPEnvironment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (CPPToolchains.createCPPEnvironment((Project)project, null, (String)it2, (EnvironmentProblems)new EnvironmentProblems(), (boolean)false, null) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CPPEnvironment it3 = (CPPEnvironment)e$iv;
            boolean bl = false;
            String key$iv = it3.getToolchain().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List otherEnvironments = list$iv;
        return CollectionsKt.plus((Collection)projectEnvironments, (Iterable)otherEnvironments);
    }

    private static final List<CPPEnvironment> getAllProjectEnvironments(Project project) {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        boolean bl;
        WorkspaceWithEnvironment it$iv$iv;
        CidrWorkspace it;
        boolean bl2;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List list = CidrWorkspace.getInitializedWorkspaces((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInitializedWorkspaces(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (CidrWorkspace)element$iv$iv;
            boolean bl3 = false;
            if ((it instanceof WorkspaceWithEnvironment ? (WorkspaceWithEnvironment)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            WorkspaceWithEnvironment it2 = (WorkspaceWithEnvironment)element$iv$iv2;
            boolean bl4 = false;
            list$iv$iv = it2.getEnvironment();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Object element$iv$iv$iv = list$iv$iv.next();
            element$iv$iv = element$iv$iv$iv;
            bl2 = false;
            it = (CidrToolEnvironment)element$iv$iv;
            boolean bl5 = false;
            if ((it instanceof CPPEnvironment ? (CPPEnvironment)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CPPEnvironment it3 = (CPPEnvironment)e$iv;
            boolean bl6 = false;
            String key$iv = it3.getToolchain().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final CdIndenter processDevOptions$logOption(CdIndenter $log, String option, boolean defaultValue) {
        Object[] objectArray = new Object[]{option + " = " + Registry.Companion.is(option, defaultValue)};
        return $log.put(objectArray);
    }

    private static final CdIndenter processDevOptions$logIntOption(CdIndenter $log, String option, int defaultValue) {
        Object[] objectArray = new Object[]{option + " = " + Registry.Companion.intValue(option, defaultValue)};
        return $log.put(objectArray);
    }

    private static final boolean testRemoteHost$lambda$13(HostMachine $remoteHost, HostMachine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CidrRSyncUtil.canUseRSync((String)$remoteHost.getHostId());
    }

    private static final ProcessOutput checkRemoteTar$lambda$14(HostMachine $remoteHost, GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return $remoteHost.runProcess(cmd, ProgressManager.getInstance().getProgressIndicator(), 5000);
    }

    private static final ProcessOutput checkRemoteRsync$lambda$15(HostMachine $remoteHost, GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return $remoteHost.runProcess(cmd, ProgressManager.getInstance().getProgressIndicator(), 5000);
    }

    private static final ProcessOutput checkRemotePigz$lambda$16(HostMachine $remoteHost, GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return $remoteHost.runProcess(cmd, ProgressManager.getInstance().getProgressIndicator(), 5000);
    }

    public static final /* synthetic */ boolean access$checkConnection(HostMachine remoteHost) {
        return CdToolchainsKt.checkConnection(remoteHost);
    }

    public static final /* synthetic */ boolean access$processCheck(HostMachine remoteHost) {
        return CdToolchainsKt.processCheck(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteFS(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteFS(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteTar(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteTar(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteRsync(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteRsync(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRsyncDownload(HostMachine remoteHost) {
        return CdToolchainsKt.checkRsyncDownload(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemotePigz(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemotePigz(remoteHost);
    }
}

