/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.index.VertexSequencePackedRtree;
import org.locationtech.jts.triangulate.tri.Tri;

class PolygonEarClipper {
    private static final int NO_VERTEX_INDEX = -1;
    private boolean isFlatCornersSkipped = false;
    private final Coordinate[] vertex;
    private final int[] vertexNext;
    private int vertexSize;
    private int vertexFirst;
    private int[] cornerIndex;
    private VertexSequencePackedRtree vertexCoordIndex;

    public static List<Tri> triangulate(Coordinate[] polyShell) {
        PolygonEarClipper clipper = new PolygonEarClipper(polyShell);
        return clipper.compute();
    }

    public PolygonEarClipper(Coordinate[] polyShell) {
        this.vertex = polyShell;
        this.vertexSize = this.vertex.length - 1;
        this.vertexNext = PolygonEarClipper.createNextLinks(this.vertexSize);
        this.vertexFirst = 0;
        this.vertexCoordIndex = new VertexSequencePackedRtree(this.vertex);
    }

    private static int[] createNextLinks(int size) {
        int[] next = new int[size];
        for (int i = 0; i < size; ++i) {
            next[i] = i + 1;
        }
        next[size - 1] = 0;
        return next;
    }

    public void setSkipFlatCorners(boolean isFlatCornersSkipped) {
        this.isFlatCornersSkipped = isFlatCornersSkipped;
    }

    public List<Tri> compute() {
        ArrayList<Tri> triList = new ArrayList<Tri>();
        int cornerScanCount = 0;
        this.initCornerIndex();
        Coordinate[] corner = new Coordinate[3];
        this.fetchCorner(corner);
        while (true) {
            if (!PolygonEarClipper.isConvex(corner)) {
                boolean isCornerRemoved;
                boolean bl = isCornerRemoved = PolygonEarClipper.isCornerInvalid(corner) || this.isFlatCornersSkipped && PolygonEarClipper.isFlat(corner);
                if (isCornerRemoved) {
                    this.removeCorner();
                }
                if (++cornerScanCount > 2 * this.vertexSize) {
                    throw new IllegalStateException("Unable to find a convex corner");
                }
            } else if (this.isValidEar(this.cornerIndex[1], corner)) {
                triList.add(Tri.create(corner));
                this.removeCorner();
                cornerScanCount = 0;
            }
            if (cornerScanCount > 2 * this.vertexSize) {
                throw new IllegalStateException("Unable to find a valid ear");
            }
            if (this.vertexSize < 3) {
                return triList;
            }
            this.nextCorner(corner);
        }
    }

    private boolean isValidEar(int cornerIndex, Coordinate[] corner) {
        int intApexIndex = this.findIntersectingVertex(cornerIndex, corner);
        if (intApexIndex == -1) {
            return true;
        }
        if (this.vertex[intApexIndex].equals2D(corner[1])) {
            return this.isValidEarScan(cornerIndex, corner);
        }
        return false;
    }

    private int findIntersectingVertex(int cornerIndex, Coordinate[] corner) {
        Envelope cornerEnv = PolygonEarClipper.envelope(corner);
        int[] result2 = this.vertexCoordIndex.query(cornerEnv);
        int dupApexIndex = -1;
        for (int i = 0; i < result2.length; ++i) {
            int vertIndex = result2[i];
            if (vertIndex == cornerIndex || vertIndex == this.vertex.length - 1 || this.isRemoved(vertIndex)) continue;
            Coordinate v = this.vertex[vertIndex];
            if (v.equals2D(corner[1])) {
                dupApexIndex = vertIndex;
                continue;
            }
            if (v.equals2D(corner[0]) || v.equals2D(corner[2]) || !Triangle.intersects(corner[0], corner[1], corner[2], v)) continue;
            return vertIndex;
        }
        if (dupApexIndex != -1) {
            return dupApexIndex;
        }
        return -1;
    }

    private boolean isValidEarScan(int cornerIndex, Coordinate[] corner) {
        double cornerAngle = Angle.angleBetweenOriented(corner[0], corner[1], corner[2]);
        int currIndex = this.nextIndex(this.vertexFirst);
        int prevIndex = this.vertexFirst;
        Coordinate vPrev = this.vertex[prevIndex];
        for (int i = 0; i < this.vertexSize; ++i) {
            Coordinate v = this.vertex[currIndex];
            if (currIndex != cornerIndex && v.equals2D(corner[1])) {
                Coordinate vNext = this.vertex[this.nextIndex(currIndex)];
                double aOut = Angle.angleBetweenOriented(corner[0], corner[1], vNext);
                double aIn = Angle.angleBetweenOriented(corner[0], corner[1], vPrev);
                if (aOut > 0.0 && aOut < cornerAngle) {
                    return false;
                }
                if (aIn > 0.0 && aIn < cornerAngle) {
                    return false;
                }
                if (aOut == 0.0 && aIn == cornerAngle) {
                    return false;
                }
            }
            vPrev = v;
            prevIndex = currIndex;
            currIndex = this.nextIndex(currIndex);
        }
        return true;
    }

    private static Envelope envelope(Coordinate[] corner) {
        Envelope cornerEnv = new Envelope(corner[0], corner[1]);
        cornerEnv.expandToInclude(corner[2]);
        return cornerEnv;
    }

    private void removeCorner() {
        int cornerApexIndex = this.cornerIndex[1];
        if (this.vertexFirst == cornerApexIndex) {
            this.vertexFirst = this.vertexNext[cornerApexIndex];
        }
        this.vertexNext[this.cornerIndex[0]] = this.vertexNext[cornerApexIndex];
        this.vertexCoordIndex.remove(cornerApexIndex);
        this.vertexNext[cornerApexIndex] = -1;
        --this.vertexSize;
        this.cornerIndex[1] = this.nextIndex(this.cornerIndex[0]);
        this.cornerIndex[2] = this.nextIndex(this.cornerIndex[1]);
    }

    private boolean isRemoved(int vertexIndex) {
        return -1 == this.vertexNext[vertexIndex];
    }

    private void initCornerIndex() {
        this.cornerIndex = new int[3];
        this.cornerIndex[0] = 0;
        this.cornerIndex[1] = 1;
        this.cornerIndex[2] = 2;
    }

    private void fetchCorner(Coordinate[] cornerVertex) {
        cornerVertex[0] = this.vertex[this.cornerIndex[0]];
        cornerVertex[1] = this.vertex[this.cornerIndex[1]];
        cornerVertex[2] = this.vertex[this.cornerIndex[2]];
    }

    private void nextCorner(Coordinate[] cornerVertex) {
        if (this.vertexSize < 3) {
            return;
        }
        this.cornerIndex[0] = this.nextIndex(this.cornerIndex[0]);
        this.cornerIndex[1] = this.nextIndex(this.cornerIndex[0]);
        this.cornerIndex[2] = this.nextIndex(this.cornerIndex[1]);
        this.fetchCorner(cornerVertex);
    }

    private int nextIndex(int index) {
        return this.vertexNext[index];
    }

    private static boolean isConvex(Coordinate[] pts) {
        return -1 == Orientation.index(pts[0], pts[1], pts[2]);
    }

    private static boolean isFlat(Coordinate[] pts) {
        return 0 == Orientation.index(pts[0], pts[1], pts[2]);
    }

    private static boolean isCornerInvalid(Coordinate[] pts) {
        return pts[1].equals2D(pts[0]) || pts[1].equals2D(pts[2]) || pts[0].equals2D(pts[2]);
    }

    public Polygon toGeometry() {
        GeometryFactory fact = new GeometryFactory();
        CoordinateList coordList = new CoordinateList();
        int index = this.vertexFirst;
        for (int i = 0; i < this.vertexSize; ++i) {
            Coordinate v = this.vertex[index];
            index = this.nextIndex(index);
            coordList.add(v, true);
        }
        coordList.closeRing();
        return fact.createPolygon(fact.createLinearRing(coordList.toCoordinateArray()));
    }
}

