/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.UnixSshFileSystem;
import com.pastdev.jsch.nio.file.UnixSshFileSystemProvider;
import com.pastdev.jsch.nio.file.UnixSshPath;
import com.pastdev.jsch.nio.file.UnixSshSftpHybridFileSystemProvider;
import com.pastdev.jsch.sftp.SftpRunner;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixSshSftpHybridFileSystem
extends UnixSshFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(UnixSshSftpHybridFileSystem.class);
    private UnixSshPath defaultDirectory;
    private UnixSshPath rootDirectory;
    private SftpRunner sftpRunner;

    public UnixSshSftpHybridFileSystem(UnixSshFileSystemProvider provider, URI uri, Map<String, ?> environment) throws IOException {
        super(provider, uri, environment);
        logger.debug("Building SftpRunner");
        this.defaultDirectory = new UnixSshPath(this, uri.getPath());
        if (!this.defaultDirectory.isAbsolute()) {
            throw new RuntimeException("default directory must be absolute");
        }
        this.rootDirectory = new UnixSshPath(this, "/");
    }

    @Override
    public void close() throws IOException {
        this.getSftpRunner().close();
        super.close();
    }

    @Override
    public UnixSshPath getPath(String first, String ... more) {
        if (more == null || more.length == 0) {
            return new UnixSshPath(this, first);
        }
        StringBuilder builder = new StringBuilder(first);
        for (String part : more) {
            builder.append('/').append(part);
        }
        return new UnixSshPath(this, builder.toString());
    }

    public void setSftpRunner(SftpRunner sftpRunner) {
        this.sftpRunner = sftpRunner;
    }

    public SftpRunner getSftpRunner() {
        return this.sftpRunner;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.unmodifiableList(Arrays.asList(this.rootDirectory));
    }

    @Override
    public UnixSshSftpHybridFileSystemProvider provider() {
        return (UnixSshSftpHybridFileSystemProvider)super.provider();
    }
}

