/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.command.CommandRunner;
import com.pastdev.jsch.nio.file.AbstractSshFileSystemProvider;
import com.pastdev.jsch.nio.file.Variant;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSshFileSystem
extends FileSystem {
    private static final Set<String> supportedFileAttributeViews = new HashSet<String>();
    private String binDir = null;
    private CommandRunner commandRunner;
    private Map<String, ?> environment;
    private AbstractSshFileSystemProvider provider;
    private URI uri;
    Variant defaultVariant;

    public AbstractSshFileSystem(AbstractSshFileSystemProvider provider, URI uri, Map<String, ?> environment) throws IOException {
        this.provider = provider;
        this.uri = uri;
        this.environment = environment;
        String binDirKey = "dir.bin";
        if (environment.containsKey(binDirKey)) {
            this.binDir = (String)environment.get(binDirKey);
        }
    }

    String getCommand(String command) {
        String commandKey = "command." + command;
        if (this.environment.containsKey(commandKey)) {
            return (String)this.environment.get(commandKey);
        }
        if (this.binDir != null) {
            return this.binDir + '/' + command;
        }
        return command;
    }

    public Variant getVariant(String command) {
        String variantKey = "variant." + command;
        if (this.environment.containsKey(variantKey)) {
            return (Variant)((Object)this.environment.get(variantKey));
        }
        if (this.defaultVariant == null) {
            CommandRunner.ExecuteResult execute2;
            try {
                execute2 = this.commandRunner.execute("uname -s");
            }
            catch (IOException e) {
                return Variant.GNU;
            }
            if (execute2.getExitCode() != 0) {
                return Variant.GNU;
            }
            switch (execute2.getStdout().trim().toLowerCase()) {
                case "darwin": 
                case "freebsd": 
                case "openbsd": 
                case "dragonfly": 
                case "netbsd": {
                    this.defaultVariant = Variant.BSD;
                    break;
                }
                default: {
                    this.defaultVariant = Variant.GNU;
                }
            }
        }
        return this.defaultVariant;
    }

    public void setCommandRunner(CommandRunner commandRunner) {
        this.commandRunner = commandRunner;
    }

    public CommandRunner getCommandRunner() {
        return this.commandRunner;
    }

    public boolean getBooleanFromEnvironment(String key) {
        Object value = this.environment.get(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public Object getFromEnvironment(String key) {
        return this.environment.get(key);
    }

    public Long getLongFromEnvironment(String key) {
        Object value = this.environment.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(value.toString());
    }

    public String getStringFromEnvironment(String key) {
        Object value = this.environment.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public TimeUnit getTimeUnitFromEnvironment(String key) {
        Object value = this.environment.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof TimeUnit) {
            return (TimeUnit)((Object)value);
        }
        return TimeUnit.valueOf(value.toString().toUpperCase());
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    static {
        supportedFileAttributeViews.add("basic");
    }
}

