/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.zipcache;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.zipcache.CidrWritableZipBackedCache;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u0005*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\bH\u0007J\u0018\u0010\t\u001a\u00020\u0005*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006H\u0007J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J/\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a*\u00020\f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ$\u0010\u001f\u001a\u00020\u0005*\u00020\f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00050\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipCacheUtil;", "", "<init>", "()V", "refreshVfsForCacheRootSynchronously", "", "Lcom/jetbrains/cidr/zipcache/CidrWritableZipBackedCache;", "onCompletion", "Lkotlin/Function0;", "refreshAllFilesInCacheRootSynchronously", "writeToFile", "dir", "Ljava/nio/file/Path;", "fileName", "", "content", "", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cacheDir", "name", "checkFileNameHasProperRegister", "", "file", "expectedName", "readBytes", "T", "block", "Lkotlin/Function1;", "Ljava/io/DataInputStream;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeBytes", "Ljava/io/DataOutputStream;", "intellij.cidr.util"})
@SourceDebugExtension(value={"SMAP\nCidrZipCacheUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrZipCacheUtil.kt\ncom/jetbrains/cidr/zipcache/CidrZipCacheUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class CidrZipCacheUtil {
    @NotNull
    public static final CidrZipCacheUtil INSTANCE = new CidrZipCacheUtil();

    private CidrZipCacheUtil() {
    }

    @RequiresBackgroundThread
    public final void refreshVfsForCacheRootSynchronously(@NotNull CidrWritableZipBackedCache<?, ?, ?> $this$refreshVfsForCacheRootSynchronously, @Nullable Function0<Unit> onCompletion) {
        Intrinsics.checkNotNullParameter($this$refreshVfsForCacheRootSynchronously, (String)"<this>");
        VirtualFile virtualFile = $this$refreshVfsForCacheRootSynchronously.getWritableCacheRoot();
        if (virtualFile == null) {
            return;
        }
        VirtualFile cacheRoot = virtualFile;
        long startTime = System.currentTimeMillis();
        Semaphore semaphore = new Semaphore(1);
        VirtualFile[] virtualFileArray = new VirtualFile[]{cacheRoot};
        RefreshQueue.getInstance().refresh(false, true, () -> CidrZipCacheUtil.refreshVfsForCacheRootSynchronously$lambda$1(onCompletion, semaphore), virtualFileArray);
        if (onCompletion != null) {
            semaphore.waitFor();
        }
        long duration = System.currentTimeMillis() - startTime;
        CidrZipBackedCache.Companion.getLOG().info("VFS refresh after " + $this$refreshVfsForCacheRootSynchronously.getClass().getName() + " took " + StringUtil.formatDuration((long)duration));
    }

    public static /* synthetic */ void refreshVfsForCacheRootSynchronously$default(CidrZipCacheUtil cidrZipCacheUtil, CidrWritableZipBackedCache cidrWritableZipBackedCache, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        cidrZipCacheUtil.refreshVfsForCacheRootSynchronously(cidrWritableZipBackedCache, (Function0<Unit>)function0);
    }

    @RequiresBackgroundThread
    public final void refreshAllFilesInCacheRootSynchronously(@NotNull CidrWritableZipBackedCache<?, ?, ?> $this$refreshAllFilesInCacheRootSynchronously) {
        Intrinsics.checkNotNullParameter($this$refreshAllFilesInCacheRootSynchronously, (String)"<this>");
        VirtualFile virtualFile = $this$refreshAllFilesInCacheRootSynchronously.getWritableCacheRoot();
        if (virtualFile == null) {
            return;
        }
        VirtualFile cacheRoot = virtualFile;
        VirtualFile[] virtualFileArray = new VirtualFile[]{cacheRoot};
        VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        CidrZipCacheUtil.refreshVfsForCacheRootSynchronously$default(this, $this$refreshAllFilesInCacheRootSynchronously, null, 1, null);
    }

    public final void writeToFile(@NotNull Path dir, @NotNull String fileName, @NotNull CharSequence content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path path = dir.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PathKt.write$default((Path)path, (CharSequence)content, null, (boolean)false, (int)6, null);
    }

    @Nullable
    public final VirtualFile findFile(@NotNull VirtualFile cacheDir, @NotNull String name) {
        VirtualFile cached;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        VirtualFile virtualFile2 = cacheDir.findChild(name);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile it = virtualFile = (cached = virtualFile2);
        boolean bl = false;
        return INSTANCE.checkFileNameHasProperRegister(cached, name) ? virtualFile : null;
    }

    private final boolean checkFileNameHasProperRegister(VirtualFile file, String expectedName) {
        return Intrinsics.areEqual((Object)expectedName, (Object)file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readBytes(@NotNull Path $this$readBytes, @NotNull Function1<? super DataInputStream, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$readBytes = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$readBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = new DataInputStream(inputStream);
        Throwable throwable = null;
        try {
            object = block.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBytes(@NotNull Path $this$writeBytes, @NotNull Function1<? super DataOutputStream, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$writeBytes = false;
        Closeable closeable = new DataOutputStream(PathKt.outputStream$default((Path)$this$writeBytes, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null));
        Throwable throwable = null;
        try {
            Object object = block.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshVfsForCacheRootSynchronously$lambda$1$lambda$0(Function0 $onCompletion, Semaphore $semaphore) {
        try {
            $onCompletion.invoke();
        }
        finally {
            $semaphore.up();
        }
    }

    private static final void refreshVfsForCacheRootSynchronously$lambda$1(Function0 $onCompletion, Semaphore $semaphore) {
        if ($onCompletion != null) {
            ApplicationKt.getApplication().executeOnPooledThread(() -> CidrZipCacheUtil.refreshVfsForCacheRootSynchronously$lambda$1$lambda$0($onCompletion, $semaphore));
        }
    }
}

