/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.zipcache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.jetbrains.cidr.lang.util.TeamCityLogApi;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import com.jetbrains.cidr.zipcache.CidrZipCache;
import com.jetbrains.cidr.zipcache.InitializationHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 E*\u0006\b\u0000\u0010\u0001 \u0000*\u0006\b\u0001\u0010\u0002 \u0001*\u0006\b\u0002\u0010\u0003 \u00002\u00020\u0004:\u0002DEB\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0010H\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\u0017\u0010%\u001a\u0004\u0018\u00018\u00012\u0006\u0010&\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u0017\u0010(\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u0004\u0018\u00018\u00012\u0006\u0010+\u001a\u00020\u00102\u0006\u0010&\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\u00020\u001e*\u00020\u001eH\u0004J\u000e\u0010.\u001a\u00020/H\u0097@\u00a2\u0006\u0002\u00100J\u0016\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0012H\u00a4@\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010:\u001a\u00020/2\u0006\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=H\u0007J\u0010\u0010>\u001a\u00020/2\u0006\u0010<\u001a\u00020=H\u0007J\b\u0010?\u001a\u00020/H\u0005J\u0010\u0010@\u001a\u00020/2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010A\u001a\u00020/2\u000e\b\u0002\u0010B\u001a\b\u0012\u0004\u0012\u00020/0CH\u0004R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0014\u00101\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006F"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache;", "Key", "Value", "CachingValue", "Lcom/jetbrains/cidr/zipcache/CidrZipCache;", "zipFileName", "", "zipCacheVersion", "", "<init>", "(Ljava/lang/String;I)V", "getZipFileName", "()Ljava/lang/String;", "getZipCacheVersion", "()I", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isZipCacheDisabledInTests", "", "initializationHandler", "Lcom/jetbrains/cidr/zipcache/InitializationHandler;", "getInitializationHandler", "()Lcom/jetbrains/cidr/zipcache/InitializationHandler;", "zipCacheRoot", "getZipCacheRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "checkZipIsAcceptable", "zipVirtualFile", "getResourceFolders", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "resourcesFolder", "getResourcesFolder", "()Ljava/nio/file/Path;", "downloadedFolder", "getDownloadedFolder", "needsToDownloadCache", "getValue", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getRelativePath", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "readValue", "dir", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)Ljava/lang/Object;", "withVersion", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isInitialized", "()Z", "additionalInitialization", "isFirstInitialization", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "installNewZip", "zip", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "defaultZipLocations", "setZipCacheRootInTests", "path", "disposableParent", "Lcom/intellij/openapi/Disposable;", "disableZipCacheRootInTests", "assertBackgroundThreadForTestMethods", "revertToInitialStateOnDisposal", "revertToInitialState", "additionalAction", "Lkotlin/Function0;", "InitializationSession", "Companion", "intellij.cidr.util"})
@SourceDebugExtension(value={"SMAP\nCidrZipBackedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache\n+ 2 InitializationHandler.kt\ncom/jetbrains/cidr/zipcache/InitializationHandler\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n22#2,19:189\n54#2:208\n75#2:209\n89#2:210\n55#2,12:211\n67#2:224\n41#2:225\n40#2:226\n54#2:227\n75#2:228\n89#2:229\n55#2,12:230\n67#2:243\n41#2:244\n19#3:223\n19#3:242\n14#4:245\n*S KotlinDebug\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache\n*L\n75#1:189,19\n75#1:208\n75#1:209\n75#1:210\n75#1:211,12\n75#1:224\n75#1:225\n92#1:226\n92#1:227\n92#1:228\n92#1:229\n92#1:230,12\n92#1:243\n92#1:244\n75#1:223\n92#1:242\n186#1:245\n*E\n"})
public abstract class CidrZipBackedCache<Key, Value, CachingValue>
implements CidrZipCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String zipFileName;
    private final int zipCacheVersion;
    @Nullable
    private volatile VirtualFile root;
    private volatile boolean isZipCacheDisabledInTests;
    @NotNull
    private final InitializationHandler initializationHandler;
    @NotNull
    public static final String AUTOMATICALLY_DOWNLOAD_KEY = "com.jetbrains.cidr.ZipCacheDownloader.shouldDownload";
    @JvmField
    public static volatile boolean buildingCache;
    @NotNull
    private static final Logger LOG;

    public CidrZipBackedCache(@Nullable String zipFileName, int zipCacheVersion) {
        this.zipFileName = zipFileName;
        this.zipCacheVersion = zipCacheVersion;
        this.initializationHandler = new InitializationHandler((Disposable)this);
    }

    @Override
    @Nullable
    public String getZipFileName() {
        return this.zipFileName;
    }

    @Override
    public int getZipCacheVersion() {
        return this.zipCacheVersion;
    }

    @NotNull
    protected final InitializationHandler getInitializationHandler() {
        return this.initializationHandler;
    }

    @Override
    @Nullable
    public VirtualFile getZipCacheRoot() {
        return this.root;
    }

    protected boolean checkZipIsAcceptable(@NotNull VirtualFile zipVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)zipVirtualFile, (String)"zipVirtualFile");
        return true;
    }

    private final Sequence<Path> getResourceFolders() {
        Sequence sequence;
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (bl) {
            Object[] objectArray = new Path[]{Path.of(TeamCityLogApi.Companion.getInstance().getTempDirectory(), new String[0]).resolve("zipCaches"), this.getResourcesFolder()};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (!bl) {
            Object[] objectArray = new Path[]{this.getResourcesFolder()};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sequence;
    }

    @NotNull
    public final Path getResourcesFolder() {
        Path path = Path.of(PathManager.getHomePath(), new String[0]).resolve("Resources");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    @NotNull
    public Path getDownloadedFolder() {
        Path path = PathManager.getSystemDir().resolve("DownloadedCaches");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.withVersion(path);
    }

    @Override
    public boolean needsToDownloadCache() {
        return !this.isZipCacheDisabledInTests && this.root == null && this.getZipFileName() != null;
    }

    @Nullable
    public Value getValue(Key key) {
        if (!this.isInitialized()) {
            LOG.error("using not initialized cache " + this);
        }
        VirtualFile virtualFile = this.root;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        Path path = this.getRelativePath(key);
        if (path == null) {
            return null;
        }
        Path path2 = path;
        VirtualFile virtualFile2 = root.findFileByRelativePath(((Object)path2).toString());
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile cacheDir = virtualFile2;
        return this.readValue(cacheDir, key);
    }

    @Nullable
    protected abstract Path getRelativePath(Key var1);

    @Nullable
    protected abstract Value readValue(@NotNull VirtualFile var1, Key var2);

    @NotNull
    protected final Path withVersion(@NotNull Path $this$withVersion) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$withVersion, (String)"<this>");
        if (this.getZipCacheVersion() == 1) {
            path = $this$withVersion;
        } else {
            Path path2 = $this$withVersion.resolve(String.valueOf(this.getZipCacheVersion()));
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        }
        return path;
    }

    @Override
    @RequiresReadLockAbsence
    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        return CidrZipBackedCache.initialize$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @RequiresReadLockAbsence
    static /* synthetic */ <Key, Value, CachingValue> Object initialize$suspendImpl(CidrZipBackedCache<? super Key, ? extends Value, ? super CachingValue> var0, Continuation<? super Unit> $completion) {
        block16: {
            block17: {
                block18: {
                    block15: {
                        if (!($completion instanceof initialize.1)) ** GOTO lbl-1000
                        var15_2 = $completion;
                        if ((var15_2.label & -2147483648) != 0) {
                            var15_2.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(var0, $completion){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                /* synthetic */ Object result;
                                final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return CidrZipBackedCache.initialize$suspendImpl(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                                }
                            };
                        }
                        $result = $continuation.result;
                        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this_$iv = $this.initializationHandler;
                                $i$f$initialize = false;
                                state$iv = this_$iv.getInitializationState().get();
                                if (!Intrinsics.areEqual((Object)state$iv, (Object)InitializationHandler.State.Broken.INSTANCE) && !Intrinsics.areEqual((Object)state$iv, (Object)InitializationHandler.State.Initialized.INSTANCE)) {
                                    if (!(state$iv instanceof InitializationHandler.State.Initializing)) break;
                                    $continuation.label = 1;
                                    v0 = ((InitializationHandler.State.Initializing)state$iv).getJob().join($continuation);
                                    if (v0 == var16_4) {
                                        return var16_4;
                                    }
                                }
                                break block16;
                            }
                            case 1: {
                                $i$f$initialize = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                break block16;
                            }
                        }
                        if (Intrinsics.areEqual((Object)state$iv, (Object)InitializationHandler.State.NotInitialized.INSTANCE)) {
                            this_$iv$iv = this_$iv;
                            $i$f$doInitializationSafely = false;
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$doInitializationSafely = false;
                            this_$iv$iv$iv$iv = this_$iv$iv$iv;
                            $i$f$createLazyInitializationJob = false;
                            initializationJob$iv$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv$iv$iv$iv, null, $this){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ InitializationHandler this$0$inline_fun;
                                final /* synthetic */ CidrZipBackedCache this$0;
                                {
                                    this.this$0$inline_fun = $receiver;
                                    this.this$0 = cidrZipBackedCache;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $completion) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$completion);
                                            $this$launch = (CoroutineScope)this.L$0;
                                            (Continuation)this;
                                            $i$a$-initialize-CidrZipBackedCache$initialize$2 = false;
                                            v0 = this.this$0.getZipFileName();
                                            if (v0 == null) ** GOTO lbl19
                                            zipFileName = v0;
                                            $i$a$-let-CidrZipBackedCache$initialize$2$defaultLocations$1 = false;
                                            v1 = CidrZipBackedCache.access$defaultZipLocations(this.this$0, zipFileName);
                                            v0 = v1;
                                            if (v1 != null) ** GOTO lbl20
lbl19:
                                            // 2 sources

                                            v0 = SequencesKt.emptySequence();
lbl20:
                                            // 2 sources

                                            defaultLocations = v0;
                                            this.label = 1;
                                            v2 = new InitializationSession(this.this$0, (Sequence)defaultLocations, false, 2, null).run((Continuation<? super Boolean>)this);
                                            ** if (v2 != var2_2) goto lbl25
lbl24:
                                            // 1 sources

                                            return var2_2;
lbl25:
                                            // 1 sources

                                            ** GOTO lbl33
                                        }
                                        case 1: {
                                            $i$a$-initialize-CidrZipBackedCache$initialize$2 = false;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v2 = $result;
lbl33:
                                                // 2 sources

                                                var9_11 = result = ((Boolean)v2).booleanValue();
                                                var10_12 = this.this$0$inline_fun.getInitializationState();
                                                $i$a$-doInitializationSafely-InitializationHandler$doInitializationSafely$2 = false;
                                                var10_12.set(result != false ? (InitializationHandler.State)InitializationHandler.State.Initialized.INSTANCE : (InitializationHandler.State)InitializationHandler.State.Broken.INSTANCE);
                                            }
                                            catch (Throwable e) {
                                                this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                                if (e instanceof ControlFlowException) {
                                                    throw e;
                                                }
                                                CidrZipBackedCache.Companion.getLOG().error(e);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null);
                            initializingState$iv$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv$iv);
lbl38:
                            // 4 sources

                            while (true) {
                                if (!this_$iv$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv$iv) && !this_$iv$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv$iv) && !this_$iv$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv$iv)) break block15;
                                $continuation.L$0 = null;
                                $continuation.L$1 = null;
                                $continuation.L$2 = null;
                                $continuation.label = 2;
                                v1 = initializationJob$iv$iv$iv.join($continuation);
                                if (v1 == var16_4) {
                                    return var16_4;
                                }
                                break block16;
                                break;
                            }
                        }
                        break block17;
                        {
                            case 2: {
                                $i$f$initialize = false;
                                $i$f$doInitializationSafely = false;
                                $i$f$doInitializationSafely = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break block16;
                            }
                        }
                    }
                    $this$asSafely$iv$iv$iv$iv = this_$iv$iv$iv.getInitializationState().get();
                    $i$f$asSafely = false;
                    v2 = $this$asSafely$iv$iv$iv$iv;
                    if (!(v2 instanceof InitializationHandler.State.Initializing)) {
                        v2 = null;
                    }
                    v3 = (InitializationHandler.State.Initializing)v2;
                    v4 = currentInitializationJob$iv$iv$iv = v3 != null ? v3.getJob() : null;
                    if (v4 == null) break block18;
                    $continuation.L$0 = this_$iv$iv$iv;
                    $continuation.L$1 = initializingState$iv$iv$iv;
                    $continuation.L$2 = initializationJob$iv$iv$iv;
                    $continuation.label = 3;
                    v5 = v4.join($continuation);
                    if (v5 == var16_4) {
                        return var16_4;
                    }
                    ** GOTO lbl38
                    {
                        case 3: {
                            $i$f$initialize = false;
                            $i$f$doInitializationSafely = false;
                            $i$f$doInitializationSafely = false;
                            initializationJob$iv$iv$iv = (Job)$continuation.L$2;
                            initializingState$iv$iv$iv = (InitializationHandler.State.Initializing)$continuation.L$1;
                            this_$iv$iv$iv = (InitializationHandler)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
                            ** GOTO lbl38
                        }
                    }
                }
                ** while (true)
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean isInitialized() {
        return this.initializationHandler.isInitialized();
    }

    @Nullable
    protected abstract Object additionalInitialization(boolean var1, @NotNull Continuation<? super Boolean> var2);

    @Override
    @Nullable
    public Object installNewZip(@NotNull Path zip, @NotNull Continuation<? super Unit> $completion) {
        return CidrZipBackedCache.installNewZip$suspendImpl(this, zip, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ <Key, Value, CachingValue> Object installNewZip$suspendImpl(CidrZipBackedCache<? super Key, ? extends Value, ? super CachingValue> var0, Path var1_1, Continuation<? super Unit> $completion) {
        block12: {
            block13: {
                if (!($completion instanceof installNewZip.1)) ** GOTO lbl-1000
                var13_3 = $completion;
                if ((var13_3.label & -2147483648) != 0) {
                    var13_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var0, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return CidrZipBackedCache.installNewZip$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if ($this.getZipFileName() == null) {
                            CidrZipBackedCache.LOG.error("trying to install a zip for " + $this + " which cannot have a zip");
                            return Unit.INSTANCE;
                        }
                        this_$iv = $this.initializationHandler;
                        $i$f$doInitializationSafely = false;
                        this_$iv$iv = this_$iv;
                        $i$f$doInitializationSafely = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$createLazyInitializationJob = false;
                        initializationJob$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv$iv$iv, null, $this, (Path)zip){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ InitializationHandler this$0$inline_fun;
                            final /* synthetic */ CidrZipBackedCache this$0;
                            final /* synthetic */ Path $zip$inlined;
                            {
                                this.this$0$inline_fun = $receiver;
                                this.this$0 = cidrZipBackedCache;
                                this.$zip$inlined = path;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $completion) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$completion);
                                        $this$launch = (CoroutineScope)this.L$0;
                                        (Continuation)this;
                                        $i$a$-doInitializationSafely-CidrZipBackedCache$installNewZip$2 = false;
                                        var5_6 = new Path[]{this.$zip$inlined};
                                        this.label = 1;
                                        v0 = new InitializationSession(this.this$0, (Sequence<? extends Path>)SequencesKt.sequenceOf((Object[])var5_6), false).run((Continuation<? super Boolean>)this);
                                        ** if (v0 != var2_2) goto lbl16
lbl15:
                                        // 1 sources

                                        return var2_2;
lbl16:
                                        // 1 sources

                                        ** GOTO lbl24
                                    }
                                    case 1: {
                                        $i$a$-doInitializationSafely-CidrZipBackedCache$installNewZip$2 = false;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl24:
                                            // 2 sources

                                            var7_9 = result = ((Boolean)v0).booleanValue();
                                            var8_10 = this.this$0$inline_fun.getInitializationState();
                                            $i$a$-doInitializationSafely-InitializationHandler$doInitializationSafely$2 = false;
                                            var8_10.set(result != false ? (InitializationHandler.State)InitializationHandler.State.Initialized.INSTANCE : (InitializationHandler.State)InitializationHandler.State.Broken.INSTANCE);
                                        }
                                        catch (Throwable e) {
                                            this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                            if (e instanceof ControlFlowException) {
                                                throw e;
                                            }
                                            CidrZipBackedCache.Companion.getLOG().error(e);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        initializingState$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv);
lbl25:
                        // 4 sources

                        while (true) {
                            if (!this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv)) break block0;
                            $continuation.L$0 = null;
                            $continuation.L$1 = null;
                            $continuation.L$2 = null;
                            $continuation.label = 1;
                            v0 = initializationJob$iv$iv.join($continuation);
                            if (v0 == var14_5) {
                                return var14_5;
                            }
                            break block12;
                            break;
                        }
                    }
                    case 1: {
                        $i$f$doInitializationSafely = false;
                        $i$f$doInitializationSafely = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        break block12;
                    }
                }
                $this$asSafely$iv$iv$iv = this_$iv$iv.getInitializationState().get();
                $i$f$asSafely = false;
                v1 = $this$asSafely$iv$iv$iv;
                if (!(v1 instanceof InitializationHandler.State.Initializing)) {
                    v1 = null;
                }
                v2 = (InitializationHandler.State.Initializing)v1;
                v3 = currentInitializationJob$iv$iv = v2 != null ? v2.getJob() : null;
                if (v3 == null) break block13;
                $continuation.L$0 = this_$iv$iv;
                $continuation.L$1 = initializingState$iv$iv;
                $continuation.L$2 = initializationJob$iv$iv;
                $continuation.label = 2;
                v4 = v3.join($continuation);
                if (v4 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl25
                {
                    case 2: {
                        $i$f$doInitializationSafely = false;
                        $i$f$doInitializationSafely = false;
                        initializationJob$iv$iv = (Job)$continuation.L$2;
                        initializingState$iv$iv = (InitializationHandler.State.Initializing)$continuation.L$1;
                        this_$iv$iv = (InitializationHandler)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        ** GOTO lbl25
                    }
                }
            }
            ** while (true)
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Sequence<Path> defaultZipLocations(String zipFileName) {
        Object[] objectArray = new Path[]{this.getDownloadedFolder()};
        return SequencesKt.map((Sequence)SequencesKt.plus(this.getResourceFolders(), (Sequence)SequencesKt.sequenceOf((Object[])objectArray)), arg_0 -> CidrZipBackedCache.defaultZipLocations$lambda$3(zipFileName, arg_0));
    }

    @TestOnly
    public final void setZipCacheRootInTests(@NotNull Path path, @NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        this.revertToInitialStateOnDisposal(disposableParent);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, path, null){
            int label;
            final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
            final /* synthetic */ Path $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.installNewZip(this.$path, (Continuation<Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @TestOnly
    @RequiresBackgroundThread
    public final void disableZipCacheRootInTests(@NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        this.assertBackgroundThreadForTestMethods();
        this.revertToInitialStateOnDisposal(disposableParent);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block11: {
                    block12: {
                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = this.this$0.initialize((Continuation<Unit>)((Continuation)this));
                                if (v0 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                var2_3 = this.this$0.getInitializationHandler();
                                var3_4 = this.this$0;
                                $i$f$doInitializationSafely = false;
                                this_$iv$iv = this_$iv;
                                $i$f$doInitializationSafely = false;
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$createLazyInitializationJob = false;
                                initializationJob$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv$iv$iv, null, var3_4){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ InitializationHandler this$0$inline_fun;
                                    final /* synthetic */ CidrZipBackedCache this$0;
                                    {
                                        this.this$0$inline_fun = $receiver;
                                        this.this$0 = cidrZipBackedCache;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $completion) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$completion);
                                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                try {
                                                    void result2;
                                                    boolean result3;
                                                    Continuation cfr_ignored_0 = (Continuation)this;
                                                    boolean bl = false;
                                                    CidrZipBackedCache.access$setRoot$p(this.this$0, null);
                                                    CidrZipBackedCache.access$setZipCacheDisabledInTests$p(this.this$0, true);
                                                    boolean bl2 = result3 = true;
                                                    AtomicReference<InitializationHandler.State> atomicReference = this.this$0$inline_fun.getInitializationState();
                                                    boolean bl3 = false;
                                                    atomicReference.set(result2 != false ? (InitializationHandler.State)InitializationHandler.State.Initialized.INSTANCE : (InitializationHandler.State)InitializationHandler.State.Broken.INSTANCE);
                                                }
                                                catch (Throwable e) {
                                                    this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                                    if (e instanceof ControlFlowException) {
                                                        throw e;
                                                    }
                                                    CidrZipBackedCache.Companion.getLOG().error(e);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)1, null);
                                initializingState$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv);
lbl24:
                                // 4 sources

                                while (true) {
                                    if (!this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv) && !this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv)) break block0;
                                    this.L$0 = null;
                                    this.L$1 = null;
                                    this.L$2 = null;
                                    this.label = 2;
                                    v1 = initializationJob$iv$iv.join((Continuation)this);
                                    if (v1 == var12_2) {
                                        return var12_2;
                                    }
                                    break block11;
                                    break;
                                }
                            }
                            case 2: {
                                $i$f$doInitializationSafely = false;
                                $i$f$doInitializationSafely = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break block11;
                            }
                        }
                        $this$asSafely$iv$iv$iv = this_$iv$iv.getInitializationState().get();
                        $i$f$asSafely = false;
                        v2 = $this$asSafely$iv$iv$iv;
                        if (!(v2 instanceof InitializationHandler.State.Initializing)) {
                            v2 = null;
                        }
                        v3 = (InitializationHandler.State.Initializing)v2;
                        v4 = currentInitializationJob$iv$iv = v3 != null ? v3.getJob() : null;
                        if (v4 == null) break block12;
                        this.L$0 = this_$iv$iv;
                        this.L$1 = initializingState$iv$iv;
                        this.L$2 = initializationJob$iv$iv;
                        this.label = 3;
                        v5 = v4.join((Continuation)this);
                        if (v5 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl24
                        {
                            case 3: {
                                $i$f$doInitializationSafely = false;
                                $i$f$doInitializationSafely = false;
                                initializationJob$iv$iv = (Job)this.L$2;
                                initializingState$iv$iv = (InitializationHandler.State.Initializing)this.L$1;
                                this_$iv$iv = (InitializationHandler)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                                ** GOTO lbl24
                            }
                        }
                    }
                    ** while (true)
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @TestOnly
    protected final void assertBackgroundThreadForTestMethods() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
    }

    private final void revertToInitialStateOnDisposal(Disposable disposableParent) {
        Disposer.register((Disposable)disposableParent, () -> CidrZipBackedCache.revertToInitialStateOnDisposal$lambda$4(this));
    }

    protected final void revertToInitialState(@NotNull Function0<Unit> additionalAction) {
        Intrinsics.checkNotNullParameter(additionalAction, (String)"additionalAction");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, additionalAction, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
            final /* synthetic */ Function0<Unit> $additionalAction;
            {
                this.this$0 = $receiver;
                this.$additionalAction = $additionalAction;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object object) {
                Object object2;
                Object object3;
                InitializationHandler.State.Initializing initializingState$iv$iv;
                Job initializationJob$iv$iv;
                InitializationHandler this_$iv$iv;
                Object object4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void this_$iv;
                        ResultKt.throwOnFailure((Object)object);
                        InitializationHandler initializationHandler = this.this$0.getInitializationHandler();
                        CidrZipBackedCache<Key, Value, CachingValue> cidrZipBackedCache = this.this$0;
                        Function0<Unit> function0 = this.$additionalAction;
                        boolean $i$f$revertToInitialState = false;
                        this_$iv$iv = this_$iv;
                        boolean $i$f$doInitializationSafely = false;
                        InitializationHandler this_$iv$iv$iv = this_$iv$iv;
                        boolean $i$f$createLazyInitializationJob = false;
                        initializationJob$iv$iv = BuildersKt.launch$default((CoroutineScope)this_$iv$iv$iv.getCoroutineScope(), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv$iv$iv, null, cidrZipBackedCache, function0){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ InitializationHandler this$0$inline_fun;
                            final /* synthetic */ CidrZipBackedCache this$0;
                            final /* synthetic */ Function0 $additionalAction$inlined;
                            {
                                this.this$0$inline_fun = $receiver;
                                this.this$0 = cidrZipBackedCache;
                                this.$additionalAction$inlined = function0;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $completion) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$completion);
                                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                        try {
                                            Continuation cfr_ignored_0 = (Continuation)this;
                                            boolean bl = false;
                                            CidrZipBackedCache.access$setZipCacheDisabledInTests$p(this.this$0, false);
                                            this.$additionalAction$inlined.invoke();
                                            boolean result2 = true;
                                            AtomicReference<InitializationHandler.State> atomicReference = this.this$0$inline_fun.getInitializationState();
                                            boolean bl2 = false;
                                            atomicReference.set(InitializationHandler.State.NotInitialized.INSTANCE);
                                        }
                                        catch (Throwable e) {
                                            this.this$0$inline_fun.getInitializationState().set(InitializationHandler.State.Broken.INSTANCE);
                                            if (e instanceof ControlFlowException) {
                                                throw e;
                                            }
                                            CidrZipBackedCache.Companion.getLOG().error(e);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        initializingState$iv$iv = new InitializationHandler.State.Initializing(initializationJob$iv$iv);
                        break;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$revertToInitialState = false;
                        boolean $i$f$doInitializationSafely = false;
                        ResultKt.throwOnFailure((Object)$result);
                        object3 = $result;
                        return Unit.INSTANCE;
                    }
                    case 2: {
                        void $result;
                        boolean $i$f$revertToInitialState = false;
                        boolean $i$f$doInitializationSafely = false;
                        initializationJob$iv$iv = (Job)this.L$2;
                        initializingState$iv$iv = (InitializationHandler.State.Initializing)this.L$1;
                        this_$iv$iv = (InitializationHandler)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (true) {
                    Job currentInitializationJob$iv$iv;
                    if (this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.NotInitialized.INSTANCE, initializingState$iv$iv) || this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Initialized.INSTANCE, initializingState$iv$iv) || this_$iv$iv.getInitializationState().compareAndSet(InitializationHandler.State.Broken.INSTANCE, initializingState$iv$iv)) {
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 1;
                        Object object5 = initializationJob$iv$iv.join((Continuation)this);
                        object3 = object5;
                        if (object5 != object4) return Unit.INSTANCE;
                        return object4;
                    }
                    InitializationHandler.State $this$asSafely$iv$iv$iv = this_$iv$iv.getInitializationState().get();
                    boolean $i$f$asSafely = false;
                    InitializationHandler.State state = $this$asSafely$iv$iv$iv;
                    if (!(state instanceof InitializationHandler.State.Initializing)) {
                        state = null;
                    }
                    InitializationHandler.State.Initializing initializing = (InitializationHandler.State.Initializing)state;
                    Job job2 = currentInitializationJob$iv$iv = initializing != null ? initializing.getJob() : null;
                    if (job2 == null) continue;
                    this.L$0 = this_$iv$iv;
                    this.L$1 = initializingState$iv$iv;
                    this.L$2 = initializationJob$iv$iv;
                    this.label = 2;
                    object2 = job2.join((Continuation)this);
                    if (object2 == object4) break;
                }
                return object4;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void revertToInitialState$default(CidrZipBackedCache cidrZipBackedCache, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: revertToInitialState");
        }
        if ((n & 1) != 0) {
            function0 = CidrZipBackedCache::revertToInitialState$lambda$5;
        }
        cidrZipBackedCache.revertToInitialState((Function0<Unit>)function0);
    }

    private static final Path defaultZipLocations$lambda$3(String $zipFileName, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.resolve($zipFileName);
    }

    private static final void revertToInitialStateOnDisposal$lambda$4(CidrZipBackedCache this$0) {
        CidrZipBackedCache.revertToInitialState$default(this$0, null, 1, null);
    }

    private static final Unit revertToInitialState$lambda$5() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setZipCacheDisabledInTests$p(CidrZipBackedCache $this, boolean bl) {
        $this.isZipCacheDisabledInTests = bl;
    }

    public static final /* synthetic */ Sequence access$defaultZipLocations(CidrZipBackedCache $this, String zipFileName) {
        return $this.defaultZipLocations(zipFileName);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CidrZipBackedCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache$Companion;", "", "<init>", "()V", "AUTOMATICALLY_DOWNLOAD_KEY", "", "buildingCache", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cidr.util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0003R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache$InitializationSession;", "", "possibleZipLocations", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "isFirstInitialization", "", "<init>", "(Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache;Lkotlin/sequences/Sequence;Z)V", "getPossibleZipLocations", "()Lkotlin/sequences/Sequence;", "()Z", "run", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeZip", "Lcom/intellij/openapi/vfs/VirtualFile;", "getZipVirtualFile", "zip", "intellij.cidr.util"})
    @SourceDebugExtension(value={"SMAP\nCidrZipBackedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache$InitializationSession\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n183#2,2:189\n1#3:191\n*S KotlinDebug\n*F\n+ 1 CidrZipBackedCache.kt\ncom/jetbrains/cidr/zipcache/CidrZipBackedCache$InitializationSession\n*L\n112#1:189,2\n*E\n"})
    private final class InitializationSession {
        @NotNull
        private final Sequence<Path> possibleZipLocations;
        private final boolean isFirstInitialization;
        final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;

        public InitializationSession(@NotNull CidrZipBackedCache this$0, Sequence<? extends Path> possibleZipLocations, boolean isFirstInitialization) {
            Intrinsics.checkNotNullParameter(possibleZipLocations, (String)"possibleZipLocations");
            this.this$0 = this$0;
            this.possibleZipLocations = possibleZipLocations;
            this.isFirstInitialization = isFirstInitialization;
        }

        public /* synthetic */ InitializationSession(CidrZipBackedCache cidrZipBackedCache, Sequence sequence, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(cidrZipBackedCache, (Sequence<? extends Path>)sequence, bl);
        }

        @NotNull
        public final Sequence<Path> getPossibleZipLocations() {
            return this.possibleZipLocations;
        }

        public final boolean isFirstInitialization() {
            return this.isFirstInitialization;
        }

        @Nullable
        public final Object run(@NotNull Continuation<? super Boolean> $completion) {
            Companion.getLOG().assertTrue(!this.this$0.isZipCacheDisabledInTests, (Object)"should never happen");
            this.this$0.root = this.initializeZip();
            return this.this$0.additionalInitialization(this.isFirstInitialization, $completion);
        }

        private final VirtualFile initializeZip() {
            Object object;
            Object v1;
            block4: {
                Sequence<Path> $this$firstOrNull$iv = this.possibleZipLocations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Path path = v1;
            if (path == null) {
                return null;
            }
            Path zip = path;
            VirtualFile virtualFile = this.getZipVirtualFile(zip);
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile;
                CidrZipBackedCache cidrZipBackedCache = this.this$0;
                VirtualFile it = virtualFile2;
                boolean bl = false;
                object = cidrZipBackedCache.checkZipIsAcceptable(it) ? virtualFile2 : null;
            } else {
                object = null;
            }
            return object;
        }

        @RequiresReadLockAbsence
        private final VirtualFile getZipVirtualFile(Path zip) {
            VirtualFile virtualFile = VfsUtil.findFile((Path)zip, (boolean)true);
            if (virtualFile == null) {
                InitializationSession initializationSession = this;
                CidrZipBackedCache cidrZipBackedCache = this.this$0;
                InitializationSession $this$getZipVirtualFile_u24lambda_u242 = initializationSession;
                boolean bl = false;
                Companion.getLOG().error("Failed to get virtual file of " + cidrZipBackedCache.getZipFileName());
                return null;
            }
            VirtualFile zipVF = virtualFile;
            VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(zipVF);
            if (virtualFile2 == null) {
                InitializationSession initializationSession = this;
                CidrZipBackedCache cidrZipBackedCache = this.this$0;
                InitializationSession $this$getZipVirtualFile_u24lambda_u243 = initializationSession;
                boolean bl = false;
                Companion.getLOG().error("Failed to get jar root for " + cidrZipBackedCache.getZipFileName());
                return null;
            }
            VirtualFile cacheRoot = virtualFile2;
            Companion.getLOG().info(this.this$0.getClass().getSimpleName() + " uses zip cache " + cacheRoot.getCanonicalPath());
            return cacheRoot;
        }
    }
}

