/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.util.InitializationWaiterKt;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H$J&\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H$J\b\u0010\u0015\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010\u0017\u001a\u00020\u0004H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\t\u0010\u0019\u001a\u00020\u0004H\u0096\u0001J\t\u0010\u001a\u001a\u00020\u0011H\u0096\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/util/InitializationWaiter;", "Lcom/intellij/openapi/util/CheckedDisposable;", "block", "Lkotlin/Function0;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "wasRun", "Ljava/util/concurrent/atomic/AtomicBoolean;", "waitForInitialization", "disposable", "Lcom/intellij/openapi/Disposable;", "isInitialized", "", "subscribeToInitialization", "parentDisposable", "callBack", "runIfInitialized", "runOnce", "executeOutsideEDT", "runIfProjectIsNotDisposed", "dispose", "isDisposed", "intellij.cidr.util"})
public abstract class InitializationWaiter
implements CheckedDisposable {
    private final /* synthetic */ CheckedDisposable $$delegate_0;
    @NotNull
    private final Function0<Unit> block;
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean wasRun;

    public InitializationWaiter(@NotNull Function0<Unit> block, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.$$delegate_0 = Disposer.newCheckedDisposable();
        this.block = block;
        this.project = project;
        this.wasRun = new AtomicBoolean(false);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public final void waitForInitialization(@NotNull Disposable disposable) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Disposer.register((Disposable)disposable, (Disposable)((Disposable)this));
            try {
                this.subscribeToInitialization(this.project, (Disposable)this, (Function0<Unit>)((Function0)() -> InitializationWaiter.waitForInitialization$lambda$0(this)));
            }
            catch (IncorrectOperationException ex) {
                if (!this.isDisposed()) {
                    throw ex;
                }
            }
            catch (NullPointerException ex) {
                if (this.isDisposed()) break block4;
                throw ex;
            }
        }
        this.runIfInitialized();
    }

    protected abstract boolean isInitialized();

    protected abstract void subscribeToInitialization(@NotNull Project var1, @NotNull Disposable var2, @NotNull Function0<Unit> var3);

    private final void runIfInitialized() {
        if (this.isInitialized()) {
            this.runOnce();
        }
    }

    private final void runOnce() {
        if (this.wasRun.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)((Disposable)this));
            this.executeOutsideEDT();
        } else {
            InitializationWaiterKt.access$getLog$p().info("Skipping running " + this + " because it was already run");
        }
    }

    private final void executeOutsideEDT() {
        Application application = ApplicationKt.getApplication();
        if (application.isDispatchThread() && !application.isUnitTestMode()) {
            Future future = application.executeOnPooledThread(() -> InitializationWaiter.executeOutsideEDT$lambda$1(this));
            Intrinsics.checkNotNull((Object)future);
        } else {
            this.runIfProjectIsNotDisposed();
        }
    }

    private final void runIfProjectIsNotDisposed() {
        if (!this.project.isDisposed()) {
            this.block.invoke();
        } else {
            InitializationWaiterKt.access$getLog$p().info("Skipping running " + this + " because project is disposed");
        }
    }

    public boolean isDisposed() {
        return this.$$delegate_0.isDisposed();
    }

    public void dispose() {
        this.$$delegate_0.dispose();
    }

    private static final Unit waitForInitialization$lambda$0(InitializationWaiter this$0) {
        this$0.runIfInitialized();
        return Unit.INSTANCE;
    }

    private static final void executeOutsideEDT$lambda$1(InitializationWaiter this$0) {
        this$0.runIfProjectIsNotDisposed();
    }
}

