/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleSourceDependency;
import com.intellij.platform.workspace.jps.entities.ModuleTypeId;
import com.intellij.platform.workspace.storage.DummyParentEntitySource;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocationUtilKt;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.PathTreeBase;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.project.CidrClasspathStorageProvider;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.project.workspace.CidrKnownModuleDetector;
import com.jetbrains.cidr.project.workspace.CidrOwnModuleDetector;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.OCEntitySource;
import com.jetbrains.cidr.project.workspace.OCImportedModuleEntitySource;
import com.jetbrains.cidr.project.workspace.OCRootTree;
import com.jetbrains.cidr.project.workspace.OCRootsBuilder;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizerListener;
import com.jetbrains.cidr.project.workspace.OCWorkspaceModelRootsBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 =2\u00020\u0001:\u0003;<=B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0007J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\nJ\u001a\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0007J\u0016\u0010#\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%H\u0007J$\u0010#\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0%H\u0003J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\rH\u0007J\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*2\u0006\u0010-\u001a\u00020.J\u0014\u0010/\u001a\u00020\u00172\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0002J\u0010\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\r2\b\u00106\u001a\u0004\u0018\u000107J\u0010\u00108\u001a\u00020\r2\b\u00103\u001a\u0004\u0018\u000104J\b\u00109\u001a\u0004\u0018\u000104J\b\u0010:\u001a\u000204H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f0\u0010\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject$intellij_cidr_workspaceModel", "()Lcom/intellij/openapi/project/Project;", "myActiveRoots", "", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "Lcom/jetbrains/cidr/project/workspace/OCRootTree;", "myUpdateContentRootsRecursionProtection", "", "myRootUrls", "", "", "myRefusedRootUrls", "", "myStorageId", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "installLegacyClasspathStorage", "", "id", "startListening", "shutdown", "dispose", "updateRoots", "workspace", "contentRoot", "Ljava/io/File;", "updateRootsWithInfo", "rootsInfo", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "batchUpdateRoots", "workspaces", "", "rootsInfos", "applyRoots", "enableRootConfiguration", "findModuleOrCreateNew", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "registerRoots", "builder", "Lcom/jetbrains/cidr/project/workspace/OCRootsBuilder;", "setCurrentCidrStorage", "module", "Lcom/intellij/openapi/module/Module;", "isFromCidrModule", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCidrModule", "getModuleIfExists", "getModuleOrCreateNew", "RootsInfo", "TreeVisitor", "Companion", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nOCRootsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCRootsSynchronizer.kt\ncom/jetbrains/cidr/project/workspace/OCRootsSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,705:1\n1#2:706\n12734#3,3:707\n3829#3:710\n4344#3,2:711\n*S KotlinDebug\n*F\n+ 1 OCRootsSynchronizer.kt\ncom/jetbrains/cidr/project/workspace/OCRootsSynchronizer\n*L\n376#1:707,3\n396#1:710\n396#1:711,2\n*E\n"})
public final class OCRootsSynchronizer
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<CidrWorkspace, OCRootTree> myActiveRoots;
    private boolean myUpdateContentRootsRecursionProtection;
    @NotNull
    private final Collection<String> myRootUrls;
    @NotNull
    private final Collection<String> myRefusedRootUrls;
    @NotNull
    private volatile String myStorageId;
    @NotNull
    private static final Logger LOG;
    private static boolean onlyWarnOnRootInTests;

    public OCRootsSynchronizer(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myActiveRoots = new HashMap();
        this.myStorageId = "CIDR";
        List rootUrls = new ArrayList(2);
        String systemDrive = System.getenv("SystemDrive");
        if (SystemInfo.isWindows && systemDrive != null) {
            rootUrls.add(VfsUtilCore.pathToUrl((String)(systemDrive + "\\")));
        }
        rootUrls.add(VfsUtilCore.pathToUrl((String)"/"));
        this.myRootUrls = List.copyOf(rootUrls);
        this.myRefusedRootUrls = new ArrayList(((List)this.myRootUrls).size());
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Sequence entitiesWithDummyEntitySource = event.getStorageAfter().entitiesBySource(1::changed$lambda$0);
                if (SequencesKt.none((Sequence)entitiesWithDummyEntitySource)) {
                    return;
                }
                RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> 1.changed$lambda$1(this));
            }

            private static final boolean changed$lambda$0(EntitySource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof DummyParentEntitySource;
            }

            private static final Unit changed$lambda$1(OCRootsSynchronizer this$0) {
                this$0.applyRoots(false);
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final Project getMyProject$intellij_cidr_workspaceModel() {
        return this.myProject;
    }

    @Deprecated(message="Only for providing forward compatibility to pre-2020.1")
    public final void installLegacyClasspathStorage(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.myStorageId = OCRootsSynchronizer.Companion.shouldMigrateToModernCidrStorage() ? "CIDR" : id;
    }

    public final void startListening() {
    }

    public final void shutdown() {
    }

    public void dispose() {
        this.shutdown();
    }

    public final void updateRoots(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        this.updateRoots(workspace, null);
    }

    @RequiresWriteLock
    public final void updateRoots(@NotNull CidrWorkspace workspace, @Nullable File contentRoot) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        ThreadingAssertions.assertWriteAccess();
        if (this.myProject.isDefault()) {
            return;
        }
        long before = System.currentTimeMillis();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> OCRootsSynchronizer.updateRoots$lambda$0(workspace, contentRoot, this));
        ((OCRootsSynchronizerListener)this.myProject.getMessageBus().syncPublisher(OCRootsSynchronizerListener.TOPIC)).afterRootsUpdated(workspace);
        LOG.debug("Updating roots took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)));
    }

    @TestOnly
    @RequiresWriteLock
    public final void updateRootsWithInfo(@NotNull CidrWorkspace workspace, @NotNull RootsInfo rootsInfo) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)rootsInfo, (String)"rootsInfo");
        ThreadingAssertions.assertWriteAccess();
        if (this.myProject.isDefault()) {
            return;
        }
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> OCRootsSynchronizer.updateRootsWithInfo$lambda$1(this, workspace, rootsInfo));
    }

    @RequiresWriteLock
    public final void batchUpdateRoots(@NotNull List<? extends CidrWorkspace> workspaces) {
        Intrinsics.checkNotNullParameter(workspaces, (String)"workspaces");
        ThreadingAssertions.assertWriteAccess();
        if (this.myProject.isDefault()) {
            return;
        }
        long before = System.currentTimeMillis();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> OCRootsSynchronizer.batchUpdateRoots$lambda$2(workspaces, this));
        LOG.debug("Updating roots in batch took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresWriteLock
    private final synchronized void batchUpdateRoots(List<? extends CidrWorkspace> workspaces, List<RootsInfo> rootsInfos) {
        boolean bl;
        boolean bl2 = bl = workspaces.size() == rootsInfos.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.myUpdateContentRootsRecursionProtection) {
            return;
        }
        this.myUpdateContentRootsRecursionProtection = true;
        try {
            this.setCurrentCidrStorage(this.getModuleOrCreateNew());
            CidrRootConfiguration rootsConfiguration = null;
            Iterator<RootsInfo> rootsInfoIterator = rootsInfos.iterator();
            for (CidrWorkspace cidrWorkspace : workspaces) {
                RootsInfo rootsInfo = rootsInfoIterator.next();
                if (cidrWorkspace.shouldEnableRootConfiguration()) {
                    if (rootsConfiguration == null) {
                        rootsConfiguration = CidrRootConfiguration.Companion.getInstance(this.myProject);
                    }
                    rootsInfo.explicitSourceFolders.addAll(rootsConfiguration.getSourceRoots());
                    rootsInfo.explicitLibraryRoots.addAll(rootsConfiguration.getLibraryRoots());
                    rootsInfo.explicitExcludeFolders.addAll(rootsConfiguration.getExcludeRoots());
                }
                this.myActiveRoots.put(cidrWorkspace, OCRootsSynchronizer.Companion.prepareRootsTree(rootsInfo));
            }
            this.applyRoots(rootsConfiguration != null);
            rootsInfoIterator = rootsInfos.iterator();
            for (CidrWorkspace cidrWorkspace : workspaces) {
                cidrWorkspace.afterUpdateContentRoots(rootsInfoIterator.next());
            }
        }
        finally {
            this.myUpdateContentRootsRecursionProtection = false;
        }
    }

    @RequiresWriteLock
    public final void applyRoots(boolean enableRootConfiguration) {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.myProject);
        OCRootsBuilder<?> rootsBuilder = OCRootsBuilder.Provider.findRootsBuilder(this.myProject);
        if (rootsBuilder == null) {
            LOG.error("Cannot find implementation of OCRootsBuilder. Please register OCRootsBuilder");
            return;
        }
        if (!(rootsBuilder instanceof OCWorkspaceModelRootsBuilder)) {
            LOG.error("Fix me: Only OCWorkspaceModelRootsBuilder is currently supported. Actual rootsBuilder is " + rootsBuilder.getClass().getName());
            return;
        }
        ModuleBridge module = ((OCWorkspaceModelRootsBuilder)rootsBuilder).getModule();
        ModuleEntity moduleEntity = ((OCWorkspaceModelRootsBuilder)rootsBuilder).getModuleEntity();
        MutableEntityStorage builder = ((OCWorkspaceModelRootsBuilder)rootsBuilder).getBuilder();
        this.registerRoots(rootsBuilder);
        workspaceModel.updateProjectModel("CIDR: apply roots", arg_0 -> OCRootsSynchronizer.applyRoots$lambda$4(builder, moduleEntity, arg_0));
        if (enableRootConfiguration) {
            CidrRootConfiguration.Companion.setEnabledFor(this.getModuleOrCreateNew(), true);
        }
        for (Facet f : FacetManager.getInstance((Module)((Module)module)).getAllFacets()) {
            f.initFacet();
        }
    }

    @NotNull
    public final Pair<ModuleBridge, ModuleEntity> findModuleOrCreateNew(@NotNull WorkspaceModel workspaceModel) {
        Intrinsics.checkNotNullParameter((Object)workspaceModel, (String)"workspaceModel");
        Module module = this.getModuleOrCreateNew();
        Intrinsics.checkNotNull((Object)module, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge");
        ModuleBridge module2 = (ModuleBridge)module;
        WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = workspaceModel.getCurrentSnapshot().resolve((SymbolicEntityId)module2.getModuleEntityId());
        Intrinsics.checkNotNull((Object)workspaceEntityWithSymbolicId);
        ModuleEntity moduleEntity = (ModuleEntity)workspaceEntityWithSymbolicId;
        return new Pair((Object)module2, (Object)moduleEntity);
    }

    private final void registerRoots(OCRootsBuilder<?> builder) {
        OCRootTree tree;
        OCRootTree oCRootTree = tree = (OCRootTree)PathTreeBase.merge(this.myActiveRoots.values(), (boolean)true);
        if (oCRootTree != null) {
            oCRootTree.accept(new TreeVisitor(builder, null));
        }
        builder.apply();
    }

    private final void setCurrentCidrStorage(Module module) {
        String string = ClassPathStorageUtil.getStorageType((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStorageType(...)");
        String storageType = string;
        if (Intrinsics.areEqual((Object)"default", (Object)storageType) || Intrinsics.areEqual((Object)"CIDR", (Object)storageType)) {
            OCRootsSynchronizer.Companion.setStorage(module, this.myStorageId);
        }
    }

    public final boolean isFromCidrModule(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        return this.isCidrModule(ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.myProject));
    }

    public final boolean isCidrModule(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        if (CidrOwnModuleDetector.Companion.isOwnModule(module)) {
            return true;
        }
        return module == this.getModuleIfExists();
    }

    @Nullable
    public final Module getModuleIfExists() {
        Module module;
        int n;
        Object v0;
        ModuleEntity it;
        Sequence sequence;
        Sequence moduleEntities;
        block14: {
            sequence = moduleEntities = WorkspaceModel.Companion.getInstance(this.myProject).getCurrentSnapshot().entities(ModuleEntity.class);
            for (Object e : sequence) {
                it = (ModuleEntity)e;
                boolean bl = false;
                if (!(it.getEntitySource() instanceof OCEntitySource)) continue;
                v0 = e;
                break block14;
            }
            v0 = null;
        }
        ModuleEntity moduleEntity = v0;
        if (moduleEntity == null) {
            Object v1;
            block15: {
                sequence = moduleEntities;
                for (Object e : sequence) {
                    it = (ModuleEntity)e;
                    n = 0;
                    if (!(it.getEntitySource() instanceof JpsProjectFileEntitySource.FileInDirectory && it.getType() == null)) continue;
                    v1 = e;
                    break block15;
                }
                v1 = null;
            }
            moduleEntity = v1;
        }
        if (moduleEntity != null && (module = ModuleManager.Companion.getInstance(this.myProject).findModuleByName(moduleEntity.getName())) != null) {
            return module;
        }
        Module foundModule = null;
        Module fallbackModule = null;
        boolean foundFallbackCandidate = false;
        Module[] modules = ModuleManager.Companion.getInstance(this.myProject).getModules();
        n = modules.length;
        for (int it2 = 0; it2 < n; ++it2) {
            String storageType;
            Module module2 = modules[it2];
            if (CidrKnownModuleDetector.Companion.isKnownModule(module2)) continue;
            if (foundFallbackCandidate) {
                fallbackModule = null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ClassPathStorageUtil.getStorageType((Module)module2), (String)"getStorageType(...)");
            boolean isModernCidrStorage = Intrinsics.areEqual((Object)"CIDR", (Object)storageType);
            if (!isModernCidrStorage && !(ClasspathStorage.getProvider((String)storageType) instanceof CidrClasspathStorageProvider)) {
                String moduleTypeName = module2.getModuleTypeName();
                if (foundFallbackCandidate || !Intrinsics.areEqual((Object)ModuleTypeManager.getInstance().getDefaultModuleType().getId(), (Object)moduleTypeName) && moduleTypeName != null) continue;
                foundFallbackCandidate = true;
                fallbackModule = module2;
                continue;
            }
            if (foundModule != null) {
                LOG.warn(OCRootsSynchronizer.class.getSimpleName() + " doesn't currently support multi-module projects.\nThe first available module '" + foundModule.getName() + "' will be used.");
                break;
            }
            if (!isModernCidrStorage && OCRootsSynchronizer.Companion.shouldMigrateToModernCidrStorage()) {
                OCRootsSynchronizer.Companion.migrateToModernCidrStorage(module2);
            }
            foundModule = module2;
        }
        if (!ApplicationKt.getApplication().isUnitTestMode() && ApplicationKt.getApplication().isInternal() && PluginUtils.hasCLion() && modules.length > 1) {
            Module[] $this$count$iv = modules;
            boolean $i$f$count = false;
            int count$iv = 0;
            int n2 = $this$count$iv.length;
            for (int i = 0; i < n2; ++i) {
                Module element$iv;
                Module it3 = element$iv = $this$count$iv[i];
                boolean bl = false;
                if (!(!CidrKnownModuleDetector.Companion.isKnownModule(it3))) continue;
                ++count$iv;
            }
            if (count$iv > 1) {
                Module module3 = foundModule;
                String foundModuleName = module3 != null ? module3.getName() : null;
                Module module4 = fallbackModule;
                String fallbackModuleName = module4 != null ? module4.getName() : null;
                LOG.error(OCRootsSynchronizer.class.getSimpleName() + " doesn't currently support multi-module projects.\n        The first available module '" + foundModuleName + "' will be used. Also fallbackModule is " + fallbackModuleName);
            }
        }
        if (foundModule != null || fallbackModule == null) {
            return foundModule;
        }
        if (OCRootsSynchronizer.Companion.shouldMigrateToModernCidrStorage()) {
            OCRootsSynchronizer.Companion.migrateToModernCidrStorage(fallbackModule);
        }
        return fallbackModule;
    }

    /*
     * WARNING - void declaration
     */
    private final Module getModuleOrCreateNew() {
        Module module = this.getModuleIfExists();
        if (module == null) {
            if (!ApplicationKt.getApplication().isUnitTestMode() && ApplicationKt.getApplication().isInternal() && PluginUtils.hasCLion()) {
                void $this$filterTo$iv$iv;
                Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this.myProject).getModules();
                boolean $i$f$filter = false;
                Module[] moduleArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!(!CidrKnownModuleDetector.Companion.isKnownModule((Module)it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List modules = (List)destination$iv$iv;
                if (!((Collection)modules).isEmpty()) {
                    ImmutableEntityStorage storage = WorkspaceModel.Companion.getInstance(this.myProject).getCurrentSnapshot();
                    String modulesString = CollectionsKt.joinToString$default((Iterable)modules, null, null, null, (int)0, null, OCRootsSynchronizer::getModuleOrCreateNew$lambda$9, (int)31, null);
                    String moduleEntities = SequencesKt.joinToString$default((Sequence)storage.entities(ModuleEntity.class), null, null, null, (int)0, null, OCRootsSynchronizer::getModuleOrCreateNew$lambda$10, (int)31, null);
                    String errorMessage = StringsKt.trimMargin$default((String)("CLion doesn't support multi-module projects. \n            |Current modules: " + modulesString + "\n            |Module entities: " + moduleEntities), null, (int)1, null);
                    LOG.error(errorMessage);
                }
            }
            String string = UniqueNameGenerator.generateUniqueName((String)this.myProject.getName(), arg_0 -> OCRootsSynchronizer.getModuleOrCreateNew$lambda$12(arg_0 -> OCRootsSynchronizer.getModuleOrCreateNew$lambda$11(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
            String moduleName = string;
            WorkspaceModel.Companion.getInstance(this.myProject).updateProjectModel("CIDR: create module entity", arg_0 -> OCRootsSynchronizer.getModuleOrCreateNew$lambda$14(this, moduleName, arg_0));
            Module module2 = this.getModuleIfExists();
            if (module2 == null) {
                boolean bl = false;
                String string2 = "Cannot find module to synchronize roots, modules = " + ModuleManager.Companion.getInstance(this.myProject).getModules();
                throw new IllegalStateException(string2.toString());
            }
            module = module2;
            ClasspathStorage.setStorageType((ModuleRootModel)((ModuleRootModel)ModuleRootManager.getInstance((Module)module)), (String)"CIDR");
        }
        return module;
    }

    private static final void updateRoots$lambda$0(CidrWorkspace $workspace, File $contentRoot, OCRootsSynchronizer this$0) {
        File file = $contentRoot;
        if (file == null) {
            file = $workspace.getContentRoot();
        }
        File actualContentRoot = $workspace.beforeUpdateContentRoots(file);
        RootsInfo rootsInfo = $workspace.collectRootsInfo(actualContentRoot);
        Intrinsics.checkNotNullExpressionValue((Object)rootsInfo, (String)"collectRootsInfo(...)");
        RootsInfo rootsInfo2 = rootsInfo;
        this$0.batchUpdateRoots(CollectionsKt.listOf((Object)$workspace), CollectionsKt.listOf((Object)rootsInfo2));
    }

    private static final void updateRootsWithInfo$lambda$1(OCRootsSynchronizer this$0, CidrWorkspace $workspace, RootsInfo $rootsInfo) {
        this$0.batchUpdateRoots(CollectionsKt.listOf((Object)$workspace), CollectionsKt.listOf((Object)$rootsInfo));
    }

    private static final void batchUpdateRoots$lambda$2(List $workspaces, OCRootsSynchronizer this$0) {
        List rootsInfos = new ArrayList($workspaces.size());
        for (CidrWorkspace workspace : $workspaces) {
            File contentRoot = workspace.beforeUpdateContentRoots(workspace.getContentRoot());
            RootsInfo rootsInfo = workspace.collectRootsInfo(contentRoot);
            Intrinsics.checkNotNullExpressionValue((Object)rootsInfo, (String)"collectRootsInfo(...)");
            rootsInfos.add(rootsInfo);
        }
        this$0.batchUpdateRoots($workspaces, rootsInfos);
    }

    private static final boolean applyRoots$lambda$4$lambda$3(ModuleEntity $moduleEntity, EntitySource entitySource) {
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        return OCRootsSynchronizer.Companion.isSupportedSource(entitySource, $moduleEntity);
    }

    private static final Unit applyRoots$lambda$4(MutableEntityStorage $builder, ModuleEntity $moduleEntity, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Registry.Companion.is("cidr.workspace.use.applyChangesFrom")) {
            it.applyChangesFrom($builder);
        } else {
            it.replaceBySource(arg_0 -> OCRootsSynchronizer.applyRoots$lambda$4$lambda$3($moduleEntity, arg_0), (EntityStorage)$builder);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence getModuleOrCreateNew$lambda$9(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + " type=" + it.getModuleTypeName();
    }

    private static final CharSequence getModuleOrCreateNew$lambda$10(ModuleEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "name=" + it.getName() + " id=" + it.getSymbolicId() + " entitySource=" + it.getEntitySource();
    }

    private static final boolean getModuleOrCreateNew$lambda$11(OCRootsSynchronizer this$0, String it) {
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(this$0.myProject);
        Intrinsics.checkNotNull((Object)it);
        return moduleManager.findModuleByName(it) == null;
    }

    private static final boolean getModuleOrCreateNew$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit getModuleOrCreateNew$lambda$14$lambda$13(ModuleEntity.Builder $this$ModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ModuleEntity, (String)"$this$ModuleEntity");
        String string = ModuleTypeManager.getInstance().getDefaultModuleType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        $this$ModuleEntity.setType(new ModuleTypeId(string));
        return Unit.INSTANCE;
    }

    private static final Unit getModuleOrCreateNew$lambda$14(OCRootsSynchronizer this$0, String $moduleName, MutableEntityStorage it) {
        VirtualFileUrl virtualFileUrl;
        JpsProjectConfigLocation projectLocation;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation((Project)this$0.myProject);
        Intrinsics.checkNotNull((Object)jpsProjectConfigLocation);
        JpsProjectConfigLocation jpsProjectConfigLocation2 = projectLocation = jpsProjectConfigLocation;
        if (jpsProjectConfigLocation2 instanceof JpsProjectConfigLocation.DirectoryBased) {
            virtualFileUrl = ((JpsProjectConfigLocation.DirectoryBased)projectLocation).getProjectDir().append(".idea");
        } else if (jpsProjectConfigLocation2 instanceof JpsProjectConfigLocation.FileBased) {
            virtualFileUrl = ((JpsProjectConfigLocation.FileBased)projectLocation).getIprFileParent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        VirtualFileUrl imlFileDir = virtualFileUrl;
        Intrinsics.checkNotNull((Object)imlFileDir);
        OCImportedModuleEntitySource source = new OCImportedModuleEntitySource((JpsFileEntitySource)new JpsProjectFileEntitySource.FileInDirectory(imlFileDir, projectLocation));
        it.addEntity((WorkspaceEntity.Builder)ModuleEntity.Companion.create($moduleName, CollectionsKt.listOf((Object)ModuleSourceDependency.INSTANCE), (EntitySource)source, OCRootsSynchronizer::getModuleOrCreateNew$lambda$14$lambda$13));
        return Unit.INSTANCE;
    }

    @JvmStatic
    @TestOnly
    public static final void setOnlyWarnOnRootInTests(boolean onlyWarn) {
        Companion.setOnlyWarnOnRootInTests(onlyWarn);
    }

    @JvmStatic
    @NotNull
    public static final OCRootsSynchronizer getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final Set<File> collectFilesNotUnder(@Nullable Collection<? extends File> parents, @Nullable Collection<? extends File> files) {
        return Companion.collectFilesNotUnder(parents, files);
    }

    static {
        Logger logger = Logger.getInstance((String)("#" + OCRootsSynchronizer.class.getPackage().getName()));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J0\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0010\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$H\u0007J(\u0010&\u001a\u00020\b2\u0010\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$J$\u0010&\u001a\u00020\b2\u0010\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010$2\b\u0010'\u001a\u0004\u0018\u00010\"H\u0002J,\u0010&\u001a\u00020\b2\u0010\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010$2\b\u0010'\u001a\u0004\u0018\u00010\"2\u0006\u0010(\u001a\u00020\bH\u0002J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020+0$H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "onlyWarnOnRootInTests", "", "isSupportedSource", "entitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "setOnlyWarnOnRootInTests", "", "onlyWarn", "getInstance", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "shouldMigrateToModernCidrStorage", "migrateToModernCidrStorage", "module", "Lcom/intellij/openapi/module/Module;", "setStorage", "storageId", "", "prepareRootsTree", "Lcom/jetbrains/cidr/project/workspace/OCRootTree;", "info", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "collectFilesNotUnder", "", "Ljava/io/File;", "parents", "", "files", "isUnder", "file", "strict", "removeDuplicatesAndSubdirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.cidr.workspaceModel"})
    @SourceDebugExtension(value={"SMAP\nOCRootsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCRootsSynchronizer.kt\ncom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,705:1\n774#2:706\n865#2,2:707\n1734#2,3:709\n*S KotlinDebug\n*F\n+ 1 OCRootsSynchronizer.kt\ncom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$Companion\n*L\n664#1:706\n664#1:707,2\n668#1:709,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSupportedSource(EntitySource entitySource, ModuleEntity moduleEntity) {
            return entitySource instanceof JpsImportedEntitySource || entitySource instanceof JpsFileEntitySource || entitySource instanceof OCEntitySource || Intrinsics.areEqual((Object)entitySource, (Object)moduleEntity.getEntitySource());
        }

        @JvmStatic
        @TestOnly
        public final void setOnlyWarnOnRootInTests(boolean onlyWarn) {
            onlyWarnOnRootInTests = onlyWarn;
        }

        @JvmStatic
        @NotNull
        public final OCRootsSynchronizer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(OCRootsSynchronizer.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (OCRootsSynchronizer)object;
        }

        private final boolean shouldMigrateToModernCidrStorage() {
            return Registry.Companion.is("cidr.workspace.migrate.to.modern.storage", false);
        }

        private final void migrateToModernCidrStorage(Module module) {
            this.setStorage(module, "CIDR");
        }

        private final void setStorage(Module module, String storageId) {
            ClasspathStorage.setStorageType((ModuleRootModel)((ModuleRootModel)ModuleRootManager.getInstance((Module)module)), (String)storageId);
        }

        private final OCRootTree prepareRootsTree(RootsInfo info) {
            OCRootTree tree = new OCRootTree();
            tree.addAll((Collection<File>)info.contentRoots, OCRootTree.RootKind.CONTENT);
            if (info.registerSystemHeaderRootUnderContentRootAsLibraries) {
                tree.addAll((Collection<File>)info.contentRoots, OCRootTree.RootKind.ALLOW_LIBRARY_ROOT_IN_CONTENT);
            }
            tree.addAll((Collection<File>)info.sourceFiles, OCRootTree.RootKind.SOURCE);
            tree.addAll((Collection<File>)info.generatedSourceFiles, OCRootTree.RootKind.SOURCE_GENERATED);
            OCRootTree.RootKind[] rootKindArray = new OCRootTree.RootKind[]{OCRootTree.RootKind.EXCLUDE, OCRootTree.RootKind.WATCHED};
            tree.addAll((Collection<File>)info.additionalBuildDirs, rootKindArray);
            tree.addAll((Collection<File>)info.explicitLibraryRoots, OCRootTree.RootKind.EXPLICIT_LIBRARY);
            tree.addAll((Collection<File>)info.explicitSourceFolders, OCRootTree.RootKind.EXPLICIT_SOURCE);
            tree.addAll((Collection<File>)info.explicitExcludeFolders, OCRootTree.RootKind.EXPLICIT_EXCLUDE);
            tree.addAll((Collection<File>)info.watchRoots, OCRootTree.RootKind.WATCHED);
            long before = System.currentTimeMillis();
            Set userHeaderRoots = new HashSet();
            Set seenRoots = new HashSet();
            for (HeadersSearchRoot root : info.headersSearchRoots) {
                if (!seenRoots.add(root)) continue;
                root.processChildren(new HeadersSearchRootProcessor(tree, root, userHeaderRoots){
                    final /* synthetic */ OCRootTree $tree;
                    final /* synthetic */ HeadersSearchRoot $root;
                    final /* synthetic */ Set<VirtualFile> $userHeaderRoots;
                    {
                        this.$tree = $tree;
                        this.$root = $root;
                        this.$userHeaderRoots = $userHeaderRoots;
                    }

                    public boolean shouldProcessRootsOnly() {
                        return true;
                    }

                    public HeadersSearchRootProcessor.FrameworkResult processFramework(AppleFramework framework) {
                        Intrinsics.checkNotNullParameter((Object)((Object)framework), (String)"framework");
                        VirtualFile virtualFile = framework.getVirtualFile();
                        if (virtualFile != null) {
                            this.$tree.addItem(virtualFile.getUrl(), (Object)((Object)OCRootTree.RootKind.LIBRARY_EXCLUDE));
                        }
                        return HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
                    }

                    public boolean process(VirtualFile file) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (file.isDirectory()) {
                            switch (prepareRootsTree.WhenMappings.$EnumSwitchMapping$0[this.$root.getKind().ordinal()]) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.$tree.addItem(file.getUrl(), (Object)((Object)OCRootTree.RootKind.LIBRARY));
                                    break;
                                }
                                case 4: {
                                    this.$userHeaderRoots.add(file);
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            for (VirtualFile each : this.removeDuplicatesAndSubdirs(userHeaderRoots)) {
                tree.addItem(each.getUrl(), (Object)OCRootTree.RootKind.CONTENT);
            }
            LOG.debug("Roots collection took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)) + " for " + info.headersSearchRoots.size() + " roots");
            return tree;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Set<File> collectFilesNotUnder(@Nullable Collection<? extends File> parents, @Nullable Collection<? extends File> files) {
            void $this$filterTo$iv$iv;
            if (files == null) {
                return SetsKt.emptySet();
            }
            Iterable $this$filter$iv = files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!(!Companion.isUnder(parents, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isUnder(@Nullable Collection<? extends File> parents, @Nullable Collection<? extends File> files) {
            File it;
            if (files == null) return false;
            Iterable $this$all$iv = files;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (File)element$iv;
                boolean bl = false;
            } while (Companion.isUnder(parents, it));
            return false;
        }

        private final boolean isUnder(Collection<? extends File> parents, File file) {
            return this.isUnder(parents, file, false);
        }

        private final boolean isUnder(Collection<? extends File> parents, File file, boolean strict) {
            if (parents == null || file == null) {
                return false;
            }
            Iterator<? extends File> iterator = parents.iterator();
            while (iterator.hasNext()) {
                File parent;
                File file2 = parent = iterator.next();
                Intrinsics.checkNotNull((Object)file2);
                if (!FileUtil.isAncestor((File)file2, (File)file, (boolean)strict)) continue;
                return true;
            }
            return false;
        }

        private final List<VirtualFile> removeDuplicatesAndSubdirs(Collection<? extends VirtualFile> files) {
            List answer = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)files, (arg_0, arg_1) -> Companion.removeDuplicatesAndSubdirs$lambda$3(Companion::removeDuplicatesAndSubdirs$lambda$2, arg_0, arg_1)));
            Iterator it = answer.iterator();
            VirtualFile prev = null;
            while (it.hasNext()) {
                VirtualFile next = (VirtualFile)it.next();
                if (prev != null && VfsUtilCore.isAncestor((VirtualFile)prev, (VirtualFile)next, (boolean)false)) {
                    it.remove();
                    continue;
                }
                prev = next;
            }
            return answer;
        }

        private static final int removeDuplicatesAndSubdirs$lambda$2(VirtualFile file1, VirtualFile file2) {
            return FileUtil.comparePaths((String)file1.getPath(), (String)file2.getPath());
        }

        private static final int removeDuplicatesAndSubdirs$lambda$3(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "", "<init>", "()V", "watchRoots", "", "Ljava/io/File;", "contentRoots", "sourceFiles", "generatedSourceFiles", "additionalBuildDirs", "explicitSourceFolders", "explicitLibraryRoots", "explicitExcludeFolders", "headersSearchRoots", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "registerSystemHeaderRootUnderContentRootAsLibraries", "", "intellij.cidr.workspaceModel"})
    public static final class RootsInfo {
        @JvmField
        @NotNull
        public final List<File> watchRoots = new ArrayList();
        @JvmField
        @NotNull
        public final List<File> contentRoots = new ArrayList();
        @JvmField
        @NotNull
        public final List<File> sourceFiles = new ArrayList();
        @JvmField
        @NotNull
        public final List<File> generatedSourceFiles = new ArrayList();
        @JvmField
        @NotNull
        public final List<File> additionalBuildDirs = new ArrayList();
        @JvmField
        @NotNull
        public final List<File> explicitSourceFolders = new ArrayList();
        @JvmField
        @NotNull
        public final List<File> explicitLibraryRoots = new ArrayList();
        @JvmField
        @NotNull
        public final List<File> explicitExcludeFolders = new ArrayList();
        @JvmField
        @NotNull
        public final List<HeadersSearchRoot> headersSearchRoots = new ArrayList();
        @JvmField
        public boolean registerSystemHeaderRootUnderContentRootAsLibraries;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003B%\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J \u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0003J\b\u0010\u001b\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$TreeVisitor;", "TState", "Lcom/jetbrains/cidr/project/workspace/OCRootsBuilder$State;", "Lcom/jetbrains/cidr/PathTreeBase$Visitor;", "Lcom/jetbrains/cidr/project/workspace/OCRootTree;", "builder", "Lcom/jetbrains/cidr/project/workspace/OCRootsBuilder;", "watchedRoots", "", "", "<init>", "(Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer;Lcom/jetbrains/cidr/project/workspace/OCRootsBuilder;Ljava/util/Collection;)V", "stack", "Lcom/intellij/util/containers/Stack;", "state", "Lcom/jetbrains/cidr/project/workspace/OCRootsBuilder$State;", "enter", "", "visit", "", "path", "tree", "shouldSkip", "url", "kinds", "", "Lcom/jetbrains/cidr/project/workspace/OCRootTree$RootKind;", "exit", "intellij.cidr.workspaceModel"})
    @SourceDebugExtension(value={"SMAP\nOCRootsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCRootsSynchronizer.kt\ncom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$TreeVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,705:1\n1#2:706\n*E\n"})
    private final class TreeVisitor<TState extends OCRootsBuilder.State>
    implements PathTreeBase.Visitor<OCRootTree> {
        @NotNull
        private final OCRootsBuilder<TState> builder;
        @Nullable
        private final Collection<String> watchedRoots;
        @NotNull
        private final Stack<TState> stack;
        @Nullable
        private TState state;

        public TreeVisitor(@Nullable OCRootsBuilder<TState> builder, Collection<String> watchedRoots) {
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            this.builder = builder;
            this.watchedRoots = watchedRoots;
            this.stack = new Stack();
        }

        public void enter() {
            ProgressManager.checkCanceled();
            this.stack.push(this.state);
            TState TState = this.state;
            OCRootsBuilder.State state = TState != null ? TState.copy() : null;
            OCRootsBuilder.State state2 = state instanceof OCRootsBuilder.State ? state : null;
            if (state2 == null) {
                TState TState2 = this.builder.createEmptyState();
                state2 = TState2;
                Intrinsics.checkNotNullExpressionValue(TState2, (String)"createEmptyState(...)");
            }
            this.state = state2;
        }

        public boolean visit(@Nullable String path, @NotNull OCRootTree tree) {
            Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
            OCRootTree subTree = tree;
            LOG.assertTrue(this.state != null);
            TState TState = this.state;
            if (TState == null) {
                return true;
            }
            TState currentState = TState;
            subTree = this.builder.visitSubTree(path, subTree);
            Set set = subTree.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getItems(...)");
            Set items = set;
            if (items.isEmpty() || this.shouldSkip(path, items)) {
                return true;
            }
            String string = path;
            if (string == null) {
                return true;
            }
            String url = string;
            if (items.contains((Object)OCRootTree.RootKind.ALLOW_LIBRARY_ROOT_IN_CONTENT)) {
                currentState.setAllowLibraryRootInContent(true);
            }
            if (this.watchedRoots != null && items.contains((Object)OCRootTree.RootKind.WATCHED)) {
                String string2 = VfsUtilCore.urlToPath((String)url);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"urlToPath(...)");
                this.watchedRoots.add(string2);
            }
            if (items.contains((Object)OCRootTree.RootKind.EXPLICIT_EXCLUDE)) {
                if (currentState.isInContentRoot()) {
                    this.builder.addSourceExcludedRoot(currentState, url);
                }
                if (currentState.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(currentState, url);
                }
                return false;
            }
            boolean isContentRoot = items.contains((Object)OCRootTree.RootKind.CONTENT);
            if (isContentRoot && !currentState.isInContentRoot()) {
                this.builder.addContentRoot(currentState, url);
                if (currentState.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(currentState, url);
                }
            }
            if (items.contains((Object)OCRootTree.RootKind.EXPLICIT_SOURCE)) {
                this.builder.addSourceFolder(currentState, url, false);
                currentState.setExplicitRoot(true);
                return true;
            }
            if (items.contains((Object)OCRootTree.RootKind.EXPLICIT_LIBRARY)) {
                this.builder.addLibraryRoot(currentState, url);
                currentState.setExplicitRoot(true);
                return true;
            }
            if (currentState.isExplicitRoot()) {
                return true;
            }
            if (items.contains((Object)OCRootTree.RootKind.SOURCE_GENERATED)) {
                this.builder.addSourceFolder(currentState, url, true);
                return true;
            }
            if (items.contains((Object)OCRootTree.RootKind.SOURCE)) {
                this.builder.addSourceFolder(currentState, url, false);
                return true;
            }
            if (currentState.allowLibraryRoot()) {
                if (items.contains((Object)OCRootTree.RootKind.LIBRARY_EXCLUDE) && currentState.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(currentState, url);
                    return true;
                }
                if (!isContentRoot && items.contains((Object)OCRootTree.RootKind.LIBRARY)) {
                    this.builder.addLibraryRoot(currentState, url);
                    return true;
                }
            }
            if (items.contains((Object)OCRootTree.RootKind.EXCLUDE)) {
                if (currentState.isInContentRoot()) {
                    this.builder.addSourceExcludedRoot(currentState, url);
                }
                if (currentState.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(currentState, url);
                }
                return true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Contract(value="null,_->fail")
        private final boolean shouldSkip(String url, Collection<? extends OCRootTree.RootKind> kinds) {
            Object v1;
            Iterable iterable;
            block12: {
                if (!LOG.assertTrue(url != null, (Object)"Synthetic root should not be registered")) {
                    return true;
                }
                String string = url;
                if (string == null) {
                    return true;
                }
                String myUrl = string;
                iterable = CollectionsKt.filterNotNull((Iterable)OCRootsSynchronizer.this.myRootUrls);
                for (Object object : iterable) {
                    String it = (String)object;
                    boolean bl = false;
                    if (!FileUtil.startsWith((String)it, (String)myUrl)) continue;
                    v1 = object;
                    break block12;
                }
                v1 = null;
            }
            if (v1 == null) {
                return false;
            }
            String logMessage = "Refusing to register file system root " + url + " as " + kinds + " for indexing as this may lead to degraded performance.";
            if (!ApplicationKt.getApplication().isUnitTestMode()) {
                Object object;
                LOG.warn(logMessage);
                iterable = OCRootsSynchronizer.this.myRefusedRootUrls;
                Object[] objectArray = OCRootsSynchronizer.this;
                object = iterable;
                synchronized (object) {
                    block13: {
                        boolean bl = false;
                        if (!((OCRootsSynchronizer)objectArray).myRefusedRootUrls.contains(url)) break block13;
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl = ((OCRootsSynchronizer)objectArray).myRefusedRootUrls.add(url);
                }
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Project Roots");
                String string = CidrWorkspaceBundle.message("roots.synchronizer.ignoring.directory", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                objectArray = new Object[]{url};
                String string2 = CidrWorkspaceBundle.message("roots.synchronizer.ignoring.directory.description", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                notificationGroup.createNotification(string, string2, NotificationType.WARNING).notify(OCRootsSynchronizer.this.getMyProject$intellij_cidr_workspaceModel());
            } else if (onlyWarnOnRootInTests) {
                LOG.warn(logMessage);
            } else {
                LOG.error(logMessage);
            }
            return true;
        }

        public void exit() {
            this.state = (OCRootsBuilder.State)this.stack.pop();
        }
    }
}

