/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.treeStructure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.jetbrains.cidr.project.workspace.OCEntitySource;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/project/treeStructure/CidrLibraryPathNodeDecorator;", "Lcom/intellij/ide/projectView/ProjectViewNodeDecorator;", "<init>", "()V", "decorate", "", "node", "Lcom/intellij/ide/projectView/ProjectViewNode;", "data", "Lcom/intellij/ide/projectView/PresentationData;", "checkHeaderLibrary", "", "extractFrameworkName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.cidr.workspaceModel"})
final class CidrLibraryPathNodeDecorator
implements ProjectViewNodeDecorator {
    public void decorate(@NotNull ProjectViewNode<?> node, @NotNull PresentationData data) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(node instanceof PsiDirectoryNode)) {
            return;
        }
        if (!this.checkHeaderLibrary(node)) {
            return;
        }
        VirtualFile virtualFile = ((PsiDirectoryNode)node).getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        data.setLocationString(file.getPresentableUrl());
        String name = this.extractFrameworkName(file);
        if (name != null) {
            data.setPresentableText(name);
        }
    }

    private final boolean checkHeaderLibrary(ProjectViewNode<?> node) {
        Project project = node.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        AbstractTreeNode libraryNode = node.getParent();
        if (!(libraryNode instanceof NamedLibraryElementNode)) {
            return false;
        }
        LibraryOrSdkOrderEntry libraryOrSdkOrderEntry = ((NamedLibraryElement)((NamedLibraryElementNode)libraryNode).getValue()).getOrderEntry();
        if (libraryOrSdkOrderEntry == null) {
            return false;
        }
        LibraryOrSdkOrderEntry libraryEntry = libraryOrSdkOrderEntry;
        if (!(libraryEntry instanceof LibraryOrderEntry)) {
            return false;
        }
        Library library = ((LibraryOrderEntry)libraryEntry).getLibrary();
        if (library == null) {
            return false;
        }
        Library library2 = library;
        if (!(library2 instanceof LibraryBridge)) {
            return false;
        }
        LibraryEntity libraryEntity = ProjectLibraryTableBridgeImpl.Companion.findLibraryEntity((EntityStorage)WorkspaceModel.Companion.getInstance(project2).getCurrentSnapshot(), (LibraryBridge)library2);
        if (libraryEntity == null) {
            return false;
        }
        LibraryEntity libraryEntity2 = libraryEntity;
        return libraryEntity2.getEntitySource() instanceof OCEntitySource;
    }

    private final String extractFrameworkName(VirtualFile file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        boolean caseSensitive = file.isCaseSensitive();
        if (!StringsKt.equals((String)name, (String)"Headers", (boolean)caseSensitive) && !StringsKt.equals((String)name, (String)"Modules", (boolean)caseSensitive)) {
            return null;
        }
        StringBuilder frameworkName = new StringBuilder();
        List list = FileUtilRt.splitPath((String)file.getPath(), (char)'/');
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        for (String part : CollectionsKt.reversed((Iterable)list)) {
            if (!FileUtil.extensionEquals((String)part, (String)"framework")) continue;
            if (!StringsKt.isBlank((CharSequence)frameworkName)) {
                frameworkName.insert(0, "::");
            }
            frameworkName.insert(0, FileUtil.getNameWithoutExtension((String)part));
        }
        if (StringsKt.isBlank((CharSequence)frameworkName)) {
            return null;
        }
        return frameworkName + "::" + name;
    }
}

