/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerResolver;", "", "resolveOrNull", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "compilerExecutable", "Ljava/nio/file/Path;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "Companion", "intellij.cidr.projectModel"})
public interface OCCompilerResolver {
    @NotNull
    public static final Companion Companion = com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final Logger LOGGER;
    @JvmField
    @NotNull
    public static final ExtensionPointName<OCCompilerResolver> EP_NAME;

    @Nullable
    public OCCompilerKind resolveOrNull(@NotNull Path var1, @NotNull CidrToolEnvironment var2);

    @JvmStatic
    @NotNull
    public static OCCompilerKind resolve(@NotNull Project project, @NotNull Path compilerExecutable, @NotNull CidrToolEnvironment environment) {
        return Companion.resolve(project, compilerExecutable, environment);
    }

    static {
        Logger logger = Logger.getInstance(OCCompilerResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
        EP_NAME = ExtensionPointName.Companion.create("cidr.lang.compilerResolver");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0013\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerResolver$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerResolver;", "resolve", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "project", "Lcom/intellij/openapi/project/Project;", "compilerExecutable", "Ljava/nio/file/Path;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "intellij.cidr.projectModel"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OCCompilerKind resolve(@NotNull Project project, @NotNull Path compilerExecutable, @NotNull CidrToolEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)compilerExecutable, (String)"compilerExecutable");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            for (OCCompilerResolver compilerResolver : EP_NAME.getExtensionList((AreaInstance)project)) {
                OCCompilerKind compilerKind = compilerResolver.resolveOrNull(compilerExecutable, environment);
                if (!(!Intrinsics.areEqual((Object)compilerKind, (Object)UnknownCompilerKind.INSTANCE))) {
                    boolean bl = false;
                    String string = "Resolver " + compilerResolver + " returned " + UnknownCompilerKind.INSTANCE;
                    throw new IllegalStateException(string.toString());
                }
                OCCompilerKind oCCompilerKind = compilerKind;
                if (oCCompilerKind == null) continue;
                return oCCompilerKind;
            }
            return UnknownCompilerKind.INSTANCE;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

