/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.GCCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.OCBuiltInCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCBuiltInCompilerKindsKt;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerCommandLineShortener;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/ClangCompilerKind;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCBuiltInCompilerKind;", "<init>", "()V", "getDisplayName", "", "resolveLanguage", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "Lorg/jetbrains/annotations/Nullable;", "switches", "", "getSwitchBuilder", "Lcom/jetbrains/cidr/lang/workspace/compiler/ClangSwitchBuilder;", "cidrSwitchBuilder", "Lcom/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder;", "getCommandLineShortener", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerCommandLineShortener;", "getCompilerInstance", "Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler;", "project", "Lcom/intellij/openapi/project/Project;", "executable", "Ljava/io/File;", "workingDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "fixPchSwitches", "intellij.cidr.projectModel"})
public final class ClangCompilerKind
extends OCBuiltInCompilerKind {
    @NotNull
    public static final ClangCompilerKind INSTANCE = new ClangCompilerKind();

    private ClangCompilerKind() {
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Clang";
    }

    @Override
    @Nullable
    public OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        Intrinsics.checkNotNullParameter(switches, (String)"switches");
        return GCCCompiler.resolveLanguage(switches);
    }

    @Override
    @NotNull
    public ClangSwitchBuilder getSwitchBuilder(@NotNull CidrSwitchBuilder cidrSwitchBuilder) {
        Intrinsics.checkNotNullParameter((Object)cidrSwitchBuilder, (String)"cidrSwitchBuilder");
        return new ClangSwitchBuilder(cidrSwitchBuilder);
    }

    @Override
    @NotNull
    public OCCompilerCommandLineShortener getCommandLineShortener() {
        return new GCCResponseFileShortener();
    }

    @Override
    @NotNull
    public GCCCompiler getCompilerInstance(@NotNull Project project, @NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)tempFilesPool, (String)"tempFilesPool");
        return new GCCCompiler(executable, workingDirectory, environment, tempFilesPool);
    }

    @Override
    @NotNull
    public List<String> fixPchSwitches(@NotNull List<String> switches) {
        Intrinsics.checkNotNullParameter(switches, (String)"switches");
        return OCBuiltInCompilerKindsKt.access$fixClangPchSwitches(switches);
    }
}

