/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackersImpl;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myResolveConfigurationsTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "mySourceFilesTracker", "myCompilerSettingsTracker", "myClientVersionTracker", "mySelectedResolveConfigurationTracker", "getResolveConfigurationsTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getSourceFilesTracker", "getCompilerSettingsTracker", "getClientVersionTracker", "getSelectedResolveConfigurationTracker", "fireWorkspaceChanged", "", "event", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceListener$OCWorkspaceEvent;", "fireSelectedResolveConfigurationChanged", "fireWorkspaceInitializationFinished", "success", "", "intellij.cidr.projectModel"})
public final class OCWorkspaceModificationTrackersImpl
implements OCWorkspaceModificationTrackers {
    @NotNull
    private final Project project;
    @NotNull
    private final SimpleModificationTracker myResolveConfigurationsTracker;
    @NotNull
    private final SimpleModificationTracker mySourceFilesTracker;
    @NotNull
    private final SimpleModificationTracker myCompilerSettingsTracker;
    @NotNull
    private final SimpleModificationTracker myClientVersionTracker;
    @NotNull
    private final SimpleModificationTracker mySelectedResolveConfigurationTracker;

    public OCWorkspaceModificationTrackersImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myResolveConfigurationsTracker = new SimpleModificationTracker();
        this.mySourceFilesTracker = new SimpleModificationTracker();
        this.myCompilerSettingsTracker = new SimpleModificationTracker();
        this.myClientVersionTracker = new SimpleModificationTracker();
        this.mySelectedResolveConfigurationTracker = new SimpleModificationTracker();
    }

    @Override
    @NotNull
    public ModificationTracker getResolveConfigurationsTracker() {
        return (ModificationTracker)this.myResolveConfigurationsTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getSourceFilesTracker() {
        return (ModificationTracker)this.mySourceFilesTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getCompilerSettingsTracker() {
        return (ModificationTracker)this.myCompilerSettingsTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getClientVersionTracker() {
        return (ModificationTracker)this.myClientVersionTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getSelectedResolveConfigurationTracker() {
        return (ModificationTracker)this.mySelectedResolveConfigurationTracker;
    }

    public final void fireWorkspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.resolveConfigurationsChanged()) {
            this.myResolveConfigurationsTracker.incModificationCount();
        }
        if (event.sourceFilesChanged()) {
            this.mySourceFilesTracker.incModificationCount();
        }
        if (event.compilerSettingsChanged()) {
            this.myCompilerSettingsTracker.incModificationCount();
        }
        if (event.clientVersionChanged()) {
            this.myClientVersionTracker.incModificationCount();
        }
        MessageBus messageBus = this.project.getMessageBus();
        Topic<OCWorkspaceListener> topic = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((OCWorkspaceListener)messageBus.syncPublisher(topic)).workspaceChanged(event);
    }

    public final void fireSelectedResolveConfigurationChanged() {
        this.mySelectedResolveConfigurationTracker.incModificationCount();
        MessageBus messageBus = this.project.getMessageBus();
        Topic<OCWorkspaceListener> topic = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((OCWorkspaceListener)messageBus.syncPublisher(topic)).selectedResolveConfigurationChanged();
    }

    public final void fireWorkspaceInitializationFinished(boolean success) {
        MessageBus messageBus = this.project.getMessageBus();
        Topic<OCWorkspaceListener> topic = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((OCWorkspaceListener)messageBus.syncPublisher(topic)).workspaceInitializationFinished(success);
    }
}

