/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.workspace.CidrProjectActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInitializationWaiter;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceLoadingWaiter;
import com.jetbrains.cidr.lang.workspace.RunAfterOCWorkspaceIsInitialized;
import com.jetbrains.cidr.lang.workspace.RunAfterOCWorkspaceIsLoaded;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a \u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\f\u001a\u001e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00022\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u000e\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"runWhenOrIfOCWorkspaceIsInitialized", "", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "block", "Lkotlin/Function0;", "runWhenOrIfOCWorkspaceIsLoaded", "isOCWorkspaceInitialized", "", "isOCWorkspaceNotEmpty", "isNotEmpty", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace;", "INITIALIZED_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/cidr/lang/workspace/RunAfterOCWorkspaceIsInitialized;", "LOADED_EP_NAME", "Lcom/jetbrains/cidr/lang/workspace/RunAfterOCWorkspaceIsLoaded;", "runCidrActivities", "project", "epName", "Lcom/jetbrains/cidr/lang/workspace/CidrProjectActivity;", "intellij.cidr.projectModel"})
@JvmName(name="OCWorkspaceInitializationUtil")
public final class OCWorkspaceInitializationUtil {
    @NotNull
    private static final ExtensionPointName<RunAfterOCWorkspaceIsInitialized> INITIALIZED_EP_NAME = ExtensionPointName.Companion.create("cidr.projectModel.runAfterOCWorkspaceIsInitialized");
    @NotNull
    private static final ExtensionPointName<RunAfterOCWorkspaceIsLoaded> LOADED_EP_NAME = ExtensionPointName.Companion.create("cidr.projectModel.runAfterOCWorkspaceIsLoaded");

    public static final void runWhenOrIfOCWorkspaceIsInitialized(@NotNull Project $this$runWhenOrIfOCWorkspaceIsInitialized, @NotNull Disposable disposable, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenOrIfOCWorkspaceIsInitialized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        new OCWorkspaceInitializationWaiter(block, $this$runWhenOrIfOCWorkspaceIsInitialized).waitForInitialization(disposable);
    }

    public static final void runWhenOrIfOCWorkspaceIsLoaded(@NotNull Project $this$runWhenOrIfOCWorkspaceIsLoaded, @NotNull Disposable disposable, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenOrIfOCWorkspaceIsLoaded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        new OCWorkspaceLoadingWaiter(block, $this$runWhenOrIfOCWorkspaceIsLoaded).waitForInitialization(disposable);
    }

    public static final boolean isOCWorkspaceInitialized(@NotNull Project $this$isOCWorkspaceInitialized) {
        Intrinsics.checkNotNullParameter((Object)$this$isOCWorkspaceInitialized, (String)"<this>");
        return OCWorkspaceImpl.Companion.getInstanceImpl($this$isOCWorkspaceInitialized).getInitialized();
    }

    public static final boolean isOCWorkspaceNotEmpty(@NotNull Project $this$isOCWorkspaceNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isOCWorkspaceNotEmpty, (String)"<this>");
        OCWorkspace oCWorkspace = OCWorkspace.getInstance($this$isOCWorkspaceNotEmpty);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
        return OCWorkspaceInitializationUtil.isNotEmpty(oCWorkspace);
    }

    public static final boolean isNotEmpty(@NotNull OCWorkspace $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        List<OCResolveConfiguration> list = $this$isNotEmpty.getConfigurations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getConfigurations(...)");
        return !((Collection)list).isEmpty();
    }

    public static final void runCidrActivities(@NotNull Project project, @NotNull ExtensionPointName<? extends CidrProjectActivity> epName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(epName, (String)"epName");
        for (CidrProjectActivity activity : epName.getExtensionList()) {
            try {
                activity.runActivity(project);
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                OCWorkspaceImplUtilKt.getLOG().error(e);
            }
        }
    }

    public static final /* synthetic */ ExtensionPointName access$getINITIALIZED_EP_NAME$p() {
        return INITIALIZED_EP_NAME;
    }

    public static final /* synthetic */ ExtensionPointName access$getLOADED_EP_NAME$p() {
        return LOADED_EP_NAME;
    }
}

