/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.FastInput;
import com.esotericsoftware.kryo.io.FastOutput;
import com.esotericsoftware.kryo.io.Input;
import com.intellij.configurationStore.SettingsSavingComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.workspace.ClusterCalculator;
import com.jetbrains.cidr.lang.workspace.CompilerSettingsData;
import com.jetbrains.cidr.lang.workspace.ConfigurationData;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurationImpl;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceCacheInvalidator;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceDeserializingVetoCondition;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceEventImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceFilePointers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplSerializationKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInterner;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceSerializer;
import com.jetbrains.cidr.lang.workspace.SourceData;
import com.jetbrains.cidr.lang.workspace.StateHolder;
import com.jetbrains.cidr.lang.workspace.WorkspaceData;
import com.jetbrains.cidr.lang.workspace.WorkspaceStateHolder;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootFactory;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoots;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 R2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004OPQRB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u001eH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010(\u001a\u00020\u001eH\u0016J\u001c\u0010)\u001a\u00020*2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010+\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0019H\u0007J\u000e\u00101\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u00102J\u0018\u00107\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00103\u001a\u000204H\u0002J\u0010\u00108\u001a\u00020\u00192\u0006\u00103\u001a\u000204H\u0002J%\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u001c2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020=0<H\u0082\bJ\u0018\u0010>\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\u001cH\u0002J)\u0010@\u001a\u00020\u00192\n\u0010A\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010B\u001a\u00020C2\u0006\u0010:\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bFJ\u001f\u0010G\u001a\u00020\u00192\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010IH\u0000\u00a2\u0006\u0004\bK\u0010LJ\u0006\u0010M\u001a\u00020\u0019J\b\u0010N\u001a\u00020\u001cH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006S"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace;", "Lcom/intellij/configurationStore/SettingsSavingComponent;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initialized", "", "(Lcom/intellij/openapi/project/Project;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "getInitialized", "()Z", "state", "Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "serializer", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceSerializer;", "getSerializer", "()Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceSerializer;", "serializer$delegate", "Lkotlin/Lazy;", "setInitialized", "", "dispose", "getClientVersion", "", "clientKey", "", "Lcom/jetbrains/cidr/lang/workspace/Key;", "getConfigurations", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getConfigurationById", "id", "getConfigurationsForFile", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceFileUrl", "getModifiableModel", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "clear", "modificationTrackersImpl", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackersImpl;", "getModificationTrackers", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers;", "initComponent", "save", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stateFile", "Ljava/nio/file/Path;", "getStateFile", "()Ljava/nio/file/Path;", "write", "load", "doUpdateState", "diff", "getChange", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$StateChange;", "updateFullState", "newState", "updateWorkspaceState", "key", "newWorkspaceState", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceStateHolder;", "updateWorkspaceState$intellij_cidr_projectModel", "fireEvents", "fireEvents$intellij_cidr_projectModel", "updateFilesCache", "updatedPointers", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "updateFilesCache$intellij_cidr_projectModel", "([Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;)V", "fireWorkspaceInitializedEvent", "fillDiffForFreshInitializedWorkspace", "InitializationActivity", "StateChange", "ModifiableModelImpl", "Companion", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nOCWorkspaceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCWorkspaceImpl.kt\ncom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,974:1\n279#1,4:993\n285#1:998\n287#1,3:1001\n279#1,4:1004\n285#1:1009\n287#1,3:1012\n1734#2,3:975\n1557#2:978\n1628#2,3:979\n1863#2,2:982\n1557#2:984\n1628#2,3:985\n1863#2,2:989\n1863#2,2:991\n1863#2,2:999\n1863#2,2:1010\n1755#2,3:1015\n1#3:988\n1#3:997\n1#3:1008\n*S KotlinDebug\n*F\n+ 1 OCWorkspaceImpl.kt\ncom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl\n*L\n291#1:993,4\n291#1:998\n291#1:1001,3\n297#1:1004,4\n297#1:1009\n297#1:1012,3\n180#1:975,3\n219#1:978\n219#1:979,3\n270#1:982,2\n253#1:984\n253#1:985,3\n285#1:989,2\n288#1:991,2\n291#1:999,2\n297#1:1010,2\n340#1:1015,3\n291#1:997\n297#1:1008\n*E\n"})
public final class OCWorkspaceImpl
implements OCWorkspace,
SettingsSavingComponent,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private volatile boolean initialized;
    @NotNull
    private volatile StateHolder state;
    @NotNull
    private final Lazy serializer$delegate;
    @NotNull
    private final OCWorkspaceModificationTrackersImpl modificationTrackersImpl;

    public OCWorkspaceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = StateHolder.Companion.getEMPTY();
        this.serializer$delegate = LazyKt.lazy(OCWorkspaceImpl::serializer_delegate$lambda$0);
        this.modificationTrackersImpl = new OCWorkspaceModificationTrackersImpl(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    private final OCWorkspaceSerializer getSerializer() {
        Lazy lazy = this.serializer$delegate;
        return (OCWorkspaceSerializer)lazy.getValue();
    }

    @TestOnly
    public OCWorkspaceImpl(@NotNull Project project, boolean initialized) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project);
        this.initialized = initialized;
    }

    @TestOnly
    public final void setInitialized() {
        this.initialized = true;
    }

    public void dispose() {
        this.state = StateHolder.Companion.getEMPTY();
    }

    @Override
    public int getClientVersion(@NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Object object = this.state.getWorkspaceStates().get(clientKey);
        return object != null && (object = ((WorkspaceStateHolder)object).getWorkspaceData()) != null ? ((WorkspaceData)object).getClientVersion() : 0;
    }

    @Override
    @NotNull
    public List<OCResolveConfiguration> getConfigurations() {
        return this.state.getConfigurations();
    }

    @Override
    @NotNull
    public List<OCResolveConfiguration> getConfigurations(@NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Object object = this.state.getWorkspaceStates().get(clientKey);
        if (object == null || (object = ((WorkspaceStateHolder)object).getConfigurations()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @Nullable
    public OCResolveConfiguration getConfigurationById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.state.getConfigurationIds().get(id);
    }

    @Override
    @NotNull
    public List<OCResolveConfiguration> getConfigurationsForFile(@NotNull VirtualFile sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        VirtualFileWithId virtualFileWithId = sourceFile instanceof VirtualFileWithId ? (VirtualFileWithId)sourceFile : null;
        if (virtualFileWithId == null) {
            return CollectionsKt.emptyList();
        }
        int id = virtualFileWithId.getId();
        List list = (List)this.state.getCache().getIdsToConfigurations().get(id);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCResolveConfiguration> getConfigurationsForFile(@NotNull String sourceFileUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceFileUrl, (String)"sourceFileUrl");
        List list = this.state.getCache().getUrlsToConfigurations().get(sourceFileUrl);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public OCWorkspace.ModifiableModel getModifiableModel(@NotNull String clientKey, boolean clear) {
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        WorkspaceStateHolder originalState = !clear ? this.state.getWorkspaceStates().get(clientKey) : null;
        WorkspaceStateHolder workspaceStateHolder = originalState;
        if (workspaceStateHolder == null) {
            workspaceStateHolder = WorkspaceStateHolder.Companion.createNewEmptyState(this);
        }
        return new ModifiableModelImpl(this, clientKey, workspaceStateHolder);
    }

    @Override
    @NotNull
    public OCWorkspaceModificationTrackers getModificationTrackers() {
        return this.modificationTrackersImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void initComponent() {
        try {
            if (this.project.isDefault()) {
                return;
            }
            long started = System.currentTimeMillis();
            Path stateFile = this.getStateFile();
            OCWorkspaceCacheInvalidator.Companion.clearCache$intellij_cidr_projectModel(this.project);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(stateFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                try {
                    this.load(stateFile);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    try {
                        String message = "Cannot load OCWorkspace: " + stateFile;
                        if (e instanceof IOException) {
                            OCWorkspaceImplUtilKt.getLOG().warn(message, e);
                        } else {
                            OCWorkspaceImplUtilKt.getLOG().error(message, e);
                        }
                    }
                    finally {
                        PathKt.delete$default((Path)stateFile, (boolean)false, (int)1, null);
                    }
                }
            }
            if (OCWorkspaceImplUtilKt.getLOG().isDebugEnabled()) {
                HashMap clientSizes = new HashMap();
                for (String clientKey : this.state.getWorkspaceStates().keySet()) {
                    ((Map)clientSizes).put(clientKey, this.getConfigurations(clientKey).size());
                }
                OCWorkspaceImplUtilKt.getLOG().debug("OCWorkspace was initialized in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - started)) + ".Read " + this.getConfigurations().size() + " total configurations (" + clientSizes + ").");
            }
            this.initialized = true;
        }
        finally {
            this.modificationTrackersImpl.fireWorkspaceInitializationFinished(this.initialized);
        }
    }

    @Nullable
    public Object save(@NotNull Continuation<? super Unit> $completion) {
        boolean bl;
        Path stateFile;
        StateHolder state;
        block8: {
            if (this.project.isDefault()) {
                return Unit.INSTANCE;
            }
            if (!this.initialized) {
                return Unit.INSTANCE;
            }
            state = this.state;
            stateFile = this.getStateFile();
            Iterable $this$all$iv = state.getWorkspaceStates().values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    WorkspaceStateHolder it = (WorkspaceStateHolder)element$iv;
                    boolean bl2 = false;
                    if (it.getWorkspaceData().getClientVersion() == 0 && it.getConfigurations().isEmpty()) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            PathKt.delete$default((Path)stateFile, (boolean)false, (int)1, null);
            return Unit.INSTANCE;
        }
        if (state.isStateCacheValid() && stateFile.toFile().lastModified() > state.getTimestamp()) {
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, stateFile, null){
            int label;
            final /* synthetic */ OCWorkspaceImpl this$0;
            final /* synthetic */ StateHolder $state;
            final /* synthetic */ Path $stateFile;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                this.$stateFile = $stateFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        long before = System.currentTimeMillis();
                        try {
                            OCWorkspaceImpl.access$write(this.this$0, this.$state, this.$stateFile);
                            this.$state.markStateCacheValid(true);
                            OCWorkspaceImplUtilKt.getLOG().debug("OCWorkspace saved in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)) + ", size = " + StringUtil.formatFileSize((long)this.$stateFile.toFile().length()) + ", timestamp = " + this.$state.getTimestamp() + ", state file timestamp = " + this.$stateFile.toFile().lastModified());
                        }
                        catch (IOException e) {
                            OCWorkspaceImplUtilKt.getLOG().warn("Cannot save OCWorkspace: " + this.$stateFile, (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            OCWorkspaceImplUtilKt.getLOG().warn("Cannot save OCWorkspace: " + this.$stateFile, (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final Path getStateFile() {
        Path path = OCWorkspaceImplSerializationKt.stateFile(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"stateFile(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void write(StateHolder state, Path stateFile) throws IOException {
        try {
            Closeable closeable = new FastOutput(PathKt.outputStream$default((Path)stateFile, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null), 65536);
            Throwable throwable = null;
            try {
                StateHolder stateHolder;
                FastOutput out = (FastOutput)closeable;
                boolean bl = false;
                StateHolder $this$write_u24lambda_u245_u24lambda_u244 = stateHolder = state;
                boolean bl2 = false;
                out.writeInt(54);
                out.writeLong($this$write_u24lambda_u245_u24lambda_u244.getTimestamp());
                out.writeInt($this$write_u24lambda_u245_u24lambda_u244.getWorkspaceStates().size());
                for (Map.Entry<String, WorkspaceStateHolder> entry : $this$write_u24lambda_u245_u24lambda_u244.getWorkspaceStates().entrySet()) {
                    Collection<ConfigurationData> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    WorkspaceStateHolder workspaceStateHolder;
                    String key = entry.getKey();
                    WorkspaceStateHolder workspaceState = entry.getValue();
                    out.writeString(key);
                    WorkspaceStateHolder $this$write_u24lambda_u245_u24lambda_u244_u24lambda_u243 = workspaceStateHolder = workspaceState;
                    boolean bl3 = false;
                    Iterable iterable = $this$write_u24lambda_u245_u24lambda_u244_u24lambda_u243.getConfigurations();
                    WorkspaceData workspaceData = $this$write_u24lambda_u245_u24lambda_u244_u24lambda_u243.getWorkspaceData();
                    FastOutput fastOutput = out;
                    OCWorkspaceSerializer oCWorkspaceSerializer = this.getSerializer();
                    boolean $i$f$map = false;
                    void var22_25 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        OCResolveConfigurationImpl oCResolveConfigurationImpl = (OCResolveConfigurationImpl)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(it.getData$intellij_cidr_projectModel());
                    }
                    collection = (List)destination$iv$iv;
                    oCWorkspaceSerializer.writeStateData(fastOutput, workspaceData, (List<ConfigurationData>)collection);
                }
                StateHolder stateHolder2 = stateHolder;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void load(Path stateFile) throws IOException {
        OCWorkspaceImplUtilKt.getLOG().debug("Reading OCWorkspace state from " + stateFile);
        List allFilePointers = new ArrayList();
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(stateFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = new FastInput(inputStream, 65536);
            Throwable throwable = null;
            try {
                LinkedHashMap<String, WorkspaceStateHolder> linkedHashMap;
                Object ins = (FastInput)closeable;
                boolean bl = false;
                int internalVersion = ((Input)ins).readInt();
                if (internalVersion != 54) {
                    return;
                }
                long timestamp = ((Input)ins).readLong();
                int size = ((Input)ins).readInt();
                OCWorkspaceInterner interner = new OCWorkspaceInterner();
                LinkedHashMap<String, WorkspaceStateHolder> $this$load_u24lambda_u2410_u24lambda_u249 = linkedHashMap = new LinkedHashMap<String, WorkspaceStateHolder>(size);
                boolean bl2 = false;
                for (int i = 0; i < size; ++i) {
                    void $this$mapTo$iv$iv;
                    Pair<WorkspaceData, List<ConfigurationData>> pair;
                    int it = i;
                    boolean bl3 = false;
                    String key = ((Input)ins).readString();
                    Pair<WorkspaceData, List<ConfigurationData>> pointers = pair = new Pair<WorkspaceData, List<ConfigurationData>>((Disposable)this);
                    boolean bl4 = false;
                    allFilePointers.add(pointers);
                    Pair<WorkspaceData, List<ConfigurationData>> filePointers = pair;
                    pair = this.getSerializer().readStateData((FastInput)ins, this.project, (OCWorkspaceFilePointers)filePointers);
                    WorkspaceData data = (WorkspaceData)ExtensionsKt.component1(pair);
                    List configs = (List)ExtensionsKt.component2(pair);
                    Intrinsics.checkNotNull((Object)key);
                    if (OCWorkspaceDeserializingVetoCondition.Companion.shouldDiscard(key, data.getClientVersion())) continue;
                    Iterable $this$map$iv = configs;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void config;
                        ConfigurationData configurationData = (ConfigurationData)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        collection.add(new OCResolveConfigurationImpl(this.project, config.unmodifiableCopy(interner, (OCWorkspaceFilePointers)filePointers)));
                    }
                    List configurations = (List)destination$iv$iv;
                    WorkspaceStateHolder state = WorkspaceStateHolder.Companion.newStateWith$intellij_cidr_projectModel(data.unmodifiableCopy(), configurations, (OCWorkspaceFilePointers)filePointers);
                    $this$load_u24lambda_u2410_u24lambda_u249.putIfAbsent(key, state);
                }
                LinkedHashMap<String, WorkspaceStateHolder> workspaceStates = linkedHashMap;
                this.updateFullState(StateHolder.Companion.newStateWith$intellij_cidr_projectModel(timestamp, (Map<String, WorkspaceStateHolder>)workspaceStates), 0);
                ins = Unit.INSTANCE;
            }
            catch (Throwable ins) {
                throwable = ins;
                throw ins;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            allFilePointers.clear();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
        finally {
            Iterable $this$forEach$iv = allFilePointers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OCWorkspaceFilePointers it = (OCWorkspaceFilePointers)element$iv;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doUpdateState(int diff, Function1<? super StateHolder, StateChange> getChange) {
        WorkspaceStateHolder it;
        void $this$doUpdateState_u24lambda_u2412;
        StateHolder stateHolder;
        boolean $i$f$doUpdateState = false;
        if (this.initialized) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        StateChange stateChange = (StateChange)getChange.invoke((Object)this.state);
        StateHolder newState = stateChange.component1();
        Collection<WorkspaceStateHolder> outdatedWorkspaceStates = stateChange.component2();
        Collection<WorkspaceStateHolder> newWorkspaceStates = stateChange.component3();
        StateHolder stateHolder2 = stateHolder = newState;
        OCWorkspaceImpl oCWorkspaceImpl = this;
        boolean bl = false;
        StateHolder.buildOrUpdateFilesCache$default((StateHolder)$this$doUpdateState_u24lambda_u2412, null, 1, null);
        oCWorkspaceImpl.state = stateHolder;
        Iterable $this$forEach$iv = outdatedWorkspaceStates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WorkspaceStateHolder)element$iv;
            boolean bl2 = false;
            Disposer.dispose((Disposable)((Disposable)it.getFilePointers()));
        }
        this.fireEvents$intellij_cidr_projectModel(diff);
        $this$forEach$iv = newWorkspaceStates;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WorkspaceStateHolder)element$iv;
            boolean bl3 = false;
            it.getFilePointers().init(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFullState(StateHolder newState, int diff) {
        WorkspaceStateHolder it$iv;
        void $this$doUpdateState_u24lambda_u2412$iv;
        StateHolder stateHolder;
        OCWorkspaceImpl this_$iv = this;
        boolean $i$f$doUpdateState = false;
        if (this_$iv.initialized) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        StateHolder oldState = this_$iv.state;
        boolean bl = false;
        StateChange stateChange = new StateChange(newState, oldState.getWorkspaceStates().values(), newState.getWorkspaceStates().values());
        StateHolder newState$iv = stateChange.component1();
        Collection<WorkspaceStateHolder> outdatedWorkspaceStates$iv = stateChange.component2();
        Collection<WorkspaceStateHolder> newWorkspaceStates$iv = stateChange.component3();
        StateHolder stateHolder2 = stateHolder = newState$iv;
        OCWorkspaceImpl oCWorkspaceImpl = this_$iv;
        boolean bl2 = false;
        StateHolder.buildOrUpdateFilesCache$default((StateHolder)$this$doUpdateState_u24lambda_u2412$iv, null, 1, null);
        oCWorkspaceImpl.state = stateHolder;
        Iterable $this$forEach$iv$iv = outdatedWorkspaceStates$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (WorkspaceStateHolder)element$iv$iv;
            boolean bl3 = false;
            Disposer.dispose((Disposable)((Disposable)it$iv.getFilePointers()));
        }
        this_$iv.fireEvents$intellij_cidr_projectModel(diff);
        $this$forEach$iv$iv = newWorkspaceStates$iv;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (WorkspaceStateHolder)element$iv$iv;
            boolean bl4 = false;
            it$iv.getFilePointers().init(this_$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateWorkspaceState$intellij_cidr_projectModel(@NotNull String key, @NotNull WorkspaceStateHolder newWorkspaceState, int diff) {
        WorkspaceStateHolder it$iv;
        void $this$doUpdateState_u24lambda_u2412$iv;
        StateHolder stateHolder;
        LinkedHashMap<String, WorkspaceStateHolder> linkedHashMap;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newWorkspaceState, (String)"newWorkspaceState");
        OCWorkspaceImpl this_$iv = this;
        boolean $i$f$doUpdateState = false;
        if (this_$iv.initialized) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        StateHolder oldState = this_$iv.state;
        boolean bl = false;
        Map<String, WorkspaceStateHolder> oldWorkspaceStates = oldState.getWorkspaceStates();
        WorkspaceStateHolder oldWorkspaceState = oldWorkspaceStates.get(key);
        int newCapacity = oldWorkspaceStates.size() + (oldWorkspaceState == null ? 1 : 0);
        LinkedHashMap<String, WorkspaceStateHolder> $this$updateWorkspaceState_u24lambda_u2417_u24lambda_u2416 = linkedHashMap = new LinkedHashMap<String, WorkspaceStateHolder>(newCapacity);
        boolean bl2 = false;
        $this$updateWorkspaceState_u24lambda_u2417_u24lambda_u2416.putAll(oldWorkspaceStates);
        $this$updateWorkspaceState_u24lambda_u2417_u24lambda_u2416.put(key, newWorkspaceState);
        Map newWorkspaceStates = linkedHashMap;
        StateChange stateChange = new StateChange(StateHolder.Companion.newStateWith$intellij_cidr_projectModel(System.currentTimeMillis(), newWorkspaceStates), CollectionsKt.listOfNotNull((Object)oldWorkspaceState), CollectionsKt.listOf((Object)newWorkspaceState));
        StateHolder newState$iv = stateChange.component1();
        Collection<WorkspaceStateHolder> outdatedWorkspaceStates$iv = stateChange.component2();
        Collection<WorkspaceStateHolder> newWorkspaceStates$iv = stateChange.component3();
        StateHolder stateHolder2 = stateHolder = newState$iv;
        OCWorkspaceImpl oCWorkspaceImpl = this_$iv;
        boolean bl3 = false;
        StateHolder.buildOrUpdateFilesCache$default((StateHolder)$this$doUpdateState_u24lambda_u2412$iv, null, 1, null);
        oCWorkspaceImpl.state = stateHolder;
        Iterable $this$forEach$iv$iv = outdatedWorkspaceStates$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (WorkspaceStateHolder)element$iv$iv;
            boolean bl4 = false;
            Disposer.dispose((Disposable)((Disposable)it$iv.getFilePointers()));
        }
        this_$iv.fireEvents$intellij_cidr_projectModel(diff);
        $this$forEach$iv$iv = newWorkspaceStates$iv;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (WorkspaceStateHolder)element$iv$iv;
            boolean bl5 = false;
            it$iv.getFilePointers().init(this_$iv);
        }
    }

    public final void fireEvents$intellij_cidr_projectModel(int diff) {
        if (this.initialized && diff != 0) {
            this.modificationTrackersImpl.fireWorkspaceChanged(new OCWorkspaceEventImpl((diff & 1) == 1, (diff & 2) == 2, (diff & 4) == 4, (diff & 8) == 8));
        }
    }

    public final void updateFilesCache$intellij_cidr_projectModel(@Nullable VirtualFilePointer[] updatedPointers) {
        boolean updated2 = this.state.buildOrUpdateFilesCache(updatedPointers);
        if (updated2) {
            this.state.markStateCacheValid(false);
        }
    }

    public final void fireWorkspaceInitializedEvent() {
        int diff = this.fillDiffForFreshInitializedWorkspace();
        this.fireEvents$intellij_cidr_projectModel(diff);
    }

    private final int fillDiffForFreshInitializedWorkspace() {
        boolean bl;
        block4: {
            List<OCResolveConfiguration> configurations = this.getConfigurations();
            if (configurations.isEmpty()) {
                return 0;
            }
            Iterable $this$any$iv = configurations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OCResolveConfiguration c = (OCResolveConfiguration)element$iv;
                    boolean bl2 = false;
                    Collection<VirtualFile> collection = c.getSources();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getSources(...)");
                    boolean bl3 = !collection.isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean hasSources = bl;
        return 5 | (hasSources ? 2 : 0);
    }

    private static final OCWorkspaceSerializer serializer_delegate$lambda$0() {
        return new OCWorkspaceSerializer(false, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final OCWorkspaceImpl getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    public static final /* synthetic */ void access$write(OCWorkspaceImpl $this, StateHolder state, Path stateFile) {
        $this.write(state, stateFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$Companion;", "", "<init>", "()V", "getInstanceImpl", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OCWorkspaceImpl getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(OCWorkspace.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl");
            return (OCWorkspaceImpl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$InitializationActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.cidr.projectModel"})
    public static final class InitializationActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Object object = CoroutinesKt.blockingContext(() -> InitializationActivity.execute$lambda$0(project), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        private static final Unit execute$lambda$0(Project $project) {
            Companion.getInstanceImpl($project).initComponent();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u00013B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020\u0005H\u0016J*\u0010'\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020$H\u0016J\b\u0010/\u001a\u00020\u001dH\u0016J\b\u00100\u001a\u000201H\u0017J\b\u00102\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "owner", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;", "key", "", "Lcom/jetbrains/cidr/lang/workspace/Key;", "originalState", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceStateHolder;", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl;Ljava/lang/String;Lcom/jetbrains/cidr/lang/workspace/WorkspaceStateHolder;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "started", "", "state", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl$State;", "filePointers", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceFilePointers;", "interner", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceInterner;", "mutableData", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceData;", "configurations", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfigurationImpl$ModifiableModelImpl;", "setClientVersion", "", "version", "", "clear", "getInterner", "getConfigurations", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;", "getConfigurationById", "id", "addConfiguration", "name", "variant", "Lcom/jetbrains/cidr/lang/workspace/OCVariant;", "fileSeparators", "Lcom/jetbrains/cidr/lang/toolchains/CidrFileSeparators;", "removeConfiguration", "configuration", "preCommit", "commit", "", "dispose", "State", "intellij.cidr.projectModel"})
    @SourceDebugExtension(value={"SMAP\nOCWorkspaceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCWorkspaceImpl.kt\ncom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,974:1\n1246#2,4:975\n1863#2:981\n1557#2:983\n1628#2,3:984\n1863#2,2:990\n1864#2:992\n1863#2,2:993\n1202#2,2:997\n1230#2,4:999\n1246#2,4:1005\n1557#2:1009\n1628#2,3:1010\n22#3,2:979\n26#3,2:995\n1317#4:982\n1318#4:987\n216#5,2:988\n462#6:1003\n412#6:1004\n*S KotlinDebug\n*F\n+ 1 OCWorkspaceImpl.kt\ncom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl\n*L\n360#1:975,4\n425#1:981\n452#1:983\n452#1:984,3\n472#1:990,2\n425#1:992\n482#1:993,2\n503#1:997,2\n503#1:999,4\n504#1:1005,4\n523#1:1009\n523#1:1010,3\n413#1:979,2\n413#1:995,2\n426#1:982\n426#1:987\n471#1:988,2\n504#1:1003\n504#1:1004\n*E\n"})
    public static final class ModifiableModelImpl
    implements OCWorkspace.ModifiableModel {
        @NotNull
        private final OCWorkspaceImpl owner;
        @NotNull
        private final String key;
        private final long started;
        @NotNull
        private State state;
        @NotNull
        private OCWorkspaceFilePointers filePointers;
        @NotNull
        private final OCWorkspaceInterner interner;
        @NotNull
        private final WorkspaceData mutableData;
        @NotNull
        private final Map<String, OCResolveConfigurationImpl.ModifiableModelImpl> configurations;

        /*
         * WARNING - void declaration
         */
        public ModifiableModelImpl(@NotNull OCWorkspaceImpl owner, @NotNull String key, @NotNull WorkspaceStateHolder originalState) {
            void destination$iv;
            void $this$associateByTo$iv;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)originalState, (String)"originalState");
            this.owner = owner;
            this.key = key;
            this.started = System.currentTimeMillis();
            this.state = State.DEFAULT;
            this.filePointers = new OCWorkspaceFilePointers(this.owner);
            this.interner = new OCWorkspaceInterner();
            this.mutableData = originalState.getWorkspaceData().mutableCopy();
            Iterable iterable = originalState.getConfigurations();
            Map map = new LinkedHashMap();
            ModifiableModelImpl modifiableModelImpl = this;
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                OCResolveConfigurationImpl oCResolveConfigurationImpl = (OCResolveConfigurationImpl)element$iv;
                void var12_12 = destination$iv;
                boolean bl = false;
                OCResolveConfigurationImpl it = (OCResolveConfigurationImpl)element$iv;
                String string = it.getUniqueId();
                boolean bl2 = false;
                OCResolveConfigurationImpl.ModifiableModelImpl modifiableModelImpl2 = new OCResolveConfigurationImpl.ModifiableModelImpl(it, this.filePointers, this.interner);
                var12_12.put(string, modifiableModelImpl2);
            }
            modifiableModelImpl.configurations = destination$iv;
        }

        private final Project getProject() {
            return this.owner.getProject();
        }

        @Override
        public void setClientVersion(int version) {
            this.mutableData.setClientVersion(version);
        }

        @Override
        public void clear() {
            this.mutableData.clear();
            this.configurations.clear();
        }

        @Override
        @NotNull
        public OCWorkspaceInterner getInterner() {
            return this.interner;
        }

        @Override
        @NotNull
        public List<OCResolveConfiguration.ModifiableModel> getConfigurations() {
            List<OCResolveConfiguration.ModifiableModel> list = Collections.unmodifiableList(CollectionsKt.toList((Iterable)this.configurations.values()));
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }

        @Override
        @Nullable
        public OCResolveConfiguration.ModifiableModel getConfigurationById(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.configurations.get(id);
        }

        @Override
        @NotNull
        public OCResolveConfiguration.ModifiableModel addConfiguration(@NotNull String id, @NotNull String name, @Nullable OCVariant variant, @NotNull CidrFileSeparators fileSeparators) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)fileSeparators, (String)"fileSeparators");
            if (this.configurations.containsKey(id)) {
                throw new IllegalStateException("Configuration with id '" + id + "' already exists");
            }
            String displayName = OCResolveConfigurationImpl.Companion.getConfigurationDisplayName(name, variant);
            ConfigurationData data = new ConfigurationData(id, name, variant, displayName, fileSeparators, new CompilerSettingsData(), MapsKt.emptyMap(), MapsKt.emptyMap(), null);
            OCResolveConfigurationImpl config = new OCResolveConfigurationImpl(this.getProject(), data);
            OCResolveConfigurationImpl.ModifiableModelImpl model = new OCResolveConfigurationImpl.ModifiableModelImpl(config, this.filePointers, this.interner);
            this.configurations.put(model.getUniqueId(), model);
            return model;
        }

        @Override
        public void removeConfiguration(@NotNull OCResolveConfiguration.ModifiableModel configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.configurations.remove(configuration.getUniqueId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void preCommit() {
            OCWorkspaceImplUtilKt.checkNoDispatch();
            if (this.state != State.DEFAULT) {
                OCWorkspaceImplUtilKt.getLOG().error("Wrong state: " + this.state);
                return;
            }
            this.state = State.PRE_COMMITTED;
            Disposable $this$use$iv = (Disposable)this.filePointers;
            boolean $i$f$use = false;
            try {
                OCWorkspaceFilePointers it = (OCWorkspaceFilePointers)$this$use$iv;
                boolean bl = false;
                this.filePointers = new OCWorkspaceFilePointers(this.owner);
                HashMap alreadyCreatedHeaderPaths = new HashMap();
                OCWorkspaceSerializer serializer = new OCWorkspaceSerializer(true);
                MessageDigest digest = DigestUtil.md5();
                ClusterCalculator clusterContext = new ClusterCalculator();
                int counter = 0;
                long digestTime = 0L;
                Closeable closeable = new FastOutput(65536, -1);
                Throwable throwable = null;
                try {
                    FastOutput output = (FastOutput)closeable;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv = this.configurations.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$preCommit_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410_u24lambda_u249;
                        Map.Entry<OCLanguageKind, CompilerSettingsData> element$iv2;
                        HashSet hashSet;
                        OCResolveConfigurationImpl.ModifiableModelImpl config = (OCResolveConfigurationImpl.ModifiableModelImpl)element$iv;
                        boolean bl3 = false;
                        Sequence<OCResolveConfigurationImpl.ModifiableModelImpl.UniqueCompilerSettings> $this$forEach$iv2 = config.getCompilerSettingsToCollect$intellij_cidr_projectModel();
                        boolean $i$f$forEach22 = false;
                        for (Object element$iv3 : $this$forEach$iv2) {
                            HeadersSearchRoots headersSearchRoots;
                            OCResolveConfigurationImpl.ModifiableModelImpl.UniqueCompilerSettings compilerSettings = (OCResolveConfigurationImpl.ModifiableModelImpl.UniqueCompilerSettings)element$iv3;
                            boolean bl4 = false;
                            ProgressManager.checkCanceled();
                            ++counter;
                            long before = System.currentTimeMillis();
                            try {
                                compilerSettings.getMergedSettings().clearCalculated();
                                serializer.writeCompilerSettingsDataDirectly(output, compilerSettings.getLanguageKind(), compilerSettings.getMergedSettings());
                                digest.update(output.getBuffer(), 0, output.position());
                                CompilerSettingsData compilerSettingsData = compilerSettings.getOriginalSettings();
                                String string = StringUtil.toHexString((byte[])digest.digest());
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
                                compilerSettingsData.setCalculatedCompilerKey(new CompilerSettingsKey(string));
                                digest.reset();
                                output.clear();
                                clusterContext.calculateCluster$intellij_cidr_projectModel(compilerSettings.getMergedSettings(), digest);
                                CompilerSettingsData compilerSettingsData2 = compilerSettings.getOriginalSettings();
                                String string2 = StringUtil.toHexString((byte[])digest.digest());
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(...)");
                                compilerSettingsData2.setCalculatedIndexingCluster(new CompilerSettingsKey(string2));
                                digest.reset();
                                digestTime += System.currentTimeMillis() - before;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            CompilerSettingsData compilerSettingsData = compilerSettings.getOriginalSettings();
                            if (compilerSettings.getOriginalSettings().getHeaderSearchPaths() != null) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                void headersSearchPaths;
                                CompilerSettingsData compilerSettingsData3 = compilerSettingsData;
                                boolean bl5 = false;
                                Iterable iterable = (Iterable)headersSearchPaths;
                                HeadersSearchRoots.Companion companion = HeadersSearchRoots.Companion;
                                boolean $i$f$map = false;
                                void var36_48 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void path;
                                    HeadersSearchPath headersSearchPath = (HeadersSearchPath)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl6 = false;
                                    ProgressManager.checkCanceled();
                                    HeadersSearchRoot root = (HeadersSearchRoot)((Object)alreadyCreatedHeaderPaths.get(path));
                                    if (root == null) {
                                        root = (HeadersSearchRoot)((Object)ReadAction.compute(() -> ModifiableModelImpl.preCommit$lambda$13$lambda$11$lambda$10$lambda$6$lambda$5$lambda$4$lambda$3(this, (HeadersSearchPath)path)));
                                        ((Map)alreadyCreatedHeaderPaths).put(path, root);
                                    }
                                    HeadersSearchRoot headersSearchRoot = root;
                                    Intrinsics.checkNotNull((Object)((Object)headersSearchRoot));
                                    collection.add(headersSearchRoot);
                                }
                                headersSearchRoots = companion.create((List)destination$iv$iv);
                                compilerSettingsData = compilerSettingsData3;
                            } else {
                                headersSearchRoots = null;
                            }
                            compilerSettingsData.setCalculatedHeadersSearchRoots(headersSearchRoots);
                        }
                        HashSet $i$f$forEach22 = hashSet = new HashSet();
                        ConfigurationData configurationData = config.getMutableData$intellij_cidr_projectModel();
                        boolean bl7 = false;
                        Object $this$forEach$iv3 = config.getMutableData$intellij_cidr_projectModel().getLanguagesData();
                        boolean $i$f$forEach3 = false;
                        Iterator<Map.Entry<OCLanguageKind, CompilerSettingsData>> iterator = $this$forEach$iv3.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<OCLanguageKind, CompilerSettingsData> entry = element$iv2 = iterator.next();
                            boolean bl8 = false;
                            OCLanguageKind langKind = entry.getKey();
                            CompilerSettingsData settings = entry.getValue();
                            if (!settings.hasCustomSettings()) continue;
                            $this$preCommit_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.add(langKind);
                        }
                        $this$forEach$iv3 = config.getMutableData$intellij_cidr_projectModel().getSourcesData().values();
                        $i$f$forEach3 = false;
                        iterator = $this$forEach$iv3.iterator();
                        while (iterator.hasNext()) {
                            element$iv2 = iterator.next();
                            SourceData it2 = (SourceData)((Object)element$iv2);
                            boolean bl9 = false;
                            $this$preCommit_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.add(it2.getLanguageKind());
                        }
                        configurationData.setCalculatedEnabledLanguages(hashSet);
                    }
                    output = Unit.INSTANCE;
                }
                catch (Throwable output) {
                    throwable = output;
                    throw output;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (OCWorkspaceImplUtilKt.getLOG().isDebugEnabled()) {
                    OCWorkspaceImplUtilKt.getLOG().debug("Compiler key calculation for " + counter + " settings took " + StringUtil.formatDuration((long)digestTime));
                }
                OCWorkspaceInterner interner = new OCWorkspaceInterner();
                Iterable $this$forEach$iv = this.configurations.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    OCResolveConfigurationImpl.ModifiableModelImpl it3 = (OCResolveConfigurationImpl.ModifiableModelImpl)element$iv;
                    boolean bl10 = false;
                    it3.preCommit$intellij_cidr_projectModel(interner, this.filePointers);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @RequiresWriteLock
        public boolean commit() {
            void $this$mapTo$iv$iv;
            void $this$mapValuesTo$iv$iv;
            Map oldConfigurations;
            Map map;
            Map.Entry it;
            Object object;
            boolean $i$f$associateByTo;
            if (this.state != State.PRE_COMMITTED) {
                OCWorkspaceImplUtilKt.getLOG().error("Wrong state: " + this.state);
                return false;
            }
            this.state = State.COMMITTED;
            if (this.getProject().isDisposed()) {
                OCWorkspaceImplUtilKt.getLOG().debug("Project is already disposed");
                Disposer.dispose((Disposable)((Disposable)this.filePointers));
                return false;
            }
            WorkspaceStateHolder workspaceState = this.owner.state.getWorkspaceStates().get(this.key);
            Object object2 = workspaceState;
            if (object2 != null && (object2 = ((WorkspaceStateHolder)object2).getConfigurations()) != null) {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = (Iterable)object2;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    OCResolveConfigurationImpl oCResolveConfigurationImpl = (OCResolveConfigurationImpl)element$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.put(((OCResolveConfigurationImpl)((Object)it)).getUniqueId(), element$iv$iv);
                }
                map = destination$iv$iv;
            } else {
                map = MapsKt.emptyMap();
            }
            Map $this$mapValues$iv = oldConfigurations = map;
            boolean $i$f$mapValues = false;
            Map $i$f$associateBy = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it2;
                void it$iv$iv;
                it = (Map.Entry)element$iv$iv$iv;
                Map bl = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = bl;
                boolean bl3 = false;
                ConfigurationData configurationData = ((OCResolveConfigurationImpl)it2.getValue()).getData$intellij_cidr_projectModel();
                object.put(k, configurationData);
            }
            Map oldConfigData = destination$iv$iv;
            Object object3 = workspaceState;
            Integer oldClientVersion = object3 != null && (object3 = ((WorkspaceStateHolder)object3).getWorkspaceData()) != null ? Integer.valueOf(((WorkspaceData)object3).getClientVersion()) : null;
            int diff = OCWorkspaceImplUtilKt.mapDiff(oldConfigData, this.configurations, 1, ModifiableModelImpl::commit$lambda$16);
            Integer n = oldClientVersion;
            if (n == null || this.mutableData.getClientVersion() != n.intValue()) {
                diff |= 8;
            }
            if (diff == 0 && !oldConfigData.isEmpty()) {
                Disposer.dispose((Disposable)((Disposable)this.filePointers));
                if (OCWorkspaceImplUtilKt.getLOG().isDebugEnabled()) {
                    OCWorkspaceImplUtilKt.getLOG().debug("OCWorkspace not changed. Setup took  " + StringUtil.formatDuration((long)(System.currentTimeMillis() - this.started)));
                }
                return false;
            }
            Iterable $this$map$iv = this.configurations.values();
            boolean $i$f$map = false;
            $this$associateByTo$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void model;
                OCResolveConfigurationImpl.ModifiableModelImpl bl = (OCResolveConfigurationImpl.ModifiableModelImpl)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl4 = false;
                model.getOwner$intellij_cidr_projectModel().setData$intellij_cidr_projectModel(model.getMutableData$intellij_cidr_projectModel());
                OCResolveConfigurationImpl newConfig = model.getOwner$intellij_cidr_projectModel();
                OCResolveConfigurationImpl oldConfig = (OCResolveConfigurationImpl)oldConfigurations.get(newConfig.getUniqueId());
                if (oldConfig != null) {
                    oldConfig.setData$intellij_cidr_projectModel(newConfig.getData$intellij_cidr_projectModel());
                    newConfig = oldConfig;
                }
                object.add(newConfig);
            }
            List unmodifiableConfigs = (List)destination$iv$iv2;
            WorkspaceData workspaceData = this.mutableData.unmodifiableCopy();
            List list = ContainerUtil.unmodifiableOrEmptyList((List)unmodifiableConfigs);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"unmodifiableOrEmptyList(...)");
            WorkspaceStateHolder newWorkspaceState = WorkspaceStateHolder.Companion.newStateWith$intellij_cidr_projectModel(workspaceData, list, this.filePointers);
            this.owner.updateWorkspaceState$intellij_cidr_projectModel(this.key, newWorkspaceState, diff);
            if (OCWorkspaceImplUtilKt.getLOG().isDebugEnabled()) {
                OCWorkspaceImplUtilKt.getLOG().debug("OCWorkspace setup took  " + StringUtil.formatDuration((long)(System.currentTimeMillis() - this.started)));
            }
            return true;
        }

        public void dispose() {
            if (this.state == State.COMMITTED) {
                return;
            }
            Disposer.dispose((Disposable)((Disposable)this.filePointers));
        }

        private static final VirtualFilePointer preCommit$lambda$13$lambda$11$lambda$10$lambda$6$lambda$5$lambda$4$lambda$3$lambda$2(ModifiableModelImpl this$0, String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this$0.filePointers.createFor(url, OCWorkspaceFilePointers.Purpose.FOR_INCLUDES);
        }

        private static final HeadersSearchRoot preCommit$lambda$13$lambda$11$lambda$10$lambda$6$lambda$5$lambda$4$lambda$3(ModifiableModelImpl this$0, HeadersSearchPath $path) {
            if (this$0.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return HeadersSearchRootFactory.createSearchRoot($path, this$0.getProject(), arg_0 -> ModifiableModelImpl.preCommit$lambda$13$lambda$11$lambda$10$lambda$6$lambda$5$lambda$4$lambda$3$lambda$2(this$0, arg_0));
        }

        private static final int commit$lambda$16(ConfigurationData a, OCResolveConfigurationImpl.ModifiableModelImpl b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.diffWith(b.getMutableData$intellij_cidr_projectModel());
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$ModifiableModelImpl$State;", "", "<init>", "(Ljava/lang/String;I)V", "DEFAULT", "PRE_COMMITTED", "COMMITTED", "intellij.cidr.projectModel"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State DEFAULT = new State();
            public static final /* enum */ State PRE_COMMITTED = new State();
            public static final /* enum */ State COMMITTED = new State();
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            @NotNull
            public static EnumEntries<State> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stateArray = new State[]{State.DEFAULT, State.PRE_COMMITTED, State.COMMITTED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceImpl$StateChange;", "", "newState", "Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "outdatedWorkspaceStates", "", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceStateHolder;", "newWorkspaceStates", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/StateHolder;Ljava/util/Collection;Ljava/util/Collection;)V", "getNewState", "()Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "getOutdatedWorkspaceStates", "()Ljava/util/Collection;", "getNewWorkspaceStates", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.projectModel"})
    private static final class StateChange {
        @NotNull
        private final StateHolder newState;
        @NotNull
        private final Collection<WorkspaceStateHolder> outdatedWorkspaceStates;
        @NotNull
        private final Collection<WorkspaceStateHolder> newWorkspaceStates;

        public StateChange(@NotNull StateHolder newState, @NotNull Collection<WorkspaceStateHolder> outdatedWorkspaceStates, @NotNull Collection<WorkspaceStateHolder> newWorkspaceStates) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            Intrinsics.checkNotNullParameter(outdatedWorkspaceStates, (String)"outdatedWorkspaceStates");
            Intrinsics.checkNotNullParameter(newWorkspaceStates, (String)"newWorkspaceStates");
            this.newState = newState;
            this.outdatedWorkspaceStates = outdatedWorkspaceStates;
            this.newWorkspaceStates = newWorkspaceStates;
        }

        @NotNull
        public final StateHolder getNewState() {
            return this.newState;
        }

        @NotNull
        public final Collection<WorkspaceStateHolder> getOutdatedWorkspaceStates() {
            return this.outdatedWorkspaceStates;
        }

        @NotNull
        public final Collection<WorkspaceStateHolder> getNewWorkspaceStates() {
            return this.newWorkspaceStates;
        }

        @NotNull
        public final StateHolder component1() {
            return this.newState;
        }

        @NotNull
        public final Collection<WorkspaceStateHolder> component2() {
            return this.outdatedWorkspaceStates;
        }

        @NotNull
        public final Collection<WorkspaceStateHolder> component3() {
            return this.newWorkspaceStates;
        }

        @NotNull
        public final StateChange copy(@NotNull StateHolder newState, @NotNull Collection<WorkspaceStateHolder> outdatedWorkspaceStates, @NotNull Collection<WorkspaceStateHolder> newWorkspaceStates) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            Intrinsics.checkNotNullParameter(outdatedWorkspaceStates, (String)"outdatedWorkspaceStates");
            Intrinsics.checkNotNullParameter(newWorkspaceStates, (String)"newWorkspaceStates");
            return new StateChange(newState, outdatedWorkspaceStates, newWorkspaceStates);
        }

        public static /* synthetic */ StateChange copy$default(StateChange stateChange, StateHolder stateHolder, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                stateHolder = stateChange.newState;
            }
            if ((n & 2) != 0) {
                collection = stateChange.outdatedWorkspaceStates;
            }
            if ((n & 4) != 0) {
                collection2 = stateChange.newWorkspaceStates;
            }
            return stateChange.copy(stateHolder, collection, collection2);
        }

        @NotNull
        public String toString() {
            return "StateChange(newState=" + this.newState + ", outdatedWorkspaceStates=" + this.outdatedWorkspaceStates + ", newWorkspaceStates=" + this.newWorkspaceStates + ")";
        }

        public int hashCode() {
            int result2 = this.newState.hashCode();
            result2 = result2 * 31 + ((Object)this.outdatedWorkspaceStates).hashCode();
            result2 = result2 * 31 + ((Object)this.newWorkspaceStates).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StateChange)) {
                return false;
            }
            StateChange stateChange = (StateChange)other;
            if (!Intrinsics.areEqual((Object)this.newState, (Object)stateChange.newState)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.outdatedWorkspaceStates, stateChange.outdatedWorkspaceStates)) {
                return false;
            }
            return Intrinsics.areEqual(this.newWorkspaceStates, stateChange.newWorkspaceStates);
        }
    }
}

