/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCPCHCache {
    private static final NotNullLazyKey<SimpleModificationTracker, Project> PROJECT_MODIFICATION_TRACKER = NotNullLazyKey.createLazyKey((String)"PROJECT_MODIFICATION_TRACKER", project -> new SimpleModificationTracker());
    private static final Key<CachedValue<PCHCache>> PCH_CACHE_KEY = Key.create((String)"PCH_CACHE_KEY");

    public static void onProjectContextChange(@NotNull Project project) {
        if (project == null) {
            OCPCHCache.$$$reportNull$$$0(0);
        }
        ((SimpleModificationTracker)PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project)).incModificationCount();
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCPCHCache.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OCPCHCache.$$$reportNull$$$0(2);
        }
        return OCPCHCache.getPCHCache(project).isPCH(file);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getBuildConfigurationByPchFile(@Nullable VirtualFile pchFile, @NotNull Project project) {
        if (project == null) {
            OCPCHCache.$$$reportNull$$$0(3);
        }
        if (pchFile == null) {
            List<OCResolveConfiguration> list = Collections.emptyList();
            if (list == null) {
                OCPCHCache.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<OCResolveConfiguration> collection = OCPCHCache.getPCHCache(project).getConfigurations(pchFile);
        if (collection == null) {
            OCPCHCache.$$$reportNull$$$0(5);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static PCHCache getPCHCache(@NotNull Project project) {
        CachedValue value;
        if (project == null) {
            OCPCHCache.$$$reportNull$$$0(6);
        }
        if ((value = (CachedValue)project.getUserData(PCH_CACHE_KEY)) == null) {
            SimpleModificationTracker modificationTracker = (SimpleModificationTracker)PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project);
            CachedValueProvider provider = () -> new CachedValueProvider.Result((Object)new PCHCache(project), new Object[]{modificationTracker});
            CachedValue newValue = CachedValuesManager.getManager((Project)project).createCachedValue(provider, false);
            value = (CachedValue)((UserDataHolderEx)project).putUserDataIfAbsent(PCH_CACHE_KEY, (Object)newValue);
        }
        if (value.hasUpToDateValue()) {
            PCHCache pCHCache = (PCHCache)value.getValue();
            if (pCHCache != null) return pCHCache;
            OCPCHCache.$$$reportNull$$$0(7);
            return pCHCache;
        }
        CachedValue cachedValue = value;
        // MONITORENTER : cachedValue
        PCHCache pCHCache = (PCHCache)value.getValue();
        // MONITOREXIT : cachedValue
        if (pCHCache != null) return pCHCache;
        OCPCHCache.$$$reportNull$$$0(8);
        return pCHCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCPCHCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCPCHCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurationByPchFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPCHCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onProjectContextChange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPrecompiledHeader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuildConfigurationByPchFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPCHCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class PCHCache {
        private final MultiMap<VirtualFile, OCResolveConfiguration> pch2configs;

        PCHCache(@NotNull Project project) {
            if (project == null) {
                PCHCache.$$$reportNull$$$0(0);
            }
            this.pch2configs = new MultiMap<VirtualFile, OCResolveConfiguration>(){

                @NotNull
                protected Collection<OCResolveConfiguration> createCollection() {
                    return new LinkedHashSet<OCResolveConfiguration>();
                }
            };
            for (OCResolveConfiguration config : OCWorkspace.getInstance(project).getConfigurations()) {
                config.getAllCompilerSettings().flatMap(it -> it.getImplicitIncludes().stream()).forEach(pch -> this.pch2configs.putValue(pch, (Object)config));
            }
        }

        Collection<OCResolveConfiguration> getConfigurations(@NotNull VirtualFile pch) {
            if (pch == null) {
                PCHCache.$$$reportNull$$$0(1);
            }
            return Collections.unmodifiableCollection(this.pch2configs.get((Object)pch));
        }

        boolean isPCH(@NotNull VirtualFile file) {
            if (file == null) {
                PCHCache.$$$reportNull$$$0(2);
            }
            return this.pch2configs.containsKey((Object)file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCPCHCache$PCHCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPCH";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

