/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.util.ApplicationKt;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\"\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0017J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/util/TeamCityLogApi;", "", "<init>", "()V", "isUnderTC", "", "()Z", "block", "T", "caption", "", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "publishArtifact", "", "path", "getTempDirectory", "error", "s", "message", "name", "singleArgument", "arguments", "", "escape", "Companion", "intellij.cidr.util"})
public final class TeamCityLogApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isUnderTC = System.getenv("TEAMCITY_VERSION") != null;

    public final boolean isUnderTC() {
        return this.isUnderTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T block(@NotNull String caption, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.message("blockOpened", MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)caption)));
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.message("blockClosed", MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)caption)));
        }
    }

    public final void publishArtifact(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.message("publishArtifacts", path);
    }

    @NotNull
    public final String getTempDirectory() {
        String string = System.getProperty("teamcity.build.tempDir");
        if (string == null) {
            String string2 = System.getProperty("java.io.tmpdir");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        }
        return string;
    }

    public final void error(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)s), TuplesKt.to((Object)"status", (Object)"ERROR")};
        this.message("message", MapsKt.mapOf((Pair[])pairArray));
    }

    public final void message(@NotNull String name, @NotNull String singleArgument) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)singleArgument, (String)"singleArgument");
        System.out.println((Object)("##teamcity[" + name + " '" + this.escape(singleArgument) + "']"));
    }

    public final void message(@NotNull String name, @NotNull Map<String, String> arguments) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        StringBuilder $this$message_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$message_u24lambda_u240.append("##teamcity[");
        $this$message_u24lambda_u240.append(name);
        for (Map.Entry<String, String> argument : arguments.entrySet()) {
            $this$message_u24lambda_u240.append(' ');
            $this$message_u24lambda_u240.append(argument.getKey());
            $this$message_u24lambda_u240.append('=');
            $this$message_u24lambda_u240.append('\'');
            $this$message_u24lambda_u240.append(this.escape(argument.getValue()));
            $this$message_u24lambda_u240.append('\'');
        }
        $this$message_u24lambda_u240.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String message = string;
        System.out.println((Object)message);
    }

    private final String escape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder;
            char ch = s.charAt(i);
            char escape = switch (ch) {
                case '\n' -> 'n';
                case '\r' -> 'r';
                case '\'', '[', ']', '|' -> ch;
                default -> '\u0000';
            };
            if (escape != '\u0000') {
                stringBuilder = sb.append('|').append(escape);
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                String string = "0x%04x";
                Object[] objectArray = new Object[]{(short)ch};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                stringBuilder = sb.append(string2);
                continue;
            }
            stringBuilder = sb.append(ch);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/util/TeamCityLogApi$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/util/TeamCityLogApi;", "intellij.cidr.util"})
    @SourceDebugExtension(value={"SMAP\nTeamCityLogApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityLogApi.kt\ncom/jetbrains/cidr/lang/util/TeamCityLogApi$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,83:1\n31#2,2:84\n*S KotlinDebug\n*F\n+ 1 TeamCityLogApi.kt\ncom/jetbrains/cidr/lang/util/TeamCityLogApi$Companion\n*L\n10#1:84,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TeamCityLogApi getInstance() {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<TeamCityLogApi> serviceClass$iv = TeamCityLogApi.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TeamCityLogApi)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

