/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import org.jetbrains.annotations.NotNull;

public enum CLanguageKind implements OCLanguageKind
{
    C("C", "C", "c"),
    OBJ_C("Objective-C", "ObjC", "m"),
    CPP("C++", "C++", "cpp"),
    OBJ_CPP("Objective-C++", "ObjC++", "mm");

    private final String myDefaultSourceExtension;
    private final String myDisplayName;
    private final String myShortDisplayName;

    private CLanguageKind(@NotNull String name, String shortDisplayName, String extension) {
        if (name == null) {
            CLanguageKind.$$$reportNull$$$0(0);
        }
        if (shortDisplayName == null) {
            CLanguageKind.$$$reportNull$$$0(1);
        }
        if (extension == null) {
            CLanguageKind.$$$reportNull$$$0(2);
        }
        this.myDefaultSourceExtension = extension;
        this.myDisplayName = name;
        this.myShortDisplayName = shortDisplayName;
    }

    @NotNull
    public static OCLanguageKind find(boolean isObjC, boolean isCpp, boolean isCuda) {
        if (isCuda) {
            CUDALanguageKind cUDALanguageKind = CUDALanguageKind.CUDA;
            if (cUDALanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(3);
            }
            return cUDALanguageKind;
        }
        if (isObjC) {
            CLanguageKind cLanguageKind = isCpp ? OBJ_CPP : OBJ_C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(4);
            }
            return cLanguageKind;
        }
        CLanguageKind cLanguageKind = isCpp ? CPP : C;
        if (cLanguageKind == null) {
            CLanguageKind.$$$reportNull$$$0(5);
        }
        return cLanguageKind;
    }

    @NotNull
    public static CLanguageKind maxLanguage() {
        CLanguageKind cLanguageKind = OBJ_CPP;
        if (cLanguageKind == null) {
            CLanguageKind.$$$reportNull$$$0(6);
        }
        return cLanguageKind;
    }

    @NotNull
    public static CLanguageKind min(@NotNull CLanguageKind a, @NotNull CLanguageKind b) {
        if (a == null) {
            CLanguageKind.$$$reportNull$$$0(7);
        }
        if (b == null) {
            CLanguageKind.$$$reportNull$$$0(8);
        }
        if (a == b) {
            CLanguageKind cLanguageKind = a;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(9);
            }
            return cLanguageKind;
        }
        if (a == C || b == C) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(10);
            }
            return cLanguageKind;
        }
        if (a == OBJ_C && b == CPP) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(11);
            }
            return cLanguageKind;
        }
        if (b == OBJ_C && a == CPP) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(12);
            }
            return cLanguageKind;
        }
        if (a == OBJ_C && b == OBJ_CPP) {
            CLanguageKind cLanguageKind = OBJ_C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(13);
            }
            return cLanguageKind;
        }
        if (b == OBJ_C && a == OBJ_CPP) {
            CLanguageKind cLanguageKind = OBJ_C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(14);
            }
            return cLanguageKind;
        }
        if (a == CPP && b == OBJ_CPP) {
            CLanguageKind cLanguageKind = CPP;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(15);
            }
            return cLanguageKind;
        }
        if (b == CPP && a == OBJ_CPP) {
            CLanguageKind cLanguageKind = CPP;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(16);
            }
            return cLanguageKind;
        }
        CLanguageKind cLanguageKind = a;
        if (cLanguageKind == null) {
            CLanguageKind.$$$reportNull$$$0(17);
        }
        return cLanguageKind;
    }

    @Override
    public boolean isCpp() {
        return this == CPP || this == OBJ_CPP;
    }

    @Override
    public boolean isObjC() {
        return this == OBJ_C || this == OBJ_CPP;
    }

    @Override
    public boolean conforms(@NotNull OCLanguageKind requiredKind) {
        if (requiredKind == null) {
            CLanguageKind.$$$reportNull$$$0(18);
        }
        return !(!this.isObjC() && requiredKind.isObjC() || !this.isCpp() && requiredKind.isCpp());
    }

    @Override
    @NotNull
    public String getDefaultSourceExtension() {
        String string = this.myDefaultSourceExtension;
        if (string == null) {
            CLanguageKind.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            CLanguageKind.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortDisplayName() {
        String string = this.myShortDisplayName;
        if (string == null) {
            CLanguageKind.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public boolean supportsPrecompiledHeaders() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortDisplayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/CLanguageKind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/CLanguageKind";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "maxLanguage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "min";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSourceExtension";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "conforms";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

