/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.NlsActions;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrProjectTaskContextProvider;
import com.jetbrains.cidr.execution.build.CidrBuildConfigurationProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J&\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0014J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0014J\u0012\u0010'\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010)H%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/execution/build/CidrAbstractBuildTargetAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "isIncrementalBuild", "", "title", "", "description", "icon", "Ljavax/swing/Icon;", "<init>", "(ZLjava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "runBuildTask", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTaskManager$Result;", "manager", "Lcom/intellij/task/ProjectTaskManager;", "context", "Lcom/intellij/task/ProjectTaskContext;", "task", "Lcom/intellij/task/ProjectTask;", "createBuildTask", "project", "Lcom/intellij/openapi/project/Project;", "buildableElements", "", "Lcom/intellij/openapi/roots/ProjectModelBuildableElement;", "isEnabled", "isVisible", "getBuildableElements", "createContext", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "buildText", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.cidr.execution"})
@SourceDebugExtension(value={"SMAP\nCidrAbstractBuildTargetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrAbstractBuildTargetAction.kt\ncom/jetbrains/cidr/execution/build/CidrAbstractBuildTargetAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n37#2,2:95\n1755#3,3:97\n1#4:100\n*S KotlinDebug\n*F\n+ 1 CidrAbstractBuildTargetAction.kt\ncom/jetbrains/cidr/execution/build/CidrAbstractBuildTargetAction\n*L\n64#1:95,2\n67#1:97,3\n*E\n"})
public abstract class CidrAbstractBuildTargetAction
extends DumbAwareAction {
    private final boolean isIncrementalBuild;

    public CidrAbstractBuildTargetAction(boolean isIncrementalBuild, @NlsActions.ActionText @Nullable String title, @NlsActions.ActionDescription @Nullable String description, @Nullable Icon icon) {
        super(title, description, icon);
        this.isIncrementalBuild = isIncrementalBuild;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean isEnabled = this.isEnabled(project);
        e.getPresentation().setVisible(this.isVisible(isEnabled));
        e.getPresentation().setEnabled(isEnabled);
        RunManager runManager = RunManager.Companion.getInstanceIfCreated(project);
        RunConfiguration configuration = runManager != null && (runManager = runManager.getSelectedConfiguration()) != null ? runManager.getConfiguration() : null;
        e.getPresentation().setText(this.buildText(configuration), false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List<ProjectModelBuildableElement> buildableElements = this.getBuildableElements(project2);
        if (buildableElements.isEmpty()) {
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ProjectTaskContext context = this.createContext(project2, dataContext);
        ProjectTaskManager manager = ProjectTaskManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)manager);
        this.runBuildTask(manager, context, this.createBuildTask(project2, manager, buildableElements));
    }

    @NotNull
    protected Promise<ProjectTaskManager.Result> runBuildTask(@NotNull ProjectTaskManager manager, @NotNull ProjectTaskContext context, @NotNull ProjectTask task2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Promise promise = manager.run(context, task2);
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"run(...)");
        return promise;
    }

    @NotNull
    protected ProjectTask createBuildTask(@NotNull Project project, @NotNull ProjectTaskManager manager, @NotNull List<? extends ProjectModelBuildableElement> buildableElements) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(buildableElements, (String)"buildableElements");
        Collection $this$toTypedArray$iv = buildableElements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProjectModelBuildableElement[] projectModelBuildableElementArray = thisCollection$iv.toArray(new ProjectModelBuildableElement[0]);
        ProjectTask projectTask = manager.createBuildTask(this.isIncrementalBuild, Arrays.copyOf(projectModelBuildableElementArray, projectModelBuildableElementArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)projectTask, (String)"createBuildTask(...)");
        return projectTask;
    }

    public boolean isEnabled(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$any$iv = CidrBuildConfigurationProvider.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CidrBuildConfigurationProvider it = (CidrBuildConfigurationProvider)element$iv;
                    boolean bl2 = false;
                    if (!(it.hasBuildableConfigurations(project) && (this.isIncrementalBuild || it.hasCleanableConfigurations(project)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isVisible(boolean isEnabled) {
        return true;
    }

    @NotNull
    protected List<ProjectModelBuildableElement> getBuildableElements(@NotNull Project project) {
        List<CidrBuildConfiguration> list;
        List<CidrBuildConfiguration> buildableConfigurations;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable iterable = CidrBuildConfigurationProvider.EP_NAME.getExtensionList();
            for (Object t : iterable) {
                CidrBuildConfigurationProvider it = (CidrBuildConfigurationProvider)t;
                boolean bl = false;
                if (!it.hasBuildableConfigurations(project)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        CidrBuildConfigurationProvider cidrBuildConfigurationProvider = v0;
        List<CidrBuildConfiguration> list2 = buildableConfigurations = cidrBuildConfigurationProvider != null && (list = cidrBuildConfigurationProvider.getBuildableConfigurations(project)) != null ? list : CollectionsKt.emptyList();
        if (buildableConfigurations.isEmpty()) {
            new EditConfigurationsDialog(project).show();
        }
        return buildableConfigurations;
    }

    @NotNull
    protected ProjectTaskContext createContext(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return CidrProjectTaskContextProvider.Companion.createContext(project, dataContext);
    }

    @Nls
    @NotNull
    protected abstract String buildText(@Nullable RunConfiguration var1);
}

