/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PredefinedVariables {
    public static final String JETBRAINS_IDE = "JETBRAINS_IDE";

    @NotNull
    @NlsSafe
    public static List<String> getIDEVariables() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        if (applicationInfo == null) {
            List<String> list = Collections.singletonList(JETBRAINS_IDE);
            if (list == null) {
                PredefinedVariables.$$$reportNull$$$0(0);
            }
            return list;
        }
        @NlsSafe String ideName = (StringUtil.toUpperCase((String)ApplicationNamesInfo.getInstance().getProductName()) + "_IDE").replaceAll("\\W", "_");
        List<String> list = List.of(JETBRAINS_IDE, ideName);
        if (list == null) {
            PredefinedVariables.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    @NlsSafe
    public static String getVersionNumber() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        if (applicationInfo == null || ApplicationManager.getApplication().isUnitTestMode()) {
            String string = PredefinedVariables.toVersionNumber("2017.1");
            if (string == null) {
                PredefinedVariables.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PredefinedVariables.toVersionNumber(applicationInfo.getFullVersion());
        if (string == null) {
            PredefinedVariables.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NlsSafe
    static String toVersionNumber(@NlsSafe @NotNull String version) {
        if (version == null) {
            PredefinedVariables.$$$reportNull$$$0(4);
        }
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(version.split("\\D")));
        while (parts.size() < 3) {
            parts.add("00");
        }
        Object major = (String)parts.get(0);
        Object minor = (String)parts.get(1);
        Object bugfix = (String)parts.get(2);
        if (((String)major).length() < 4) {
            major = StringUtil.repeat((String)"0", (int)(4 - ((String)major).length())) + (String)major;
        }
        if (((String)minor).length() < 2) {
            minor = StringUtil.repeat((String)"0", (int)(2 - ((String)minor).length())) + (String)minor;
        }
        if (((String)bugfix).length() < 2) {
            bugfix = StringUtil.repeat((String)"0", (int)(2 - ((String)bugfix).length())) + (String)bugfix;
        }
        return (String)major + (String)minor + (String)bugfix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/PredefinedVariables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIDEVariables";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionNumber";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/PredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toVersionNumber";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }
}

