/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.nio;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.util.execution.ParametersListUtil;
import com.pastdev.jsch.IOUtils;
import com.pastdev.jsch.command.CommandRunner;
import com.pastdev.jsch.nio.file.UnixSshFileSystem;
import com.pastdev.jsch.nio.file.UnixSshFileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

class UnixSshFileSysProviderInternal
extends UnixSshFileSystemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.ssh.nio");
    private static final int MAX_REMOTE_FS_CONNECT_TIMEOUT = StringUtil.parseInt((String)System.getProperty("ssh.nio.connection.timeout"), (int)4000);
    private static final int MAX_REMOTE_FS_COMMAND_TIMEOUT = StringUtil.parseInt((String)System.getProperty("ssh.nio.command.timeout"), (int)30000);
    private static final long REMOTE_PROCESS_CLOSE_TIMEOUT = StringUtil.parseLong((String)System.getProperty("ssh.nio.process.close.timeout"), (long)60000L);
    private final RemoteCredentials myCredentials;
    private final SshCommandRunner myCommandRunner;

    UnixSshFileSysProviderInternal(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            UnixSshFileSysProviderInternal.$$$reportNull$$$0(0);
        }
        this.myCredentials = credentials;
        this.myCommandRunner = new SshCommandRunner();
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> environment) throws IOException {
        try {
            String path = "ssh://" + Ssh.wrapIPv6Address((String)this.myCredentials.getHost()) + ":" + this.myCredentials.getPort() + "/";
            uri = new URI(path);
            UnixSshFileSystem fs = (UnixSshFileSystem)super.newFileSystem(uri, environment);
            fs.setCommandRunner(this.myCommandRunner);
            if (LOG.isDebugEnabled()) {
                LOG.debug("UnixSshFS was created: connection timeout = " + MAX_REMOTE_FS_CONNECT_TIMEOUT + ", command timeout = " + MAX_REMOTE_FS_COMMAND_TIMEOUT);
            }
            return fs;
        }
        catch (URISyntaxException e) {
            LOG.warn("UnixSshFS", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/ssh/nio/UnixSshFileSysProviderInternal", "<init>"));
    }

    private class SshCommandRunner
    extends CommandRunner {
        private SshCommandRunner() {
        }

        @Override
        public void close() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("UnixSshFS:: SshCommandRunner.close");
            }
        }

        @Override
        public CommandRunner duplicate() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("UnixSshFS:: SshCommandRunner.duplicate");
            }
            return new SshCommandRunner();
        }

        @Override
        public CommandRunner.ExecuteResult execute(String command) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("UnixSshFS:: SshCommandRunner.execute: " + command);
            }
            GeneralCommandLine cmd = SshCommandRunner.createCommandLine(command);
            ProcessOutput processOutput = this.runRemoteProcess(cmd, UnixSshFileSysProviderInternal.this.myCredentials);
            if (LOG.isDebugEnabled()) {
                processOutput.checkSuccess(LOG);
            }
            return new CommandRunner.ExecuteResult(processOutput.getExitCode(), processOutput.getStdout().trim(), processOutput.getStderr().trim());
        }

        @NotNull
        private static GeneralCommandLine createCommandLine(final @NotNull String command) {
            if (command == null) {
                SshCommandRunner.$$$reportNull$$$0(0);
            }
            List cmdArgs = ParametersListUtil.parse((String)command);
            GeneralCommandLine cmd = new GeneralCommandLine(cmdArgs){

                @NotNull
                public String getCommandLineString() {
                    String string = command;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ssh/nio/UnixSshFileSysProviderInternal$SshCommandRunner$1", "getCommandLineString"));
                }
            };
            Ssh.doNotEscapeArgs((GeneralCommandLine)cmd);
            cmd.getEnvironment().put("LC_ALL", "C");
            GeneralCommandLine generalCommandLine = cmd;
            if (generalCommandLine == null) {
                SshCommandRunner.$$$reportNull$$$0(1);
            }
            return generalCommandLine;
        }

        @NotNull
        private ProcessOutput runRemoteProcess(@NotNull GeneralCommandLine cmd, @NotNull RemoteCredentials credentials) throws IOException {
            ProcessOutput processOutput;
            if (cmd == null) {
                SshCommandRunner.$$$reportNull$$$0(2);
            }
            if (credentials == null) {
                SshCommandRunner.$$$reportNull$$$0(3);
            }
            try {
                SshExecProcess process = this.startRemoteProcess(cmd, credentials);
                CapturingSshProcessHandler handler = new CapturingSshProcessHandler((SshProcess)process, cmd.getCharset(), cmd.getCommandLineString());
                processOutput = new CapturingProcessRunner((BaseProcessHandler)handler).runProcess(MAX_REMOTE_FS_COMMAND_TIMEOUT);
            }
            catch (Exception e) {
                LOG.warn("UnixSshFS:: SshCommandRunner.runRemoteProcess: " + cmd.getCommandLineString(), (Throwable)e);
                throw new IOException(e);
            }
            if (processOutput == null) {
                SshCommandRunner.$$$reportNull$$$0(4);
            }
            return processOutput;
        }

        @Override
        public CommandRunner.ChannelExecWrapper open(final String command) throws IOException {
            SshExecProcess process;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("UnixSshFS:: SshCommandRunner.open: " + command);
                }
                GeneralCommandLine cmd = SshCommandRunner.createCommandLine(command);
                process = this.startRemoteProcess(cmd, UnixSshFileSysProviderInternal.this.myCredentials);
            }
            catch (Exception e) {
                LOG.warn("UnixSshFS:: SshCommandRunner.open: " + command, (Throwable)e);
                throw new IOException(e);
            }
            final InputStream errorStream = process.getErrorStream();
            final InputStream inputStream = process.getInputStream();
            final OutputStream outputStream = process.getOutputStream();
            return new CommandRunner.ChannelExecWrapper(){

                @Override
                public int close() {
                    try {
                        IOUtils.closeAndLogException(errorStream);
                        IOUtils.closeAndLogException(inputStream);
                        IOUtils.closeAndLogException(outputStream);
                        if (!process.isDisconnected()) {
                            process.waitFor(REMOTE_PROCESS_CLOSE_TIMEOUT, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException e) {
                        process.killProcessTree();
                        LOG.warn("UnixSshFS:: ChannelExecWrapper.close", (Throwable)e);
                    }
                    finally {
                        if (!process.isDisconnected()) {
                            LOG.warn("UnixSshFS:: process is still alive: " + command);
                        }
                        process.destroy();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("UnixSshFS:: ChannelExecWrapper.close: ", new Object[]{process.exitValue()});
                    }
                    return process.exitValue();
                }

                @Override
                public InputStream getErrStream() throws IOException {
                    return errorStream;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return inputStream;
                }

                @Override
                public OutputStream getOutputStream() throws IOException {
                    return outputStream;
                }
            };
        }

        @NotNull
        private static ConnectionBuilder createConnectionBuilder(@NotNull RemoteCredentials credentials) {
            if (credentials == null) {
                SshCommandRunner.$$$reportNull$$$0(5);
            }
            boolean allowDialogs = false;
            ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, null, null, (boolean)false);
            if (connectionBuilder == null) {
                SshCommandRunner.$$$reportNull$$$0(6);
            }
            return connectionBuilder;
        }

        @NotNull
        private SshExecProcess startRemoteProcess(@NotNull GeneralCommandLine cmd, @NotNull RemoteCredentials credentials) {
            if (cmd == null) {
                SshCommandRunner.$$$reportNull$$$0(7);
            }
            if (credentials == null) {
                SshCommandRunner.$$$reportNull$$$0(8);
            }
            ConnectionBuilder connectionBuilder = SshCommandRunner.createConnectionBuilder(credentials).withConnectionTimeout((long)MAX_REMOTE_FS_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
            SshExecProcess sshExecProcess = SshCommandRunner.startProcess(() -> RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)cmd).withAllocatePty(false).withChangeDir(false).start());
            if (sshExecProcess == null) {
                SshCommandRunner.$$$reportNull$$$0(9);
            }
            return sshExecProcess;
        }

        private static SshExecProcess startProcess(final @NotNull Supplier<? extends SshExecProcess> processBuilder) {
            if (processBuilder == null) {
                SshCommandRunner.$$$reportNull$$$0(10);
            }
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return processBuilder.get();
            }
            return (SshExecProcess)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<SshExecProcess, RuntimeException>(null, SshBundle.message((String)"remote.process.start", (Object[])new Object[0]), true){

                protected SshExecProcess compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return (SshExecProcess)processBuilder.get();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ssh/nio/UnixSshFileSysProviderInternal$SshCommandRunner$3", "compute"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/nio/UnixSshFileSysProviderInternal$SshCommandRunner";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmd";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/nio/UnixSshFileSysProviderInternal$SshCommandRunner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommandLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runRemoteProcess";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConnectionBuilder";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startRemoteProcess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createCommandLine";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runRemoteProcess";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createConnectionBuilder";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "startRemoteProcess";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "startProcess";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 6, 9 -> new IllegalStateException(string);
            };
        }
    }
}

