/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.GasFileDirective;
import com.intellij.cidr.translateCode.GasLocDirective;
import com.intellij.cidr.translateCode.UtilKt;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/cidr/translateCode/GasLocationTracker;", "", "srcFilePath", "", "<init>", "(Ljava/lang/String;)V", "srcFileNos", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "matchingPaths", "", "", "processFileDirective", "", "fileDirective", "Lcom/intellij/cidr/translateCode/GasFileDirective;", "isSourceFileLocation", "loc", "Lcom/intellij/cidr/translateCode/GasLocDirective;", "intellij.cidr.translateCode"})
public final class GasLocationTracker {
    @NotNull
    private final String srcFilePath;
    @NotNull
    private final HashSet<Integer> srcFileNos;
    @NotNull
    private final Map<String, Boolean> matchingPaths;

    public GasLocationTracker(@NotNull String srcFilePath) {
        Intrinsics.checkNotNullParameter((Object)srcFilePath, (String)"srcFilePath");
        this.srcFilePath = srcFilePath;
        this.srcFileNos = new HashSet();
        this.matchingPaths = new LinkedHashMap();
    }

    public final void processFileDirective(@NotNull GasFileDirective fileDirective) {
        Intrinsics.checkNotNullParameter((Object)fileDirective, (String)"fileDirective");
        if (fileDirective.getFile() == null) {
            return;
        }
        if (fileDirective.getPath2() == null) {
            Boolean bl = this.matchingPaths.computeIfAbsent(fileDirective.getPath1(), arg_0 -> GasLocationTracker.processFileDirective$lambda$1(arg_0 -> GasLocationTracker.processFileDirective$lambda$0(this, fileDirective, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
            boolean matchesSrcFile = bl;
            if (matchesSrcFile) {
                this.srcFileNos.add(fileDirective.getFile());
            }
        } else {
            Path path;
            Path path2 = UtilKt.pathOrNull(fileDirective.getPath2(), new String[0]);
            if (path2 == null) {
                return;
            }
            Path path22 = path2;
            if (path22.isAbsolute()) {
                path = path22;
            } else {
                String[] stringArray = new String[]{fileDirective.getPath2()};
                path = UtilKt.pathOrNull(fileDirective.getPath1(), stringArray);
                if (path == null) {
                    return;
                }
            }
            Path combinedPath = path;
            Boolean bl = this.matchingPaths.computeIfAbsent(((Object)combinedPath).toString(), arg_0 -> GasLocationTracker.processFileDirective$lambda$3(arg_0 -> GasLocationTracker.processFileDirective$lambda$2(this, combinedPath, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
            boolean matchesSrcFile = bl;
            if (matchesSrcFile) {
                this.srcFileNos.add(fileDirective.getFile());
            }
        }
    }

    public final boolean isSourceFileLocation(@NotNull GasLocDirective loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        return this.srcFileNos.contains(loc.getFile());
    }

    private static final Boolean processFileDirective$lambda$0(GasLocationTracker this$0, GasFileDirective $fileDirective, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilKt.isSameFile(this$0.srcFilePath, $fileDirective.getPath1());
    }

    private static final Boolean processFileDirective$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean processFileDirective$lambda$2(GasLocationTracker this$0, Path $combinedPath, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilKt.isSameFile(this$0.srcFilePath, ((Object)$combinedPath).toString());
    }

    private static final Boolean processFileDirective$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

