/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.cidr.translateCode.CidrTranslationResultBuilder;
import com.intellij.cidr.translateCode.Gas;
import com.intellij.cidr.translateCode.GasAsmLineProcessor;
import com.intellij.cidr.translateCode.GasFileDirective;
import com.intellij.cidr.translateCode.GasLocDirective;
import com.intellij.cidr.translateCode.GasLocationTracker;
import com.intellij.cidr.translateCode.GasSectionDirective;
import com.intellij.cidr.translateCode.MangledNameIterator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.system.CpuArch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0017\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020 0'0&H\u0002J\u001a\u0010)\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\n\u0010-\u001a\u0004\u0018\u00010,H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020(H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0012j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/cidr/translateCode/GasAsm;", "", "asm", "", "srcFilePath", "raw", "", "isRemoteToolchain", "stripComments", "demangledNames", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZZZLjava/util/Map;)V", "asmLines", "", "noCommentLineLength", "", "labels", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "comment", "isUsedLabel", "label", "processLines", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "builder", "Lcom/intellij/cidr/translateCode/CidrTranslationResultBuilder;", "", "processor", "Lcom/intellij/cidr/translateCode/GasAsmLineProcessor;", "demangleLine", "line", "", "shouldSkipSection", "(Ljava/lang/CharSequence;)Ljava/lang/Boolean;", "section", "Lcom/intellij/cidr/translateCode/GasSectionDirective;", "linesWithoutComments", "", "Lkotlin/Pair;", "", "commentStartOrLength", "detectCommentStartToken", "detectArch", "Lcom/intellij/util/system/CpuArch;", "detectArchFromDirective", "lookaheadLocDirective", "Lcom/intellij/cidr/translateCode/GasLocDirective;", "startLineIdx", "intellij.cidr.translateCode"})
@SourceDebugExtension(value={"SMAP\nGas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gas.kt\ncom/intellij/cidr/translateCode/GasAsm\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,580:1\n1567#2:581\n1598#2,4:582\n*S KotlinDebug\n*F\n+ 1 Gas.kt\ncom/intellij/cidr/translateCode/GasAsm\n*L\n413#1:581\n413#1:582,4\n*E\n"})
public final class GasAsm {
    @NotNull
    private final String srcFilePath;
    private final boolean raw;
    private final boolean isRemoteToolchain;
    @NotNull
    private final Map<String, String> demangledNames;
    @NotNull
    private final List<String> asmLines;
    @NotNull
    private final int[] noCommentLineLength;
    @NotNull
    private final HashMap<String, Boolean> labels;
    @Nullable
    private final String comment;

    public GasAsm(@NotNull String asm, @NotNull String srcFilePath, boolean raw, boolean isRemoteToolchain, boolean stripComments, @NotNull Map<String, String> demangledNames) {
        Intrinsics.checkNotNullParameter((Object)asm, (String)"asm");
        Intrinsics.checkNotNullParameter((Object)srcFilePath, (String)"srcFilePath");
        Intrinsics.checkNotNullParameter(demangledNames, (String)"demangledNames");
        this.srcFilePath = srcFilePath;
        this.raw = raw;
        this.isRemoteToolchain = isRemoteToolchain;
        this.demangledNames = demangledNames;
        this.asmLines = StringsKt.lines((CharSequence)asm);
        this.noCommentLineLength = new int[this.asmLines.size()];
        this.labels = new HashMap();
        this.comment = !this.raw && stripComments ? this.detectCommentStartToken() : null;
        Iterator iterator = ((Iterable)this.asmLines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String line = (String)iterator.next();
            this.noCommentLineLength[i] = this.commentStartOrLength(line, this.comment);
            String labelName = Gas.Companion.getLabelName(StringsKt.subSequence((CharSequence)line, (IntRange)RangesKt.until((int)0, (int)this.noCommentLineLength[i])));
            if (labelName == null) continue;
            ((Map)this.labels).put(labelName, false);
        }
        boolean skipSection = false;
        ArrayList labelRefs = new ArrayList();
        Iterator<Pair<Integer, CharSequence>> iterator2 = this.linesWithoutComments().iterator();
        while (iterator2.hasNext()) {
            Iterator iterator3;
            String labelName;
            CharSequence line = (CharSequence)iterator2.next().component2();
            if (!this.raw) {
                Boolean bl = this.shouldSkipSection(line);
                if (bl != null) {
                    boolean it = bl;
                    boolean bl2 = false;
                    skipSection = it;
                }
            }
            if (skipSection || (labelName = Gas.Companion.getLabelName(line)) != null) continue;
            labelRefs.clear();
            Gas.Companion.possibleLabelRefs(line, labelRefs);
            Intrinsics.checkNotNullExpressionValue(labelRefs.iterator(), (String)"iterator(...)");
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String ref = (String)e;
                if (!Intrinsics.areEqual((Object)this.labels.get(ref), (Object)false)) continue;
                ((Map)this.labels).put(ref, true);
            }
        }
    }

    public /* synthetic */ GasAsm(String string, String string2, boolean bl, boolean bl2, boolean bl3, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            map = new HashMap();
        }
        this(string, string2, bl, bl2, bl3, map);
    }

    private final boolean isUsedLabel(String label) {
        return Intrinsics.areEqual((Object)this.labels.get(label), (Object)true);
    }

    @NotNull
    public final CidrTranslationResult processLines(@NotNull CidrTranslationResultBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.processLines(new GasAsmLineProcessor(builder){
            final /* synthetic */ CidrTranslationResultBuilder $builder;
            {
                this.$builder = $builder;
            }

            public void processSrcFileLineMark(int line) {
                this.$builder.markSrcLine(line);
            }

            public void processForeignFileLineMark() {
                this.$builder.resetSrcLine();
            }

            public void processLine(String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                this.$builder.addTranslatedCodeLine(line);
            }
        });
        return builder.build();
    }

    public final void processLines(@NotNull GasAsmLineProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        boolean skipSection = false;
        GasLocationTracker locationTracker = new GasLocationTracker(this.srcFilePath);
        boolean isInSrcFile = false;
        for (Pair<Integer, CharSequence> pair : this.linesWithoutComments()) {
            GasLocDirective locDirective;
            int idx = ((Number)pair.component1()).intValue();
            CharSequence line = (CharSequence)pair.component2();
            GasFileDirective fileDirective = Gas.Companion.parseFileDirective(line);
            if (fileDirective != null) {
                locationTracker.processFileDirective(fileDirective);
                if (!this.raw) continue;
            }
            if ((locDirective = Gas.Companion.parseLocDirective(line)) != null) {
                if (locationTracker.isSourceFileLocation(locDirective)) {
                    isInSrcFile = true;
                    processor.processSrcFileLineMark(locDirective.getLine());
                } else {
                    isInSrcFile = false;
                    processor.processForeignFileLineMark();
                }
                if (!this.raw) continue;
            }
            Boolean bl = this.shouldSkipSection(line);
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                skipSection = it;
            }
            if (!this.raw) {
                if (skipSection || StringsKt.isBlank((CharSequence)line) || Gas.Companion.isDirectiveToSkip(line)) continue;
                String labelName = Gas.Companion.getLabelName(line);
                if (labelName != null) {
                    if (!this.isUsedLabel(labelName)) continue;
                    if (!Gas.Companion.isLocalLabelName(labelName)) {
                        GasLocDirective loc;
                        if (isInSrcFile && (loc = this.lookaheadLocDirective(idx + 1)) != null) {
                            processor.processForeignFileLineMark();
                        }
                        processor.processLine("");
                    }
                }
            }
            processor.processLine(this.demangleLine(line));
        }
    }

    private final String demangleLine(CharSequence line) {
        StringBuilder result2 = new StringBuilder();
        int idx = 0;
        MangledNameIterator iter = new MangledNameIterator(line);
        while (true) {
            IntRange mangledNameRange;
            if ((mangledNameRange = iter.getNextMangledNameRange()) == null) break;
            result2.append(line, idx, (int)mangledNameRange.getStart());
            String mangledName = ((Object)line.subSequence(mangledNameRange.getFirst(), mangledNameRange.getLast())).toString();
            String demangled = this.demangledNames.get(mangledName);
            String string = demangled;
            if (string == null) {
                string = mangledName;
            }
            result2.append(string);
            idx = mangledNameRange.getEndInclusive();
        }
        result2.append(line, idx, line.length());
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Boolean shouldSkipSection(CharSequence line) {
        GasSectionDirective sectionDirective = Gas.Companion.parseSectionDirective(line);
        if (sectionDirective != null) {
            return this.shouldSkipSection(sectionDirective);
        }
        CharSequence trimmed = StringsKt.trim((CharSequence)line);
        if (StringsKt.startsWith$default((CharSequence)trimmed, (CharSequence)".text", (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)trimmed, (CharSequence)".data", (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)trimmed, (CharSequence)".rodata", (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)trimmed, (CharSequence)".bss", (boolean)false, (int)2, null)) {
            return false;
        }
        return null;
    }

    private final boolean shouldSkipSection(GasSectionDirective section) {
        return section.isDebugSection() || section.isExceptionSection();
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<Pair<Integer, CharSequence>> linesWithoutComments() {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.asmLines;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void line;
            void idx;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)((int)idx), (Object)StringsKt.subSequence((CharSequence)((CharSequence)line), (IntRange)RangesKt.until((int)0, (int)this.noCommentLineLength[idx]))));
        }
        return (List)destination$iv$iv;
    }

    private final int commentStartOrLength(String line, String comment) {
        if (comment == null) {
            return line.length();
        }
        int commentStart = StringsKt.indexOf$default((CharSequence)line, (String)comment, (int)0, (boolean)false, (int)6, null);
        if (commentStart != -1) {
            return commentStart;
        }
        return line.length();
    }

    private final String detectCommentStartToken() {
        CpuArch arch;
        CpuArch cpuArch = arch = this.detectArch();
        return switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1, 2 -> "#";
            case 3, 4 -> {
                if (this.isRemoteToolchain) {
                    yield null;
                }
                if (SystemInfo.isMac) {
                    yield ";";
                }
                if (SystemInfo.isLinux) {
                    yield "//";
                }
                yield null;
            }
            default -> null;
        };
    }

    private final CpuArch detectArch() {
        CpuArch arch = this.detectArchFromDirective();
        if (arch != null) {
            return arch;
        }
        if (!this.isRemoteToolchain) {
            return CpuArch.CURRENT;
        }
        return null;
    }

    private final CpuArch detectArchFromDirective() {
        String line;
        String trimmed;
        Iterator<String> iterator = this.asmLines.iterator();
        while (iterator.hasNext() && !StringsKt.startsWith$default((String)(trimmed = ((Object)StringsKt.trim((CharSequence)(line = iterator.next()))).toString()), (String)".text", (boolean)false, (int)2, null)) {
            String arch = Gas.Companion.parseArchDirective(trimmed);
            if (arch == null) continue;
            if (StringsKt.contains$default((CharSequence)arch, (CharSequence)"arm", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)arch, (CharSequence)"iwmmxt", (boolean)false, (int)2, null)) {
                return CpuArch.ARM64;
            }
            if (!Gas.Companion.getX86Arches().contains(arch)) break;
            return CpuArch.X86_64;
        }
        return null;
    }

    private final GasLocDirective lookaheadLocDirective(int startLineIdx) {
        int n = this.asmLines.size();
        for (int idx = startLineIdx; idx < n; ++idx) {
            CharSequence line = StringsKt.trimStart((CharSequence)StringsKt.subSequence((CharSequence)this.asmLines.get(idx), (IntRange)RangesKt.until((int)0, (int)this.noCommentLineLength[idx])));
            if (StringsKt.isBlank((CharSequence)line) || Gas.Companion.getLabelName(line) != null) continue;
            if (!StringsKt.startsWith$default((CharSequence)line, (CharSequence)".", (boolean)false, (int)2, null)) break;
            GasLocDirective locDirective = Gas.Companion.parseLocDirective(line);
            if (locDirective == null) continue;
            return locDirective;
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.X86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

