/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.CidrTranslatedCodeBlock;
import com.intellij.cidr.translateCode.CidrTranslationCommand;
import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BR\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012#\b\u0002\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/cidr/translateCode/CidrTranslationResultBuilder;", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "command", "Lcom/intellij/cidr/translateCode/CidrTranslationCommand;", "options", "", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "fileSetup", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/ParameterName;", "name", "file", "", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/cidr/translateCode/CidrTranslationCommand;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "translatedCode", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "lineMapping", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "currentSrcLine1", "", "maxSrcLine1", "addTranslatedCodeLine", "translatedLine", "resetSrcLine", "markSrcLine", "srcLine1", "build", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "intellij.cidr.translateCode"})
public final class CidrTranslationResultBuilder {
    @NotNull
    private final FileType fileType;
    @Nullable
    private final CidrTranslationCommand command;
    @NotNull
    private final List<ToggleAction> options;
    @NotNull
    private final Function1<VirtualFile, Unit> fileSetup;
    @NotNull
    private final ArrayList<String> translatedCode;
    @NotNull
    private final IntArrayList lineMapping;
    private int currentSrcLine1;
    private int maxSrcLine1;

    public CidrTranslationResultBuilder(@NotNull FileType fileType, @Nullable CidrTranslationCommand command, @NotNull List<? extends ToggleAction> options, @NotNull Function1<? super VirtualFile, Unit> fileSetup) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(fileSetup, (String)"fileSetup");
        this.fileType = fileType;
        this.command = command;
        this.options = options;
        this.fileSetup = fileSetup;
        this.translatedCode = new ArrayList();
        this.lineMapping = new IntArrayList();
    }

    public /* synthetic */ CidrTranslationResultBuilder(FileType fileType, CidrTranslationCommand cidrTranslationCommand, List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileType = (FileType)FileTypes.PLAIN_TEXT;
        }
        if ((n & 2) != 0) {
            cidrTranslationCommand = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            function1 = CidrTranslationResultBuilder::_init_$lambda$0;
        }
        this(fileType, cidrTranslationCommand, list, (Function1<? super VirtualFile, Unit>)function1);
    }

    public final void addTranslatedCodeLine(@NotNull String translatedLine) {
        Intrinsics.checkNotNullParameter((Object)translatedLine, (String)"translatedLine");
        this.translatedCode.add(translatedLine);
        this.lineMapping.add(this.currentSrcLine1);
    }

    public final void resetSrcLine() {
        this.currentSrcLine1 = 0;
    }

    public final void markSrcLine(int srcLine1) {
        if (!(srcLine1 > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentSrcLine1 = srcLine1;
        this.maxSrcLine1 = Math.max(srcLine1, this.maxSrcLine1);
    }

    @NotNull
    public final CidrTranslationResult build() {
        ArrayList transRanges;
        int n;
        int n2 = 0;
        int n3 = this.maxSrcLine1 + 1;
        ArrayList[] arrayListArray = new ArrayList[n3];
        while (n2 < n3) {
            n = n2++;
            arrayListArray[n] = new ArrayList();
        }
        ArrayList[] srcLine1ToTranslatedRanges = arrayListArray;
        int transLine0 = 0;
        while (transLine0 < this.lineMapping.size()) {
            int srcLine1 = this.lineMapping.getInt(transLine0);
            if (srcLine1 > 0) {
                boolean bl;
                int transEnd0;
                int transStart0 = transLine0;
                for (transEnd0 = transStart0 + 1; transEnd0 < this.lineMapping.size() && this.lineMapping.getInt(transEnd0) == srcLine1; ++transEnd0) {
                }
                transLine0 = transEnd0;
                transRanges = srcLine1ToTranslatedRanges[srcLine1];
                IntRange lastRange = (IntRange)CollectionsKt.lastOrNull((List)transRanges);
                if (lastRange != null && lastRange.getLast() == transStart0) {
                    CollectionsKt.removeLast((List)transRanges);
                    bl = transRanges.add(new IntRange(lastRange.getFirst(), transEnd0));
                    continue;
                }
                bl = transRanges.add(new IntRange(transStart0, transEnd0));
                continue;
            }
            ++transLine0;
        }
        ArrayList<CidrTranslatedCodeBlock> blocks = new ArrayList<CidrTranslatedCodeBlock>();
        n = srcLine1ToTranslatedRanges.length;
        for (int srcLine1 = 0; srcLine1 < n; ++srcLine1) {
            transRanges = srcLine1ToTranslatedRanges[srcLine1];
            if (!(!((Collection)transRanges).isEmpty())) continue;
            blocks.add(new CidrTranslatedCodeBlock(new IntRange(srcLine1 - 1, srcLine1), transRanges));
        }
        String text = CollectionsKt.joinToString$default((Iterable)this.translatedCode, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return new CidrTranslationResult(text, this.fileType, (List<CidrTranslatedCodeBlock>)blocks, this.command, this.options, this.fileSetup);
    }

    private static final Unit _init_$lambda$0(VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    public CidrTranslationResultBuilder() {
        this(null, null, null, null, 15, null);
    }
}

