/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer._OCLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class OCLexer
extends FlexAdapter {
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION1 = _OCLexer.FLEX_JIT_ERROR_GUARD1;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION2 = _OCLexer.FLEX_JIT_ERROR_GUARD2;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION3 = _OCLexer.FLEX_JIT_ERROR_GUARD3;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION_ = _OCLexer.FLEX_ERROR;
    public static final int INITIAL = 0;
    public static final int INITIAL_INSIDE_LINE = 1024;
    public static final int DIRECTIVE_BODY_STATE = 8;
    public static final int PRAGMA_BODY_STATE = 12;
    public static final int INCLUDE_BODY_STATE = 10;
    public static final int MAX_RAW_STRING_PREFIX_LENGTH = 16;
    @NotNull
    private final CidrTokenTypeProvider myTokenTypeProvider;

    public OCLexer(@NotNull CidrLexerSettings settings) {
        if (settings == null) {
            OCLexer.$$$reportNull$$$0(0);
        }
        super((FlexLexer)new _OCLexer(null){

            @Override
            public void reset(CharSequence buffer, int start, int end, int initialState) {
                boolean isInsideLine = initialState == 1024;
                super.reset(buffer, start, end, isInsideLine ? 0 : initialState);
                this.myLogicalLineStartOffset = isInsideLine ? -1 : start;
            }
        });
        _OCLexer base = (_OCLexer)this.getFlex();
        base.setTokenTypeProvider(settings.getTokenTypeProvider());
        this.myTokenTypeProvider = settings.getTokenTypeProvider();
        if (settings.getLanguageKind().isCpp()) {
            base.allowCPPKeywords();
        }
        if (settings.getLanguageKind().isCuda()) {
            base.allowCUDAKeywords();
        }
        if (settings.getLanguageKind().isObjC()) {
            base.allowObjCKeywords();
        }
        if (settings.getAllowNullabilityKeywords()) {
            base.allowNullabilityKeywords();
        }
        if (settings.getAllowNullabilityNullableResultKeywords()) {
            base.allowNullabilityNullableResultKeywords();
        }
        if (settings.getAllowGccAutoType()) {
            base.allowGccAutoType();
        }
        if (settings.getAllowAvailabilityExpression()) {
            base.allowAvailabilityExpression();
        }
        if (settings.getAllowMsvcExtensions()) {
            base.allowMsvcExtensions();
        }
        if (settings.getAllowRiderMsvcExtensions()) {
            base.allowRiderMsvcExtensions();
        }
        base.setLanguageStandard(settings.getLanguageLevel());
        if (settings.getTreatCppAltOpsAsKeywords()) {
            base.forHighlighting();
        }
    }

    @NotNull
    public CidrTokenTypeProvider getTokenTypeProvider() {
        CidrTokenTypeProvider cidrTokenTypeProvider = this.myTokenTypeProvider;
        if (cidrTokenTypeProvider == null) {
            OCLexer.$$$reportNull$$$0(1);
        }
        return cidrTokenTypeProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/cpp/lexer/OCLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/cpp/lexer/OCLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

