/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrLexerUtils {
    public static int indexOf(CharSequence source, CharSequence model) {
        return CidrLexerUtils.indexOf(source, model, 0);
    }

    public static int indexOf(CharSequence source, CharSequence model, int fromSourceIndex) {
        return CidrLexerUtils.indexOf(source, 0, source.length(), model, 0, model.length(), fromSourceIndex);
    }

    static int indexOf(CharSequence source, int sourceOffset, int sourceLength, CharSequence model, int modelOffset, int modelLength, int fromSourceIndex) {
        if (fromSourceIndex >= sourceLength) {
            return modelLength == 0 ? sourceLength : -1;
        }
        if (fromSourceIndex < 0) {
            fromSourceIndex = 0;
        }
        if (modelLength == 0) {
            return fromSourceIndex;
        }
        char first = model.charAt(modelOffset);
        int maxSourceOffset = sourceOffset + (sourceLength - modelLength);
        for (int i = sourceOffset + fromSourceIndex; i <= maxSourceOffset; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= maxSourceOffset && source.charAt(i) != first) {
                }
            }
            if (i > maxSourceOffset) continue;
            int j = i + 1;
            int end = j + modelLength - 1;
            int k = modelOffset + 1;
            while (j < end && source.charAt(j) == model.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    @Nullable
    public static IElementType goToNextSignificantToken(@NotNull OCLexer lexer) {
        if (lexer == null) {
            CidrLexerUtils.$$$reportNull$$$0(0);
        }
        lexer.advance();
        while (!CidrLexerUtils.isAtSignificantToken(lexer)) {
            lexer.advance();
        }
        return lexer.getTokenType();
    }

    public static boolean isAtSignificantToken(@NotNull OCLexer lexer) {
        if (lexer == null) {
            CidrLexerUtils.$$$reportNull$$$0(1);
        }
        CidrTokenTypeProvider tokensProvider = lexer.getTokenTypeProvider();
        IElementType tt = lexer.getTokenType();
        return !tokensProvider.getWhitespaces().contains(tt) && !tokensProvider.getComments().contains(tt);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "lexer";
        objectArray2[1] = "com/intellij/cidr/cpp/lexer/CidrLexerUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "goToNextSignificantToken";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtSignificantToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

