/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.asm.debugger;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.lang.asm.psi.AsmFile;
import com.jetbrains.cidr.lang.asm.psi.AsmGdbSymbol;
import com.jetbrains.cidr.lang.asm.psi.AsmInstruction;
import com.jetbrains.cidr.lang.asm.psi.AsmTypes;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class CidrAsmEvaluator
extends CidrEvaluator {
    public CidrAsmEvaluator(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrAsmEvaluator.$$$reportNull$$$0(0);
        }
        super(frame);
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            CidrAsmEvaluator.$$$reportNull$$$0(1);
        }
        if (document == null) {
            CidrAsmEvaluator.$$$reportNull$$$0(2);
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> this.getExpressionInfoAtOffset(project, document, offset, sideEffectsAllowed)).withDocumentsCommitted(project).submit((Executor)AppExecutorUtil.getAppExecutorService());
        if (cancellablePromise == null) {
            CidrAsmEvaluator.$$$reportNull$$$0(3);
        }
        return cancellablePromise;
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        PsiFile file;
        if (project == null) {
            CidrAsmEvaluator.$$$reportNull$$$0(4);
        }
        if (document == null) {
            CidrAsmEvaluator.$$$reportNull$$$0(5);
        }
        if (!((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) instanceof AsmFile)) {
            return null;
        }
        for (PsiElement at = file.findElementAt(offset); at != null; at = at.getParent()) {
            ASTNode node = at.getNode();
            if (node != null && node.getElementType() == AsmTypes.IDENTIFIER) {
                return CidrAsmEvaluator.isInGdbSymbol(at) ? null : new ExpressionInfo(at.getTextRange(), "$" + at.getText());
            }
            if (at instanceof AsmInstruction) break;
        }
        return null;
    }

    private static boolean isInGdbSymbol(@NotNull PsiElement at) {
        if (at == null) {
            CidrAsmEvaluator.$$$reportNull$$$0(6);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)at, AsmGdbSymbol.class, (boolean)true, (Class[])new Class[]{AsmInstruction.class}) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/asm/debugger/CidrAsmEvaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/asm/debugger/CidrAsmEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionInfoAtOffsetAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInGdbSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

