/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.AsyncProducer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.system.AutoUploadManager;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentUtil;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.remote.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.webDeployment.AlwaysOverwrite;
import com.jetbrains.plugins.webDeployment.IgnoreOverwritingStrategy;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDeploymentImpl
implements RemoteDeployment {
    public void addBrowseRemoteHostAction(@NotNull @NlsContexts.DialogTitle String title, @NotNull ComponentWithBrowseButton browsableComponent, @NotNull JComponent textComponent, @NotNull TextComponentAccessor accessor, @NotNull AsyncProducer<RemoteCredentials> producer, @Nullable Consumer<String> pathConsumer) {
        if (title == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(0);
        }
        if (browsableComponent == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(1);
        }
        if (textComponent == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(2);
        }
        if (accessor == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(3);
        }
        if (producer == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(4);
        }
        RemoteBrowseActionListener.addBrowseRemoteHostAction(title, browsableComponent, textComponent, accessor, producer, pathConsumer);
    }

    public ActionListener getBrowseRemoteActionListener(@NotNull JComponent component, @NotNull TextComponentAccessor accessor, @NotNull @NlsContexts.DialogTitle String title, @NotNull AsyncProducer<RemoteCredentials> sdkDataProducer, @Nullable Consumer<String> pathConsumer) {
        if (component == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(5);
        }
        if (accessor == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(6);
        }
        if (title == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(7);
        }
        if (sdkDataProducer == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(8);
        }
        return new RemoteBrowseActionListener(component, accessor, title, sdkDataProducer, pathConsumer);
    }

    public String addRemoteHost(@NotNull String hostName, @NotNull SshConfig sshConfig) {
        if (hostName == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(9);
        }
        if (sshConfig == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(10);
        }
        WebServerConfig remoteHost = RemoteDeploymentUtil.createSftpWebServerConfig(hostName, sshConfig);
        RemoteDeploymentImpl.addServerToPredefinedGroup(remoteHost);
        return remoteHost.getId();
    }

    public boolean isDeploymentConfigAvailable(@NotNull String hostId) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(11);
        }
        return RemoteDeploymentUtil.getHost(hostId) != null;
    }

    public boolean isDeploymentConfigSFTP(@NotNull String hostId) {
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(12);
        }
        return (host = RemoteDeploymentUtil.getHost(hostId)) != null && host.getAccessType() == AccessType.SFTP;
    }

    public boolean isTransferNeeded(@NotNull String hostId, Project project, @NotNull String remotePath, @NotNull String localPath) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(13);
        }
        if (remotePath == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(14);
        }
        if (localPath == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(15);
        }
        WebServerConfig host = RemoteDeploymentUtil.getHost(hostId);
        if (project == null || host == null || host.getAccessType() != AccessType.MOUNT) {
            return true;
        }
        List<PathMappingSettings.PathMapping> mappings = this.getPathMapping(hostId, project);
        for (PathMappingSettings.PathMapping mapping : mappings) {
            if (!mapping.mapToLocal(remotePath).equals(localPath)) continue;
            return false;
        }
        return true;
    }

    public boolean isUseRsync(@NotNull String hostId) {
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(16);
        }
        return (host = RemoteDeploymentUtil.getHost(hostId)) != null && host.isUseRsync();
    }

    public void enableRsyncForConfigs(@NotNull List<String> hostIds) {
        if (hostIds == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(17);
        }
        if (SystemInfo.isWindows || !RSyncUtil.checkRsyncInstalled()) {
            return;
        }
        GroupedServersConfigManager manager = GroupedServersConfigManager.getInstance(null);
        ArrayList servers = new ArrayList(manager.getGroupedServers());
        for (WebServerGroupingWrap server : servers) {
            if (server.isSingleServer()) {
                WebServerConfig serverConfig = server.getAsSingleServer();
                if (!hostIds.contains(serverConfig.getId())) continue;
                serverConfig.getFileTransferConfig().getAdvancedOptions().setUseRsync(true);
                continue;
            }
            for (WebServerConfig serverConfig : server.getServers()) {
                if (!hostIds.contains(serverConfig.getId())) continue;
                serverConfig.getFileTransferConfig().getAdvancedOptions().setUseRsync(true);
            }
        }
    }

    private static void addServerToPredefinedGroup(@NotNull WebServerConfig server) {
        if (server == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(18);
        }
        GroupedServersConfigManager.getInstance(null).addServerToPredefinedGroup(server, ToolchainsBundle.message((String)"remote.development", (Object[])new Object[0]), false);
    }

    @Nullable
    public SshConfig getSshConfig(@NotNull String hostId) {
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(19);
        }
        if ((host = RemoteDeploymentUtil.getHost(hostId)) == null) {
            return null;
        }
        return host.findSshConfig(null);
    }

    public void updateRemoteHost(@NotNull String hostId, @NotNull String hostName, @NotNull SshConfig sshConfig) {
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(20);
        }
        if (hostName == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(21);
        }
        if (sshConfig == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(22);
        }
        if ((host = RemoteDeploymentUtil.getHost(hostId)) != null) {
            String uniqueName = hostName + " (" + hostId + ")";
            host.setName(uniqueName);
            if (host.getAccessType() == AccessType.SFTP) {
                host.getFileTransferConfig().setSshConfig(sshConfig);
            }
        } else {
            RemoteDeploymentImpl.addServerToPredefinedGroup(RemoteDeploymentUtil.createSftpWebServerConfig(sshConfig, hostName, hostId));
        }
    }

    public boolean deleteRemoteHost(@NotNull String hostId) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(23);
        }
        return GroupedServersConfigManager.getInstance(null).removeServer(hostId);
    }

    public boolean setPathMapping(@NotNull String hostId, @NotNull Project project, @NotNull List<PathMappingSettings.PathMapping> pathMappings) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(24);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(25);
        }
        if (pathMappings == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(26);
        }
        if (project.isDefault()) {
            return false;
        }
        WebServerConfig host = RemoteDeploymentUtil.getHost(hostId);
        if (host == null) {
            return false;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        publishConfig.setPathMappingsSilently(hostId, ContainerUtil.mapNotNull(pathMappings, mapping -> RemoteDeploymentUtil.convert(mapping)));
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeployment service: path-mapping was set for host: " + hostId + " " + pathMappings);
        }
        return true;
    }

    public void addExcludedPaths(@NotNull String hostId, @NotNull Project project, @NotNull List<String> excludeList) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(27);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(28);
        }
        if (excludeList == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(29);
        }
        this.updatedExcludePaths(hostId, project, excludeList, Collections.emptyList());
    }

    public void updatedExcludePaths(@NotNull String hostId, @NotNull Project project, @NotNull List<String> addList, @NotNull List<String> removeList) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(30);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(31);
        }
        if (addList == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(32);
        }
        if (removeList == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(33);
        }
        if (project.isDefault()) {
            return;
        }
        WebServerConfig host = RemoteDeploymentUtil.getHost(hostId);
        if (host == null) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        if (publishConfig == null) {
            return;
        }
        HashSet excludedPaths = new HashSet(publishConfig.getExcludedPaths(hostId));
        excludedPaths.removeAll(ContainerUtil.mapNotNull(removeList, path -> new ExcludedPath(path, true)));
        excludedPaths.addAll(ContainerUtil.mapNotNull(addList, path -> new ExcludedPath(path, true)));
        publishConfig.setExcludedPaths(hostId, new ArrayList(excludedPaths));
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeployment service: exclude-list was updated: " + hostId + " " + excludedPaths);
        }
    }

    public List<String> getExcludedPaths(@NotNull String hostId, @NotNull Project project) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(34);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(35);
        }
        if (project.isDefault()) {
            return Collections.emptyList();
        }
        WebServerConfig host = RemoteDeploymentUtil.getHost(hostId);
        if (host == null) {
            return Collections.emptyList();
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        if (publishConfig == null) {
            return Collections.emptyList();
        }
        return publishConfig.getExcludedPaths(hostId).stream().filter(p -> p != null && p.isLocal()).map(p -> p.getPath()).collect(Collectors.toList());
    }

    @NotNull
    public List<PathMappingSettings.PathMapping> getPathMapping(@NotNull String hostId, @NotNull Project project) {
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(36);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(37);
        }
        if ((host = RemoteDeploymentUtil.getHost(hostId)) == null) {
            List<PathMappingSettings.PathMapping> list = Collections.emptyList();
            if (list == null) {
                RemoteDeploymentImpl.$$$reportNull$$$0(38);
            }
            return list;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        List mappings = publishConfig.getPathMappings(hostId);
        List list = ContainerUtil.mapNotNull((Collection)mappings, mapping -> RemoteDeploymentUtil.convert(mapping));
        if (list == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public String getRootPath(@NotNull String hostId) {
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(40);
        }
        if ((host = RemoteDeploymentUtil.getHost(hostId)) == null) {
            return "";
        }
        String string = StringUtil.notNullize((String)host.getFileTransferConfig().getRootFolder());
        if (string == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public CompletableFuture<Void> upload(@NotNull String hostId, @NotNull Project project) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(42);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(43);
        }
        WebServerConfig host = RemoteDeploymentUtil.getHost(hostId);
        if (project.isDefault() || host == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                RemoteDeploymentImpl.$$$reportNull$$$0(44);
            }
            return completableFuture;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        CompletableFuture<Void> completableFuture = RemoteDeploymentUtil.runUploadTask(project, host, publishConfig);
        if (completableFuture == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(45);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> upload(@NotNull String hostId, @NotNull Project project, @NotNull String localPath) throws IOException {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(46);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(47);
        }
        if (localPath == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(48);
        }
        List<PathMappingSettings.PathMapping> mappings = this.getPathMapping(hostId, project);
        String remotePath = null;
        for (PathMappingSettings.PathMapping mapping : mappings) {
            if (!mapping.canReplaceLocal(localPath)) continue;
            remotePath = mapping.mapToRemote(localPath);
        }
        if (remotePath == null) {
            throw new IOException("Cannot find mapped remote path for: " + localPath);
        }
        CompletableFuture<Void> completableFuture = this.upload(hostId, project, localPath, remotePath);
        if (completableFuture == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(49);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> upload(@NotNull String hostId, @NotNull Project project, @NotNull String localPath, @NotNull String remotePath) {
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(50);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(51);
        }
        if (localPath == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(52);
        }
        if (remotePath == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(53);
        }
        WebServerConfig host = RemoteDeploymentUtil.getHost(hostId);
        if (project.isDefault() || host == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                RemoteDeploymentImpl.$$$reportNull$$$0(54);
            }
            return completableFuture;
        }
        host = RemoteDeploymentImpl.dropConfigRootPathToDefaultIfNeeded(host);
        PublishConfig publishConfig = new PublishConfig(null);
        DeploymentPathMapping deploymentMapping = new DeploymentPathMapping();
        deploymentMapping.setLocalPath(localPath);
        deploymentMapping.setDeployPath(remotePath);
        publishConfig.setPathMappingsSilently(hostId, Collections.singletonList(deploymentMapping));
        CompletableFuture<Void> completableFuture = RemoteDeploymentUtil.runUploadTask(project, host, publishConfig);
        if (completableFuture == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(55);
        }
        return completableFuture;
    }

    public CompletableFuture<Void> download(@NotNull String hostId, @NotNull SshConfig sshConfig, @NotNull Project project, @NotNull String remotePath, @NotNull String localPath) throws IOException {
        Deployable server;
        RemoteConnection connection;
        WebServerConfig host;
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(56);
        }
        if (sshConfig == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(57);
        }
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(58);
        }
        if (remotePath == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(59);
        }
        if (localPath == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(60);
        }
        if ((host = RemoteDeploymentUtil.getHost(hostId)) == null) {
            return CompletableFuture.completedFuture(null);
        }
        WebServerConfig tmpHost = host;
        if (host.getAccessType() != AccessType.SFTP) {
            tmpHost = host.clone();
            tmpHost.setFileTransferConfig(RemoteDeploymentUtil.createTransferConfig(sshConfig));
        }
        if ((connection = RemoteDeploymentUtil.getConnection(project, server = Deployable.create((WebServerConfig)(tmpHost = RemoteDeploymentImpl.dropConfigRootPathToDefaultIfNeeded(tmpHost)), null))) == null) {
            throw new IOException("connection error");
        }
        return RemoteDeploymentUtil.downloadInternal(project, hostId, server, connection, remotePath, localPath, (IgnoreOverwritingStrategy)AlwaysOverwrite.INSTANCE);
    }

    private static WebServerConfig dropConfigRootPathToDefaultIfNeeded(@NotNull WebServerConfig host) {
        String rootPath;
        if (host == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(61);
        }
        if ((rootPath = host.getFileTransferConfig().getRootFolder()).length() > 1) {
            host = host.clone();
            host.getFileTransferConfig().setRootFolder("/");
        }
        return host;
    }

    public void subscribeForUploading(@NotNull Project project, @NotNull Set<String> hostIds) {
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(62);
        }
        if (hostIds == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(63);
        }
        AutoUploadManager.getInstance(project).subscribe(hostIds);
    }

    public boolean waitForFilesSync(@NotNull Project project, @NotNull String hostId) {
        if (project == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(64);
        }
        if (hostId == null) {
            RemoteDeploymentImpl.$$$reportNull$$$0(65);
        }
        try {
            return AutoUploadManager.getInstance(project).waitForSync(hostId, ProgressIndicatorProvider.getGlobalProgressIndicator());
        }
        catch (ProcessCanceledException ignore) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 38, 39, 41, 44, 45, 49, 54, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browsableComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkDataProducer";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostName";
                break;
            }
            case 10: 
            case 22: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 46: 
            case 50: 
            case 56: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostId";
                break;
            }
            case 14: 
            case 53: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 15: 
            case 48: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 17: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostIds";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 43: 
            case 47: 
            case 51: 
            case 58: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeList";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addList";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeList";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteDeploymentImpl";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteDeploymentImpl";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapping";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "upload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseRemoteHostAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBrowseRemoteActionListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteHost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDeploymentConfigAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDeploymentConfigSFTP";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTransferNeeded";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUseRsync";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enableRsyncForConfigs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addServerToPredefinedGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSshConfig";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateRemoteHost";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteHost";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setPathMapping";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedPaths";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updatedExcludePaths";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedPaths";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPathMapping";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRootPath";
                break;
            }
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "upload";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "dropConfigRootPathToDefaultIfNeeded";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "subscribeForUploading";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "waitForFilesSync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 38, 39, 41, 44, 45, 49, 54, 55 -> new IllegalStateException(string);
        };
    }
}

