/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.project.CidrRootConfigurationListener;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentUtil;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.autoupload.AutoUploadAsyncFileListener;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="AutoUploadManager", storages={@Storage(value="other.xml")})
public final class AutoUploadManager
implements PersistentStateComponent<Element> {
    private static final Element EMPTY_ELEMENT = new Element("hosts");
    @Nullable
    private AutoUploadAsyncFileListener myUploadListener;
    @NotNull
    private Set<String> myHosts;
    @NotNull
    private final Project myProject;

    private AutoUploadManager(final @NotNull Project project) {
        if (project == null) {
            AutoUploadManager.$$$reportNull$$$0(0);
        }
        this.myHosts = new HashSet<String>();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            public void optionsChanged() {
                AutoUploadManager.this.updateUploadListener();
            }

            public void excludedPathsChanged() {
                AutoUploadManager.this.updateUploadListener();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)GroupedServersConfigManager.getInstance((Project)project)).subscribe(WebDeploymentTopics.WEB_SERVER_CONFIGS, () -> this.updateUploadListener());
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project == AutoUploadManager.this.myProject) {
                    AutoUploadManager.this.updateUploadListener();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/system/AutoUploadManager$2", "projectOpened"));
            }
        });
        connection.subscribe(CidrRootConfigurationListener.TOPIC, (Object)new CidrRootConfigurationListener(){

            public void rootsAdded(@NotNull @NotNull List<@NotNull File> roots, @NotNull CidrRootConfiguration.RootType rootType) {
                if (roots == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (rootType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!Registry.is((String)"clion.remote.mark.dir.excluded")) {
                    return;
                }
                if (rootType != CidrRootConfiguration.RootType.EXCLUDED || AutoUploadManager.this.myHosts.isEmpty()) {
                    return;
                }
                List files = ContainerUtil.map(roots, f -> f.getPath());
                if (AutoUploadManager.this.skipNotification(project, excludedPaths -> excludedPaths.containsAll(files))) {
                    return;
                }
                Notification notification = AutoUploadManager.createNotification();
                notification.addAction((AnAction)AutoUploadManager.this.createUpdateAction(files, Collections.emptyList()));
                notification.notify(project);
            }

            public void rootsRemoved(@NotNull @NotNull List<@NotNull File> roots, @Nullable CidrRootConfiguration.RootType rootType) {
                if (roots == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!Registry.is((String)"clion.remote.mark.dir.excluded")) {
                    return;
                }
                if (rootType != CidrRootConfiguration.RootType.EXCLUDED || AutoUploadManager.this.myHosts.isEmpty()) {
                    return;
                }
                List files = ContainerUtil.map(roots, f -> f.getPath());
                if (AutoUploadManager.this.skipNotification(project, excludedPaths -> !ContainerUtil.exists((Iterable)excludedPaths, p -> files.contains(p)))) {
                    return;
                }
                Notification notification = AutoUploadManager.createNotification();
                notification.addAction((AnAction)AutoUploadManager.this.createUpdateAction(Collections.emptyList(), files));
                notification.addAction((AnAction)AutoUploadManager.this.createUpdateAndUploadAction(files));
                notification.notify(project);
            }

            public void configurationChanged() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "roots";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/system/AutoUploadManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rootsAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rootsRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static AutoUploadManager getInstance(@NotNull Project project) {
        if (project == null) {
            AutoUploadManager.$$$reportNull$$$0(1);
        }
        return (AutoUploadManager)project.getComponent(AutoUploadManager.class);
    }

    private void updateUploadListener() {
        this.subscribe(this.myHosts);
    }

    @NotNull
    public Element getState() {
        State stateBean = new State();
        stateBean.hosts = new ArrayList<String>(this.myHosts);
        Element element = (Element)ObjectUtils.chooseNotNull((Object)XmlSerializer.serialize((Object)stateBean), (Object)EMPTY_ELEMENT);
        if (element == null) {
            AutoUploadManager.$$$reportNull$$$0(2);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            AutoUploadManager.$$$reportNull$$$0(3);
        }
        State stateBean = (State)XmlSerializer.deserialize((Element)state, State.class);
        List<String> hosts = stateBean.hosts;
        if (hosts != null) {
            this.myHosts = new HashSet<String>(hosts);
        }
    }

    public void subscribe(@NotNull Set<String> hostIds) {
        if (hostIds == null) {
            AutoUploadManager.$$$reportNull$$$0(4);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("AutoUploadManager: try to subscribe: " + hostIds);
        }
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return;
        }
        HashSet<String> validHostIds = new HashSet<String>(hostIds.size());
        ArrayList<WebServerConfig> hosts = new ArrayList<WebServerConfig>(hostIds.size());
        for (String hostId : hostIds) {
            WebServerConfig host = RemoteDeploymentUtil.getHost(hostId);
            if (host == null || host.getAccessType() != AccessType.SFTP) {
                RemoteHostUtil.LOG.debug("Host: '" + hostId + "' is not relevant anymore...");
                continue;
            }
            hosts.add(host);
            validHostIds.add(hostId);
        }
        PublishConfig publishConfigClone = AutoUploadManager.getPreparedPublishConfigClone(this.myProject);
        publishConfigClone.setAutoUploadState(PublishConfig.AutoUploadState.ALWAYS);
        AutoUploadAsyncFileListener uploadListener = new AutoUploadAsyncFileListener(this.myProject, publishConfigClone, hosts, null);
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)uploadListener);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("AutoUploadManager: " + hostIds + " were subscribed");
        }
        Disposer.register((Disposable)this.myProject, () -> AutoUploadManager.unsubscribe(uploadListener));
        for (String host : this.myHosts) {
            this.waitForSync(host, ProgressIndicatorProvider.getGlobalProgressIndicator());
        }
        this.myHosts = validHostIds;
        AutoUploadManager.unsubscribe(this.myUploadListener);
        this.myUploadListener = uploadListener;
    }

    @NotNull
    public HashSet<String> getHosts() {
        return new HashSet<String>(this.myHosts);
    }

    public boolean waitForSync(@NotNull String hostId, @Nullable ProgressIndicator pi) throws ProcessCanceledException {
        AutoUploadAsyncFileListener uploadListener;
        if (hostId == null) {
            AutoUploadManager.$$$reportNull$$$0(5);
        }
        if ((uploadListener = this.myUploadListener) == null) {
            return true;
        }
        int timeout = Registry.intValue((String)"clion.remote.sync.step.timeout", (int)200);
        long start = System.currentTimeMillis();
        int maxTimeoutMs = Registry.intValue((String)"clion.remote.sync.timeout", (int)3000);
        boolean isTimeout = false;
        do {
            if (pi != null) {
                pi.checkCanceled();
            }
            TimeoutUtil.sleep((long)timeout);
            boolean bl = isTimeout = System.currentTimeMillis() - start > (long)maxTimeoutMs;
        } while (!uploadListener.allChangedFilesAreUploaded(hostId) && !isTimeout);
        if (!isTimeout) {
            if (pi != null) {
                pi.isCanceled();
            }
            TimeoutUtil.sleep((long)timeout);
        }
        return !isTimeout;
    }

    private static PublishConfig getPreparedPublishConfigClone(@NotNull Project project) {
        if (project == null) {
            AutoUploadManager.$$$reportNull$$$0(6);
        }
        boolean enabled = Registry.is((String)"clion.remote.upload.external.changes", (boolean)true);
        PublishConfig publishConfigClone = PublishConfig.getInstance((Project)project).clone();
        publishConfigClone.setAutoUploadExternalChanges(enabled);
        publishConfigClone.setDeleteMissingItems(enabled);
        return publishConfigClone;
    }

    private static void unsubscribe(@Nullable AutoUploadAsyncFileListener uploadListener) {
        if (uploadListener != null) {
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("AutoUploadManager: unsubscribe upload listener");
            }
            Disposer.dispose((Disposable)uploadListener);
        }
    }

    private static Notification createNotification() {
        return RemoteUtil.NOTIFICATION_GROUP.createNotification(ToolchainsBundle.message((String)"remote.development", (Object[])new Object[0]), ToolchainsBundle.message((String)"remote.excluded.paths.update", (Object[])new Object[0]), NotificationType.INFORMATION);
    }

    private boolean skipNotification(@NotNull Project project, @NotNull Predicate<List<String>> skipCondition) {
        if (project == null) {
            AutoUploadManager.$$$reportNull$$$0(7);
        }
        if (skipCondition == null) {
            AutoUploadManager.$$$reportNull$$$0(8);
        }
        RemoteDeployment service = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class);
        for (String hostId : new HashSet<String>(this.myHosts)) {
            if (skipCondition.test(service.getExcludedPaths(hostId, project))) continue;
            return false;
        }
        return true;
    }

    private NotificationAction createUpdateAction(@NotNull @NotNull List<@NotNull String> addList, @NotNull @NotNull List<@NotNull String> removeList) {
        if (addList == null) {
            AutoUploadManager.$$$reportNull$$$0(9);
        }
        if (removeList == null) {
            AutoUploadManager.$$$reportNull$$$0(10);
        }
        return NotificationAction.createSimpleExpiring((String)ToolchainsBundle.message((String)"remote.excluded.paths.update.action", (Object[])new Object[0]), () -> this.updateDeploymentConfigs(addList, removeList));
    }

    private NotificationAction createUpdateAndUploadAction(@NotNull @NotNull List<@NotNull String> removeList) {
        if (removeList == null) {
            AutoUploadManager.$$$reportNull$$$0(11);
        }
        return NotificationAction.createSimpleExpiring((String)ToolchainsBundle.message((String)"remote.excluded.paths.upload.action", (Object[])new Object[0]), () -> this.updateDeploymentConfigsAndUpload(removeList));
    }

    private void updateDeploymentConfigs(@NotNull @NotNull List<@NotNull String> addList, @NotNull @NotNull List<@NotNull String> removeList) {
        if (addList == null) {
            AutoUploadManager.$$$reportNull$$$0(12);
        }
        if (removeList == null) {
            AutoUploadManager.$$$reportNull$$$0(13);
        }
        RemoteDeployment service = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class);
        for (String hostId : new HashSet<String>(this.myHosts)) {
            if (!service.isDeploymentConfigSFTP(hostId)) continue;
            service.updatedExcludePaths(hostId, this.myProject, addList, removeList);
        }
        ((DeploymentConfigChangeListener)this.myProject.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).excludedPathsChanged();
    }

    private void updateDeploymentConfigsAndUpload(@NotNull @NotNull List<@NotNull String> removeList) {
        if (removeList == null) {
            AutoUploadManager.$$$reportNull$$$0(14);
        }
        this.updateDeploymentConfigs(Collections.emptyList(), removeList);
        RemoteDeployment service = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class);
        for (String hostId : new HashSet<String>(this.myHosts)) {
            if (!service.isDeploymentConfigSFTP(hostId)) continue;
            for (String path : removeList) {
                try {
                    service.upload(hostId, this.myProject, path);
                }
                catch (IOException e) {
                    RemoteHostUtil.LOG.warn("Cannot upload un-excluded path: " + path, (Throwable)e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/AutoUploadManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostIds";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addList";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/AutoUploadManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "waitForSync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedPublishConfigClone";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipNotification";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateAndUploadAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateDeploymentConfigs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateDeploymentConfigsAndUpload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class State {
        public List<String> hosts = new ArrayList<String>();
    }
}

