/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public final class OCLValueUtil {
    public static boolean isLValue(@NotNull OCExpression expression) {
        if (expression == null) {
            OCLValueUtil.$$$reportNull$$$0(0);
        }
        LValueChecker checker = new LValueChecker();
        checker.process(expression);
        return checker.isLValue();
    }

    public static boolean isAssignmentLHS(@NotNull OCExpression expression) {
        if (expression == null) {
            OCLValueUtil.$$$reportNull$$$0(1);
        }
        LValueChecker checker = new LValueChecker();
        checker.process(expression);
        return checker.isAssignmentLHS();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/jetbrains/cidr/lang/util/OCLValueUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignmentLHS";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LValueChecker {
        private boolean myLValue = false;
        private boolean myAssignmentLHS = false;

        LValueChecker() {
        }

        public boolean isLValue() {
            return this.myLValue;
        }

        public boolean isAssignmentLHS() {
            return this.myAssignmentLHS;
        }

        public void process(@NotNull OCExpression expression) {
            PsiElement parent;
            if (expression == null) {
                LValueChecker.$$$reportNull$$$0(0);
            }
            if ((parent = (expression = this.getTopmostLValueParent(expression)).getParent()) instanceof OCAssignmentExpression) {
                this.myAssignmentLHS = ((OCAssignmentExpression)parent).getReceiverExpression() == expression;
            } else if (parent instanceof OCPostfixExpression) {
                OCElementType sign = ((OCPostfixExpression)parent).getOperationSign();
                this.myAssignmentLHS = sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS;
            } else if (parent instanceof OCPrefixExpression) {
                OCElementType sign = ((OCPrefixExpression)parent).getOperationSign();
                this.myAssignmentLHS = sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS;
            }
            this.myLValue |= this.myAssignmentLHS;
        }

        @NotNull
        private OCExpression getTopmostLValueParent(@NotNull OCExpression expression) {
            OCExpression parentExpr;
            if (expression == null) {
                LValueChecker.$$$reportNull$$$0(1);
            }
            OCExpression unparen = OCParenthesesUtils.topmostParenthesized(expression);
            PsiElement parent = unparen.getParent();
            while (parent instanceof OCExpression && (LValueChecker.isAddressOperator(parentExpr = (OCExpression)parent) || LValueChecker.isDereference(parentExpr) || LValueChecker.isBodyOfConditionalExpr(unparen, parentExpr))) {
                this.myLValue = LValueChecker.isAddressOperator(parentExpr) || LValueChecker.isDereference(parentExpr);
                unparen = OCParenthesesUtils.topmostParenthesized(parentExpr);
                parent = unparen.getParent();
            }
            OCExpression oCExpression = unparen;
            if (oCExpression == null) {
                LValueChecker.$$$reportNull$$$0(2);
            }
            return oCExpression;
        }

        private static boolean isAddressOperator(@NotNull OCExpression expression) {
            if (expression == null) {
                LValueChecker.$$$reportNull$$$0(3);
            }
            return expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).isGetAddress();
        }

        private static boolean isDereference(@NotNull OCExpression expression) {
            if (expression == null) {
                LValueChecker.$$$reportNull$$$0(4);
            }
            return expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).getOperationSign() == OCTokenTypes.MUL;
        }

        private static boolean isBodyOfConditionalExpr(@NotNull OCExpression expression, @NotNull OCExpression parentExpression) {
            if (expression == null) {
                LValueChecker.$$$reportNull$$$0(5);
            }
            if (parentExpression == null) {
                LValueChecker.$$$reportNull$$$0(6);
            }
            if (!(parentExpression instanceof OCConditionalExpression)) {
                return false;
            }
            OCConditionalExpression conditionalExpression = (OCConditionalExpression)parentExpression;
            return conditionalExpression.getPositiveExpression(true) == expression || conditionalExpression.getNegativeExpression() == expression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/util/OCLValueUtil$LValueChecker";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/util/OCLValueUtil$LValueChecker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTopmostLValueParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTopmostLValueParent";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAddressOperator";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isDereference";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isBodyOfConditionalExpr";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

