/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.ui.OCResolveContextPanelUsageCollector;
import com.jetbrains.cidr.lang.ui.OCUnloadedResolveContextsUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCUnloadedResolveContext;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.InputEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCResolveContextPanel
extends EditorBasedStatusBarPopup {
    private static final DataKey<ListPopupModel<?>> POPUP_MODEL = DataKey.create((String)"OCResolveContextPanelPopupModel");
    @NonNls
    public static final String ID = "ActiveOCBuildConfiguration";
    @NonNls
    private static final String PREFIX_SEPARATOR = ": ";
    private volatile boolean isCalculatingContext;
    private final AtomicReference<Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState>> myUpdateInfoRef;
    private volatile VirtualFile myLastUpdatedFile;
    private ProgressIndicator myCurrentProgress;
    private boolean myShowAllUnrelatedContexts;

    public OCResolveContextPanel(@NotNull Project project) {
        if (project == null) {
            OCResolveContextPanel.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myUpdateInfoRef = new AtomicReference();
    }

    private boolean hasAccessToSymbols() {
        return !DumbService.getInstance((Project)this.getProject()).isDumb() && FileSymbolTablesCache.areSymbolsLoaded(this.getProject());
    }

    @NotNull
    public JComponent getComponent() {
        JComponent component = super.getComponent();
        component.setName(ID);
        JComponent jComponent = component;
        if (jComponent == null) {
            OCResolveContextPanel.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState> updateInfo = this.replaceUpdateInfo(null);
        if (file == null || !Comparing.equal((Object)this.getSelectedFile(), (Object)file) || !FileSymbolTableHelper.isSourceFile(file, this.getProject())) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(2);
            }
            return widgetState;
        }
        if (!file.isValid()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = OCResolveContextPanel.getNoContextState();
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(3);
            }
            return widgetState;
        }
        if (updateInfo == null || !Comparing.equal((Object)((VirtualFile)updateInfo.first), (Object)file)) {
            if (this.myCurrentProgress != null) {
                this.myCurrentProgress.cancel();
            }
            this.myCurrentProgress = new EmptyProgressIndicator();
            this.scheduleReloadFileContexts(file, this.myCurrentProgress);
            EditorBasedStatusBarPopup.WidgetState widgetState = !Comparing.equal((Object)this.myLastUpdatedFile, (Object)file) || this.isEmpty() ? OCResolveContextPanel.getLoadingState() : EditorBasedStatusBarPopup.WidgetState.NO_CHANGE_MAKE_VISIBLE;
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(4);
            }
            return widgetState;
        }
        this.myLastUpdatedFile = file;
        EditorBasedStatusBarPopup.WidgetState widgetState = (EditorBasedStatusBarPopup.WidgetState)updateInfo.second;
        if (widgetState == null) {
            OCResolveContextPanel.$$$reportNull$$$0(5);
        }
        return widgetState;
    }

    public void update(@Nullable Runnable finishUpdate) {
        this.replaceUpdateInfo(null);
        super.update(finishUpdate);
    }

    @Nullable
    private Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState> replaceUpdateInfo(@Nullable Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState> newValue) {
        return this.myUpdateInfoRef.getAndSet(newValue);
    }

    private void scheduleReloadFileContexts(VirtualFile file, @NotNull ProgressIndicator globalProgress) {
        if (globalProgress == null) {
            OCResolveContextPanel.$$$reportNull$$$0(6);
        }
        Runnable update = () -> {
            EditorBasedStatusBarPopup.WidgetState state = this.getWidgetStateSync(file);
            this.replaceUpdateInfo((Pair<VirtualFile, EditorBasedStatusBarPopup.WidgetState>)Pair.create((Object)file, (Object)state));
            super.update(null);
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(update);
        } else {
            ReadAction.nonBlocking((Runnable)update).expireWith((Disposable)this).wrapProgress(globalProgress).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EditorBasedStatusBarPopup.WidgetState getWidgetStateSync(@NotNull VirtualFile file) {
        OCParsedLanguageAndConfiguration langAndConfig;
        if (file == null) {
            OCResolveContextPanel.$$$reportNull$$$0(7);
        }
        if (!file.isValid()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = OCResolveContextPanel.getNoContextState();
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(8);
            }
            return widgetState;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        if (!OCResolveContextPanel.isRelevantFile(psiFile)) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(9);
            }
            return widgetState;
        }
        if (!this.hasAccessToSymbols()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.getDumbModeState((String)OCBundle.message("resolve.contexts.name", new Object[0]), (String)OCResolveContextPanel.getContextPrefix());
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(10);
            }
            return widgetState;
        }
        this.isCalculatingContext = true;
        try {
            langAndConfig = this.getAndVerifyLangAndConfiguration(psiFile);
        }
        finally {
            this.isCalculatingContext = false;
        }
        OCResolveConfiguration config = langAndConfig.getConfiguration();
        if (config == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = OCResolveContextPanel.getRecoveryContext(this.myProject);
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(11);
            }
            return widgetState;
        }
        OCLanguageKind kind = langAndConfig.getLanguageKind();
        Collection<OCResolveConfiguration> cs = OCResolveContextPanel.getFileConfigurations((PsiFile)psiFile, (boolean)false).configurations;
        if (!cs.isEmpty() && !cs.contains(config)) {
            OCResolveContextPanel.scheduleReParse(psiFile, (OCResolveConfiguration)ContainerUtil.getFirstItem(cs));
            EditorBasedStatusBarPopup.WidgetState widgetState = OCResolveContextPanel.getLoadingState();
            if (widgetState == null) {
                OCResolveContextPanel.$$$reportNull$$$0(12);
            }
            return widgetState;
        }
        String text = kind.getShortDisplayName() + PREFIX_SEPARATOR + StringUtil.shortenTextWithEllipsis((String)config.getDisplayName(), (int)40, (int)15);
        String tooltip = OCBundle.message("resolve.contexts.current.file", kind.getDisplayName(), config.getDisplayName());
        List<OCUnloadedResolveContext> unloadedContexts = OCUnloadedResolveContextsUtil.getAllUnloadedContextsForFile(psiFile);
        return new EditorBasedStatusBarPopup.WidgetState(tooltip, text, cs.size() + unloadedContexts.size() > 1);
    }

    @Nullable
    public ListPopup createPopup(@NotNull DataContext context) {
        VirtualFile file;
        if (context == null) {
            OCResolveContextPanel.$$$reportNull$$$0(13);
        }
        if ((file = this.getSelectedFile()) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        if (!OCResolveContextPanel.isRelevantFile(psiFile)) {
            return null;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        @NotNull FileConfigurations configInfo = OCResolveContextPanel.getFileConfigurations(psiFile, true);
        Collection<OCResolveConfiguration> configurations = configInfo.configurations;
        boolean isDetermined = configInfo.isDetermined;
        int configsSize = configurations.size();
        List<OCUnloadedResolveContext> unloadedContexts = OCUnloadedResolveContextsUtil.getAllUnloadedContextsForFile(psiFile);
        if (!isDetermined) {
            group.addSeparator(OCBundle.message("resolve.contexts.all.contexts", new Object[0]));
        }
        if (configsSize + unloadedContexts.size() > 1) {
            if (configsSize > 1) {
                group.add((AnAction)new AutoSelectItem(psiFile));
            }
            for (OCResolveConfiguration config : configurations) {
                group.add((AnAction)new ConfigurationItem(psiFile, config));
            }
        }
        if (!unloadedContexts.isEmpty()) {
            ArrayList<OCUnloadedResolveContext> relatedContexts = new ArrayList<OCUnloadedResolveContext>();
            ArrayList otherContexts = new ArrayList();
            if (isDetermined) {
                for (OCUnloadedResolveContext unloadedContext : unloadedContexts) {
                    ArrayList<OCUnloadedResolveContext> contexts = CollectionsKt.indexOfFirst(configurations, arg_0 -> ((OCUnloadedResolveContext)unloadedContext).isRelatedTo(arg_0)) >= 0 ? relatedContexts : otherContexts;
                    contexts.add(unloadedContext);
                }
            } else {
                relatedContexts.addAll(unloadedContexts);
            }
            ContainerUtil.sort(relatedContexts);
            ContainerUtil.sort(otherContexts);
            group.addSeparator(OCBundle.message("resolve.contexts.unindexed.contexts", new Object[0]));
            for (OCUnloadedResolveContext unloadedContext : relatedContexts) {
                group.add((AnAction)new UnloadedItem(psiFile, unloadedContext, true));
            }
            if (!otherContexts.isEmpty()) {
                for (OCUnloadedResolveContext unloadedContext : otherContexts) {
                    group.add((AnAction)new UnloadedItem(psiFile, unloadedContext, false));
                }
                group.add((AnAction)new ShowMoreItem());
            }
        }
        OCResolveContextSettings settings = OCResolveContextSettings.getInstance((Project)this.getProject());
        final OCResolveConfiguration priorityConfig = (OCResolveConfiguration)settings.findPriorityConfiguration(configurations).first;
        OCResolveConfiguration effectiveConfig = this.getAndVerifyLangAndConfiguration(psiFile).getConfiguration();
        final Color outOfProjectColor = FileColorManager.getInstance((Project)this.getProject()).getScopeColor("Non-Project Files");
        PopupFactoryImpl.ActionGroupPopup list = new PopupFactoryImpl.ActionGroupPopup(null, OCBundle.message("resolve.contexts.available", new Object[0]), (ActionGroup)group, context, "popup", new PresentationFactory(), ActionPopupOptions.create((boolean)false, (boolean)true, (boolean)true, (boolean)false, (int)15, (boolean)false, action -> action instanceof ItemBase && ((ItemBase)((Object)action)).matches(effectiveConfig)), null){
            {
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
                this.getList().putClientProperty(POPUP_MODEL, dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
            }

            protected ListCellRenderer<?> getListElementRenderer() {
                return new PopupListElementRenderer<PopupFactoryImpl.ActionItem>((ListPopupImpl)this){

                    protected void customizeComponent(@NotNull JList<? extends PopupFactoryImpl.ActionItem> list, @NotNull PopupFactoryImpl.ActionItem actionItem, boolean isSelected) {
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (actionItem == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.customizeComponent(list, (Object)actionItem, isSelected);
                        AnAction anAction = actionItem.getAction();
                        if (!(anAction instanceof ItemBase)) {
                            return;
                        }
                        ItemBase item = (ItemBase)anAction;
                        if (item.isGrayedOut()) {
                            this.myTextLabel.setForeground((Color)JBColor.GRAY);
                        }
                        if (item.isOutOfProject() && !isSelected && outOfProjectColor != null) {
                            UIUtil.setBackgroundRecursively((Component)this.getItemComponent(), (Color)outOfProjectColor);
                        }
                        Font listFont = UIUtil.getListFont();
                        this.myTextLabel.setFont(item.matches(priorityConfig) ? listFont.deriveFont(1) : listFont);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "list";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "actionItem";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$1$1";
                        objectArray[2] = "customizeComponent";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            public boolean shouldBeShowing(Object value) {
                if (!super.shouldBeShowing(value)) {
                    return false;
                }
                if (!(value instanceof PopupFactoryImpl.ActionItem)) {
                    return true;
                }
                AnAction action = ((PopupFactoryImpl.ActionItem)value).getAction();
                if (this.getSpeedSearch().isHoldingFilter()) {
                    return !(action instanceof ShowMoreItem);
                }
                return !(action instanceof UnloadedItem) || ((UnloadedItem)action).isRelated() || OCResolveContextPanel.this.myShowAllUnrelatedContexts;
            }
        };
        list.setAdText(OCBundle.message("resolve.contexts.file.resolved.in", new Object[0]), 10);
        OCResolveContextPanelUsageCollector.POPUP_CLICKED.log(this.myProject, (Object)(configInfo.rootKind == OCRootKind.Include ? 1 : 0));
        return list;
    }

    private static boolean isRelevantFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof OCConfigurationOwner && psiFile.isValid();
    }

    @NotNull
    private static FileConfigurations getFileConfigurations(@NotNull PsiFile psiFile, boolean sort) {
        if (psiFile == null) {
            OCResolveContextPanel.$$$reportNull$$$0(14);
        }
        boolean isDetermined = true;
        OCInclusionContextUtil.ConfigurationsAndRootKind configurationsForFileAndIsHeader = OCInclusionContextUtil.getAllBuildConfigurationsForFileAndIsHeader(psiFile, null);
        List allConfigurations = configurationsForFileAndIsHeader.configurations();
        @NotNull OCRootKind rootKind = configurationsForFileAndIsHeader.rootKind();
        if (allConfigurations.isEmpty()) {
            isDetermined = false;
            allConfigurations = OCWorkspace.getInstance((Project)psiFile.getProject()).getConfigurations();
        }
        if (!sort) {
            return new FileConfigurations(allConfigurations, isDetermined, rootKind);
        }
        ArrayList<OCResolveConfiguration> sorted = new ArrayList<OCResolveConfiguration>(allConfigurations);
        ContainerUtil.sort(sorted);
        return new FileConfigurations(sorted, isDetermined, rootKind);
    }

    protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            OCResolveContextPanel.$$$reportNull$$$0(15);
        }
        class Listener
        implements DumbService.DumbModeListener,
        OCInclusionContextListener,
        FileSymbolTableCacheListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                OCResolveContextPanel.this.update();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                OCResolveContextPanel.this.update();
            }

            @Override
            public void resolveRootAndActiveConfigurationChanged(@NotNull VirtualFile file, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
                if (file == null) {
                    Listener.$$$reportNull$$$0(0);
                }
                if (rootAndConfiguration == null) {
                    Listener.$$$reportNull$$$0(1);
                }
                if (!OCResolveContextPanel.this.isCalculatingContext && !this.isDumbMode) {
                    OCResolveContextPanel.this.updateForFile(file);
                }
            }

            @Override
            public void onSymbolsUpToDate() {
                OCResolveContextPanel.this.update();
            }

            @Override
            public void onSymbolsInvalidated() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootAndConfiguration";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$1Listener";
                objectArray[2] = "resolveRootAndActiveConfigurationChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        Listener listener = new Listener();
        connection.subscribe(DumbService.DUMB_MODE, (Object)listener);
        connection.subscribe(OCInclusionContextListener.TOPIC, (Object)listener);
        connection.subscribe(FileSymbolTableCacheListener.TOPIC, (Object)listener);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            OCResolveContextPanel.$$$reportNull$$$0(16);
        }
        return new OCResolveContextPanel(project);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public OCParsedLanguageAndConfiguration getAndVerifyLangAndConfiguration(@NotNull PsiFile file) {
        if (file == null) {
            OCResolveContextPanel.$$$reportNull$$$0(17);
        }
        OCLog.LOG.assertTrue(file instanceof OCConfigurationOwner);
        OCParsedLanguageAndConfiguration stored = ((OCConfigurationOwner)file).getParsedLanguageAndConfiguration();
        if (!(file instanceof OCPsiFile)) {
            OCLog.LOG.assertTrue(stored != null, (Object)"Non-OC file has no stored config");
            OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration = stored;
            if (oCParsedLanguageAndConfiguration == null) {
                OCResolveContextPanel.$$$reportNull$$$0(18);
            }
            return oCParsedLanguageAndConfiguration;
        }
        OCImmutableInclusionContext context = OCHeaderContextCache.headerContext(file);
        OCParsedLanguageAndConfiguration result = new OCParsedLanguageAndConfiguration(context.getConfiguration(), context.getLanguageKind());
        if (stored != null && (result.getConfiguration() != stored.getConfiguration() || result.getLanguageKind() != stored.getLanguageKind())) {
            VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
                this.update();
            });
        }
        OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration = result;
        if (oCParsedLanguageAndConfiguration == null) {
            OCResolveContextPanel.$$$reportNull$$$0(19);
        }
        return oCParsedLanguageAndConfiguration;
    }

    @Nullable
    private static VirtualFile findAnySupportedJson(@NotNull String rootPath) {
        if (rootPath == null) {
            OCResolveContextPanel.$$$reportNull$$$0(20);
        }
        List<Path> possiblePaths = Arrays.asList(Path.of(rootPath, ".idea", "c_cpp_properties.json"), Path.of(rootPath, ".vscode", "c_cpp_properties.json"), Path.of(rootPath, "CppProperties.json"));
        for (Path path : possiblePaths) {
            @Nullable VirtualFile file = LocalFileSystem.getInstance().findFileByNioFile(path);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static void scheduleReParse(PsiFile psiFile, OCResolveConfiguration config) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> OCResolveContextPanel.setUserConfiguration(psiFile, config));
    }

    private static void setUserConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        if (psiFile == null) {
            OCResolveContextPanel.$$$reportNull$$$0(21);
        }
        Application application = ApplicationManager.getApplication();
        ThreadingAssertions.assertEventDispatchThread();
        application.runWriteAction(() -> {
            Project project = psiFile.getProject();
            FileManager fileManager = PsiManagerEx.getInstanceEx((Project)project).getFileManager();
            for (VirtualFile file : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
                PsiFile cachedPsi = OCInclusionContextUtil.findCachedPsiFile(file, project);
                if (!OCResolveContextPanel.isRelevantFile(cachedPsi)) continue;
                fileManager.setViewProvider(file, null);
            }
            OCFileActiveConfigurationCache.setUserSelectedConfiguration(psiFile, config);
        });
    }

    @NlsContexts.StatusBarText
    public static String getContextPrefix() {
        return OCBundle.message("resolve.contexts.prefix", new Object[0]) + PREFIX_SEPARATOR;
    }

    private static EditorBasedStatusBarPopup.WidgetState getLoadingState() {
        return new EditorBasedStatusBarPopup.WidgetState(OCBundle.message("resolve.contexts.loading", new Object[0]), OCResolveContextPanel.getContextPrefix() + CommonBundle.getLoadingTreeNodeText(), false);
    }

    private static EditorBasedStatusBarPopup.WidgetState getNoContextState() {
        return new EditorBasedStatusBarPopup.WidgetState(OCBundle.message("resolve.contexts.prefix.no.context", new Object[0]), OCResolveContextPanel.getContextPrefix() + OCBundle.message("resolve.contexts.no.context", new Object[0]), false);
    }

    private static EditorBasedStatusBarPopup.WidgetState getRecoveryContext(Project project) {
        String rootPath = project.getBasePath();
        if (rootPath == null) {
            return OCResolveContextPanel.getNoContextState();
        }
        @Nullable VirtualFile jsonFile = OCResolveContextPanel.findAnySupportedJson(rootPath);
        if (jsonFile == null) {
            return new EditorBasedStatusBarPopup.WidgetState(OCBundle.message("resolve.contexts.prefix.unsupported.build.system.no.json.context", new Object[0]), OCResolveContextPanel.getContextPrefix() + " " + OCBundle.message("resolve.contexts.unsupported.build.system.no.json.context", new Object[0]), false);
        }
        return new EditorBasedStatusBarPopup.WidgetState(OCBundle.message("resolve.contexts.prefix.unsupported.build.system.context", jsonFile.getName()), OCResolveContextPanel.getContextPrefix() + " " + jsonFile.getName(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalProgress";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetStateSync";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndVerifyLangAndConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReloadFileContexts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetStateSync";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileConfigurations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomListeners";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAndVerifyLangAndConfiguration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnySupportedJson";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setUserConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static class FileConfigurations {
        @NotNull
        final Collection<OCResolveConfiguration> configurations;
        final boolean isDetermined;
        @NotNull
        final OCRootKind rootKind;

        private FileConfigurations(@NotNull Collection<OCResolveConfiguration> configurations, boolean isDetermined, @NotNull OCRootKind rootKind) {
            if (configurations == null) {
                FileConfigurations.$$$reportNull$$$0(0);
            }
            if (rootKind == null) {
                FileConfigurations.$$$reportNull$$$0(1);
            }
            this.configurations = configurations;
            this.isDetermined = isDetermined;
            this.rootKind = rootKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configurations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootKind";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$FileConfigurations";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class AutoSelectItem
    extends ItemBase {
        @NotNull
        private final PsiFile myFile;

        AutoSelectItem(@NotNull PsiFile file) {
            if (file == null) {
                AutoSelectItem.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.getTemplatePresentation().setText(OCBundle.message("resolve.contexts.select.automatically", new Object[0]), false);
        }

        @Override
        protected boolean matches(@Nullable OCResolveConfiguration config) {
            return config == null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AutoSelectItem.$$$reportNull$$$0(1);
            }
            OCResolveContextPanelUsageCollector.DEFAULT_CONFIGURATION_CLICKED.log(e.getProject());
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                OCInclusionContextUtil.resetUserSelectedConfigurations(this.myFile.getProject());
                OCResolveContextPanel.setUserConfiguration(this.myFile, null);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$AutoSelectItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ConfigurationItem
    extends ItemBase {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final OCResolveConfiguration myConfig;

        private ConfigurationItem(@NotNull PsiFile file, @NotNull OCResolveConfiguration config) {
            if (file == null) {
                ConfigurationItem.$$$reportNull$$$0(0);
            }
            if (config == null) {
                ConfigurationItem.$$$reportNull$$$0(1);
            }
            String text = config.getDisplayName();
            this.getTemplatePresentation().setText(text, false);
            this.myFile = file;
            this.myConfig = config;
        }

        @Override
        protected boolean matches(@Nullable OCResolveConfiguration config) {
            return config == this.myConfig;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigurationItem.$$$reportNull$$$0(2);
            }
            OCResolveContextPanelUsageCollector.CONFIGURATION_CLICKED.log(e.getProject());
            OCResolveContextPanel.scheduleReParse(this.myFile, this.myConfig);
        }

        @NotNull
        public OCResolveConfiguration getConfig() {
            OCResolveConfiguration oCResolveConfiguration = this.myConfig;
            if (oCResolveConfiguration == null) {
                ConfigurationItem.$$$reportNull$$$0(3);
            }
            return oCResolveConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ConfigurationItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ConfigurationItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class UnloadedItem
    extends ItemBase {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final OCUnloadedResolveContext myUnloadedContext;
        private final boolean myIsRelated;

        private UnloadedItem(@NotNull PsiFile file, @NotNull OCUnloadedResolveContext unloadedContext, boolean related) {
            if (file == null) {
                UnloadedItem.$$$reportNull$$$0(0);
            }
            if (unloadedContext == null) {
                UnloadedItem.$$$reportNull$$$0(1);
            }
            this.myIsRelated = related;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(unloadedContext.getDisplayName(), false);
            this.myFile = file;
            this.myUnloadedContext = unloadedContext;
        }

        public boolean isRelated() {
            return this.myIsRelated;
        }

        @Override
        protected boolean isGrayedOut() {
            return true;
        }

        @Override
        protected boolean isOutOfProject() {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UnloadedItem.$$$reportNull$$$0(2);
            }
            OCResolveContextPanelUsageCollector.UNLOADED_CONFIGURATION_CLICKED.log(e.getProject());
            Class configurableClass = this.myUnloadedContext.getConfigurableToSelect();
            if (configurableClass != null) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myFile.getProject(), configurableClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unloadedContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$UnloadedItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public final class ShowMoreItem
    extends ItemBase {
        private ShowMoreItem() {
            this.updateText();
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Always);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowMoreItem.$$$reportNull$$$0(0);
            }
            OCResolveContextPanelUsageCollector.SHOW_MORE_CLICKED.log(e.getProject());
            OCResolveContextPanel.this.myShowAllUnrelatedContexts = !OCResolveContextPanel.this.myShowAllUnrelatedContexts;
            this.updateText();
            ShowMoreItem.refilter(e.getInputEvent());
        }

        private void updateText() {
            this.getTemplatePresentation().setText(OCResolveContextPanel.this.myShowAllUnrelatedContexts ? OCBundle.message("resolve.show.related.contexts", new Object[0]) : OCBundle.message("resolve.show.all.contexts", new Object[0]), false);
        }

        private static void refilter(@Nullable InputEvent event) {
            if (event == null || !(event.getSource() instanceof JComponent)) {
                return;
            }
            Object property = ((JComponent)event.getSource()).getClientProperty(POPUP_MODEL);
            if (property instanceof DataProvider) {
                DataProvider dataProvider = (DataProvider)property;
                Objects.requireNonNull((ListPopupModel)POPUP_MODEL.getData(dataProvider)).refilter();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/ui/OCResolveContextPanel$ShowMoreItem", "actionPerformed"));
        }
    }

    private static abstract class ItemBase
    extends AnAction {
        private ItemBase() {
        }

        protected boolean matches(@Nullable OCResolveConfiguration config) {
            return false;
        }

        protected boolean isGrayedOut() {
            return false;
        }

        protected boolean isOutOfProject() {
            return false;
        }
    }
}

