/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapHeaderResolve;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.CallerAwareJob;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DirtyIncludesInvalidator
extends CallerAwareJob<Collection<VirtualFile>> {
    @NotNull
    private final FileSymbolTablesCache myCache;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    @NotNull
    private final MyConcurrentObjBoolMap<QualifiedName> moduleDirtyCache;
    @NotNull
    private final Set<String> myDirtyNames;
    private final boolean myIsRelativePath;

    DirtyIncludesInvalidator(@NotNull FileSymbolTablesCache cache, @NotNull Set<String> dirtyNames, boolean isRelativePath, int estimatedWorksetSize) {
        if (cache == null) {
            DirtyIncludesInvalidator.$$$reportNull$$$0(0);
        }
        if (dirtyNames == null) {
            DirtyIncludesInvalidator.$$$reportNull$$$0(1);
        }
        super(estimatedWorksetSize);
        this.moduleDirtyCache = new MyConcurrentObjBoolMap();
        this.myCache = cache;
        this.moduleMapManager = ModuleMapManager.getInstance(cache.getProject());
        this.myDirtyNames = dirtyNames;
        this.myIsRelativePath = isRelativePath;
    }

    @NotNull
    Collection<VirtualFile> collect(@NotNull ImmutableList<VirtualFile> workset2) {
        if (workset2 == null) {
            DirtyIncludesInvalidator.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection collection = (Collection)this.run(new FileWorker(null, workset2));
        if (collection == null) {
            DirtyIncludesInvalidator.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/DirtyIncludesInvalidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/DirtyIncludesInvalidator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyConcurrentObjBoolMap<T> {
        @NotNull
        private final Object2ByteOpenHashMap<T> map = new Object2ByteOpenHashMap();
        @NotNull
        private final Lock r;
        @NotNull
        private final Lock w;

        MyConcurrentObjBoolMap() {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.w = lock.writeLock();
            this.r = lock.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Boolean getBoolean(@NotNull T key) {
            if (key == null) {
                MyConcurrentObjBoolMap.$$$reportNull$$$0(0);
            }
            this.r.lock();
            try {
                byte b = this.map.getByte(key);
                Boolean bl = b == 0 ? null : Boolean.valueOf(b > 0);
                return bl;
            }
            finally {
                this.r.unlock();
            }
        }

        void putBoolean(@NotNull T key, boolean value) {
            if (key == null) {
                MyConcurrentObjBoolMap.$$$reportNull$$$0(1);
            }
            this.w.lock();
            try {
                this.map.put(key, (byte)(value ? 1 : -1));
            }
            finally {
                this.w.unlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/DirtyIncludesInvalidator$MyConcurrentObjBoolMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBoolean";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putBoolean";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class FileWorker
    extends CallerAwareJob.IterativeWorker<VirtualFile> {
        @NotNull
        private final Map<QualifiedName, Collection<VirtualFile>> additionalModulesWorkset;
        @NotNull
        private final Set<QualifiedName> newModulesImportedByFile;
        @NotNull
        private final List<VirtualFile> result;

        private FileWorker(@NotNull FileWorker parent, ImmutableList<? extends VirtualFile> workset2) {
            if (workset2 == null) {
                FileWorker.$$$reportNull$$$0(0);
            }
            super(DirtyIncludesInvalidator.this, parent, workset2);
            this.additionalModulesWorkset = new HashMap<QualifiedName, Collection<VirtualFile>>();
            this.newModulesImportedByFile = new HashSet<QualifiedName>();
            this.result = new ArrayList<VirtualFile>();
        }

        @Nullable
        private FileWorker getParent() {
            return (FileWorker)this.getCompleter();
        }

        @NotNull
        protected FileWorker newWorker(@NotNull ImmutableList<? extends VirtualFile> workset2) {
            if (workset2 == null) {
                FileWorker.$$$reportNull$$$0(1);
            }
            return new FileWorker(this, workset2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(@NotNull ImmutableList<? extends VirtualFile> workset2) {
            if (workset2 == null) {
                FileWorker.$$$reportNull$$$0(2);
            }
            block3: for (VirtualFile file : workset2) {
                this.newModulesImportedByFile.clear();
                for (FileSymbolTable table : DirtyIncludesInvalidator.this.myCache.allTablesForFile(file)) {
                    for (OCSymbol include : table.getContents()) {
                        if (!(include instanceof OCIncludeSymbol ? this.isIncludeDirty((OCIncludeSymbol)include) : include instanceof OCModuleImportSymbol && this.isModuleDirty((OCModuleImportSymbol)include))) continue;
                        List<VirtualFile> list = this.result;
                        synchronized (list) {
                            this.result.add(file);
                            continue block3;
                        }
                    }
                }
                for (QualifiedName moduleName : this.newModulesImportedByFile) {
                    this.additionalModulesWorkset.computeIfAbsent(moduleName, m -> new SmartList()).add(file);
                }
            }
        }

        private boolean isIncludeDirty(@NotNull OCIncludeSymbol includeSymbol) {
            if (includeSymbol == null) {
                FileWorker.$$$reportNull$$$0(3);
            }
            return DirtyIncludesInvalidator.this.myDirtyNames.contains(DirtyIncludesInvalidator.this.myIsRelativePath ? includeSymbol.getRelativePath() : includeSymbol.getLastPathComponent());
        }

        private boolean isModuleDirty(@NotNull OCModuleImportSymbol include) {
            QualifiedName moduleName;
            if (include == null) {
                FileWorker.$$$reportNull$$$0(4);
            }
            if ((moduleName = include.getModuleName()) == null) {
                return false;
            }
            Boolean dirty = DirtyIncludesInvalidator.this.moduleDirtyCache.getBoolean(moduleName);
            if (dirty == null) {
                this.newModulesImportedByFile.add(moduleName);
            }
            return dirty == Boolean.TRUE;
        }

        @Override
        protected void processingFinished() {
            if (!this.additionalModulesWorkset.isEmpty()) {
                DirtyIncludesInvalidator.this.scheduleOnCallerAsPending(this, new ModuleWorker(this, this.additionalModulesWorkset));
            }
            this.tryComplete();
        }

        @Override
        public void onCompletion(@NotNull CountedCompleter<?> caller) {
            FileWorker parent;
            if (caller == null) {
                FileWorker.$$$reportNull$$$0(5);
            }
            if ((parent = this.getParent()) != null && !this.result.isEmpty()) {
                parent.propagateResults(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void propagateResults(Collection<VirtualFile> childResults) {
            List<VirtualFile> list = this.result;
            synchronized (list) {
                this.result.addAll(childResults);
            }
        }

        @Override
        public List<VirtualFile> getRawResult() {
            return this.result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workset";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includeSymbol";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "include";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caller";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/DirtyIncludesInvalidator$FileWorker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newWorker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIncludeDirty";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isModuleDirty";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCompletion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ModuleWorker
    extends CountedCompleter<Collection<VirtualFile>>
    implements BiConsumer<QualifiedName, Collection<VirtualFile>> {
        @NotNull
        private final Map<QualifiedName, Collection<VirtualFile>> workset;
        @NotNull
        private final Set<VirtualFile> result;

        private ModuleWorker(@NotNull FileWorker parent, Map<QualifiedName, Collection<VirtualFile>> workset2) {
            if (workset2 == null) {
                ModuleWorker.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ModuleWorker.$$$reportNull$$$0(1);
            }
            super(parent);
            this.result = new HashSet<VirtualFile>();
            this.workset = workset2;
        }

        @NotNull
        private FileWorker getParent() {
            FileWorker fileWorker = (FileWorker)this.getCompleter();
            if (fileWorker == null) {
                ModuleWorker.$$$reportNull$$$0(2);
            }
            return fileWorker;
        }

        @Override
        public void compute() {
            AlreadyComputedRemover remover = new AlreadyComputedRemover();
            DirtyIncludesInvalidator.this.moduleDirtyCache.r.lock();
            try {
                this.workset.forEach(remover);
            }
            finally {
                DirtyIncludesInvalidator.this.moduleDirtyCache.r.unlock();
            }
            this.workset.forEach(this);
            this.tryComplete();
        }

        @Override
        public void accept(@NotNull QualifiedName moduleName, @NotNull Collection<VirtualFile> files) {
            if (moduleName == null) {
                ModuleWorker.$$$reportNull$$$0(3);
            }
            if (files == null) {
                ModuleWorker.$$$reportNull$$$0(4);
            }
            if (files.isEmpty()) {
                return;
            }
            ModuleMapManager.Cache globalCache = DirtyIncludesInvalidator.this.moduleMapManager.getGlobalCache();
            ModuleMapSymbol module = globalCache.findModule(moduleName);
            if (module != null) {
                for (String name : DirtyIncludesInvalidator.this.myIsRelativePath ? ModuleMapHeaderResolve.getIncludeHeaderRelativePaths(module) : ContainerUtil.map(module.getIncludeHeaders(), VirtualFile::getName)) {
                    if (!DirtyIncludesInvalidator.this.myDirtyNames.contains(name)) continue;
                    DirtyIncludesInvalidator.this.moduleDirtyCache.putBoolean(moduleName, true);
                    this.result.addAll(files);
                    return;
                }
            }
            DirtyIncludesInvalidator.this.moduleDirtyCache.putBoolean(moduleName, false);
        }

        @Override
        public Set<VirtualFile> getRawResult() {
            return this.result;
        }

        @Override
        public void onCompletion(CountedCompleter<?> caller) {
            if (!this.result.isEmpty()) {
                this.getParent().propagateResults(this.result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workset";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/DirtyIncludesInvalidator$ModuleWorker";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/DirtyIncludesInvalidator$ModuleWorker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        private class AlreadyComputedRemover
        implements BiConsumer<QualifiedName, Collection<VirtualFile>> {
            private AlreadyComputedRemover() {
            }

            @Override
            public void accept(@NotNull QualifiedName moduleName, @NotNull Collection<VirtualFile> files) {
                Boolean dirty;
                if (moduleName == null) {
                    AlreadyComputedRemover.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    AlreadyComputedRemover.$$$reportNull$$$0(1);
                }
                if ((dirty = DirtyIncludesInvalidator.this.moduleDirtyCache.getBoolean(moduleName)) == null) {
                    return;
                }
                if (dirty.booleanValue()) {
                    ModuleWorker.this.result.addAll(files);
                }
                files.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "moduleName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/DirtyIncludesInvalidator$ModuleWorker$AlreadyComputedRemover";
                objectArray[2] = "accept";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

