/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.symbols.symtable.ConsumedTokenRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CountingPsiBuilder
extends PsiBuilderAdapter
implements WhitespaceSkippedCallback {
    private final List<ConsumedTokenRange> myConsumedTokenRanges;

    public CountingPsiBuilder(PsiBuilder builder) {
        super(builder);
        assert (builder instanceof PsiBuilderImpl);
        int lexemeCount = ((PsiBuilderImpl)builder).getLexemeCount();
        this.myConsumedTokenRanges = new ArrayList<Object>(Collections.nCopies(lexemeCount, null));
        builder.setWhitespaceSkippedCallback((WhitespaceSkippedCallback)this);
    }

    public void advanceLexer() {
        this.onTokenConsumed(0);
        super.advanceLexer();
    }

    public IElementType lookAhead(int steps) {
        this.emulateLookAhead(steps);
        return super.lookAhead(steps);
    }

    private void emulateLookAhead(int steps) {
        PsiBuilderImpl impl = (PsiBuilderImpl)this.getDelegate();
        if (!this.eof()) {
            int cur = this.rawTokenIndex();
            while (steps > 0) {
                this.onTokenConsumed(cur);
                ++cur;
                while (true) {
                    this.onTokenConsumed(cur);
                    if (cur >= impl.getLexemeCount() || !impl.whitespaceOrComment(impl.rawLookup(cur - this.rawTokenIndex()))) break;
                    ++cur;
                }
                --steps;
            }
        }
    }

    private void onTokenConsumed(int offset) {
        int idx = this.rawTokenIndex() + offset;
        if (idx < this.myConsumedTokenRanges.size()) {
            this.getOrAddConsumedToken(offset).onConsumed();
        }
    }

    @NotNull
    private ConsumedTokenRange getOrAddConsumedToken(int offset) {
        int idx = this.rawTokenIndex() + offset;
        ConsumedTokenRange existing = this.myConsumedTokenRanges.get(idx);
        if (existing == null) {
            int begin = this.getDelegate().rawTokenTypeStart(offset);
            int end = this.getDelegate().rawTokenTypeStart(offset + 1);
            ConsumedTokenRange result = new ConsumedTokenRange(begin, end);
            this.myConsumedTokenRanges.set(idx, result);
            ConsumedTokenRange consumedTokenRange = result;
            if (consumedTokenRange == null) {
                CountingPsiBuilder.$$$reportNull$$$0(0);
            }
            return consumedTokenRange;
        }
        ConsumedTokenRange consumedTokenRange = existing;
        if (consumedTokenRange == null) {
            CountingPsiBuilder.$$$reportNull$$$0(1);
        }
        return consumedTokenRange;
    }

    public List<ConsumedTokenRange> getConsumedTokenRanges() {
        return this.myConsumedTokenRanges;
    }

    public void onSkip(IElementType type, int start, int end) {
        this.onTokenConsumed(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/CountingPsiBuilder", "getOrAddConsumedToken"));
    }
}

