/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.settings.CidrCodeStylePreview;
import com.jetbrains.cidr.lang.settings.CidrCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCBaseLanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCCustomOption;
import com.jetbrains.cidr.lang.settings.OCCustomOptionCpp;
import com.jetbrains.cidr.lang.settings.OCCustomOptionObjC;
import com.jetbrains.cidr.lang.settings.OCGenerateCodeConfigurable;
import com.jetbrains.cidr.lang.settings.OCIndentOptionsEditor;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageCodeStyleSettingsProvider
extends OCBaseLanguageCodeStyleSettingsProvider {
    public OCLanguageCodeStyleSettingsProvider() {
        super(OCLanguageUtils.getConfigLanguage());
    }

    @NotNull
    private static OCCustomOption getCustomOption() {
        return OCLanguage.enableObjectiveCSettings() ? new OCCustomOptionObjC() : new OCCustomOptionCpp();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (indentOptions == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        CidrCodeStyleSettings.configureDefaultSettings((CommonCodeStyleSettings)commonSettings);
    }

    @NotNull
    public static String getCodeSample(@NotNull String fileNameWithoutExt) {
        if (fileNameWithoutExt == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        String defExampleExtension = OCLanguageCodeStyleSettingsProvider.getCustomOption().getExampleExtension();
        String string = CidrCodeStylePreview.getCodeSample((String)fileNameWithoutExt, (String)defExampleExtension);
        if (string == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static OCCustomOption.CustomOption @NotNull [] getFoldingCustomOptions() {
        OCCustomOption.CustomOption[] customOptionArray = OCLanguageCodeStyleSettingsProvider.getCustomOption().getFoldingCustomOptions();
        if (customOptionArray == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return customOptionArray;
    }

    public static AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        AttributesDescriptor[] attributesDescriptorArray = OCLanguageCodeStyleSettingsProvider.getCustomOption().getAttributeDescriptors();
        if (attributesDescriptorArray == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        return attributesDescriptorArray;
    }

    @Override
    @NotNull
    protected String getCodeSampleContent(@NotNull String fileNameWithoutExt) {
        if (fileNameWithoutExt == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        return OCLanguageCodeStyleSettingsProvider.getCodeSample(fileNameWithoutExt);
    }

    public String getFileExt() {
        return OCLanguageCodeStyleSettingsProvider.getCustomOption().getExampleExtension();
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new OCIndentOptionsEditor(this);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable c, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (c == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (settingsType == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        OCCustomOption customOption = OCLanguageCodeStyleSettingsProvider.getCustomOption();
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            c.showStandardOptions(customOption.getWrappingAndBracesOptions());
            for (OCCustomOption.RenameAction renameAction : customOption.getWrappingAndBracesRenames()) {
                c.renameStandardOption(renameAction.getFrom(), renameAction.getTo());
            }
            for (OCCustomOption.CustomOption customOption2 : customOption.getWrappingAndBracesCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption2.getFieldName(), customOption2.getTitle(), customOption2.getGroupName(), customOption2.getAnchor(), customOption2.getAnchorFieldName(), customOption2.getOptions());
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            c.showStandardOptions(customOption.getSpacingOptions());
            for (OCCustomOption.RenameAction renameAction : customOption.getSpacingRenames()) {
                c.renameStandardOption(renameAction.getFrom(), renameAction.getTo());
            }
            for (OCCustomOption.CustomOption customOption3 : customOption.getSpacingCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption3.getFieldName(), customOption3.getTitle(), customOption3.getGroupName(), customOption3.getAnchor(), customOption3.getAnchorFieldName(), customOption3.getOptions());
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            for (OCCustomOption.CustomOption customOption4 : customOption.getIndentCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption4.getFieldName(), customOption4.getTitle(), customOption4.getGroupName(), customOption4.getAnchor(), customOption4.getAnchorFieldName(), customOption4.getOptions());
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC) {
            OCGenerateCodeConfigurable.customizeSettings(c);
        } else {
            c.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AFTER_CLASS_HEADER", "BLANK_LINES_AROUND_FIELD_IN_INTERFACE", "BLANK_LINES_AROUND_METHOD_IN_INTERFACE", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY"});
        }
        for (OCCustomOption.RenameAction renameAction : customOption.getBlankLinesRenames()) {
            c.renameStandardOption(renameAction.getFrom(), renameAction.getTo());
        }
    }

    @NotNull
    public String getExternalLanguageId() {
        return "c";
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        CidrCodeStyleSettings.NewLineConstant newLineConstantAnnotation;
        if (codeStyleObject == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        if (field == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        if ((newLineConstantAnnotation = field.getAnnotation(CidrCodeStyleSettings.NewLineConstant.class)) != null) {
            return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{0, 1, 2}, new String[]{"never", "always", "if_long"});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExt";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeSample";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingCustomOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSampleContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

