/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressResult;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExternalResolver;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.constructors.OCConstructorReferenceFromCompoundInit;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNamesValidator;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCInplaceRenamer
extends MemberInplaceRenamer {
    private static final int MODAL_DIALOG_DELAY_MS = 1000;
    protected final OCSymbol mySymbol;
    protected final boolean myCategoryMode;
    private PsiElement mySelectorIdentifier;
    private int mySelectorIndex;
    private boolean myConvertToSetter;
    private boolean myInplaceRenameStarted;

    public OCInplaceRenamer(@NotNull OCMethod elementToRename, @NotNull OCMethodSymbol symbol, PsiElement selectorIdentifier, int selectorIndex, Editor editor, String initialName, String oldName) {
        if (elementToRename == null) {
            OCInplaceRenamer.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            OCInplaceRenamer.$$$reportNull$$$0(1);
        }
        super((PsiNamedElement)elementToRename, (PsiElement)elementToRename, editor, initialName != null ? initialName : selectorIdentifier.getText(), oldName != null ? oldName : selectorIdentifier.getText());
        this.myInplaceRenameStarted = false;
        this.mySymbol = symbol;
        this.myCategoryMode = false;
        this.mySelectorIdentifier = selectorIdentifier;
        this.mySelectorIndex = selectorIndex;
        boolean bl = this.myConvertToSetter = this.mySelectorIdentifier.getParent() instanceof OCQualifiedExpression && new OCReadWriteAccessDetector().getExpressionAccess(this.mySelectorIdentifier.getParent()) == ReadWriteAccessDetector.Access.Write;
        assert (this.mySelectorIndex != -1);
    }

    public OCInplaceRenamer(@NotNull PsiNamedElement elementToRename, @NotNull OCSymbol symbol, Editor editor, boolean categoryMode, String initialName, String oldName) {
        if (elementToRename == null) {
            OCInplaceRenamer.$$$reportNull$$$0(2);
        }
        if (symbol == null) {
            OCInplaceRenamer.$$$reportNull$$$0(3);
        }
        super(elementToRename, (PsiElement)elementToRename, editor, initialName != null ? initialName : OCInplaceRenamer.getElementName(elementToRename), oldName != null ? oldName : OCInplaceRenamer.getElementName(elementToRename));
        this.myInplaceRenameStarted = false;
        this.mySymbol = symbol;
        this.myCategoryMode = categoryMode;
    }

    private static String getElementName(PsiNamedElement elementToRename) {
        OCSymbolWithQualifiedName symbol;
        if (elementToRename instanceof OCDeclarator && elementToRename.getParent() instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)elementToRename.getParent()).getSymbol()) instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
            return symbol.getName().substring(1);
        }
        return elementToRename.getName();
    }

    @TestOnly
    public Collection<PsiElement> getMarkedElements() {
        ArrayList<Pair<PsiElement, TextRange>> stringUsages = new ArrayList<Pair<PsiElement, TextRange>>();
        Collection<PsiReference> refs = this.collectRefs(this.getReferencesSearchScope(OCInplaceRenamer.getTopLevelVirtualFile((FileViewProvider)this.myElementToRename.getContainingFile().getViewProvider())));
        this.appendAdditionalElement(refs, stringUsages);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        refs.stream().map(ref -> ref.getElement()).forEach(e -> result.add((PsiElement)e));
        stringUsages.stream().map(pair -> (PsiElement)pair.getFirst()).forEach(e -> result.add((PsiElement)e));
        return result;
    }

    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        return (Boolean)this.executeUnderModalDialog(() -> this.appendAdditionalElementImpl(refs, stringUsages), OCRefactoringBundle.message("progress.title.inplace.rename.appending.additional.elements", new Object[0]));
    }

    private boolean appendAdditionalElementImpl(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        boolean showChooser = super.appendAdditionalElement(refs, stringUsages);
        OCInplaceRenamer.filterStringUsages(stringUsages);
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        VirtualFile curVirtualFile = currentFile != null ? currentFile.getVirtualFile() : null;
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
            OCSymbolWithQualifiedName owner;
            OCFunctionSymbol function;
            if (Comparing.equal((Object)symbol.getContainingFile(), (Object)curVirtualFile)) {
                PsiElement definition = symbol.locateDefinition(this.myProject);
                if (this.myCategoryMode) {
                    if (definition instanceof OCClassDeclaration && Objects.equals(((OCClassSymbol)this.mySymbol).getCategoryName(), ((OCClassSymbol)symbol).getCategoryName())) {
                        PsiElement identifier = ((OCClassDeclaration)definition).getCategoryElement().getNameIdentifier();
                        OCInplaceRenamer.appendStringUsage(identifier, stringUsages);
                    }
                } else if (definition instanceof PsiNameIdentifierOwner) {
                    if (definition instanceof OCMethod) {
                        PsiElement selector;
                        List<OCMethodSelectorPart> parameters = ((OCMethod)definition).getParameters();
                        if (this.mySelectorIndex < parameters.size() && (selector = parameters.get(this.mySelectorIndex).getSelectorIdentifier()) != null && this.mySelectorIdentifier != null && selector.getText().equals(this.mySelectorIdentifier.getText())) {
                            OCInplaceRenamer.appendStringUsage(selector, stringUsages);
                        }
                    } else {
                        OCInplaceRenamer.appendStringUsage(((PsiNameIdentifierOwner)definition).getNameIdentifier(), stringUsages);
                    }
                }
                if (symbol instanceof OCLocalizedStringSymbol) {
                    OCInplaceRenamer.appendReference(new OCStringResourceReference(this.myElementToRename.getFirstChild(), FileUtilRt.getNameWithoutExtension((String)this.myElementToRename.getContainingFile().getName())), refs);
                }
            }
            if (symbol instanceof OCStructSymbol) {
                OCInplaceRenamer.appendAdditionalSymbolsForStruct((OCStructSymbol)symbol, stringUsages, refs, currentFile);
            } else if (symbol instanceof OCFunctionSymbol && ((function = (OCFunctionSymbol)symbol).isCppConstructor() || function.isCppDestructor()) && (owner = function.getResolvedOwner(OCResolveContext.forPsi((PsiElement)currentFile))) instanceof OCStructSymbol) {
                OCInplaceRenamer.appendAdditionalSymbol(owner, stringUsages, refs, currentFile);
                OCInplaceRenamer.appendAdditionalSymbolsForStruct((OCStructSymbol)owner, stringUsages, refs, currentFile);
            }
            return true;
        }), this.myProject);
        if (this.mySelectorIdentifier != null) {
            for (PsiReference ref : refs) {
                PsiElement element = ref.getElement();
                PsiElement selector = null;
                if (element instanceof OCSendMessageExpression) {
                    List<OCArgumentSelector> selectors = ((OCSendMessageExpression)element).getArgumentSelectors();
                    if (this.mySelectorIndex < selectors.size()) {
                        selector = selectors.get(this.mySelectorIndex).getSelectorIdentifier();
                    }
                } else if (element instanceof OCQualifiedExpression) {
                    selector = ((OCQualifiedExpression)element).getNameIdentifier();
                } else if (element instanceof OCSelectorExpression) {
                    selector = ((OCSelectorExpression)element).getSelectorParts().get(this.mySelectorIndex);
                }
                if (selector == null || !selector.getText().equals(this.mySelectorIdentifier.getText())) continue;
                OCInplaceRenamer.appendStringUsage(selector, stringUsages);
            }
            refs.clear();
        }
        refs.removeIf(r -> r instanceof OCConstructorReferenceFromCompoundInit);
        return showChooser;
    }

    private static void appendStringUsage(PsiElement element, Collection<? super Pair<PsiElement, TextRange>> stringUsages) {
        if (element != null && !OCElementUtil.isPartOfMacroSubstitution(element)) {
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)element, (Object)new TextRange(0, element.getTextLength())));
        }
    }

    private static void filterStringUsages(Collection<Pair<PsiElement, TextRange>> stringUsages) {
        stringUsages.removeIf(elementAndTextRange -> OCElementUtil.isPartOfMacroSubstitution((PsiElement)elementAndTextRange.getFirst()));
    }

    private static void appendAdditionalSymbolsForStruct(OCStructSymbol symbol, Collection<? super Pair<PsiElement, TextRange>> stringUsages, Collection<? super PsiReference> refs, @NotNull PsiFile currentFile) {
        if (currentFile == null) {
            OCInplaceRenamer.$$$reportNull$$$0(4);
        }
        Processor processor2 = symbol1 -> {
            OCInplaceRenamer.appendAdditionalSymbol(symbol1, stringUsages, refs, currentFile);
            return true;
        };
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)currentFile);
        symbol.processConstructors((Processor<? super OCFunctionSymbol>)processor2, true, context);
        symbol.processDestructors((Processor<? super OCFunctionSymbol>)processor2, true, context);
        symbol.processDeductionGuides((Processor<? super OCDeductionGuideSymbol>)processor2, context);
    }

    private static void appendAdditionalSymbol(OCSymbol symbol, Collection<? super Pair<PsiElement, TextRange>> stringUsages, Collection<? super PsiReference> refs, PsiFile currentFile) {
        PsiElement identifier;
        if (!Comparing.equal((Object)symbol.getContainingFile(), (Object)currentFile.getVirtualFile())) {
            return;
        }
        PsiElement definition = symbol.locateDefinition(currentFile.getProject());
        if (definition instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)definition).getNameIdentifier()) != null) {
            OCInplaceRenamer.appendStringUsage(identifier, stringUsages);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)definition, (SearchScope)new LocalSearchScope((PsiElement)currentFile), (boolean)false).findAll()) {
                if (reference.getElement() instanceof OCDeclarator) continue;
                OCInplaceRenamer.appendReference(reference, refs);
            }
        }
    }

    protected PsiElement checkLocalScope() {
        PsiFile currentFile;
        if (this.mySymbol.getKind() == OCSymbolKind.PARAMETER && this.mySymbol.getAssociatedSymbol(this.myProject) != null && (currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            return currentFile;
        }
        return super.checkLocalScope();
    }

    protected PsiNamedElement getVariable() {
        return this.myRenameOffset == null || this.myElementToRename instanceof OCLocalizedString && this.myElementToRename.isValid() ? this.myElementToRename : super.getVariable();
    }

    public PsiElement getSubstituted() {
        return this.myRenameOffset == null || this.myElementToRename instanceof OCLocalizedString && this.myElementToRename.isValid() ? this.myElementToRename : super.getSubstituted();
    }

    protected JComponent getComponent() {
        if (this.myCategoryMode) {
            return null;
        }
        final OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(null);
        OCRenameProcessor.processAssociatedSymbols(this.mySymbol, new OCRenameProcessor.AssociatedElementsProcessor(){

            @Override
            public boolean processIvar(OCInstanceVariableSymbol ivar, OCPropertySymbol fromProperty) {
                if (ivar.isClang4ImplicitIvar(OCInplaceRenamer.this.myProject)) {
                    return true;
                }
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, OCRefactoringBundle.message("refactoring.rename", ivar.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)OCInplaceRenamer.this.myElementToRename))), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_PROPERTIES_AND_IVARS = selected;
                    return settings2.REFACTOR_PROPERTIES_AND_IVARS;
                }));
                return false;
            }

            @Override
            public boolean processPropertyAccessors(OCPropertySymbol property) {
                return false;
            }

            @Override
            public boolean processProperty(OCPropertySymbol property, OCSymbol fromSymbol) {
                if (!(fromSymbol instanceof OCInstanceVariableSymbol) || ((OCInstanceVariableSymbol)fromSymbol).isClang4ImplicitIvar(OCInplaceRenamer.this.myProject)) {
                    return true;
                }
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, OCRefactoringBundle.message("refactoring.rename", property.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)OCInplaceRenamer.this.myElementToRename))), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_PROPERTIES_AND_IVARS = selected;
                    return settings2.REFACTOR_PROPERTIES_AND_IVARS;
                }));
                return false;
            }

            @Override
            public boolean processClassAlias(OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, OCRefactoringBundle.message("refactoring.rename.class.aliases", new Object[0]), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = selected;
                    return settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
                }));
                return false;
            }

            @Override
            public boolean processClass(OCCompatibilityAliasSymbol alias, OCClassSymbol clazz) {
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, OCRefactoringBundle.message("refactoring.rename", clazz.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)OCInplaceRenamer.this.myElementToRename))), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = selected;
                    return settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
                }));
                return false;
            }
        }, (SearchScope)OCSearchScope.getProjectSourcesScope(this.myProject), this.myProject);
        return panel.getComponentCount() > 0 ? panel : null;
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        Collection references = super.collectRefs(referencesSearchScope);
        this.updateNameSuggestions(references);
        return references;
    }

    protected void addReferenceAtCaret(Collection<? super PsiReference> refs) {
        PsiFile editorFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiFile containingFile = editorFile != null ? editorFile : this.myElementToRename.getContainingFile();
        PsiReference reference = containingFile.findReferenceAt(this.myEditor.getCaretModel().getOffset());
        if (reference instanceof OCOperatorReference && reference.isReferenceTo((PsiElement)this.myElementToRename)) {
            return;
        }
        super.addReferenceAtCaret(refs);
    }

    public void performRenameInner(final @NotNull PsiElement element, @NlsSafe @NotNull String newName) {
        if (element == null) {
            OCInplaceRenamer.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            OCInplaceRenamer.$$$reportNull$$$0(6);
        }
        if (this.mySelectorIdentifier != null || this.mySymbol instanceof OCFunctionSymbol && !this.mySymbol.getKind().isConstructorOrDestructor()) {
            PsiElement definition;
            if (this.myConvertToSetter) {
                newName = "set" + StringUtil.capitalize((String)newName);
            }
            if ((definition = OCElementUtil.findRenameTargetDefinition(element, false)) instanceof OCCallable) {
                OCCallable callable = (OCCallable)definition;
                EnumSet<OCChangeSignatureActionHandler.ChangeSignatureFlags> flags = EnumSet.of(OCChangeSignatureActionHandler.ChangeSignatureFlags.SilentMode);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    flags.add(OCChangeSignatureActionHandler.ChangeSignatureFlags.AskForSuperMethods);
                }
                OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, element, flags);
                handler.setTitle(this.getCommandName());
                if (this.mySymbol instanceof OCFunctionSymbol) {
                    handler.setName((String)newName);
                } else {
                    handler.renameSelector(this.mySelectorIndex, (String)newName);
                }
                handler.invoke();
            }
        } else {
            if (this.mySymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)this.mySymbol).isClang4ImplicitIvar(this.myProject) && !((String)newName).startsWith("_")) {
                newName = "_" + (String)newName;
            }
            if (this.mySymbol instanceof OCPropertySymbol && ((String)newName).startsWith("_")) {
                newName = ((String)newName).substring(1);
            }
            Object newNameFinal = newName;
            RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement((PsiElement)element);
            RenameProcessor renameProcessor = new RenameProcessor(this.myProject, element, (String)newName, elementProcessor.isToSearchInComments(element), elementProcessor.isToSearchForTextOccurrences(element), (String)newNameFinal){
                private OCRenameProcessor.RenameUsages myOption;
                final /* synthetic */ String val$newNameFinal;
                {
                    this.val$newNameFinal = string;
                    super(arg0, arg1, arg2, arg3, arg4);
                }

                public void prepareRenaming(@NotNull PsiElement element2, String newName, LinkedHashMap<PsiElement, String> allRenames) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    OCInplaceRenamer.this.executeUnderModalDialog(() -> {
                        super.prepareRenaming(element2, newName, allRenames);
                        return true;
                    }, OCRefactoringBundle.message("progress.title.inplace.rename.preparing", new Object[0]));
                }

                public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
                    if (refUsages == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (!super.preprocessUsages(refUsages)) {
                        return false;
                    }
                    this.myOption = OCRenameProcessor.validateUsages(OCInplaceRenamer.this.myElementToRename, refUsages, OCInplaceRenamer.this.myInplaceRenameStarted);
                    return this.myOption != OCRenameProcessor.RenameUsages.CANCEL;
                }

                protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
                    if (usages == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return this.myOption == OCRenameProcessor.RenameUsages.SHOW_USAGES;
                }

                public UsageInfo @NotNull [] findUsages() {
                    PsiFile containingFile = element.getContainingFile();
                    if (containingFile != null) {
                        for (OCExternalResolver resolver : OCExternalResolver.EP_NAME.getExtensionList()) {
                            resolver.ensureUpToDate(containingFile);
                        }
                    }
                    ArrayList<UsageInfo> result = new ArrayList<UsageInfo>(Arrays.asList(super.findUsages()));
                    ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters(element, element.getUseScope(), false);
                    new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(parameters, (Processor<? super OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)((Processor)usage -> {
                        PsiElement e = usage.getElement();
                        if (OCElementUtil.getElementType(e) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
                            TextRange range = usage.getTextRange();
                            result.add((UsageInfo)NonCodeUsageInfo.create((PsiFile)e.getContainingFile(), (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)element, (String)this.val$newNameFinal));
                        }
                        return true;
                    }));
                    UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
                    if (usageInfoArray == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return usageInfoArray;
                }

                @NotNull
                protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
                    if (usages == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    LinkedHashMap<PsiElement, String> renamesMap = new LinkedHashMap<PsiElement, String>();
                    for (PsiElement psiElement : this.myAllRenames.keySet()) {
                        if (!(psiElement instanceof OCSymbolDeclarator) || ((OCSymbolDeclarator)psiElement).getSymbol() == null) continue;
                        renamesMap.put(psiElement, (String)this.myAllRenames.get(psiElement));
                    }
                    return new RenameViewDescriptor(renamesMap);
                }

                public void doRun() {
                    try {
                        if (OCRenameUtil.askToRenameSameEntityIfNeed(element)) {
                            super.doRun();
                        }
                    }
                    finally {
                        OCInplaceRenamer.this.restoreCaretOffsetAfterRename();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refUsages";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "usages";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenamer$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenamer$2";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "findUsages";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "prepareRenaming";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "preprocessUsages";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isPreviewUsages";
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "createUsageViewDescriptor";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 3 -> new IllegalStateException(string);
                    };
                }
            };
            renameProcessor.run();
        }
    }

    public boolean performInplaceRename(@Nullable Collection<String> nameSuggestions) {
        this.myInplaceRenameStarted = this.performInplaceRefactoring(nameSuggestions == null ? new LinkedHashSet() : new LinkedHashSet<String>(nameSuggestions));
        return this.myInplaceRenameStarted;
    }

    private void updateNameSuggestions(@NotNull Collection<PsiReference> references) {
        if (references == null) {
            OCInplaceRenamer.$$$reportNull$$$0(7);
        }
        if (this.myNameSuggestions == null) {
            this.myNameSuggestions = new LinkedHashSet();
        }
        String originalName = this.myElementToRename.getName();
        if (this.myElementToRename instanceof OCDeclarator) {
            predefinedNames = ContainerUtil.createMaybeSingletonList((Object)originalName);
            this.myNameSuggestions.addAll(OCNameSuggester.suggestForDeclaration((OCDeclarator)this.myElementToRename, false, predefinedNames));
        } else {
            predefinedNames = this.myElementToRename;
            if (predefinedNames instanceof OCMethodSelectorPart) {
                OCMethodSelectorPart selectorPart = (OCMethodSelectorPart)((Object)predefinedNames);
                ArrayList<String> paramNames = new ArrayList<String>();
                OCMethod method = (OCMethod)this.myElementToRename.getParent();
                List<OCMethodSelectorPart> parameters = method.getParameters();
                for (OCMethodSelectorPart part : parameters) {
                    String parameterName = part.getParameterName();
                    if (parameterName == null) continue;
                    paramNames.add(parameterName);
                }
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)this.myElementToRename);
                this.myNameSuggestions.addAll(OCNameSuggester.suggestForType(selectorPart.getType(), (PsiElement)selectorPart, paramNames, context));
                this.myNameSuggestions.add(OCNameSuggester.suggestForParameter(paramNames, parameters.get(0) == this.myElementToRename, selectorPart.getSelectorPart(), selectorPart.getType(), (OCMethodSymbol)method.getSymbol(), null, context));
            }
        }
        for (PsiReference ref : references) {
            OCExpression expr = null;
            PsiElement element = ref.getElement();
            if (element instanceof OCQualifiedExpression) {
                expr = (OCExpression)element;
            } else if (element instanceof OCReferenceElement && element.getParent() instanceof OCReferenceExpression) {
                expr = (OCExpression)element.getParent();
            }
            if (expr == null) continue;
            this.myNameSuggestions.addAll(OCNameSuggester.suggestForExpression(this.mySymbol.getKind(), expr, false));
        }
        Iterator iterator2 = this.myNameSuggestions.iterator();
        while (iterator2.hasNext()) {
            String name = (String)iterator2.next();
            if ((originalName == null || !name.startsWith(originalName) || !name.substring(originalName.length()).matches("[0-9]*")) && OCCodeInsightUtil.isUniqueInScope(this.mySymbol.getKind(), name, (PsiElement)this.myElementToRename, this.myProject)) continue;
            iterator2.remove();
        }
        if (this.myNameSuggestions.isEmpty()) {
            this.myNameSuggestions.add(originalName);
        }
    }

    @TestOnly
    public void performRefactoringForTest(String newName) {
        this.performRefactoringRename(newName, null);
    }

    protected boolean acceptReference(PsiReference reference) {
        return !OCElementUtil.isPartOfMacroSubstitution(reference.getElement()) && Objects.equals(reference.getCanonicalText(), this.myElementToRename.getName());
    }

    private static void appendReference(PsiReference ref, Collection<? super PsiReference> refs) {
        if (!OCElementUtil.isPartOfMacroSubstitution(ref.getElement())) {
            refs.add((PsiReference)ref);
        }
    }

    protected boolean isIdentifier(String newName, Language language) {
        if (this.myElementToRename instanceof OCLocalizedString && !newName.isEmpty()) {
            return true;
        }
        if (this.mySelectorIdentifier != null && newName.isEmpty()) {
            return true;
        }
        OCFile containingFile = this.getContainingFile();
        if (containingFile != null && OCNamesValidator.isIdentifier(newName, containingFile.getKind(), containingFile)) {
            return true;
        }
        return super.isIdentifier(newName, language);
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        OCInplaceRenamer renamer = new OCInplaceRenamer(variable, this.mySymbol, editor, this.myCategoryMode, this.myInitialName, this.myOldName);
        renamer.myInplaceRenameStarted = this.myInplaceRenameStarted;
        OCInplaceRenamer oCInplaceRenamer = renamer;
        if (oCInplaceRenamer == null) {
            OCInplaceRenamer.$$$reportNull$$$0(8);
        }
        return oCInplaceRenamer;
    }

    @Nullable
    private String getInitialName(PsiNamedElement variable, String initialName) {
        if (!(variable instanceof OCMethod)) {
            return StringUtil.sanitizeJavaIdentifier((String)initialName);
        }
        String originalName = variable.getName();
        if (StringUtil.isEmpty((String)originalName)) {
            return this.myOldName;
        }
        List originalNameParts = StringUtil.split((String)originalName, (String)":", (boolean)true, (boolean)true);
        List initialNameParts = StringUtil.split((String)initialName, (String)":", (boolean)true, (boolean)true);
        if (originalNameParts.size() != initialNameParts.size()) {
            return this.myOldName;
        }
        for (int i = 0; i < originalNameParts.size(); ++i) {
            if (((String)originalNameParts.get(i)).equals(initialNameParts.get(i))) continue;
            return (String)initialNameParts.get(i);
        }
        return this.myOldName;
    }

    protected PsiElement getNameIdentifier() {
        PsiElement identifier = this.mySelectorIdentifier != null ? this.mySelectorIdentifier : super.getNameIdentifier();
        return identifier != null && OCElementUtil.isPartOfMacroSubstitution(identifier) ? null : identifier;
    }

    protected String getCommandName() {
        PsiNamedElement variable = this.getVariable();
        return variable != null && !variable.isValid() ? OCRefactoringBundle.message("refactoring.rename.command.name", new Object[0]) : super.getCommandName();
    }

    protected boolean isReferenceAtCaret(PsiElement selectedElement, PsiReference ref) {
        return false;
    }

    private <T> T executeUnderModalDialog(@NotNull ThrowableComputable<T, ProcessCanceledException> computable, @NotNull @NlsContexts.ProgressTitle String title) {
        Object result;
        if (computable == null) {
            OCInplaceRenamer.$$$reportNull$$$0(9);
        }
        if (title == null) {
            OCInplaceRenamer.$$$reportNull$$$0(10);
        }
        try {
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                result = ProgressManager.getInstance().runProcess(() -> computable.compute(), (ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressWindow progress = new ProgressWindow(true, false, this.myProject);
                progress.setIndeterminate(true);
                progress.setTitle(title);
                progress.setDelayInMillis(1000);
                ProgressResult progressResult = new ProgressRunner(__ -> ReadAction.compute((ThrowableComputable)computable)).withProgress((ProgressIndicator)progress).modal().submitAndGet();
                if (progressResult.isCanceled()) {
                    throw new ProcessCanceledException();
                }
                if (progressResult.getThrowable() != null) {
                    ExceptionUtil.rethrow((Throwable)progressResult.getThrowable());
                }
                result = progressResult.getResult();
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
            throw e;
        }
        return (T)result;
    }

    @Nullable
    private OCFile getContainingFile() {
        if (this.myScope != null && this.myScope.getContainingFile() instanceof OCFile) {
            return (OCFile)this.myScope.getContainingFile();
        }
        if (this.myElementToRename != null && this.myElementToRename.getContainingFile() instanceof OCFile) {
            return (OCFile)this.myElementToRename.getContainingFile();
        }
        return null;
    }

    protected void collectAdditionalElementsToRename(@NotNull List<? super Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            OCInplaceRenamer.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenamer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenamer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createInplaceRenamerToRestart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendAdditionalSymbolsForStruct";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRenameInner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateNameSuggestions";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderModalDialog";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalElementsToRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

