/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUpDownMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            OCUpDownMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCUpDownMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            OCUpDownMover.$$$reportNull$$$0(2);
        }
        if (!(file instanceof OCFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        Pair psiRange = OCUpDownMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)info.toMove);
        if (psiRange == null) {
            return false;
        }
        OCElementsRange range = new OCElementsRange(this.firstNonMacroWhiteElement(editor, info.toMove.startLine, (PsiElement)psiRange.first, true, false), this.firstNonMacroWhiteElement(editor, info.toMove.endLine - 1, (PsiElement)psiRange.second, false, false));
        return this.checkAvailable(editor, info, range, down);
    }

    public abstract boolean checkAvailable(@NotNull Editor var1, @NotNull StatementUpDownMover.MoveInfo var2, @NotNull OCElementsRange var3, boolean var4);

    protected static int elementStartLine(Editor editor, PsiElement element) {
        return editor.offsetToLogicalPosition((int)element.getTextRange().getStartOffset()).line;
    }

    protected static int elementEndLine(Editor editor, PsiElement element) {
        return editor.offsetToLogicalPosition((int)element.getTextRange().getEndOffset()).line;
    }

    protected static LineRange calcDestRange(boolean down, int destStart, int destEnd) {
        if (down) {
            return new LineRange(destStart, destEnd);
        }
        if (destStart < destEnd + 1) {
            return new LineRange(destStart, destEnd + 1);
        }
        return new LineRange(destEnd, destStart + 1);
    }

    @Nullable
    protected PsiElement firstNonMacroWhiteElement(@NotNull Editor editor, int offset, int line, @NotNull PsiFile file, boolean lookRight, boolean skipMacros) {
        ASTNode leafElement;
        if (editor == null) {
            OCUpDownMover.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OCUpDownMover.$$$reportNull$$$0(4);
        }
        return (leafElement = file.getNode().findLeafElementAt(offset)) == null ? null : this.firstNonMacroWhiteElement(editor, line, leafElement.getPsi(), lookRight, skipMacros);
    }

    @Nullable
    protected PsiElement firstNonMacroWhiteElement(@NotNull Editor editor, int line, PsiElement element, boolean lookRight, boolean skipMacros) {
        if (editor == null) {
            OCUpDownMover.$$$reportNull$$$0(5);
        }
        while (element != null && this.isMacroWhiteElement(element, skipMacros)) {
            int curLine;
            PsiElement nextElement;
            PsiElement psiElement = nextElement = lookRight ? element.getNextSibling() : element.getPrevSibling();
            if (nextElement == null) break;
            if (OCElementUtil.getElementType(nextElement) == TokenType.WHITE_SPACE) {
                curLine = lookRight ? OCUpDownMover.elementEndLine(editor, nextElement) : OCUpDownMover.elementStartLine(editor, nextElement);
            } else {
                int n = curLine = lookRight ? OCUpDownMover.elementStartLine(editor, nextElement) : OCUpDownMover.elementEndLine(editor, nextElement);
            }
            if (line != curLine) break;
            element = nextElement;
        }
        return element;
    }

    protected boolean isMacroWhiteElement(PsiElement element, boolean skipMacros) {
        return skipMacros && element instanceof OCMacroCall || OCElementUtil.isElementEmpty(element) && !OCTokenTypes.DIRECTIVES.contains(OCElementUtil.getElementType(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/OCUpDownMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "firstNonMacroWhiteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

