/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCGeneratedInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterTableModel;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class OCChangeSignatureHandlerImpl
implements OCChangeSignatureHandler {
    protected OCParameterTableModel myParametersTableModel;
    protected OCMethodDescriptor myMethod;
    private String myName;
    protected String myReturnTypeText;
    protected OCType myReturnType;
    protected OCCallableKind myCallableKind;
    protected OCChangeInfo myChangeInfo;
    protected boolean myChangeUsages;
    protected boolean myChangeAncestors;
    protected OCGeneratedInfo myGeneratedInfo;
    protected @NlsContexts.Command String myTitle;
    protected String myHelpId;
    @NotNull
    private final PsiElement myContext;
    private final boolean myFilterNonCodeUsages;

    OCChangeSignatureHandlerImpl(OCParameterTableModel parametersTableModel, OCMethodDescriptor methodDescriptor, @NotNull PsiElement context, boolean filterNonCodeUsages) {
        if (context == null) {
            OCChangeSignatureHandlerImpl.$$$reportNull$$$0(0);
        }
        this.myChangeUsages = true;
        this.myParametersTableModel = parametersTableModel;
        this.myMethod = methodDescriptor;
        this.myName = this.myMethod.getName();
        this.myReturnType = this.myMethod.getReturnType();
        this.myReturnTypeText = this.myMethod.getReturnTypeText(context);
        this.myCallableKind = this.myMethod.getCallableKind();
        this.myContext = context;
        this.myGeneratedInfo = new OCGeneratedInfo(context.getProject());
        this.myFilterNonCodeUsages = filterNonCodeUsages;
    }

    OCChangeSignatureHandlerImpl(OCMethodDescriptor methodDescriptor, @NotNull PsiElement context, boolean filterNonCodeUsages) {
        String selector;
        OCParameterInfo firstParam;
        if (context == null) {
            OCChangeSignatureHandlerImpl.$$$reportNull$$$0(1);
        }
        this.myChangeUsages = true;
        OCCallable method = methodDescriptor.getMethod();
        this.myMethod = methodDescriptor;
        this.myName = this.myMethod.getName();
        this.myReturnType = this.myMethod.getReturnType();
        this.myReturnTypeText = this.myMethod.getReturnTypeText(context);
        this.myCallableKind = this.myMethod.getCallableKind();
        this.myParametersTableModel = new OCParameterTableModel(context, method instanceof OCMethod);
        this.myParametersTableModel.setParameterInfos(methodDescriptor.getParameters());
        this.myContext = context;
        this.myGeneratedInfo = new OCGeneratedInfo(context.getProject());
        this.myFilterNonCodeUsages = filterNonCodeUsages;
        if (ApplicationManager.getApplication().isUnitTestMode() && (firstParam = this.getFirstParameter()) != null && (selector = firstParam.getSelector()) != null && selector.startsWith("_")) {
            this.renameSelector(0, selector.substring(1));
            this.myName = this.myName.substring(1);
        }
    }

    @Override
    public OCParameterInfo addParameter(String name, OCType type, int oldIndex) {
        return this.addParameter("", name, type, oldIndex, false);
    }

    @Override
    public OCParameterInfo addParameter(String selector, String name, OCType type, int oldIndex, boolean isReferenceMode) {
        return this.addParameter(selector, name, type, oldIndex, isReferenceMode, null);
    }

    @Override
    public OCParameterInfo addParameter(String selector, String name, OCType type, int oldIndex, boolean isReferenceMode, @Nullable String defaultArgumentValue) {
        return this.insertParameter(selector, name, type, null, -1, oldIndex, isReferenceMode, defaultArgumentValue);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name, OCType type, int index, int oldIndex, boolean isReferenceMode) {
        return this.insertParameter(selector, name, type, null, index, oldIndex, isReferenceMode);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name, OCType type, String typeText, int index, int oldIndex, boolean isReferenceMode) {
        return this.insertParameter(selector, name, type, typeText, index, oldIndex, isReferenceMode, null);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name, OCType type, String typeText, int index, int oldIndex, boolean isReferenceMode, @Nullable String defaultArgumentValue) {
        OCParameterInfo result;
        OCParameterInfo firstParam;
        if (this.isMethod() && (firstParam = this.getFirstParameter()) != null && firstParam.getName().isEmpty()) {
            selector = firstParam.getSelector();
            this.myParametersTableModel.removeRow(0);
        }
        OCParameterInfo oCParameterInfo = result = typeText == null ? new OCParameterInfo(selector, name, type, oldIndex, this.myContext) : new OCParameterInfo(selector, name, type, typeText, oldIndex, this.myContext);
        if (defaultArgumentValue != null) {
            result.setDefaultValue(defaultArgumentValue);
        }
        result.setReferenceMode(isReferenceMode);
        if (index == -1) {
            this.myParametersTableModel.addLastRow(result);
        } else {
            this.myParametersTableModel.addRow(result, index);
        }
        return result;
    }

    @Override
    public OCParameterInfo insertParameter(String name, OCType type, int index) {
        return this.insertParameter("", name, type, index, -1, false);
    }

    @Override
    public void removeParameter(int index) {
        this.removeParameter(index, true);
    }

    private void removeParameter(int index, boolean mergeFirstSelector) {
        if (this.isMethod()) {
            OCParameterInfo firstParam = this.getFirstParameter();
            if (this.myParametersTableModel.getRowCount() == 1 && firstParam != null && !firstParam.getSelector().isEmpty()) {
                String selector = firstParam.getSelector();
                this.myParametersTableModel.removeRow(index, mergeFirstSelector);
                this.addParameter(selector, "", null, -1, false);
                return;
            }
        }
        this.myParametersTableModel.removeRow(index, mergeFirstSelector);
    }

    @Override
    public void removeParameter(String name, boolean mergeFirstSelector) {
        int rowIndex = 0;
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            if (((OCParameterInfo)item.parameter).getName().equals(name)) {
                this.removeParameter(rowIndex, mergeFirstSelector);
                return;
            }
            ++rowIndex;
        }
        assert (false) : "Could not find parameter: " + name;
    }

    @Override
    public void renameParameter(String oldName, String newName) {
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            if (!((OCParameterInfo)item.parameter).getName().equals(oldName)) continue;
            ((OCParameterInfo)item.parameter).setName(newName);
            return;
        }
        assert (false) : "Could not find parameter: " + oldName;
    }

    @Override
    public void exchangeParameters(int i1, int i2) {
        this.myParametersTableModel.exchangeRows(i1, i2);
    }

    @Override
    public void renameSelector(int index, String newName) {
        ((OCParameterInfo)((ParameterTableModelItemBase)this.myParametersTableModel.getItems().get((int)index)).parameter).setSelector(newName);
        this.myName = this.calculateMethodName();
    }

    @Override
    public void setName(String name) {
        this.myName = name;
        OCParameterInfo firstParam = this.getFirstParameter();
        if (this.isMethod()) {
            if (firstParam == null) {
                this.addParameter(name, "", null, -1, false);
            } else {
                this.renameSelector(0, name);
            }
        } else if (firstParam != null && !firstParam.getSelector().isEmpty()) {
            this.myParametersTableModel.removeRow(0);
        }
    }

    @Override
    public void setReturnType(OCType returnType) {
        this.myReturnType = returnType;
        this.myReturnTypeText = returnType.getBestNameInContext(this.myContext);
    }

    @Override
    public void setAddExplicitKeyword(boolean addExplicitKeyword) {
        this.myMethod.setAddExplicitKeyword(addExplicitKeyword);
    }

    @Override
    public void setAddConstQualifier(boolean addConstQualifier) {
        this.myMethod.setAddConstQualifier(addConstQualifier);
    }

    @Override
    public void setAddConstexprSpecifier(boolean addConstexprSpecifier) {
        this.myMethod.setAddConstexprSpecifier(addConstexprSpecifier);
    }

    @Override
    public void setAddNoexceptSpecifier(boolean addNoexceptSpecifier) {
        this.myMethod.setAddNoexceptSpecifier(addNoexceptSpecifier);
    }

    @TestOnly
    @Nullable
    public OCType getRawReturnType() {
        return this.getReturnType();
    }

    @Override
    public void setParentClass(OCSymbol parent, boolean allowChangeCategories, List<? extends OCClassSymbol> auxParents) {
        this.getGeneratedInfo().setMethodParent(parent, allowChangeCategories, auxParents);
    }

    @Override
    public void setChangeParentClassPossible(boolean possible) {
    }

    @Override
    public void setNameVisible(boolean visible) {
    }

    @Override
    public void setChangeUsages(boolean change) {
        this.myChangeUsages = change;
    }

    @Override
    public void setChangeAncestors(boolean change) {
        this.myChangeAncestors = change;
    }

    @Override
    public OCGeneratedInfo getGeneratedInfo() {
        return this.myGeneratedInfo;
    }

    @Override
    public void invoke() {
        this.createRefactoringProcessor().run();
    }

    @Override
    public void invokeSynchronously() {
        this.invokeSynchronously(true);
    }

    @Override
    public void invokeSynchronously(boolean prepare) {
        this.createRefactoringProcessor().runSynchronously(prepare);
    }

    @Override
    public void setTitle(@NlsContexts.DialogTitle String title) {
        this.myTitle = title;
    }

    @Override
    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    @Override
    public String getNewSignature(boolean addInitializers) {
        return this.calculateSignature(null, false, addInitializers);
    }

    @Override
    public void setCallableKind(OCCallableKind callableKind) {
        boolean isMethod;
        this.myCallableKind = callableKind;
        OCParameterInfo firstParam = this.getFirstParameter();
        boolean bl = isMethod = callableKind == OCCallableKind.METHOD;
        if (firstParam != null && firstParam.isSelfParameter() && isMethod) {
            this.myParametersTableModel.removeRow(0);
        }
        if (isMethod && this.myMethod.getMethod() instanceof OCFunctionDeclaration) {
            this.setName(this.myMethod.getName());
        } else if (!isMethod && this.myMethod.getMethod() instanceof OCMethod && this.myParametersTableModel.getRowCount() == 1 && firstParam != null && firstParam.getName().isEmpty()) {
            this.myParametersTableModel.removeRow(0);
        }
        if (!(isMethod || this.myMethod.getSelfReferences().isEmpty() || firstParam != null && firstParam.isSelfParameter())) {
            this.addSelfParameter(this.myMethod.getContainerClass().getName());
        }
    }

    @Override
    public void addSelfParameter(String parentClassName) {
        OCType type = OCReferenceType.resolvedFromText(parentClassName, this.myMethod.getMethod());
        type = OCPointerType.to(type);
        OCParameterInfo parameterInfo = new OCParameterInfo("", "_self", type, -1, this.myContext);
        parameterInfo.setSelfParameter(true);
        this.myParametersTableModel.addFirstRow(parameterInfo);
    }

    @Nullable
    private OCParameterInfo getFirstParameter() {
        int rowCount = this.myParametersTableModel.getRowCount();
        return rowCount > 0 ? (OCParameterInfo)((ParameterTableModelItemBase)this.myParametersTableModel.getRowValue((int)0)).parameter : null;
    }

    @Override
    public List<OCParameterInfo> getParameters() {
        ArrayList<OCParameterInfo> result = new ArrayList<OCParameterInfo>(this.myParametersTableModel.getRowCount());
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            OCType parameterType = OCElementUtil.getType((PsiElement)item.typeCodeFragment);
            OCType transformedParameterType = OCFunctionType.convertArrayParameterType(parameterType);
            ((OCParameterInfo)item.parameter).setType(transformedParameterType);
            ((OCParameterInfo)item.parameter).setTypeText(OCElementUtil.getTextWithMacros((PsiElement)item.typeCodeFragment));
            result.add((OCParameterInfo)item.parameter);
        }
        return result;
    }

    OCType getReturnType() {
        return this.myReturnType;
    }

    String getReturnTypeText() {
        return this.myReturnTypeText;
    }

    String getMethodName() {
        String name = this.myName;
        if (this.myMethod.getMethod() instanceof OCBlockExpression) {
            return "block";
        }
        if (this.isFunction()) {
            return name.indexOf(58) == -1 ? name : name.substring(0, name.indexOf(58));
        }
        return name;
    }

    String calculateMethodName() {
        StringBuilder result = new StringBuilder();
        List items = this.myParametersTableModel.getItems();
        for (ParameterTableModelItemBase item : items) {
            result.append(((OCParameterInfo)item.parameter).getSelector());
            if (items.size() == 1 && ((OCParameterInfo)item.parameter).getName().isEmpty()) break;
            result.append(':');
        }
        return result.toString();
    }

    @Nullable
    OCClassDeclaration<?> getContainerClass() {
        return this.myCallableKind == OCCallableKind.METHOD ? this.myMethod.getContainerClass() : null;
    }

    OCChangeSignatureProcessor createRefactoringProcessor() {
        return new OCChangeSignatureProcessor(this.myMethod.getMethod().getProject(), this.getCallableKind(), this.myMethod.getMethod(), this.evaluateChangeInfo(), this.myTitle, this.myFilterNonCodeUsages);
    }

    @Override
    public OCChangeInfo getChangeInfo() {
        if (this.myChangeInfo == null) {
            this.evaluateChangeInfo();
        }
        return this.myChangeInfo;
    }

    private OCChangeInfo evaluateChangeInfo() {
        List<OCParameterInfo> parameters = this.getParameters();
        this.myChangeInfo = new OCChangeInfo(this.myContext, this.myMethod, this.getMethodName(), parameters.toArray(new OCParameterInfo[0]), this.getReturnTypeText(), this.getContainerClass(), this.getCallableKind(), this.calculateSignature(null, false, true), this.calculateSignature(null, false, false), this.myChangeUsages, this.myChangeAncestors, this.myGeneratedInfo){

            @Override
            public String getNewInheritedSignature(OCCallable oldCallable, boolean addInitializers) {
                return OCChangeSignatureHandlerImpl.this.calculateSignature(oldCallable, false, addInitializers);
            }
        };
        return this.myChangeInfo;
    }

    OCCallableKind getCallableKind() {
        return this.myCallableKind;
    }

    @Override
    public List<OCCallable<?>> getNewCallables() {
        return this.myChangeInfo != null ? this.myChangeInfo.getNewMethods() : Collections.emptyList();
    }

    private static boolean checkIfMemberFunctionNeedsTemplateParameterList(@NotNull PsiElement context, @Nullable OCSymbol symbol, @Nullable OCDeclaration declaration) {
        if (context == null) {
            OCChangeSignatureHandlerImpl.$$$reportNull$$$0(2);
        }
        if (declaration == null) {
            return false;
        }
        boolean parentStructIsTemplated = declaration.getTemplateParameterList() != null;
        boolean functionIsTemplated = false;
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol funcSym = (OCFunctionSymbol)symbol;
            functionIsTemplated = !funcSym.getTemplateParameters().isEmpty();
        } else if (symbol == null && context instanceof OCFunctionDeclaration) {
            OCFunctionSymbol funcSym;
            OCFunctionDeclaration funcDecl = (OCFunctionDeclaration)context;
            OCSymbol oCSymbol = funcDecl.getSymbol();
            functionIsTemplated = oCSymbol instanceof OCFunctionSymbol && !(funcSym = (OCFunctionSymbol)oCSymbol).getTemplateParameters().isEmpty();
        }
        return !parentStructIsTemplated || functionIsTemplated;
    }

    String calculateSignature(@Nullable OCCallable<?> oldCallable, boolean newlines, boolean addInitializers) {
        StringBuilder result = new StringBuilder();
        List params = this.myParametersTableModel.getItems();
        OCCallable method = this.myMethod.getMethod();
        PsiElement context = oldCallable != null ? oldCallable : this.myContext;
        boolean isTrailingReturnType = false;
        if (method instanceof OCFunctionDeclaration) {
            OCFunctionDeclaration funcDecl = (OCFunctionDeclaration)method;
            boolean bl = isTrailingReturnType = funcDecl.getTrailingReturnTypeElement() != null;
        }
        if (this.isMethod()) {
            boolean isInstance = method instanceof OCMethod && ((OCMethod)method).isInstanceMethod();
            result.append(isInstance ? (char)'-' : '+');
            result.append('(');
            result.append(this.getReturnTypeText());
            result.append(')');
            boolean isFirstParam = true;
            for (ParameterTableModelItemBase item : params) {
                result.append(isFirstParam || !newlines ? (char)' ' : '\n');
                isFirstParam = false;
                OCParameterInfo parameter = (OCParameterInfo)item.parameter;
                result.append(parameter.getSelector());
                if (parameter.getName().isEmpty()) break;
                result.append(": (");
                result.append(OCElementUtil.getTextWithMacros((PsiElement)item.typeCodeFragment));
                result.append(") ");
                if (oldCallable != null) {
                    result.append(this.myChangeInfo.getNewParameterName(true, (OCCallable)oldCallable, parameter));
                    continue;
                }
                result.append(parameter.getName());
            }
            OCMethod psi = OCElementFactory.methodFromSignature(result.toString(), context, false, false);
            CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)psi);
            String text = psi.getTextWithMacros();
            return text.substring(0, text.length() - 1);
        }
        StringBuilder paramsBuilder = this.buildParams(this.myChangeInfo, params, (OCCallable<?>)oldCallable, context, oldCallable != null, newlines, addInitializers);
        if (this.isFunction()) {
            String methodName = this.getMethodName();
            if (methodName.isEmpty()) {
                methodName = "unnamed";
            }
            Object methodFullName = methodName;
            ArrayList<String> modifiers = new ArrayList<String>(0);
            if (method instanceof OCFunctionDeclaration) {
                OCFunctionSymbol funcSym;
                OCFunctionDeclaration function = (OCFunctionDeclaration)method;
                OCSymbolWithQualifiedName methodSymbol = (OCSymbolWithQualifiedName)function.getSymbol();
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                if (this.myGeneratedInfo.isStatic() || function.isStatic() || methodSymbol instanceof OCFunctionSymbol && (funcSym = (OCFunctionSymbol)methodSymbol).resolveIsStatic(resolveContext)) {
                    modifiers.add("static");
                }
                if (this.myMethod.isAddConstexprSpecifier()) {
                    modifiers.add("constexpr");
                } else if (this.myMethod.isConsteval()) {
                    modifiers.add("consteval");
                }
                if (function.isOperator() && methodSymbol != null) {
                    methodFullName = methodSymbol.getName();
                } else if (function.getNamespaceQualifier() != null) {
                    methodFullName = OCElementUtil.getTextWithMacros(function.getNamespaceQualifier()) + "::" + methodName;
                }
                List paramTypes = ContainerUtil.mapNotNull((Collection)params, p -> ((OCParameterInfo)p.parameter).getType());
                OCFunctionType type = function.getFunctionType();
                OCStructLike struct = (OCStructLike)PsiTreeUtil.getParentOfType((PsiElement)context, OCStructLike.class);
                OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)struct, OCDeclaration.class);
                boolean isFreeStandingFunction = struct == null;
                boolean memberFunctionNeedsTemplateList = OCChangeSignatureHandlerImpl.checkIfMemberFunctionNeedsTemplateParameterList(context, this.myMethod.getMethodSymbol(), declaration);
                if (type != null && (isFreeStandingFunction || memberFunctionNeedsTemplateList)) {
                    OCSymbol oCSymbol;
                    List<PsiElement> statements = this.myGeneratedInfo.getMethodStatements();
                    List<OCTypeParameterSymbol<?>> symbols = OCCallableUtil.getDependentTemplateSymbols(new OCFunctionType(type.getReturnType(), paramTypes), statements, false, true, resolveContext);
                    if (method == context && (oCSymbol = this.myMethod.getMethodSymbol()) instanceof OCFunctionSymbol) {
                        OCFunctionSymbol funcSym2 = (OCFunctionSymbol)oCSymbol;
                        result.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader(funcSym2, context));
                    } else {
                        result.append(OCCallableUtil.getFunctionTemplateHeader(symbols, context)).append("\n");
                    }
                }
            }
            if (this.myMethod.isConstructor()) {
                OCFunctionDeclaration funcDecl;
                ArrayList<String> specifiers = new ArrayList<String>();
                if (this.myMethod.isAddConstexprSpecifier()) {
                    specifiers.add("constexpr");
                } else if (this.myMethod.isConsteval()) {
                    specifiers.add("consteval");
                }
                if (this.myMethod.isAddExplicitKeyword()) {
                    if (method instanceof OCFunctionDeclaration && (funcDecl = (OCFunctionDeclaration)method).getExplicitSpecifier() != null) {
                        specifiers.add(funcDecl.getExplicitSpecifier().getTextWithMacros());
                    } else {
                        specifiers.add("explicit");
                    }
                }
                if (method instanceof OCFunctionDeclaration) {
                    funcDecl = (OCFunctionDeclaration)method;
                    OCChangeSignatureHandlerImpl.sortFunctionSpecifiers(funcDecl, specifiers);
                    if (!specifiers.isEmpty()) {
                        result.append(StringUtil.join(specifiers, (String)" ")).append(" ");
                    }
                }
                result.append((String)methodFullName);
            } else {
                String typeNameHint;
                OCType returnType = isTrailingReturnType ? new OCAutoType() : this.getReturnType();
                String string = typeNameHint = isTrailingReturnType ? "auto" : this.getReturnTypeText();
                if (method instanceof OCFunctionDeclaration) {
                    OCFunctionDeclaration funcDecl = (OCFunctionDeclaration)method;
                    OCChangeSignatureHandlerImpl.sortFunctionSpecifiers(funcDecl, modifiers);
                }
                String declText = OCElementFactory.declarationText(modifiers, (String)methodFullName, returnType, null, context, typeNameHint, false);
                result.append(declText);
            }
            result.insert(result.lastIndexOf(methodName) + methodName.length(), paramsBuilder);
            result.append(";");
            PsiElement psi = this.myMethod.isConstructor() ? OCElementFactory.constructorFromText(result.toString(), this.myMethod.getName(), context) : OCElementFactory.topLevelDeclarationFromText(result.toString(), context);
            CodeStyleManager.getInstance((Project)context.getProject()).reformat(psi);
            result.setLength(0);
            result.append(OCElementUtil.getTextWithMacros(psi));
            if (result.charAt(result.length() - 1) == ';') {
                result.setLength(result.length() - 1);
            }
        } else if (this.isBlock()) {
            result.append('^');
            if (!"void".equals(this.getReturnTypeText())) {
                result.append(this.getReturnTypeText());
            }
        } else if (this.isLambda()) {
            result.append("[]");
        }
        if (this.isBlock() || this.isLambda()) {
            result.append((CharSequence)paramsBuilder);
            OCExpression psi = OCElementFactory.expressionFromText(result.toString(), context, false);
            if (psi != null) {
                CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)psi);
            }
            result.setLength(0);
            result.append(OCElementUtil.getTextWithMacros(psi));
            result.append("{...}");
        } else if (method instanceof OCFunctionDeclaration) {
            OCSymbol oCSymbol;
            OCFunctionDeclaration func = (OCFunctionDeclaration)method;
            CVQualifiers cvQuals = CVQualifiers.get(this.myMethod.isAddConstQualifier(), func.getCVQualifiers().isVolatile());
            cvQuals.appendCVQualifiers(result);
            OCFunctionType funcType = func.getFunctionType();
            if (funcType != null) {
                if (funcType.isLValueRef()) {
                    result.append(" &");
                } else if (funcType.isRValueRef()) {
                    result.append(" &&");
                }
            }
            OCExceptionSpecificationInfo exceptionSpec = Objects.requireNonNull(func.getFunctionType()).getExceptionSpecification();
            if (this.myMethod.isAddNoexceptSpecifier()) {
                if (exceptionSpec.isNoexcept() && (oCSymbol = this.myMethod.getMethodSymbol()) instanceof OCFunctionSymbol) {
                    functionSymbol = (OCFunctionSymbol)oCSymbol;
                    result.append(OCCppDefinitionsUtil.getExceptionSpecification(functionSymbol, func));
                } else {
                    result.append(" noexcept");
                }
            } else if (!exceptionSpec.isNoexcept() && (oCSymbol = this.myMethod.getMethodSymbol()) instanceof OCFunctionSymbol) {
                functionSymbol = (OCFunctionSymbol)oCSymbol;
                result.append(OCCppDefinitionsUtil.getExceptionSpecification(functionSymbol, func));
            }
            if (isTrailingReturnType && !this.getReturnTypeText().equals("auto")) {
                result.append(" -> ").append(this.getReturnTypeText());
            }
        }
        return result.toString();
    }

    private static void sortFunctionSpecifiers(@NotNull OCFunctionDeclaration funcDecl, @NotNull List<String> specifiers) {
        if (funcDecl == null) {
            OCChangeSignatureHandlerImpl.$$$reportNull$$$0(3);
        }
        if (specifiers == null) {
            OCChangeSignatureHandlerImpl.$$$reportNull$$$0(4);
        }
        String funcText = funcDecl.getTextWithMacros();
        specifiers.sort(Comparator.comparingInt(it -> funcText.indexOf((String)it)));
    }

    private StringBuilder buildParams(@Nullable OCChangeInfo changeInfo, @NotNull List<ParameterTableModelItemBase<OCParameterInfo>> params, @Nullable OCCallable<?> oldFunction, @NotNull PsiElement context, boolean isInherited, boolean newlines, boolean addInitializers) {
        if (params == null) {
            OCChangeSignatureHandlerImpl.$$$reportNull$$$0(5);
        }
        if (context == null) {
            OCChangeSignatureHandlerImpl.$$$reportNull$$$0(6);
        }
        boolean isFirstParam = true;
        StringBuilder paramsBuilder = new StringBuilder();
        if (params.size() > 0 || this.isFunction()) {
            paramsBuilder.append('(');
            if (newlines && params.size() > 0) {
                paramsBuilder.append('\n');
            }
        }
        for (ParameterTableModelItemBase<OCParameterInfo> param : params) {
            String name = changeInfo != null && oldFunction != null ? changeInfo.getNewParameterName(isInherited, oldFunction, (OCParameterInfo)param.parameter) : ((OCParameterInfo)param.parameter).getName();
            PsiCodeFragment typeFragment = param.typeCodeFragment;
            String typeText = OCElementUtil.getTextWithMacros((PsiElement)typeFragment);
            if (name.isEmpty() && typeText.isEmpty()) continue;
            if (!isFirstParam) {
                paramsBuilder.append(",").append(newlines ? (char)'\n' : ' ');
            }
            if (typeText.equals("...")) {
                paramsBuilder.append("...");
            } else {
                int oldIndex = ((OCParameterInfo)param.parameter).getOldIndex();
                OCExpression initializer = ((OCParameterInfo)param.parameter).getInitializer();
                if (!addInitializers || oldFunction instanceof OCFunctionDeclaration && oldIndex >= 0 && oldFunction.getParameters() != null && oldIndex < oldFunction.getParameters().size() && ((OCDeclarator)oldFunction.getParameters().get(oldIndex)).getInitializer() == null) {
                    initializer = null;
                }
                String initializerText = initializer != null ? initializer.getTextWithMacros() : null;
                OCType type = OCElementUtil.getType((PsiElement)typeFragment);
                Object declarationText = type != null ? OCElementFactory.declarationText(name, type.resolve((PsiElement)typeFragment), typeText, initializerText, context) : typeText + " " + name + (String)(initializerText != null ? " = " + initializerText : "");
                if (newlines) {
                    paramsBuilder.append("  ");
                }
                paramsBuilder.append((String)declarationText);
            }
            isFirstParam = false;
        }
        if (params.size() > 0 || this.isFunction()) {
            if (newlines && params.size() > 0) {
                paramsBuilder.append('\n');
            }
            paramsBuilder.append(')');
        }
        return paramsBuilder;
    }

    boolean isBlock() {
        return OCCallableKind.BLOCK == this.getCallableKind();
    }

    boolean isLambda() {
        return OCCallableKind.LAMBDA == this.getCallableKind();
    }

    boolean isFunction() {
        return OCCallableKind.FUNCTION == this.getCallableKind();
    }

    boolean isMethod() {
        return OCCallableKind.METHOD == this.getCallableKind();
    }

    boolean isMethodGenerated() {
        return this.myMethod.getMethod().getContainingFile() instanceof OCCodeFragment;
    }

    OCCallableKind getOriginalCallableKind() {
        return this.myMethod.getCallableKind();
    }

    @Override
    public OCMethodDescriptor getMethodDescriptor() {
        return this.myMethod;
    }

    @Override
    public void setRefactorButtonText(@NlsContexts.Button String text) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcDecl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureHandlerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfMemberFunctionNeedsTemplateParameterList";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sortFunctionSpecifiers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "buildParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

