/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCExceptionSpecificationKind;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandlerImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterTableModel;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCTargetSymbolPanel;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.ui.OCTypeReferenceEditor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCChangeSignatureDialog
extends ChangeSignatureDialogBase<OCParameterInfo, OCCallable, Object, OCMethodDescriptor, ParameterTableModelItemBase<OCParameterInfo>, OCParameterTableModel> {
    private DialogChangeSignatureHandlerImpl myHandler;
    private OCTypeReferenceEditor myContainerClassField;
    private JPanel myContainerPanel;
    private boolean myChangeParentClassPossible;
    private JBCheckBox myExplicitCtorCheckBox;
    private JBCheckBox myConstQualifierCheckBox;
    private JBCheckBox myConstexprSpecifierCheckBox;
    private JBCheckBox myNoexceptSpecifierCheckBox;
    private String myHelpId;
    private static final Key<Integer> DECLARATION_PLACE_KEY = Key.create((String)"DECLARATION_PLACE_KEY");

    public OCChangeSignatureDialog(@NotNull Project project, @NotNull OCMethodDescriptor method, @NotNull PsiElement context) {
        if (project == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        if (method == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(2);
        }
        super(project, (MethodDescriptor)method, false, context);
        this.initHandler();
        this.myNameField.setText(method.getName());
    }

    protected void initHandler() {
        if (this.myHandler == null) {
            this.myHandler = new DialogChangeSignatureHandlerImpl();
        }
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    protected String getHelpId() {
        return this.myHelpId == null ? "procedures.refactoring.changeMethodSignature" : this.myHelpId;
    }

    protected JComponent createNorthPanel() {
        OCFunctionSymbol funcSym;
        boolean isCppOperator;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, (Insets)JBInsets.emptyInsets(), 0, 0);
        OCClassDeclaration containerClass = ((OCMethodDescriptor)this.myMethod).getContainerClass();
        this.myContainerClassField = OCTypeReferenceEditor.create(containerClass != null ? containerClass.getSymbol() : null, (Condition<OCSymbol>)((Condition)declaration -> declaration instanceof OCImplementationSymbol), ((OCMethodDescriptor)this.myMethod).getMethod(), true, this.myProject);
        this.myContainerClassField.addDocumentListener((DocumentListener)this.mySignatureUpdater);
        this.myContainerClassField.getEditorTextField().setPreferredWidth(200);
        this.myContainerPanel = new JPanel(new BorderLayout(0, 2));
        JLabel containerPrompt = new JLabel();
        containerPrompt.setText(OCBundle.message("changeSignature.dialog.containing.class", new Object[0]));
        containerPrompt.setLabelFor((Component)((Object)this.myContainerClassField));
        panel.add((Component)super.createNorthPanel(), gbc);
        this.myContainerPanel.add((Component)containerPrompt, "North");
        this.myContainerPanel.add((Component)((Object)this.myContainerClassField), "South");
        OCSymbol symbol = this.myHandler.getMethodDescriptor().getMethodSymbol();
        boolean bl = isCppOperator = symbol instanceof OCFunctionSymbol && (funcSym = (OCFunctionSymbol)symbol).isCppOperator();
        if (isCppOperator || ((OCMethodDescriptor)this.myMethod).getMethod() instanceof OCLambdaExpression) {
            this.myNameField.setEnabled(false);
        }
        gbc.insets.left = 8;
        ++gbc.gridx;
        panel.add((Component)this.myContainerPanel, gbc);
        this.getRefactorAction().setEnabled(false);
        this.validateButtons();
        if (this.myReturnTypeField != null) {
            this.myReturnTypeField.setFont(EditorFontType.getGlobalPlainFont());
        }
        this.myNameField.setFont(EditorFontType.getGlobalPlainFont());
        return panel;
    }

    protected JComponent createOptionsPanel() {
        JComponent optionsPanel = super.createOptionsPanel();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)optionsPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.addQualifierAndSpecifierOptions(panel);
        return panel;
    }

    private void addQualifierAndSpecifierOptions(@NotNull JComponent panel) {
        if (panel == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(3);
        }
        PsiFile containingFile = ((OCMethodDescriptor)this.myMethod).getMethod().getContainingFile();
        int buttonNumber = 0;
        if (((OCMethodDescriptor)this.myMethod).isConstructor()) {
            this.myExplicitCtorCheckBox = new JBCheckBox(OCBundle.message("changeSignature.explicit.constructor.checkbox", new Object[0]), ((OCMethodDescriptor)this.myMethod).isAddExplicitKeyword());
            this.addCheckBoxOption(panel, this.myExplicitCtorCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 3, (Insets)JBInsets.emptyInsets(), 10, 10), (Consumer<Boolean>)((Consumer)((OCMethodDescriptor)this.myMethod)::setAddExplicitKeyword));
            ++buttonNumber;
        } else if (((OCMethodDescriptor)this.myMethod).isMemberFunction()) {
            this.myConstQualifierCheckBox = new JBCheckBox(OCBundle.message("changeSignature.const.member.function.checkbox", new Object[0]), ((OCMethodDescriptor)this.myMethod).isAddConstQualifier());
            this.addCheckBoxOption(panel, this.myConstQualifierCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 3, (Insets)JBInsets.emptyInsets(), 10, 10), (Consumer<Boolean>)((Consumer)((OCMethodDescriptor)this.myMethod)::setAddConstQualifier));
            ++buttonNumber;
        }
        if (this.isConstexprAllowed(containingFile)) {
            this.myConstexprSpecifierCheckBox = new JBCheckBox(OCBundle.message("changeSignature.constexpr.function.checkbox", new Object[0]), ((OCMethodDescriptor)this.myMethod).isAddConstexprSpecifier());
            this.addCheckBoxOption(panel, this.myConstexprSpecifierCheckBox, new GridBagConstraints(buttonNumber, 1, 1, 1, 0.0, 0.0, 18, 3, (Insets)JBInsets.emptyInsets(), 10, 10), (Consumer<Boolean>)((Consumer)((OCMethodDescriptor)this.myMethod)::setAddConstexprSpecifier));
            boolean canBeConstexprVoid = OCCompilerFeaturesHelper.supportsConstexprVoid(containingFile);
            this.myConstexprSpecifierCheckBox.setEnabled(!((OCMethodDescriptor)this.myMethod).isConsteval() && (!((OCMethodDescriptor)this.myMethod).getReturnType().isVoid() || canBeConstexprVoid));
            ++buttonNumber;
        }
        if (OCCompilerFeaturesHelper.supportsCxxNoexcept(containingFile)) {
            this.myNoexceptSpecifierCheckBox = new JBCheckBox(OCBundle.message("changeSignature.noexcept.function.checkbox", new Object[0]), ((OCMethodDescriptor)this.myMethod).isAddNoexceptSpecifier());
            this.addCheckBoxOption(panel, this.myNoexceptSpecifierCheckBox, new GridBagConstraints(buttonNumber, 1, 1, 1, 0.0, 0.0, 18, 3, (Insets)JBInsets.emptyInsets(), 10, 10), (Consumer<Boolean>)((Consumer)((OCMethodDescriptor)this.myMethod)::setAddNoexceptSpecifier));
            OCSymbol oCSymbol = ((OCMethodDescriptor)this.myMethod).getMethodSymbol();
            if (oCSymbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol funcSym = (OCFunctionSymbol)oCSymbol;
                OCExceptionSpecificationInfo exceptionSpec = funcSym.getType().getExceptionSpecification();
                boolean isEnabled = exceptionSpec.isNoexcept() || exceptionSpec.getSpecificationKind() == OCExceptionSpecificationKind.None;
                this.myNoexceptSpecifierCheckBox.setEnabled(isEnabled);
            }
        }
    }

    private boolean isConstexprAllowed(@Nullable PsiFile containingFile) {
        OCFunctionDefinition funcDef;
        if (!OCCompilerFeaturesHelper.supportsCxxConstexpr(containingFile) && !OCCompilerFeaturesHelper.supportsCConstexpr(containingFile)) {
            return false;
        }
        if (((OCMethodDescriptor)this.myMethod).isVirtual() && !OCCompilerFeaturesHelper.supportsConstexprVirtual(containingFile)) {
            return false;
        }
        OCCallable oCCallable = ((OCMethodDescriptor)this.myMethod).getMethod();
        return !(oCCallable instanceof OCFunctionDefinition) || !(funcDef = (OCFunctionDefinition)oCCallable).isFunctionTryBlock() || OCCompilerFeaturesHelper.supportsConstexprFunctionTryBlock(containingFile);
    }

    private void addCheckBoxOption(@NotNull JComponent panel, @NotNull JBCheckBox checkBox, @NotNull GridBagConstraints gridBagConstraints, @NotNull Consumer<Boolean> onActionPerformed) {
        if (panel == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(4);
        }
        if (checkBox == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(5);
        }
        if (gridBagConstraints == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(6);
        }
        if (onActionPerformed == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(7);
        }
        checkBox.addActionListener(e -> {
            onActionPerformed.consume((Object)checkBox.isSelected());
            this.updateSignature();
        });
        panel.add((Component)checkBox, gridBagConstraints);
    }

    protected JPanel createParametersPanel(boolean hasTabsInDialog) {
        JPanel panel = super.createParametersPanel(hasTabsInDialog);
        this.myPropagateParamChangesButton.setVisible(false);
        return panel;
    }

    protected LanguageFileType getFileType() {
        return OCFileType.INSTANCE;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.getMethodName().isEmpty() && !this.myHandler.isMethod()) {
            return this.myNameField;
        }
        return super.getPreferredFocusedComponent();
    }

    @NotNull
    protected OCParameterTableModel createParametersInfoModel(@NotNull OCMethodDescriptor method) {
        if (method == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(8);
        }
        return new OCParameterTableModel(this.myDefaultValueContext, ((OCMethodDescriptor)this.myMethod).getMethod() instanceof OCMethod);
    }

    protected BaseRefactoringProcessor createRefactoringProcessor() {
        return this.myHandler.createRefactoringProcessor();
    }

    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return OCElementFactory.getTypeCodeFragmentInWriteAction(((OCMethodDescriptor)this.myMethod).getReturnTypeText(this.myDefaultValueContext), this.myProject, this.myDefaultValueContext);
    }

    protected CallerChooserBase<OCCallable> createCallerChooser(String title, Tree treeToReuse, Consumer<? super Set<OCCallable>> callback) {
        throw new UnsupportedOperationException();
    }

    protected void updateSignatureAlarmFired() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.updateButtonState();
        super.updateSignatureAlarmFired();
        this.validateButtons();
    }

    private void updateButtonState() {
        OCType returnType = this.myHandler.getReturnType();
        if (returnType == null) {
            return;
        }
        PsiFile containingFile = ((OCMethodDescriptor)this.myMethod).getMethod().getContainingFile();
        boolean canBeConstexprVoid = OCCompilerFeaturesHelper.supportsConstexprVoid(containingFile);
        if (this.myConstQualifierCheckBox != null) {
            this.myConstQualifierCheckBox.setEnabled(((OCMethodDescriptor)this.myMethod).isMemberFunction() && !this.myHandler.getGeneratedInfo().isStatic());
        }
        if (this.myConstexprSpecifierCheckBox != null) {
            this.myConstexprSpecifierCheckBox.setEnabled(!((OCMethodDescriptor)this.myMethod).isConsteval() && (!returnType.isVoid() || canBeConstexprVoid));
            if (returnType.isVoid() && !canBeConstexprVoid) {
                this.myConstexprSpecifierCheckBox.setSelected(false);
            }
        }
        if (returnType.isVoid() && !canBeConstexprVoid) {
            ((OCMethodDescriptor)this.myMethod).setAddConstexprSpecifier(false);
        }
    }

    protected String getMethodName() {
        return this.myHandler.isMethod() ? this.myHandler.calculateMethodName() : super.getMethodName();
    }

    protected void canRun() throws ConfigurationException {
        if (this.myNameField == null) {
            return;
        }
        VisibilityPanelBase visibilityPanelBase = this.myVisibilityPanel;
        if (visibilityPanelBase instanceof OCTargetSymbolPanel) {
            OCTargetSymbolPanel panel = (OCTargetSymbolPanel)visibilityPanelBase;
            if (this.myVisibilityPanel.isVisible() && panel.isOnlyNewCategoryAllowed() && !panel.createNewCategory(this.myHandler.getGeneratedInfo())) {
                this.doCancelAction();
            }
        }
        this.initHandler();
        String callableKind = StringUtil.decapitalize((String)this.myHandler.getCallableKind().toString());
        if (this.myNamePanel.isVisible() && this.myNameField.isEnabled() && !StringUtil.isJavaIdentifier((String)this.myNameField.getText().trim())) {
            throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.name.invalid", callableKind));
        }
        if ((this.myHandler.isFunction() || this.myHandler.isMethod()) && ((OCMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && OCElementUtil.getType((PsiElement)this.myReturnTypeCodeFragment) == null) {
            throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.return.type.invalid", callableKind));
        }
        if (this.myHandler.isMethod() && ((OCParameterTableModel)this.myParametersTableModel).getRowCount() == 0) {
            throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.no.selector.parts.for", callableKind));
        }
        if (this.myContainerPanel.isVisible()) {
            OCSymbol classSymbol = this.myContainerClassField.getClassDeclaration(this.myProject);
            if (classSymbol == null) {
                throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.containing.class.invalid", this.myContainerClassField.getText()));
            }
            VirtualFile containingFile = classSymbol.getContainingFile();
            if (containingFile != null && !OCSearchScope.isInProjectSources(classSymbol, this.myProject)) {
                throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.containing.class.outside.project", this.myContainerClassField.getText()));
            }
        }
        List items = ((OCParameterTableModel)this.myParametersTableModel).getItems();
        boolean isSingleSelector = false;
        if (items.size() == 1 && this.myHandler.isMethod()) {
            ParameterTableModelItemBase item = (ParameterTableModelItemBase)items.get(0);
            isSingleSelector = item.typeCodeFragment.getText().isEmpty() && ((OCParameterInfo)item.parameter).getName().isEmpty();
        }
        boolean isFirst = true;
        for (ParameterTableModelItemBase item : items) {
            boolean isEllipsis = item.typeCodeFragment.getText().equals("...");
            String selectorName = ((OCParameterInfo)item.parameter).getSelector().trim();
            String parameterName = ((OCParameterInfo)item.parameter).getName().trim();
            if (this.myHandler.isMethod() && !StringUtil.isJavaIdentifier((String)selectorName) && (isFirst || !selectorName.isEmpty())) {
                throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.selector.part.invalid", StringUtil.escapeXmlEntities((String)selectorName)));
            }
            if (isEllipsis) {
                throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.can.t.refactor.with.variable.arguments", this.myHandler.getCallableKind().toStringLowercase()));
            }
            if (!(isSingleSelector || StringUtil.isJavaIdentifier((String)parameterName) || parameterName.isEmpty())) {
                throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.parameter.name.invalid", StringUtil.escapeXmlEntities((String)parameterName)));
            }
            String defaultValue = OCChangeSignatureDialog.getDefaultValue((ParameterTableModelItemBase<OCParameterInfo>)item);
            if (StringUtil.isNotEmpty((String)defaultValue) && !this.validateDefaultValue(defaultValue)) {
                throw new ConfigurationException(OCRefactoringBundle.message("dialog.message.paramer.default.value.invalid", StringUtil.escapeXmlEntities((String)defaultValue)));
            }
            isFirst = false;
        }
    }

    protected void doAction() {
        if (!this.isPreviewUsages() || ((OCMethodDescriptor)this.myMethod).getMethod().isPhysical()) {
            super.doAction();
        }
    }

    @Nullable
    protected String validateAndCommitData() {
        OCSymbol containerClass;
        if (this.myContainerPanel.isVisible() && (containerClass = this.myContainerClassField.getClassDeclaration(this.myProject)) != null) {
            this.myHandler.getGeneratedInfo().setMethodParent(containerClass);
        }
        for (ParameterTableModelItemBase item : ((OCParameterTableModel)this.myParametersTableModel).getItems()) {
            String defaultValue = OCChangeSignatureDialog.getDefaultValue((ParameterTableModelItemBase<OCParameterInfo>)item);
            ((OCParameterInfo)item.parameter).setDefaultValue(defaultValue);
        }
        return null;
    }

    @Nullable
    private static String getDefaultValue(ParameterTableModelItemBase<OCParameterInfo> item) {
        if (item.defaultValueCodeFragment != null) {
            return item.defaultValueCodeFragment.getText();
        }
        if (((OCParameterInfo)item.parameter).getDefaultValue() != null) {
            return ((OCParameterInfo)item.parameter).getDefaultValue();
        }
        return "";
    }

    private boolean validateDefaultValue(@NotNull String defaultValue) {
        OCExpression expression;
        if (defaultValue == null) {
            OCChangeSignatureDialog.$$$reportNull$$$0(9);
        }
        if ((expression = OCElementFactory.expressionFromText(defaultValue, this.myDefaultValueContext)) == null) {
            return false;
        }
        return !PsiTreeUtil.hasErrorElements((PsiElement)expression);
    }

    private static String convertName(String oldName) {
        return oldName.indexOf(58) == -1 ? oldName : oldName.substring(0, oldName.indexOf(58));
    }

    protected VisibilityPanelBase<Object> createVisibilityControl() {
        this.initHandler();
        if (((OCMethodDescriptor)this.myMethod).isChangeCallableKindPossible()) {
            OCCallableKind[] visibility = new OCCallableKind[]{OCCallableKind.METHOD, OCCallableKind.FUNCTION, OCCallableKind.BLOCK};
            String title = OCBundle.message("changeSignature.dialog.callable.type", new Object[0]);
            ComboBoxVisibilityPanel panel = new ComboBoxVisibilityPanel(title, (Object[])visibility);
            panel.addListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    OCChangeSignatureDialog.this.updateCallableKind((OCCallableKind)((Object)OCChangeSignatureDialog.this.getVisibility()));
                }
            });
            panel.setEnabled(((OCMethodDescriptor)this.myMethod).getMethod().getBody() != null);
            return panel;
        }
        this.updateCallableKind((OCCallableKind)((Object)((OCMethodDescriptor)this.myMethod).getVisibility()));
        if (((OCMethodDescriptor)this.myMethod).getMethod() instanceof OCFunctionDefinition && ((OCFunctionDefinition)((OCMethodDescriptor)this.myMethod).getMethod()).getNamespaceQualifier() == null) {
            final Object[] places = new Object[]{"above", "below"};
            final ComboBoxVisibilityPanel panel = new ComboBoxVisibilityPanel(OCRefactoringBundle.message("label.declaration.place", new Object[0]), places);
            panel.addListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Object selectedItem = panel.getVisibility();
                    OCChangeSignatureDialog.this.myHandler.getGeneratedInfo().setTargetSymbolsMode("below".equals(selectedItem) ? OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE : OCTargetSymbolPanel.TargetSymbolsMode.IMPLEMENTATION);
                    OCChangeSignatureDialog.this.myProject.putUserData(DECLARATION_PLACE_KEY, (Object)ArrayUtil.find((Object[])places, (Object)panel.getVisibility()));
                }
            });
            panel.setVisible(false);
            Integer choice = (Integer)this.myProject.getUserData(DECLARATION_PLACE_KEY);
            if (choice == null || choice == -1) {
                choice = 1;
            }
            panel.setVisibility(places[choice]);
            return panel;
        }
        OCTargetSymbolPanel panel = new OCTargetSymbolPanel();
        panel.setVisible(false);
        return panel;
    }

    private void updateCallableKind(OCCallableKind callableKind) {
        List parameters;
        String name = OCChangeSignatureDialog.convertName(this.myNameField.getText());
        if (this.myHandler.getCallableKind() == OCCallableKind.METHOD && !(parameters = this.myHandler.getParameters()).isEmpty()) {
            name = OCChangeSignatureDialog.convertName(((OCParameterInfo)parameters.get(0)).getSelector());
        }
        this.myHandler.setCallableKindToModel(callableKind);
        boolean parentClassVisible = this.myChangeParentClassPossible || this.myHandler.isMethod() && this.myHandler.getOriginalCallableKind() != OCCallableKind.METHOD;
        this.myContainerPanel.setVisible(parentClassVisible);
        this.myHandler.setNameVisible(this.myHandler.isFunction());
        this.myNameField.setText(name);
        ((OCParameterTableModel)this.myParametersTableModel).updateColumns(this.myProject, this.myHandler.isMethod());
        if (this.getTableComponent() != null) {
            this.getTableComponent().repaint();
        }
    }

    public OCChangeSignatureHandlerImpl getHandler() {
        this.initHandler();
        return this.myHandler;
    }

    protected boolean hasPreviewButton() {
        return !this.myHandler.isMethodGenerated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String calculateSignature() {
        this.initHandler();
        String signature2 = this.myHandler.calculateSignature(null, true, true);
        CodeStyleSettings tempSettings = CodeStyle.getSettings((PsiFile)this.myDefaultValueContext.getContainingFile()).clone();
        OCCodeStyleSettings tempCustomSettings = (OCCodeStyleSettings)tempSettings.getCustomSettings(OCCodeStyleSettings.class);
        tempCustomSettings.METHOD_PARAMETERS_ALIGN_MULTILINE = true;
        tempCustomSettings.METHOD_PARAMETERS_ALIGN_BY_COLONS = true;
        tempCustomSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = true;
        try {
            CodeStyle.setTemporarySettings((Project)this.getProject(), (CodeStyleSettings)tempSettings);
            String string = switch (this.myHandler.getCallableKind()) {
                case OCCallableKind.METHOD -> {
                    String text = OCElementFactory.methodFromSignature(signature2, ((OCMethodDescriptor)this.myMethod).getMethod(), false, true).getText();
                    yield text.substring(0, text.length() - 1);
                }
                case OCCallableKind.FUNCTION -> {
                    if (((OCMethodDescriptor)this.myMethod).isConstructor()) {
                        yield OCElementFactory.constructorFromText(signature2, ((OCMethodDescriptor)this.myMethod).getName(), ((OCMethodDescriptor)this.myMethod).getMethod(), true).getText();
                    }
                    yield OCElementFactory.topLevelDeclarationFromText(signature2, ((OCMethodDescriptor)this.myMethod).getMethod(), true).getText();
                }
                default -> OCElementFactory.expressionFromText(signature2, ((OCMethodDescriptor)this.myMethod).getMethod(), true).getText();
            };
            return string;
        }
        finally {
            CodeStyle.dropTemporarySettings((Project)this.getProject());
        }
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    private int getTypesMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((OCParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = item.typeCodeFragment == null ? null : item.typeCodeFragment.getText();
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    private int getTypesColumnWidth() {
        Font font = EditorFontType.getGlobalPlainFont();
        font = new Font(font.getFontName(), font.getStyle(), 12);
        return (this.getTypesMaxLength() + 1) * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
    }

    private int getSelectorsMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((OCParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = ((OCParameterInfo)item.parameter).getSelector();
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    protected static SimpleTextAttributes getSelectorTextAttributes(EditorColorsScheme scheme) {
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)scheme.getAttributes(OCHighlightingKeys.METHOD_DECLARATION));
    }

    protected static SimpleTextAttributes getTypeTextAttributes(EditorColorsScheme scheme) {
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)scheme.getAttributes(OCHighlightingKeys.CLASS_REFERENCE));
    }

    protected JComponent getRowPresentation(ParameterTableModelItemBase<OCParameterInfo> item, boolean selected, boolean focused) {
        String defaultValue;
        Color selBg = UIUtil.getTableSelectionBackground((boolean)true);
        Color selFg = UIUtil.getTableSelectionForeground();
        SimpleTextAttributes ATTR = selected && focused ? new SimpleTextAttributes(selBg, selFg, null, 0) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        SimpleColoredComponent text = new SimpleColoredComponent();
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font font = globalScheme.getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        text.setFont(font);
        String typeText = item.typeCodeFragment.getText();
        String selector = ((OCParameterInfo)item.parameter).getSelector();
        String name = ((OCParameterInfo)item.parameter).getName();
        String string = defaultValue = item.defaultValueCodeFragment != null ? item.defaultValueCodeFragment.getText() : "";
        if (this.myHandler.isMethod() && !StringUtil.isEmpty((String)selector)) {
            text.append(selector, selected ? ATTR : OCChangeSignatureDialog.getSelectorTextAttributes(globalScheme));
            if (!StringUtil.isEmpty((String)name)) {
                text.append(":", ATTR);
            }
            text.append(StringUtil.repeatSymbol((char)' ', (int)(this.getSelectorsMaxLength() - selector.length())), ATTR);
        }
        if (this.myHandler.isMethod() && !StringUtil.isEmpty((String)typeText)) {
            text.append("(", ATTR);
        }
        text.append(typeText, selected && focused ? ATTR : OCChangeSignatureDialog.getTypeTextAttributes(globalScheme));
        if (this.myHandler.isMethod() && !StringUtil.isEmpty((String)typeText)) {
            text.append(")", ATTR);
        }
        text.append(StringUtil.repeatSymbol((char)' ', (int)(this.getTypesMaxLength() - typeText.length() + 1)), ATTR);
        text.append(name, ATTR);
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            @NlsSafe String defaultValueComment = " // default value = " + defaultValue;
            text.append(defaultValueComment, ATTR);
        }
        text.setBackground(selected && focused ? selBg : UIUtil.getTableBackground());
        return text;
    }

    protected JBTableRowEditor getTableEditor(final JTable t, final ParameterTableModelItemBase<OCParameterInfo> item) {
        return new JBTableRowEditor(){
            private List<EditorTextField> myEditors = new ArrayList<EditorTextField>();

            public void prepareEditor(JTable table, int row) {
                Project project = OCChangeSignatureDialog.this.getProject();
                this.setLayout(new BorderLayout());
                ColumnInfo[] rowColumns = this.getFilteredRowColumns(((OCParameterTableModel)OCChangeSignatureDialog.this.myParametersTableModel).getColumnInfos(), row);
                int columnsPerRow = Math.min(3, rowColumns.length);
                ColumnInfo[] firstRow = Arrays.copyOf(rowColumns, columnsPerRow);
                this.addRowColumns(firstRow, 0, columnsPerRow, null, project);
                if (rowColumns.length > 3) {
                    ColumnInfo[] secondRow = Arrays.copyOfRange(rowColumns, 3, rowColumns.length);
                    JPanel additionalPanel = new JPanel(new BorderLayout());
                    this.addRowColumns(secondRow, 1, columnsPerRow, additionalPanel, project);
                    this.add(additionalPanel, "South");
                }
            }

            private void addRowColumns(@NotNull ColumnInfo[] rowColumns, final int rowNumber, final int columnsPerRow, @Nullable JPanel outputPanel, @NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (rowColumns == null) {
                    3.$$$reportNull$$$0(1);
                }
                assert (rowColumns.length <= 3);
                String[] anchors = new String[]{"West", "Center", "East"};
                int columnIndex = 0;
                for (ColumnInfo column : rowColumns) {
                    EditorTextField editor;
                    JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                    if (OCParameterTableModel.isTypeColumn(column)) {
                        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)item.typeCodeFragment);
                        editor = new EditorTextField(document, project, (FileType)OCChangeSignatureDialog.this.getFileType());
                    } else {
                        Object columnValue = column.valueOf((Object)item);
                        if (columnValue instanceof PsiCodeFragment) {
                            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)((PsiCodeFragment)columnValue));
                            editor = new EditorTextField(document, project, (FileType)OCChangeSignatureDialog.this.getFileType());
                        } else {
                            String columnValueStr = columnValue != null ? (String)columnValue : "";
                            editor = new EditorTextField(columnValueStr, project, (FileType)OCChangeSignatureDialog.this.getFileType());
                        }
                    }
                    final int columnFinal = columnIndex;
                    editor.addDocumentListener(new DocumentListener(){

                        public void documentChanged(@NotNull DocumentEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            this.fireDocumentChanged(e, rowNumber * columnsPerRow + columnFinal);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureDialog$3$1", "documentChanged"));
                        }
                    });
                    JBLabel label = new JBLabel(column.getName(), UIUtil.ComponentStyle.SMALL);
                    panel.add((Component)label);
                    panel.add((Component)editor);
                    editor.setPreferredWidth(t.getWidth() / columnsPerRow);
                    if (outputPanel != null) {
                        outputPanel.add((Component)panel, anchors[columnIndex]);
                    } else {
                        this.add(panel, anchors[columnIndex]);
                    }
                    this.myEditors.add(editor);
                    ++columnIndex;
                }
            }

            private ColumnInfo[] getFilteredRowColumns(ColumnInfo[] columns, int row) {
                ArrayList<ColumnInfo> newColumns = new ArrayList<ColumnInfo>(columns.length);
                for (ColumnInfo column : columns) {
                    if (OCParameterTableModel.isDefaultValueColumn(column) && !((OCParameterInfo)((ParameterTableModelItemBase)((OCParameterTableModel)((OCChangeSignatureDialog)OCChangeSignatureDialog.this).myParametersTableModel).getRowValue((int)row)).parameter).isNew()) continue;
                    newColumns.add(column);
                }
                return newColumns.toArray(ColumnInfo.EMPTY_ARRAY);
            }

            public JBTableRow getValue() {
                return new JBTableRow(){

                    public Object getValueAt(int column) {
                        if (column >= myEditors.size()) {
                            return null;
                        }
                        if (OCParameterTableModel.isTypeColumn(((OCParameterTableModel)OCChangeSignatureDialog.this.myParametersTableModel).getColumnInfos()[column])) {
                            return item.typeCodeFragment;
                        }
                        return myEditors.get(column).getText();
                    }
                };
            }

            private int getEditorIndex(int x) {
                Font font = EditorFontType.getGlobalPlainFont();
                font = new Font(font.getFontName(), font.getStyle(), 12);
                int selectorsWidth = (OCChangeSignatureDialog.this.getSelectorsMaxLength() + 1) * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W");
                int typesWidth = (OCChangeSignatureDialog.this.getTypesMaxLength() + 1) * Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("W") + selectorsWidth;
                if (OCChangeSignatureDialog.this.myHandler.isMethod()) {
                    return x <= selectorsWidth ? 0 : (x <= typesWidth ? 1 : 2);
                }
                return x <= typesWidth ? 0 : 1;
            }

            public JComponent getPreferredFocusedComponent() {
                MouseEvent me = this.getMouseEvent();
                if (me == null) {
                    return this.myEditors.get(0).getFocusTarget();
                }
                return this.myEditors.get(this.getEditorIndex((int)me.getPoint().getX())).getFocusTarget();
            }

            public JComponent[] getFocusableComponents() {
                JComponent[] focusable = new JComponent[this.myEditors.size()];
                for (int i = 0; i < this.myEditors.size(); ++i) {
                    focusable[i] = this.myEditors.get(i).getFocusTarget();
                }
                return focusable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rowColumns";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureDialog$3";
                objectArray[2] = "addRowColumns";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gridBagConstraints";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onActionPerformed";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addQualifierAndSpecifierOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addCheckBoxOption";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createParametersInfoModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "validateDefaultValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class DialogChangeSignatureHandlerImpl
    extends OCChangeSignatureHandlerImpl {
        DialogChangeSignatureHandlerImpl() {
            super((OCParameterTableModel)OCChangeSignatureDialog.this.myParametersTableModel, (OCMethodDescriptor)OCChangeSignatureDialog.this.myMethod, OCChangeSignatureDialog.this.myDefaultValueContext, false);
        }

        @Override
        public void setTitle(@NlsContexts.DialogTitle String title) {
            super.setTitle(title);
            OCChangeSignatureDialog.this.setTitle(title);
        }

        @Override
        public void setHelpId(String helpId) {
            super.setHelpId(helpId);
            OCChangeSignatureDialog.this.setHelpId(helpId);
        }

        public void setCallableKindToModel(OCCallableKind callableKind) {
            super.setCallableKind(callableKind);
        }

        @Override
        public void setCallableKind(OCCallableKind callableKind) {
            super.setCallableKind(callableKind);
            OCChangeSignatureDialog.this.myVisibilityPanel.setVisibility((Object)callableKind);
            if (callableKind == OCCallableKind.LAMBDA) {
                OCChangeSignatureDialog.this.myNoexceptSpecifierCheckBox.setEnabled(false);
                OCChangeSignatureDialog.this.myNoexceptSpecifierCheckBox.setVisible(false);
                OCChangeSignatureDialog.this.myConstexprSpecifierCheckBox.setEnabled(false);
                OCChangeSignatureDialog.this.myConstexprSpecifierCheckBox.setVisible(false);
            }
        }

        @Override
        public void setAddConstQualifier(boolean addConstQualifier) {
            super.setAddConstQualifier(addConstQualifier);
            if (addConstQualifier && OCChangeSignatureDialog.this.myConstQualifierCheckBox != null) {
                OCChangeSignatureDialog.this.myConstQualifierCheckBox.setSelected(true);
            }
        }

        @Override
        public void setChangeParentClassPossible(boolean possible) {
            OCChangeSignatureDialog.this.myChangeParentClassPossible = possible;
            OCChangeSignatureDialog.this.myContainerPanel.setVisible(possible);
        }

        @Override
        public void setNameVisible(boolean visible) {
            OCChangeSignatureDialog.this.myNamePanel.setVisible(visible);
        }

        @Override
        public void setName(String name) {
            super.setName(name);
            OCChangeSignatureDialog.this.myNameField.setText(OCChangeSignatureDialog.this.myHandler.isMethod() ? this.calculateMethodName() : name);
            PsiDocumentManager.getInstance((Project)OCChangeSignatureDialog.this.myProject).commitAllDocuments();
            OCChangeSignatureDialog.this.updateSignature();
        }

        @Override
        public void setReturnType(OCType returnType) {
            super.setReturnType(returnType);
            if (OCChangeSignatureDialog.this.myReturnTypeField != null) {
                OCChangeSignatureDialog.this.myReturnTypeField.setText(this.myReturnTypeText);
            }
        }

        @Override
        public void setParentClass(OCSymbol parent, boolean allowChangeCategories, List<? extends OCClassSymbol> auxParents) {
            super.setParentClass(parent, allowChangeCategories, auxParents);
            OCChangeSignatureDialog.this.myContainerClassField.setText(parent != null ? parent.getName() : "");
        }

        @Override
        OCType getReturnType() {
            OCType type = OCElementUtil.getType((PsiElement)OCChangeSignatureDialog.this.myReturnTypeCodeFragment);
            return type != null ? type : this.myReturnType;
        }

        @Override
        String getReturnTypeText() {
            OCType returnType = this.getReturnType();
            return returnType != null ? returnType.getName(OCChangeSignatureDialog.this.myDefaultValueContext) : "";
        }

        @Override
        String getMethodName() {
            return OCChangeSignatureDialog.this.getMethodName();
        }

        @Nullable
        OCClassDeclaration getContainerClass() {
            if (this.myCallableKind == OCCallableKind.METHOD) {
                OCClassSymbol symbol = (OCClassSymbol)OCChangeSignatureDialog.this.myContainerClassField.getClassDeclaration(OCChangeSignatureDialog.this.myProject);
                return OCElementUtil.resolveClassDeclaration(symbol, OCChangeSignatureDialog.this.myProject);
            }
            return null;
        }

        @Override
        public void setRefactorButtonText(@NlsContexts.Button String text) {
            OCChangeSignatureDialog.this.setRefactorButtonText(text);
        }

        @Override
        public void invoke() {
            List items = this.myParametersTableModel.getItems();
            if (OCChangeSignatureDialog.this.myHandler.isMethod() && !items.isEmpty() && ((OCParameterInfo)((ParameterTableModelItemBase)items.get((int)0)).parameter).getSelector().isEmpty()) {
                this.invoke(0, 0);
            }
            this.invoke(-1, -1);
        }

        public void invoke(int rowToEdit, int columnToEdit) {
            if (OCChangeSignatureDialog.this.myHandler.getGeneratedInfo().getMethodParent() instanceof OCClassSymbol) {
                OCChangeSignatureDialog.this.myVisibilityPanel.setVisible(!OCChangeSignatureDialog.this.myChangeParentClassPossible);
                ((OCTargetSymbolPanel)OCChangeSignatureDialog.this.myVisibilityPanel).fillData(OCChangeSignatureDialog.this.myHandler.getGeneratedInfo());
                OCChangeSignatureDialog.this.myContainerClassField.setText(OCChangeSignatureDialog.this.myHandler.getGeneratedInfo().getMethodParent().getName());
            } else if (this.myMethod.getMethod() instanceof OCFunctionDefinition && ((OCFunctionDefinition)this.myMethod.getMethod()).getNamespaceQualifier() == null && this.myGeneratedInfo.getMethodReference() != null) {
                OCChangeSignatureDialog.this.myVisibilityPanel.setVisible(true);
            }
            if (this.myMethod.isConstructor()) {
                if (OCChangeSignatureDialog.this.myReturnTypeField != null) {
                    OCChangeSignatureDialog.this.myReturnTypeField.setEnabled(false);
                }
                OCChangeSignatureDialog.this.myNameField.setEnabled(false);
                OCChangeSignatureDialog.this.myVisibilityPanel.setVisible(false);
            }
            if (this.myCallableKind == OCCallableKind.BLOCK || this.myCallableKind == OCCallableKind.LAMBDA) {
                OCChangeSignatureDialog.this.myVisibilityPanel.setVisible(false);
                OCChangeSignatureDialog.this.myReturnTypeField.setEnabled(false);
            }
            if (rowToEdit != -1 && columnToEdit != -1) {
                JBTable table = OCChangeSignatureDialog.this.getTableComponent();
                Runnable editAlarm = () -> DialogChangeSignatureHandlerImpl.lambda$invoke$1((JTable)table, rowToEdit, columnToEdit);
                SwingUtilities.invokeLater(editAlarm);
                Container parent = table.getParent();
                if (parent == null) {
                    table.repaint();
                } else {
                    parent.repaint();
                }
            }
            OCChangeSignatureDialog.this.show();
        }

        @TestOnly
        @NotNull
        public OCCodeFragment getReturnTypeCodeFragment() {
            OCCodeFragment oCCodeFragment = (OCCodeFragment)Objects.requireNonNull(OCChangeSignatureDialog.this.myReturnTypeCodeFragment);
            if (oCCodeFragment == null) {
                DialogChangeSignatureHandlerImpl.$$$reportNull$$$0(0);
            }
            return oCCodeFragment;
        }

        @TestOnly
        @NotNull
        public OCChangeSignatureDialog getDialog() {
            OCChangeSignatureDialog oCChangeSignatureDialog = OCChangeSignatureDialog.this;
            if (oCChangeSignatureDialog == null) {
                DialogChangeSignatureHandlerImpl.$$$reportNull$$$0(1);
            }
            return oCChangeSignatureDialog;
        }

        private static /* synthetic */ void lambda$invoke$1(JTable table, int rowToEdit, int columnToEdit) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD).addRequest(() -> table.editCellAt(rowToEdit, columnToEdit), 300);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureDialog$DialogChangeSignatureHandlerImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReturnTypeCodeFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDialog";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

