/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClangDiagnosticIntentionAction
extends SuppressIntentionAction {
    private final SmartPsiElementPointer<PsiElement> myElementPtr;
    private final String myCompiler;
    private final String mySuppressOption;
    private final String mySuppressScope;

    protected OCSuppressClangDiagnosticIntentionAction(@Nullable PsiElement element, @Nullable OCSuppressionGroup suppressionGroup, String suppressScope) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
        this.myCompiler = suppressionGroup == null ? null : suppressionGroup.compiler;
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
        this.mySuppressScope = suppressScope;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.suppress.for", (Object[])new Object[]{this.mySuppressScope});
        if (string == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.suppress.option.for", (Object[])new Object[]{this.mySuppressOption, this.mySuppressScope});
        if (string == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected TextRange getSuppressionRange(OCFile file) {
        PsiElement element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        return element != null ? OCElementUtil.getRangeWithMacros(element) : null;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(3);
        }
        return element.isValid() && this.myElementPtr != null && this.mySuppressOption != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(5);
        }
        OCFile file = (OCFile)element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        int elementOffset = OCElementUtil.getRangeWithMacros(element).getStartOffset();
        TextRange suppressionRange = this.getSuppressionRange(file);
        if (document == null || suppressionRange == null) {
            return;
        }
        if (OCPragmaSuppressionUtils.getDiagnosticMode(file, elementOffset, this.mySuppressOption) == OCPragma.Mode.IGNORE) {
            return;
        }
        int startLine = document.getLineNumber(suppressionRange.getStartOffset());
        int endLine = document.getLineNumber(suppressionRange.getEndOffset());
        if (startLine >= 0 && startLine < document.getLineCount() && endLine >= 0 && endLine < document.getLineCount()) {
            int startOffset = document.getLineStartOffset(startLine);
            int endOffset = document.getLineEndOffset(endLine);
            boolean pushToStack = true;
            if (OCPragmaSuppressionUtils.findExactScope(file, startOffset, endOffset) != null) {
                pushToStack = false;
            }
            if (pushToStack) {
                document.insertString(endOffset, (CharSequence)"\n#pragma clang diagnostic pop");
            }
            document.insertString(startOffset, (CharSequence)("#pragma " + this.myCompiler + " diagnostic ignored \"" + this.mySuppressOption + "\"\n"));
            if (pushToStack) {
                document.insertString(startOffset, (CharSequence)"#pragma clang diagnostic push\n");
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(8);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            OCSuppressClangDiagnosticIntentionAction.$$$reportNull$$$0(9);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

